/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DataAccessor.FileEntityDA;
import oracle.rat.tfa.db.DataAccessor.InstanceStartupDA;
import oracle.rat.tfa.db.OracleJdbc;
import oracle.rat.tfa.entity.AdrIncident;
import oracle.rat.tfa.entity.AlertClusterEviction;
import oracle.rat.tfa.entity.AlertClusterReconfiguration;
import oracle.rat.tfa.entity.DatabaseGeneralError;
import oracle.rat.tfa.entity.DatabaseParameter;
import oracle.rat.tfa.entity.Generic;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.InstanceShutdown;
import oracle.rat.tfa.entity.InstanceStartup;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.singletons.DirectoryMappings;
import oracle.rat.tfa.singletons.MatchDates;
import oracle.rat.tfa.singletons.MatchFileTypes;
import oracle.rat.tfa.type.DateFormatType;
import oracle.rat.tfa.type.DirectoryMappingType;
import oracle.rat.tfa.type.FileType;
import oracle.rat.tfa.util.DateSearchResult;
import oracle.rat.tfa.util.FileHelper;
import oracle.rat.tfa.util.FileList;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.RandomFileReader;
import oracle.rat.tfa.util.TimeZoneUtil;

@Entity(version=7)
public class FileEntity
implements Serializable {
    private static final long serialVersionUID = 57L;
    @PrimaryKey
    private String fileName;
    @SecondaryKey(relate=Relationship.MANY_TO_ONE)
    private String component = "NULL";
    private Long fileSize;
    private String shortName;
    private Date lastModified;
    private int numberOfLines;
    private Date firstTimestamp;
    private Date lastTimestamp;
    private int samplingRowNumberFirst = -1;
    private int samplingRowNumberLast = -1;
    private int samplingSize = -1;
    private Host hostInfo;
    private String database;
    private String instance;
    private String cluster;
    private String baseDirectory;
    private Boolean analysisStarted = false;
    private Date analysisTimestamp;
    public String datePattern;
    public String srNumber;
    public boolean isTrimFile = false;
    private List<Integer> timestampOffset;
    private String category;
    private String type;
    private String alsoCollectFor;
    long curPos = -1L;
    private String hostName;
    private boolean useDfOnly = false;
    private long keepHeaderLines = 0L;
    private boolean isCore = false;

    public FileEntity() {
    }

    public FileEntity(File file) {
        this.fileName = file.getAbsolutePath();
        this.shortName = file.getName();
        this.fileSize = file.length();
        this.lastModified = new Date(file.lastModified());
        this.hostInfo = new Host();
        this.hostName = this.hostInfo.getHostname().trim();
        DirectoryMappingType directoryMappingType = DirectoryMappings.getInstance().lookForDirectory(this.fileName);
        if (directoryMappingType != null) {
            this.baseDirectory = directoryMappingType.directoryPath;
            this.database = directoryMappingType.database;
            this.instance = directoryMappingType.instance;
            this.srNumber = directoryMappingType.srNumber;
        }
    }

    public void setIsCore() {
        if (this.fileName.matches(".*" + File.separator + "cdump" + File.separator + ".*" + "core.*")) {
            this.isCore = true;
            Output.printTrace("isCoreFile: " + this.fileName + ", Status: " + this.isCore, 3);
        }
    }

    public boolean getIsCore() {
        return this.isCore;
    }

    public boolean isSymbolicLink() {
        boolean bl = false;
        try {
            File file = new File(this.fileName);
            bl = !file.getAbsoluteFile().equals(file.getCanonicalFile());
        }
        catch (Exception exception) {
            Output.printTrace("Exception in isSymbolicLink() : " + exception.getMessage(), 1);
            exception.printStackTrace();
            bl = true;
        }
        return bl;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFileSize(Long l) {
        this.fileSize = l;
    }

    public void updateFromFile(File file) {
        this.fileSize = file.length();
        this.lastModified = new Date(file.lastModified());
    }

    public String getFileName() {
        return this.fileName;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setNumberOfLines(int n) {
        this.numberOfLines = n;
    }

    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    public int getFileYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.lastModified);
        return calendar.get(1);
    }

    public synchronized Date getAnalysisTimestamp() {
        return this.analysisTimestamp;
    }

    public synchronized void setAnalysisTimestamp(Date date) {
        this.analysisTimestamp = date;
    }

    public synchronized Boolean getAnalysisStarted() {
        return this.analysisStarted;
    }

    public synchronized void setAnalysisStarted() {
        this.analysisStarted = true;
    }

    public synchronized Boolean isRealTimeTail() {
        if (this.type != null && this.getType().contains("Alert") && !this.getType().contains("XML") && !this.getType().contains("xml")) {
            return true;
        }
        return false;
    }

    public synchronized Boolean isAlertLog() {
        if (this.getType() != null && this.getType().contains("Alert") && !this.getType().contains("XML")) {
            return true;
        }
        return false;
    }

    public void lookForFirstTimestamp(boolean bl) {
        boolean bl2 = false;
        if (this.fileName.endsWith(".tar") || this.fileName.endsWith(".zip")) {
            bl2 = true;
        }
        if (!bl2) {
            MatchDates matchDates = MatchDates.getInstance();
            int n = 0;
            boolean bl3 = false;
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.fileName));
                DateSearchResult dateSearchResult = null;
                DateFormatType dateFormatType = null;
                while ((string = bufferedReader.readLine()) != null && !bl3) {
                    if ((string = string.trim()).length() <= 0) continue;
                    if (++n > 1000) {
                        return;
                    }
                    if (string.contains("Version:")) continue;
                    if (dateFormatType != null) {
                        dateSearchResult = matchDates.searchReuseFormat(string, dateFormatType);
                    } else {
                        dateSearchResult = bl ? matchDates.searchForDate(string, this, bl) : matchDates.searchForDate(string, this);
                        if (dateSearchResult != null) {
                            dateFormatType = dateSearchResult.getDft();
                        }
                    }
                    if (dateSearchResult == null) continue;
                    this.firstTimestamp = dateSearchResult.getDateFound();
                    Output.printTrace("String for which first timestamp was found : " + string + " and first timestamp : " + this.firstTimestamp, 3);
                    try {
                        String string2 = this.firstTimestamp.toString();
                        this.samplingRowNumberFirst = n;
                        bl3 = true;
                    }
                    catch (Exception exception) {}
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Vector tail(String string, int n) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            Vector vector = new Vector();
            if (this.curPos == -1L) {
                this.curPos = randomAccessFile.length() - 1L;
            }
            while (true) {
                byte[] byArray;
                long l;
                if ((l = this.curPos - (long)n) <= 0L) {
                    randomAccessFile.seek(0L);
                    byArray = new byte[(int)this.curPos];
                    randomAccessFile.readFully(byArray);
                    FileHelper.parseLinesFromLast(byArray, vector);
                    this.curPos = -1L;
                    break;
                }
                randomAccessFile.seek(l);
                byArray = new byte[n];
                try {
                    randomAccessFile.readFully(byArray);
                }
                catch (EOFException eOFException) {
                    Output.printTrace("curPos: " + this.curPos + " fromPos: " + l + " chunkSize: " + n + " fileName: " + string + " fileSize: " + randomAccessFile.length(), 3);
                    eOFException.printStackTrace();
                }
                if (FileHelper.isValidASCII(byArray)) {
                    FileHelper.parseLinesFromLast(byArray, vector);
                    String string2 = vector.lastElement().toString();
                    Output.printTrace("FileEntity.tail: lastLine - " + string2, 3);
                    this.curPos = l + (long)string2.length();
                    break;
                }
                long l2 = FileHelper.getCurrentPosition(byArray);
                this.curPos -= (long)n - l2;
            }
            randomAccessFile.close();
            return vector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setLastTimestamp(boolean bl) {
        MatchDates matchDates = MatchDates.getInstance();
        Date date = null;
        int n = 1000;
        int n2 = 1000;
        int n3 = 0;
        if (this.fileSize > 0L) {
            block0: do {
                Output.printTrace("Tailing file : " + this.fileName + " with cursor at : " + this.curPos, 3);
                Vector vector = this.tail(this.fileName, n);
                for (String string : vector) {
                    DateSearchResult dateSearchResult = null;
                    dateSearchResult = bl ? matchDates.searchForDate(string, this, bl) : matchDates.searchForDate(string, this);
                    if (dateSearchResult != null) {
                        date = dateSearchResult.getDateFound();
                        continue block0;
                    }
                    ++n3;
                }
            } while (n3 <= n2 && date == null && this.curPos != -1L);
        }
        Output.printTrace("Out of while loop with cursor at : " + this.curPos + " lastTime : " + date + " linesProcessed : " + n3, 3);
        this.curPos = -1L;
        if (date == null) {
            if (this.lastModified.after(this.firstTimestamp)) {
                Output.printTrace("Setting the lastTimestamp to lastModified : " + this.lastModified, 3);
                date = this.lastModified;
            } else {
                Output.printTrace("Setting the lastTimestamp to firstTimestamp", 3);
                date = this.firstTimestamp;
            }
        }
        this.lastTimestamp = date;
    }

    public Date getFirstTime() {
        return this.firstTimestamp;
    }

    public Date getLastTime() {
        return this.lastTimestamp;
    }

    public int getSampleRowsFirst() {
        return this.samplingRowNumberFirst;
    }

    public int getSampleRowsLast() {
        return this.samplingRowNumberLast;
    }

    public int getSampleSize() {
        return this.samplingSize;
    }

    public String getHostname() {
        if (this.hostName != null) {
            return this.hostName;
        }
        return this.hostInfo.getHostname();
    }

    public String getType() {
        return this.type;
    }

    public Host getHostInfo() {
        return this.hostInfo;
    }

    public void setFirstTimestamp(Date date) {
        this.firstTimestamp = date;
    }

    public void setLastTimestamp(Date date) {
        this.lastTimestamp = date;
    }

    public void setFileType(String string) {
        this.type = string;
    }

    public void setFileType() {
        boolean bl;
        int n;
        if (this.type != null) {
            return;
        }
        MatchFileTypes matchFileTypes = MatchFileTypes.getInstance();
        Vector<FileType> vector = matchFileTypes.getDBWLMFileTypes();
        Vector<FileType> vector2 = matchFileTypes.getACFSFileTypes();
        Vector<FileType> vector3 = matchFileTypes.getODAFileTypes();
        Vector<FileType> vector4 = matchFileTypes.getASMFileTypes();
        Vector<FileType> vector5 = matchFileTypes.getNonASMFileTypes();
        Vector<FileType> vector6 = matchFileTypes.getCellExadataFileTypes();
        String string = Properties.getInstance().getNodeType();
        if (string.equals("ODA") || string.equals("ODAVMGuest") || string.equals("ODADom0")) {
            for (FileType fileType : vector3) {
                n = fileType.getNumberNamePatterns();
                if (n <= 0 || !(bl = fileType.checkNamePatterns(this.fileName))) continue;
                this.type = fileType.getName();
                this.component = fileType.getComponent();
                this.category = fileType.getCategory();
                this.alsoCollectFor = fileType.getAlsoCollectFor();
                this.useDfOnly = fileType.isUseDfOnly();
                this.keepHeaderLines = fileType.getKeepHeaderLines();
                return;
            }
        }
        if (!(string.equals("TYPICAL") || string.equals("ODA") || string.equals("ODAVMGuest") || string.equals("ODADom0"))) {
            for (FileType fileType : vector6) {
                n = fileType.getNumberNamePatterns();
                if (n <= 0 || !(bl = fileType.checkNamePatterns(this.fileName))) continue;
                this.type = fileType.getName();
                this.component = fileType.getComponent();
                this.category = fileType.getCategory();
                this.alsoCollectFor = fileType.getAlsoCollectFor();
                this.useDfOnly = fileType.isUseDfOnly();
                this.keepHeaderLines = fileType.getKeepHeaderLines();
                return;
            }
        }
        for (FileType fileType : vector) {
            n = fileType.getNumberNamePatterns();
            if (n <= 0 || !(bl = fileType.checkNamePatterns(this.fileName))) continue;
            this.type = fileType.getName();
            this.component = fileType.getComponent();
            this.category = fileType.getCategory();
            this.alsoCollectFor = fileType.getAlsoCollectFor();
            this.useDfOnly = fileType.isUseDfOnly();
            this.keepHeaderLines = fileType.getKeepHeaderLines();
            return;
        }
        for (FileType fileType : vector2) {
            n = fileType.getNumberNamePatterns();
            if (n <= 0 || !(bl = fileType.checkNamePatterns(this.fileName))) continue;
            this.type = fileType.getName();
            this.component = fileType.getComponent();
            this.category = fileType.getCategory();
            this.alsoCollectFor = fileType.getAlsoCollectFor();
            return;
        }
        for (FileType fileType : vector4) {
            n = fileType.getNumberNamePatterns();
            if (n <= 0 || !(bl = fileType.checkNamePatterns(this.fileName))) continue;
            this.type = fileType.getName();
            this.component = fileType.getComponent();
            this.category = fileType.getCategory();
            this.alsoCollectFor = fileType.getAlsoCollectFor();
            this.useDfOnly = fileType.isUseDfOnly();
            this.keepHeaderLines = fileType.getKeepHeaderLines();
            return;
        }
        for (FileType fileType : vector5) {
            n = fileType.getNumberNamePatterns();
            if (n <= 0 || !(bl = fileType.checkNamePatterns(this.fileName))) continue;
            this.type = fileType.getName();
            this.component = fileType.getComponent();
            this.category = fileType.getCategory();
            this.alsoCollectFor = fileType.getAlsoCollectFor();
            this.useDfOnly = fileType.isUseDfOnly();
            this.keepHeaderLines = fileType.getKeepHeaderLines();
            return;
        }
    }

    public String dumpXML() {
        String string = "";
        string = string + "<file>" + "\n";
        string = string + "<file_name>" + this.fileName + "</file_name>" + "\n";
        string = string + "<file_type>" + this.type + "</file_type>" + "\n";
        string = string + "<size>" + this.fileSize + "</size>" + "\n";
        string = string + "<database>" + this.database + "</database>" + "\n";
        string = string + "<cluster>" + this.cluster + "</cluster>" + "\n";
        string = string + "<instance>" + this.instance + "</instance>" + "\n";
        string = string + "<component>" + this.component + "</component>" + "\n";
        string = string + "<base_directory>" + this.baseDirectory + "</base_directory>" + "\n";
        string = string + "<last_modified>" + this.lastModified + "</last_modified>" + "\n";
        string = string + "<hostname>" + this.hostName + "</hostname>" + "\n";
        string = string + "<lines>" + this.numberOfLines + "</lines>" + "\n";
        string = string + "<first_timestamp>" + this.firstTimestamp + "</first_timestamp>" + "\n";
        string = string + "<last_timestamp>" + this.lastTimestamp + "</last_timestamp>" + "\n";
        string = string + "<sampling_rows_first>" + this.getSampleRowsFirst() + "</sampling_rows_first>" + "\n";
        string = string + "<sampling_rows_last>" + this.getSampleRowsLast() + "</sampling_rows_last>" + "\n";
        string = string + "<date_pattern>" + this.getDatePattern() + "</date_pattern>" + "\n";
        string = string + "<sample_size>" + this.samplingSize + "</sample_size>" + "\n";
        string = string + "<use_df_only>" + this.isUseDfOnly() + "</use_df_only>" + "\n";
        string = string + "<keep_header_lines>" + this.getKeepHeaderLines() + "</keep_header_lines>" + "\n";
        string = string + "</file>" + "\n";
        return string;
    }

    public Boolean isExcessive(Date date, Date date2) {
        long l;
        long l2;
        if (date == null || date2 == null) {
            Output.printTrace("***startDate or endDate is null", 3);
            return false;
        }
        long l3 = Global.getTrimsize();
        if (this.fileSize <= l3) {
            Output.printTrace("***Small file, no need to trim", 3);
            return false;
        }
        long l4 = 0L;
        long l5 = 1L;
        if (this.firstTimestamp != null && date.after(this.firstTimestamp)) {
            l2 = date.getTime() - this.firstTimestamp.getTime();
            l = l2 / 86400000L;
            l4 += l;
        }
        if (this.lastTimestamp != null && date2.before(this.lastTimestamp)) {
            l2 = this.lastTimestamp.getTime() - date2.getTime();
            l = l2 / 86400000L;
            l4 += l;
        }
        if (l4 >= l5) {
            Output.printTrace("***Excess in days: " + l4, 3);
            return true;
        }
        return false;
    }

    private Date getPreviousStartupDate(Date date) {
        InstanceStartupDA instanceStartupDA = new InstanceStartupDA();
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(InstanceStartup.class);
        EntityCursor entityCursor = primaryIndex.entities();
        ArrayList<Date> arrayList = new ArrayList<Date>();
        try {
            for (InstanceStartup instanceStartup : entityCursor) {
                if (!instanceStartup.getFileName().equalsIgnoreCase(this.fileName)) continue;
                arrayList.add(instanceStartup.getStartupTime());
            }
            Collections.sort(arrayList);
            int n = Collections.binarySearch(arrayList, date);
            int n2 = -n - 1;
            if (--n2 >= 0) {
                date = (Date)arrayList.get(n2);
                Output.printTrace("Previous startup date : " + date, 3);
            } else {
                Output.printTrace("Negative index for date : " + date, 3);
            }
            entityCursor.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return date;
    }

    public FileEntity createTrimmedFile(Date date, Date date2, File file, boolean bl) {
        Output.printTrace("Trimming file : " + this.fileName, 3);
        int n = TimeZoneUtil.getDifferenceBetweenDefaultAndSessionTZ();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, n);
        date = calendar.getTime();
        calendar = Calendar.getInstance();
        calendar.setTime(date2);
        calendar.add(11, n);
        date2 = calendar.getTime();
        RandomFileReader randomFileReader = new RandomFileReader(this);
        String string = file.getAbsolutePath() + File.separator + this.shortName + ".trimmed";
        try {
            long l = System.currentTimeMillis() / 1000L;
            if (this.type.equalsIgnoreCase("Alert Log - ASM") || this.type.equalsIgnoreCase("Alert Log - DB")) {
                Output.printTrace("Got an alert log of type : " + this.type, 3);
                Output.printTrace("Getting previous start up date for : " + date, 3);
                date = this.getPreviousStartupDate(date);
                Output.printTrace("Previous start up date : " + date, 3);
            }
            Output.printTrace("startDate ----> " + date + " endDate -----> " + date2, 3);
            Output.printTrace("Inside TRIM: " + this.getFileName(), 4);
            long l2 = this.getKeepHeaderLines();
            Output.printTrace("keep header lines: " + l2, 3);
            if (l2 > 0L) {
                BufferedReader bufferedReader = null;
                BufferedWriter bufferedWriter = null;
                bufferedReader = new BufferedReader(new FileReader(this.fileName));
                bufferedWriter = new BufferedWriter(new FileWriter(string));
                String string2 = bufferedReader.readLine();
                int n2 = 1;
                while ((long)n2 <= l2 && string2 != null) {
                    bufferedWriter.write(string2);
                    bufferedWriter.write("\n");
                    string2 = bufferedReader.readLine();
                    ++n2;
                }
                bufferedReader.close();
                bufferedWriter.close();
            }
            long l3 = randomFileReader.binarySearch(date);
            Output.printTrace("startPos : " + l3, 4);
            if (l3 != -1L) {
                long l4 = randomFileReader.binarySearch(date2);
                Output.printTrace("endPos : " + l4, 4);
                if (l4 != -1L) {
                    long l5;
                    Output.printTrace("Getting next higher timestamp to : " + date2, 3);
                    l4 = randomFileReader.getNextHigherTimestampOffset(date2, l4);
                    FileOutputStream fileOutputStream = new FileOutputStream(string, true);
                    RandomAccessFile randomAccessFile = new RandomAccessFile(this.fileName, "r");
                    randomAccessFile.seek(l3);
                    Output.printTrace("endPos after nextHigherTimestamp : " + l4, 4);
                    if (l4 == 0L || !bl) {
                        l4 = randomAccessFile.length();
                    }
                    Output.printTrace("endPos : " + l4, 4);
                    byte[] byArray = new byte[4096];
                    int n3 = 0;
                    while (randomAccessFile.getFilePointer() <= l4 && n3 != -1) {
                        l5 = l4 - randomAccessFile.getFilePointer();
                        if (l5 < 4096L) {
                            byte[] byArray2 = new byte[(int)l5];
                            n3 = randomAccessFile.read(byArray2);
                            fileOutputStream.write(byArray2);
                            break;
                        }
                        n3 = randomAccessFile.read(byArray);
                        fileOutputStream.write(byArray);
                    }
                    fileOutputStream.close();
                    randomAccessFile.close();
                    l5 = System.currentTimeMillis() / 1000L;
                    Output.printTrace("Time taken to write trimmed file : " + (l5 - l), 3);
                }
            }
            randomFileReader.closeFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        File file2 = new File(string);
        if (file2.exists()) {
            FileEntity fileEntity = new FileEntity(file2);
            this.setTrimFile();
            fileEntity.firstTimestamp = null;
            fileEntity.lastTimestamp = null;
            fileEntity.type = this.type;
            return fileEntity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntity createTrimFile(Date date, Date date2) {
        Object object;
        Object object2;
        MatchDates matchDates = MatchDates.getInstance();
        Date date3 = null;
        int n = 0;
        int n2 = 1;
        boolean bl = false;
        String string = System.getProperty("line.separator");
        Date date4 = null;
        Date date5 = null;
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        String string2 = stringBuilder.append(Properties.getTmpDir()).append(this.shortName).append(".trimmed").toString();
        boolean bl2 = false;
        FileOutputStream fileOutputStream = null;
        Object var14_14 = null;
        try {
            fileOutputStream = new FileOutputStream(string2, true);
            object2 = new BufferedReader(new FileReader(this.fileName));
            DateSearchResult dateSearchResult = null;
            while ((object = ((BufferedReader)object2).readLine()) != null && !bl2) {
                if (((String)(object = ((String)object).trim())).length() <= 0 || ((String)object).contains("Version:")) continue;
                dateSearchResult = matchDates.searchForDate((String)object, this);
                if (dateSearchResult != null) {
                    date3 = dateSearchResult.getDateFound();
                }
                if (date3 != null) {
                    n2 = 1;
                    if (!bl) {
                        n = date3.compareTo(date);
                    }
                    if (n >= 0) {
                        n2 = date3.compareTo(date2);
                    }
                    if (n2 <= 0) {
                        bl = true;
                        if (date4 == null) {
                            date4 = (Date)date3.clone();
                        } else {
                            date5 = (Date)date3.clone();
                        }
                    } else if (bl) {
                        bl = false;
                        bl2 = true;
                    }
                }
                if (!bl) continue;
                fileOutputStream.write(((String)object + string).getBytes());
            }
            ((BufferedReader)object2).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        object2 = new File(string2);
        object = new FileEntity((File)object2);
        this.setTrimFile();
        try {
            ((FileEntity)object).setNumberOfLines(FileList.countLines(string2));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((FileEntity)object).firstTimestamp = date4;
        ((FileEntity)object).lastTimestamp = date5;
        ((FileEntity)object).type = this.type;
        return object;
    }

    public void setDatabase(String string) {
        this.database = string;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setInstance(String string) {
        this.instance = string;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setCluster(String string) {
        this.cluster = string;
    }

    public String getCluster() {
        return this.cluster;
    }

    public static void dumpFilesFromStoreToXML() throws DatabaseException {
        long l = 0L;
        long l2 = 0L;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(FileEntity.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                String string;
                FileWriter fileWriter = new FileWriter(Properties.inventoryXMLFile);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write("<files>\n");
                FileWriter fileWriter2 = new FileWriter(Properties.filesWithNoFileTypes);
                BufferedWriter bufferedWriter2 = new BufferedWriter(fileWriter2);
                bufferedWriter2.write("<?xml version=\"1.0\" ?>\n");
                bufferedWriter2.write("<files>\n");
                String string2 = TimeZoneUtil.getCRSTimeZone();
                if (string2 != null) {
                    bufferedWriter.write("<CRS_TZ>" + string2 + "</CRS_TZ>" + "\n");
                }
                if ((string = Properties.timezone) != null) {
                    bufferedWriter.write("<session_TZ>" + string + "</session_TZ>" + "\n");
                }
                bufferedWriter.write("<system_TZ>" + TimeZone.getDefault().getDisplayName() + "</system_TZ>" + "\n");
                for (FileEntity fileEntity : entityCursor) {
                    if (!new File(fileEntity.getFileName()).exists()) {
                        if (fileEntity.isAlertLog().booleanValue()) {
                            Output.printTrace("Deleting Events from BDB" + fileEntity.getFileName(), 3);
                            InstanceStartup.deleteStartupEvent(fileEntity.getFileName());
                            InstanceShutdown.deleteShutdownEvent(fileEntity.getFileName());
                            DatabaseParameter.deleteDatabaseParameterEvent(fileEntity.getFileName());
                            DatabaseGeneralError.deleteDatabaseErrorEvent(fileEntity.getFileName());
                            AlertClusterEviction.deleteClusterEvictionEvent(fileEntity.getFileName());
                            AlertClusterReconfiguration.deleteClusterReconfigurartionEvent(fileEntity.getFileName());
                            Generic.deleteGenericEvent(fileEntity.getFileName());
                            AdrIncident.deleteADRIncident(fileEntity.getFileName());
                        }
                        Output.printTrace("Deleting File from BDB" + fileEntity.getFileName(), 3);
                        primaryIndex.delete((Object)fileEntity.getFileName());
                        continue;
                    }
                    String string3 = "";
                    String string4 = "";
                    String string5 = null;
                    string5 = fileEntity.dumpXML();
                    bufferedWriter.write(string5);
                    if (fileEntity.getType() == null) {
                        bufferedWriter2.write("<file>\n");
                        bufferedWriter2.write("<filename>" + fileEntity.getFileName() + "</filename>\n");
                        bufferedWriter2.write("</file>\n");
                    }
                    try {
                        string3 = fileEntity.getFirstTime().toString();
                        string4 = fileEntity.getLastTime().toString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++l;
                    l2 += fileEntity.getFileSize().longValue();
                }
                bufferedWriter.write("</files>");
                bufferedWriter.close();
                bufferedWriter2.write("</files>\n");
                bufferedWriter2.close();
                FileList.fileCount = l;
                FileList.totalFileSize = l2;
                LogFile.writeLog("Total files found in database: " + l);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
                fileWriter.close();
                fileWriter2.close();
            }
            catch (Exception exception) {
                Output.print("Exception in dumping files from store to xml: " + exception.getMessage());
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            Output.print("Exception in dumping files from store to xml: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private static long getDateTime(Date date) {
        long l = 0L;
        l = date == null ? 0L : date.getTime();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpFilestoOracle() throws DatabaseException {
        block17: {
            int n = 1000;
            long l = 0L;
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(FileEntity.class);
            EntityCursor entityCursor = primaryIndex.entities();
            Connection connection = null;
            Statement statement = null;
            Statement statement2 = null;
            try {
                connection = OracleJdbc.getConnection();
                connection.setAutoCommit(false);
                if (connection == null) break block17;
                statement = connection.prepareStatement("begin tfa_v2.saveTraceFile(                     srBugNum => ?,                      fileName => ?,                      fileSize => ?,                     firstTimestamp => ?,                      lastTimestamp => ?,                      lastUpdated => ?,                     hostname => ?,                      databaseName => ?,                     clusterName => ?,                      instanceName => ?,                     fileType => ?                     ); end;");
                statement2 = connection.prepareStatement("begin tfa_v2.saveTraceFileType(                     fileName => ?,                      fileType => ?,                     dateFormat => ?                     ); end;");
                for (FileEntity fileEntity : entityCursor) {
                    String string = "";
                    String string2 = "";
                    try {
                        string = fileEntity.getFirstTime().toString();
                        string2 = fileEntity.getLastTime().toString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Timestamp timestamp = null;
                    if (fileEntity.getFirstTime() != null) {
                        timestamp = new Timestamp(fileEntity.getFirstTime().getTime());
                    }
                    Timestamp timestamp2 = null;
                    if (fileEntity.getLastTime() != null) {
                        timestamp2 = new Timestamp(fileEntity.getLastTime().getTime());
                    }
                    Timestamp timestamp3 = null;
                    if (fileEntity.getLastModified() != null) {
                        timestamp3 = new Timestamp(fileEntity.getLastModified().getTime());
                    }
                    Properties.getInstance();
                    statement.setString(1, Properties.getSrOrBugNum());
                    statement.setString(2, fileEntity.getFileName());
                    statement.setLong(3, fileEntity.getFileSize());
                    statement.setTimestamp(4, timestamp);
                    statement.setTimestamp(5, timestamp2);
                    statement.setTimestamp(6, timestamp3);
                    statement.setString(7, fileEntity.getHostname());
                    statement.setString(8, fileEntity.getDatabase());
                    statement.setString(9, fileEntity.getCluster());
                    statement.setString(10, fileEntity.getInstance());
                    statement.setString(11, fileEntity.getType());
                    statement.execute();
                    statement2.setString(1, fileEntity.getFileName());
                    statement2.setString(2, fileEntity.getType());
                    statement2.setString(3, fileEntity.getDatePattern());
                    statement2.execute();
                    if (++l % (long)n != 0L) continue;
                    Output.print("Committed " + l + " entities to database");
                    connection.commit();
                }
                LogFile.writeLog("Total files found in database: " + l);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                entityCursor.close();
                try {
                    statement.close();
                    statement2.close();
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setDatePattern(String string) {
        Output.printTrace(this.getFileName() + ":" + this.getType() + ":" + string, 3);
        this.datePattern = string;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public boolean doesFileContainDates(Date date, Date date2) {
        Date date3 = date;
        Date date4 = date2;
        if (date3 == null && (date3 = this.firstTimestamp) == null) {
            date3 = new Date(0L);
        }
        if (date4 == null && (date4 = this.lastTimestamp) == null) {
            date4 = new Date(Long.MAX_VALUE);
        }
        if (this.firstTimestamp == null) {
            Output.printTrace("First timestamp is null for " + this.fileName, 3);
        }
        if (this.lastTimestamp == null) {
            Output.printTrace("Last timestamp is null for " + this.fileName, 3);
        }
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        if (this.firstTimestamp != null) {
            n = this.firstTimestamp.compareTo(date3);
            n2 = this.firstTimestamp.compareTo(date4);
        }
        if (this.lastTimestamp != null) {
            n3 = this.lastTimestamp.compareTo(date3);
            n4 = this.lastTimestamp.compareTo(date4);
        }
        if (this.firstTimestamp == null || this.lastTimestamp == null) {
            n = this.lastModified.compareTo(date3);
            n2 = this.lastModified.compareTo(date4);
            n3 = this.lastModified.compareTo(date3);
            n4 = this.lastModified.compareTo(date4);
        }
        if (n >= 0 && n2 <= 0) {
            return true;
        }
        if (n3 >= 0 && n4 <= 0) {
            return true;
        }
        return n < 0 && n4 > 0;
    }

    public void dumpBasicInfo() {
        System.out.println("############################################");
        System.out.println("File: " + this.shortName);
        System.out.println("");
        System.out.println("     Full Path: " + this.fileName);
        try {
            System.out.println("     Type: " + this.type);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.out.println("     Size: " + this.fileSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.out.println("     First Time: " + this.firstTimestamp.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.out.println("     Last Time: " + this.lastTimestamp.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean fileExists() {
        File file = new File(this.fileName);
        return file.exists();
    }

    public void setBaseDirectory(String string) {
        this.baseDirectory = string;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String toString() {
        return this.shortName;
    }

    public void setTrimFile() {
        this.isTrimFile = true;
    }

    public void printFileDetails() {
        Output.print("##################################################");
        Output.print("File: " + this.fileName);
        Output.print("....Last Modified: " + this.lastModified);
        Output.print("....File Type: " + this.type);
        Output.print("....First Time: " + this.firstTimestamp);
        Output.print("....Last Time: " + this.lastTimestamp);
        Output.print("....Size: " + this.fileSize);
        Output.print("....Database: " + this.database);
        Output.print("....Instance: " + this.instance);
        Output.print("....Component: " + this.component);
        Output.print("....Base Directory: " + this.baseDirectory);
        Output.print("....Number of lines: " + this.numberOfLines);
        Output.print("....Sampling Row Number First: " + this.samplingRowNumberFirst);
        Output.print("....Sampling Row Number Last: " + this.samplingRowNumberLast);
        Output.print("....Date Pattern: " + this.datePattern);
        Output.print("....Sampling Size: " + this.samplingSize);
    }

    public void printFileDetails(PrintWriter printWriter, String string) {
        if (printWriter != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM/dd/yy HH:mm");
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = new Host().getHostname().trim();
            if (this.firstTimestamp != null) {
                string2 = simpleDateFormat.format(this.firstTimestamp);
            }
            if (this.lastTimestamp != null) {
                string3 = simpleDateFormat.format(this.lastTimestamp);
            }
            if (this.lastModified != null) {
                string4 = simpleDateFormat.format(this.lastModified);
            }
            if (string == null) {
                printWriter.println(this.fileName + "!" + string4 + "!" + this.type + "!" + string2 + "!" + string3 + "!" + this.fileSize / 1000L + "!" + string5);
            } else {
                printWriter.println(this.fileName + "!" + string4 + "!" + this.type + "!" + string2 + "!" + string3 + "!" + this.fileSize / 1000L + "!" + string);
            }
        } else {
            Output.printTrace("##################################################", 3);
            Output.printTrace("File: " + this.fileName, 3);
            Output.printTrace("....Last Modified: " + this.lastModified, 3);
            Output.printTrace("....File Type: " + this.type, 3);
            Output.printTrace("....First Time: " + this.firstTimestamp, 3);
            Output.printTrace("....Last Time: " + this.lastTimestamp, 3);
            Output.printTrace("....Size: " + this.fileSize, 3);
        }
    }

    public void writeFileDetails(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("##################################################\n");
            bufferedWriter.write("File: " + this.fileName + "\n");
            bufferedWriter.write("....Last Modified: " + this.lastModified + "\n");
            bufferedWriter.write("....File Type: " + this.type + "\n");
            bufferedWriter.write("....First Time: " + this.firstTimestamp + "\n");
            bufferedWriter.write("....Last Time: " + this.lastTimestamp + "\n");
            bufferedWriter.write("....Size: " + this.fileSize + "\n");
            bufferedWriter.write("....Instance: " + this.instance + "\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setTimestampOffset(List<Integer> list) {
        this.timestampOffset = list;
    }

    public List<Integer> getTimestampOffset() {
        return this.timestampOffset;
    }

    public String getComponent() {
        return this.component;
    }

    public String getCategory() {
        return this.category;
    }

    public void setAlsoCollectFor(String string) {
        this.alsoCollectFor = string;
    }

    public String getAlsoCollectFor() {
        return this.alsoCollectFor;
    }

    public void setComponent(String string) {
        this.component = string;
    }

    public void setLastModified(Date date) {
        this.lastModified = date;
    }

    public void setSamplingRowNumberFirst(int n) {
        this.samplingRowNumberFirst = n;
    }

    public void setSamplingRowNumberLast(int n) {
        this.samplingRowNumberLast = n;
    }

    public void setSamplingSize(int n) {
        this.samplingSize = n;
    }

    public void setHostName(String string) {
        this.hostName = string;
    }

    public void setUseDfOnly(boolean bl) {
        this.useDfOnly = bl;
    }

    public void setKeepHeaderLines(long l) {
        this.keepHeaderLines = l;
    }

    public boolean isUseDfOnly() {
        return this.useDfOnly;
    }

    public long getKeepHeaderLines() {
        return this.keepHeaderLines;
    }

    public static boolean deleteAllFileEntities() {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(String.class, FileEntity.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (FileEntity fileEntity : entityCursor) {
                    primaryIndex.delete((Object)fileEntity.getFileName());
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteAllFileEntities: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteAllFileEntities: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object == null || object.getClass() != this.getClass()) {
            bl = false;
        } else {
            FileEntity fileEntity = (FileEntity)object;
            if (this.getFileName().equals(fileEntity.getFileName())) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getFileName() == null ? 0 : this.getFileName().hashCode());
        return n;
    }

    public void store(FileEntityDA fileEntityDA) {
        Transaction transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
        try {
            fileEntityDA.pIdx.put(transaction, (Object)this);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.abort();
                transaction = null;
            }
            Output.print("FileEntity: Caught Exception in storing FileEntity.");
        }
    }
}

