/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.util.Date;
import java.util.List;
import oracle.rat.tfa.db.DataAccessor.EventMapDA;
import oracle.rat.tfa.entity.entitykey.EventMapKey;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;

@Entity(version=4)
public class EventMapEntity
implements Comparable {
    @PrimaryKey
    private EventMapKey key;
    private long eventStartTrimBuffer;
    private long eventEndTrimBuffer;
    private boolean processStatus = false;
    private Date processTime = null;
    private List<String> extraComponents = null;
    private boolean notify = false;
    private boolean clusterwide = false;

    public EventMapEntity() {
    }

    public EventMapEntity(Date date, String string, String string2, long l, long l2, String string3, List<String> list) {
        this.key = new EventMapKey(date, string3, string, string2);
        this.eventStartTrimBuffer = l;
        this.eventEndTrimBuffer = l2;
        this.extraComponents = list;
    }

    public int compareTo(Object object) {
        int n = this.getTimestamp().compareTo(((EventMapEntity)object).getTimestamp());
        if (n == 0 && (n = this.getSearchString().compareTo(((EventMapEntity)object).getSearchString())) == 0 && (n = this.getFileName().compareTo(((EventMapEntity)object).getFileName())) == 0) {
            n = this.getStr().compareTo(((EventMapEntity)object).getStr());
        }
        return n;
    }

    public EventMapKey getKey() {
        return this.key;
    }

    public Date getTimestamp() {
        return this.key.getTimestamp();
    }

    public String getStr() {
        return this.key.getStr();
    }

    public String getSearchString() {
        return this.key.getSearchString();
    }

    public String getFileName() {
        return this.key.getFileName();
    }

    public void setProcessStatus(boolean bl) {
        this.processStatus = bl;
    }

    public boolean isProcessStatus() {
        return this.processStatus;
    }

    public long getEventStartTrimBuffer() {
        return this.eventStartTrimBuffer;
    }

    public long getEventEndTrimBuffer() {
        return this.eventEndTrimBuffer;
    }

    public void setProcessTime(Date date) {
        this.processTime = date;
    }

    public Date getProcessTime() {
        return this.processTime;
    }

    public List<String> getExtraComponents() {
        return this.extraComponents;
    }

    public void setNotify(boolean bl) {
        this.notify = bl;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setClusterwide(boolean bl) {
        this.clusterwide = bl;
    }

    public boolean isClusterwide() {
        return this.clusterwide;
    }

    public synchronized void store() {
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            EventMapDA eventMapDA = new EventMapDA();
            eventMapDA.pIdx.put((Object)this);
            try {
                transaction.commit();
            }
            catch (LockConflictException lockConflictException) {
                Output.print("################# " + lockConflictException.getMessage() + " : caught Lock conflict");
                try {
                    if (transaction != null) {
                        transaction.abort();
                    }
                }
                catch (DatabaseException databaseException) {
                    Output.print("txn abort failed: " + databaseException.toString());
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("Initial Transaction Try failed: " + databaseException.toString());
            databaseException.printStackTrace();
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object == null || object.getClass() != this.getClass()) {
            bl = false;
        } else {
            EventMapEntity eventMapEntity = (EventMapEntity)object;
            if (this.getTimestamp().equals(eventMapEntity.getTimestamp()) && this.getStr().equals(eventMapEntity.getStr()) && this.getSearchString().equals(eventMapEntity.getSearchString()) && this.getFileName().equals(eventMapEntity.getFileName())) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        n += this.getStr() == null ? 0 : this.getStr().hashCode();
        n += this.getSearchString() == null ? 0 : this.getSearchString().hashCode();
        return n += this.getFileName() == null ? 0 : this.getFileName().hashCode();
    }
}

