/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import oracle.rat.tfa.db.DataAccessor.DatabaseParameterDA;
import oracle.rat.tfa.db.DbPut;
import oracle.rat.tfa.db.OracleJdbc;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.entitykey.DatabaseParameterKey;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SessionIdentifierGenerator;
import oracle.rat.tfa.xml.DatabaseParameterXMLReader;

@Entity(version=1)
public class DatabaseParameter {
    @PrimaryKey
    DatabaseParameterKey key;
    String value;
    String atStartup;
    String eventId;

    public DatabaseParameter() {
    }

    public DatabaseParameter(String string, Date date, String string2, String string3, String string4) {
        this.value = string3;
        this.key = new DatabaseParameterKey(string, date, string2);
        this.atStartup = string4;
        SessionIdentifierGenerator sessionIdentifierGenerator = new SessionIdentifierGenerator();
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        this.eventId = stringBuilder.append(Properties.getClusterName()).append(sessionIdentifierGenerator.nextSessionId()).toString();
    }

    public DatabaseParameter(String string, Date date, String string2, String string3, String string4, String string5) {
        this.value = string3;
        this.key = new DatabaseParameterKey(string, date, string2);
        this.atStartup = string4;
        this.eventId = string5;
    }

    public String getParameterName() {
        return this.key.getparameterName();
    }

    public String getParameterValue() {
        return this.value;
    }

    public String getFileName() {
        return this.key.getFileName();
    }

    public Date getSetTime() {
        return this.key.getSetTime();
    }

    public void setParameterValue(String string) {
        this.value = string;
    }

    public void store(DbPut dbPut) {
        DatabaseParameterDA databaseParameterDA = new DatabaseParameterDA();
        databaseParameterDA.pIdx.put((Object)this);
    }

    public void print() {
        Output.print("++++++ DB Parameter Start +++++");
        Output.print("Event Id     : " + this.eventId);
        Output.print("File Name    : " + this.getFileName());
        Output.print("Set Time     : " + this.getSetTime().toString());
        Output.print("Param Name   : " + this.getParameterName());
        Output.print("Param Value  : " + this.value);
        Output.print("At Startup   : " + this.atStartup);
        Output.print("++++++ DB Parameter  End +++++");
    }

    public String dumpXml() {
        String string = "";
        string = string + "<parameter>" + "\n";
        string = string + "<eventid>" + this.eventId + "</eventid>" + "\n";
        string = string + "<timeset>" + this.getSetTime().toString() + "</timeset>" + "\n";
        string = string + "<paramname>" + this.getParameterName() + "</paramname>" + "\n";
        string = string + "<paramvalue>" + this.value + "</paramvalue>" + "\n";
        string = string + "<atstartup>" + this.atStartup + "</atstartup>" + "\n";
        string = string + "</parameter>" + "\n";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpToOracle() throws DatabaseException {
        long l = 0L;
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(DatabaseParameter.class);
        EntityCursor entityCursor = primaryIndex.entities();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = OracleJdbc.getConnection();
            if (connection != null) {
                statement = connection.prepareStatement("begin tfa_v2.addDbParam(                     srFileId => ?,                      fileName => ?,                      hostname => ?,                     timeSet => ?,                      paramName => ?,                      paramValue => ?,                     atStartup => ?                      ); end;");
                for (DatabaseParameter databaseParameter : entityCursor) {
                    Timestamp timestamp = null;
                    if (databaseParameter.getSetTime() != null) {
                        timestamp = new Timestamp(databaseParameter.getSetTime().getTime());
                    }
                    Properties.getInstance();
                    statement.setString(1, Properties.srFileId);
                    statement.setString(2, databaseParameter.getFileName());
                    statement.setNull(3, 12);
                    statement.setTimestamp(4, timestamp);
                    statement.setString(5, databaseParameter.getParameterName());
                    statement.setString(6, databaseParameter.getParameterValue());
                    statement.setString(7, databaseParameter.atStartup);
                    statement.execute();
                    ++l;
                }
                connection.commit();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            exception.printStackTrace();
        }
        finally {
            entityCursor.close();
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("++++++ Parameter Start +++++");
        printWriter.println("Event Id       : " + this.eventId);
        printWriter.println("File Name      : " + this.getFileName());
        printWriter.println("Startup Time   : " + this.atStartup);
        printWriter.println("Parameter Name : " + this.getParameterName());
        printWriter.println("Parameter Name : " + this.getParameterValue());
        printWriter.println("Set Time       : " + this.getSetTime().toString());
        printWriter.println("++++++ Parameter End +++++");
    }

    public static synchronized DatabaseParameter getEvent(String string) throws DatabaseException {
        DatabaseParameter databaseParameter = null;
        DatabaseParameterDA databaseParameterDA = new DatabaseParameterDA();
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(DatabaseParameter.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (DatabaseParameter databaseParameter2 : entityCursor) {
                    if (!databaseParameter2.eventId.equals(string)) continue;
                    databaseParameter = databaseParameter2;
                    break;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        return databaseParameter;
    }

    public static synchronized void printEvents(PrintWriter printWriter) throws DatabaseException {
        DatabaseParameterDA databaseParameterDA = new DatabaseParameterDA();
        Transaction transaction = null;
        long l = 0L;
        String string = new Host().getHostname().trim();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(DatabaseParameter.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (DatabaseParameter databaseParameter : entityCursor) {
                    printWriter.println(databaseParameter.eventId + "!" + string + "!Database Parameter!" + simpleDateFormat.format(databaseParameter.getSetTime()) + "!" + databaseParameter.getFileName());
                    ++l;
                }
                printWriter.println("Total Params found in database: " + l);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static synchronized void printXMLEvents(PrintWriter printWriter, List<String> list) throws DatabaseException {
        String string = Properties.inventoryDir + File.separator;
        long l = 0L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        for (String string2 : list) {
            String string3 = string + string2 + "_DatabaseParameter.xml";
            if (!new File(string3).exists()) continue;
            try {
                DatabaseParameterXMLReader databaseParameterXMLReader = new DatabaseParameterXMLReader(string3);
                for (DatabaseParameter databaseParameter : databaseParameterXMLReader.getDatabaseParameterEntities()) {
                    printWriter.println(databaseParameter.eventId + "!" + string2 + "!Database Parameter!" + simpleDateFormat.format(databaseParameter.getSetTime()) + "!" + databaseParameter.getFileName());
                    ++l;
                }
                printWriter.println("Total Params found in database: " + l);
            }
            catch (DatabaseException databaseException) {
                Output.print(databaseException.toString());
            }
        }
    }

    public static synchronized void printAll(PrintWriter printWriter) throws DatabaseException {
        DatabaseParameterDA databaseParameterDA = new DatabaseParameterDA();
        Transaction transaction = null;
        long l = 0L;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(DatabaseParameter.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (DatabaseParameter databaseParameter : entityCursor) {
                    databaseParameter.print(printWriter);
                    ++l;
                }
                printWriter.println("Total Params found in database: " + l);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static boolean deleteAllDatabaseParameters() {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(DatabaseParameterKey.class, DatabaseParameter.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (DatabaseParameter databaseParameter : entityCursor) {
                    primaryIndex.delete((Object)databaseParameter.key);
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteAllDatabaseParameters: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteAllDatabaseParameters: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean deleteDatabaseParameterEvent(String string) {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(DatabaseParameterKey.class, DatabaseParameter.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (DatabaseParameter databaseParameter : entityCursor) {
                    if (!databaseParameter.getFileName().equalsIgnoreCase(string)) continue;
                    primaryIndex.delete((Object)databaseParameter.key);
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteDatabaseParameterEvent: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteDatabaseParameterEvent: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }
}

