/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import oracle.rat.tfa.analysis.Globals.hAlrtDbGenErr;
import oracle.rat.tfa.db.DataAccessor.DatabaseGeneralErrorDA;
import oracle.rat.tfa.db.DbPut;
import oracle.rat.tfa.db.OracleJdbc;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.entitykey.DatabaseGeneralErrorKey;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SessionIdentifierGenerator;
import oracle.rat.tfa.xml.DatabaseGeneralErrorXMLReader;

@Entity(version=1)
public class DatabaseGeneralError {
    @PrimaryKey
    DatabaseGeneralErrorKey key;
    String traceFileName;
    String eventId;

    public DatabaseGeneralError() {
    }

    public DatabaseGeneralError(String string, Date date, Date date2, String string2, String string3, hAlrtDbGenErr hAlrtDbGenErr2) {
        this.traceFileName = hAlrtDbGenErr2.getFileName() != null ? hAlrtDbGenErr2.getFileName() : "NONE";
        this.key = new DatabaseGeneralErrorKey(string, date, date2, string2, string3);
        SessionIdentifierGenerator sessionIdentifierGenerator = new SessionIdentifierGenerator();
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        this.eventId = stringBuilder.append(Properties.getClusterName()).append(sessionIdentifierGenerator.nextSessionId()).toString();
    }

    public DatabaseGeneralError(String string, Date date, Date date2, String string2, String string3, hAlrtDbGenErr hAlrtDbGenErr2, String string4) {
        this.traceFileName = hAlrtDbGenErr2.getFileName() != null ? hAlrtDbGenErr2.getFileName() : "NONE";
        this.key = new DatabaseGeneralErrorKey(string, date, date2, string2, string3);
        this.eventId = string4;
    }

    public String getErrorCode() {
        return this.key.getErrorCode();
    }

    public String getErrorText() {
        return this.key.getErrorText();
    }

    public String getErrorTime() {
        return this.key.getErrorTime().toString();
    }

    public Date getErrorTimeObj() {
        return this.key.getErrorTime();
    }

    public String getFileName() {
        return this.key.getFileName();
    }

    public String getTraceFileName() {
        return this.traceFileName;
    }

    public Date getStartupTime() {
        return this.key.getStartupTime();
    }

    public void setErrorText(String string) {
        this.key.setErrorText(string);
    }

    public void setErrorCode(String string) {
        this.key.setErrorCode(string);
    }

    public void store(DbPut dbPut) {
        EntityStore entityStore = dbPut.getStore();
        DatabaseGeneralErrorDA databaseGeneralErrorDA = new DatabaseGeneralErrorDA();
        databaseGeneralErrorDA.pIdx.put((Object)this);
    }

    public void print() {
        Output.print("++++++ DB General Error Start +++++");
        Output.print("Event Id     : " + this.eventId);
        Output.print("File Name    : " + this.getFileName());
        Output.print("Startup Time : " + this.getStartupTime().toString());
        Output.print("Error Code   : " + this.getErrorCode());
        Output.print("Error Text   : " + this.key.getErrorText());
        Output.print("Error Time   : " + this.getErrorTime());
        Output.print("Trace File   : " + this.traceFileName);
        Output.print("++++++ DB General Error  End +++++");
    }

    public String dumpXml() {
        String string = "";
        string = string + "<dbgeneralerror>" + "\n";
        string = string + "<eventid>" + this.eventId + "</eventid>" + "\n";
        string = string + "<startuptime>" + this.getStartupTime().toString() + "</startuptime>" + "\n";
        string = string + "<errorcode>" + this.getErrorCode() + "</errorcode>" + "\n";
        string = string + "<errortext>" + this.key.getErrorText() + "</errortext>" + "\n";
        string = string + "<errortime>" + this.getErrorTime() + "</errortime>" + "\n";
        string = string + "<tracefile>" + this.traceFileName + "</tracefile>" + "\n";
        string = string + "</dbgeneralerror>" + "\n";
        return string;
    }

    public String dumpSimileXml() {
        String string = "";
        String string2 = this.getErrorText();
        string = string + "<event start=\"" + this.getErrorTime() + "\" icon=\"red-circle.png\" title=\"" + this.getErrorCode() + "\">" + string2 + "</event>\n";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpToOracle() throws DatabaseException {
        long l = 0L;
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(DatabaseGeneralError.class);
        EntityCursor entityCursor = primaryIndex.entities();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = OracleJdbc.getConnection();
            if (connection != null) {
                statement = connection.prepareStatement("begin tfa_v2.addDbError(                     srFileId => ?,                      fileName => ?,                      hostname => ?,                     errorTime => ?,                      startupTime => ?,                      errorCode => ?,                     errorText => ?,                      tracefile => ?                     ); end;");
                for (DatabaseGeneralError databaseGeneralError : entityCursor) {
                    Timestamp timestamp = null;
                    if (databaseGeneralError.getErrorTime() != null) {
                        timestamp = new Timestamp(databaseGeneralError.getErrorTimeObj().getTime());
                    }
                    Timestamp timestamp2 = null;
                    if (databaseGeneralError.getStartupTime() != null) {
                        timestamp2 = new Timestamp(databaseGeneralError.getStartupTime().getTime());
                    }
                    Properties.getInstance();
                    statement.setString(1, Properties.srFileId);
                    statement.setString(2, databaseGeneralError.getFileName());
                    statement.setNull(3, 12);
                    statement.setTimestamp(4, timestamp);
                    statement.setTimestamp(5, timestamp2);
                    statement.setString(6, databaseGeneralError.getErrorCode());
                    statement.setString(7, databaseGeneralError.getErrorText());
                    statement.setString(8, databaseGeneralError.getTraceFileName());
                    statement.execute();
                    ++l;
                }
                connection.commit();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            exception.printStackTrace();
        }
        finally {
            entityCursor.close();
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("++++++ Error Start +++++");
        printWriter.println("Event Id          : " + this.eventId);
        printWriter.println("File Name         : " + this.getFileName());
        printWriter.println("Error Code        : " + this.getErrorCode());
        printWriter.println("Error Description : " + this.getErrorText());
        printWriter.println("Error Time        : " + this.getErrorTime().toString());
        printWriter.println("Startup Time          : " + this.getStartupTime());
        printWriter.println("Trace File Name   : " + this.getTraceFileName());
        printWriter.println("++++++ Error End +++++");
    }

    public static synchronized DatabaseGeneralError getEvent(String string) throws DatabaseException {
        DatabaseGeneralError databaseGeneralError = null;
        DatabaseGeneralErrorDA databaseGeneralErrorDA = new DatabaseGeneralErrorDA();
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(DatabaseGeneralError.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (DatabaseGeneralError databaseGeneralError2 : entityCursor) {
                    if (!databaseGeneralError2.eventId.equals(string)) continue;
                    databaseGeneralError = databaseGeneralError2;
                    break;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        return databaseGeneralError;
    }

    public static synchronized void printEvents(PrintWriter printWriter, long l) throws DatabaseException {
        DatabaseGeneralErrorDA databaseGeneralErrorDA = new DatabaseGeneralErrorDA();
        Transaction transaction = null;
        long l2 = 0L;
        String string = new Host().getHostname().trim();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(DatabaseGeneralError.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (DatabaseGeneralError databaseGeneralError : entityCursor) {
                    long l3 = databaseGeneralError.getErrorTimeObj().getTime();
                    long l4 = Calendar.getInstance().getTimeInMillis();
                    long l5 = (l4 - l3) / 1000L;
                    if (l5 > l) continue;
                    printWriter.println(databaseGeneralError.eventId + "!" + string + "!Database General Error!" + simpleDateFormat.format(databaseGeneralError.getErrorTimeObj()) + "!" + databaseGeneralError.getTraceFileName() + "!" + databaseGeneralError.getErrorCode());
                    ++l2;
                }
                printWriter.println("Total Errors found in database: " + l2);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static synchronized void printXMLEvents(PrintWriter printWriter, long l, List<String> list) throws DatabaseException {
        String string = Properties.inventoryDir + File.separator;
        long l2 = 0L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        for (String string2 : list) {
            String string3 = string + string2 + "_DatabaseGeneralError.xml";
            if (!new File(string3).exists()) continue;
            try {
                DatabaseGeneralErrorXMLReader databaseGeneralErrorXMLReader = new DatabaseGeneralErrorXMLReader(string3);
                for (DatabaseGeneralError databaseGeneralError : databaseGeneralErrorXMLReader.getDatabaseGeneralErrorEntities()) {
                    long l3 = databaseGeneralError.getErrorTimeObj().getTime();
                    long l4 = Calendar.getInstance().getTimeInMillis();
                    long l5 = (l4 - l3) / 1000L;
                    if (l5 > l) continue;
                    printWriter.println(databaseGeneralError.eventId + "!" + string2 + "!Database General Error!" + simpleDateFormat.format(databaseGeneralError.getErrorTimeObj()) + "!" + databaseGeneralError.getTraceFileName() + "!" + databaseGeneralError.getErrorCode());
                    ++l2;
                }
                printWriter.println("Total Errors found in database: " + l2);
            }
            catch (DatabaseException databaseException) {
                Output.print(databaseException.toString());
            }
        }
    }

    public static synchronized void printAll(PrintWriter printWriter) throws DatabaseException {
        DatabaseGeneralErrorDA databaseGeneralErrorDA = new DatabaseGeneralErrorDA();
        Transaction transaction = null;
        long l = 0L;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(DatabaseGeneralError.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (DatabaseGeneralError databaseGeneralError : entityCursor) {
                    databaseGeneralError.print(printWriter);
                    ++l;
                }
                printWriter.println("Total Errors found in database: " + l);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public DatabaseGeneralErrorKey getKey() {
        return this.key;
    }

    public static boolean deleteAllDatabaseErrors() {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(DatabaseGeneralErrorKey.class, DatabaseGeneralError.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (DatabaseGeneralError databaseGeneralError : entityCursor) {
                    primaryIndex.delete((Object)databaseGeneralError.getKey());
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteAllDatabaseErrors: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteAllDatabaseErrors: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean deleteDatabaseErrorEvent(String string) {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(DatabaseGeneralErrorKey.class, DatabaseGeneralError.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (DatabaseGeneralError databaseGeneralError : entityCursor) {
                    if (!databaseGeneralError.getFileName().equalsIgnoreCase(string)) continue;
                    primaryIndex.delete((Object)databaseGeneralError.getKey());
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteDatabaseErrorEvent: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteDatabaseErrorEvent: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }
}

