/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import oracle.rat.tfa.db.DataAccessor.CollectionDA;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;

@Entity(version=4)
public class Collection {
    @PrimaryKey
    private String collectionId;
    private String masterHost;
    private String tag;
    private String zipFileName;
    private String diagcollectLog;
    private String hostname;
    private Set<String> nodeList = new HashSet<String>();
    private Set<String> componentList = new HashSet<String>();
    private Date startTime;
    private Date endTime;
    private String tempFile;
    private long filesInRange;
    private long sizeOfFilesInRange;
    private long sizeOfExtraFiles;
    private long sizeOfFilesBeforeZip;
    private long zipFileSize;
    private long numTrimmedFiles;
    private long trimSavings;
    private String requestUser;
    private String TFAVersion;
    private String TFABuildId;
    private boolean manual;
    private Set<String> events = new HashSet<String>();
    private long collectionTime;
    private int score;
    private int additionalZipCounter = 0;
    private String[] ziplist = null;
    private Date collectionDate = null;
    public static LinkedBlockingQueue<String> remoteCollectionMessages = new LinkedBlockingQueue(20000);

    public Collection() {
    }

    public Collection(String string) {
        this.collectionId = string;
    }

    public Collection(String string, Date date, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        this.collectionId = string;
        this.collectionDate = date;
        this.masterHost = string2;
        this.tag = string4;
        this.zipFileName = string5;
        this.diagcollectLog = string6;
        this.hostname = string3;
        this.startTime = this.startTime;
        this.endTime = this.endTime;
        this.zipFileName = string5;
        this.requestUser = this.requestUser;
        this.TFAVersion = string7;
        this.TFABuildId = string8;
        this.manual = bl;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionDate(Date date) {
        this.collectionDate = date;
    }

    public Date getCollectionDate() {
        return this.collectionDate;
    }

    public void setMasterHost(String string) {
        this.masterHost = string;
    }

    public String getMasterHost() {
        return this.masterHost;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public String getTag() {
        return this.tag;
    }

    public void setDiagcollectLog(String string) {
        this.diagcollectLog = string;
    }

    public String getDiagcollectLog() {
        return this.diagcollectLog;
    }

    public void setZipFileName(String string) {
        this.zipFileName = string;
    }

    public String getZipFileName() {
        return this.zipFileName;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setComponentList(Set<String> set) {
        this.componentList = set;
    }

    public Set<String> getComponentList() {
        return this.componentList;
    }

    public void setNodeList(Set<String> set) {
        this.nodeList = set;
    }

    public Set<String> getNodeList() {
        return this.nodeList;
    }

    public void setStartTime(Date date) {
        this.startTime = date;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setTempFile(String string) {
        this.tempFile = string;
    }

    public String getTempFile() {
        return this.tempFile;
    }

    public void setFilesInRange(long l) {
        this.filesInRange = l;
    }

    public long getFilesInRange() {
        return this.filesInRange;
    }

    public void setSizeOfFilesInRange(long l) {
        this.sizeOfFilesInRange = l;
    }

    public long getSizeOfFilesInRange() {
        return this.sizeOfFilesInRange;
    }

    public void setSizeOfExtraFiles(long l) {
        this.sizeOfExtraFiles = l;
    }

    public long getSizeOfExtraFiles() {
        return this.sizeOfExtraFiles;
    }

    public void setSizeOfFilesBeforeZip(long l) {
        this.sizeOfFilesBeforeZip = l;
    }

    public long getSizeOfFilesBeforeZip() {
        return this.sizeOfFilesBeforeZip;
    }

    public void setZipFileSize(long l) {
        this.zipFileSize = l;
    }

    public long getZipFileSize() {
        return this.zipFileSize;
    }

    public static void setRemoteCollectionMessages(LinkedBlockingQueue<String> linkedBlockingQueue) {
        remoteCollectionMessages = linkedBlockingQueue;
    }

    public static LinkedBlockingQueue<String> getRemoteCollectionMessages() {
        return remoteCollectionMessages;
    }

    public void setRequestUser(String string) {
        this.requestUser = string;
    }

    public String getRequestUser() {
        return this.requestUser;
    }

    public void setNumTrimmedFiles(long l) {
        this.numTrimmedFiles = l;
    }

    public long getNumTrimmedFiles() {
        return this.numTrimmedFiles;
    }

    public void setTrimSavings(long l) {
        this.trimSavings = l;
    }

    public long getTrimSavings() {
        return this.trimSavings;
    }

    public void setTFAVersion(String string) {
        this.TFAVersion = string;
    }

    public String getTFAVersion() {
        return this.TFAVersion;
    }

    public void setTFABuildId(String string) {
        this.TFABuildId = string;
    }

    public String getTFABuildId() {
        return this.TFABuildId;
    }

    public void setManual(boolean bl) {
        this.manual = bl;
    }

    public boolean isManual() {
        return this.manual;
    }

    public void setEvents(Set<String> set) {
        this.events = set;
    }

    public Set<String> getEvents() {
        return this.events;
    }

    public void setCollectionTime(long l) {
        this.collectionTime = l;
    }

    public long getCollectionTime() {
        return this.collectionTime;
    }

    public void setScore(int n) {
        this.score = n;
    }

    public int getScore() {
        return this.score;
    }

    public void setAdditionalZipCounter(int n) {
        this.additionalZipCounter = n;
    }

    public int getAdditionalZipCounter() {
        return this.additionalZipCounter;
    }

    public void setZiplist() {
        this.ziplist = new String[this.additionalZipCounter];
        for (int i = 0; i < this.additionalZipCounter; ++i) {
            String string = this.getZipFileName().replace(".zip", "");
            this.ziplist[i] = string = string + "_" + (i + 1) + ".zip";
        }
    }

    public String[] getZiplist() {
        return this.ziplist;
    }

    public String getZipNameFromList(int n) {
        String string = null;
        if (this.ziplist != null) {
            try {
                string = this.ziplist[n];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store() {
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CollectionDA collectionDA = new CollectionDA();
            int n = 0;
            boolean bl = false;
            while (n < 3 && !bl) {
                try {
                    collectionDA.pIdx.put((Object)this);
                    transaction.commit();
                    bl = true;
                }
                catch (LockConflictException lockConflictException) {
                    ++n;
                    Output.print("Lock conflict in storing collection details for collectionId: " + this.collectionId);
                }
                catch (Exception exception) {
                    ++n;
                    Output.print("Exception in storing collection details for collectionId: " + this.collectionId);
                }
                finally {
                    if (n != 3) continue;
                    try {
                        if (transaction == null) continue;
                        transaction.abort();
                    }
                    catch (DatabaseException databaseException) {
                        Output.print("txn abort failed: " + databaseException.toString());
                    }
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("Initial Transaction Try failed: " + databaseException.toString());
            databaseException.printStackTrace();
        }
    }
}

