/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import oracle.rat.tfa.db.DataAccessor.AlertClusterReconfigurationDA;
import oracle.rat.tfa.db.DbPut;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.entitykey.AlertClusterReconfigurationKey;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SessionIdentifierGenerator;
import oracle.rat.tfa.xml.AlertClusterReconfigurationXMLReader;

@Entity(version=1)
public class AlertClusterReconfiguration {
    @PrimaryKey
    AlertClusterReconfigurationKey key;
    String[] node;
    String code;
    String text;
    String eventId;

    public AlertClusterReconfiguration() {
    }

    public AlertClusterReconfiguration(String string, Date date, String string2, String string3, String string4) {
        this.key = new AlertClusterReconfigurationKey(string, date);
        this.node = string2.split(" ");
        this.code = string3;
        this.text = string4;
        SessionIdentifierGenerator sessionIdentifierGenerator = new SessionIdentifierGenerator();
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        this.eventId = stringBuilder.append(Properties.getClusterName()).append(sessionIdentifierGenerator.nextSessionId()).toString();
    }

    public AlertClusterReconfiguration(String string, Date date, String string2, String string3, String string4, String string5) {
        this.key = new AlertClusterReconfigurationKey(string, date);
        this.node = string2.split(" ");
        this.code = string3;
        this.text = string4;
        this.eventId = string5;
    }

    public String getFileName() {
        return this.key.getFileName();
    }

    public String[] getNodes() {
        return this.node;
    }

    public Date getreconfigTime() {
        return this.key.getreconfigTime();
    }

    public void store(DbPut dbPut) {
        EntityStore entityStore = dbPut.getStore();
        AlertClusterReconfigurationDA alertClusterReconfigurationDA = new AlertClusterReconfigurationDA();
        alertClusterReconfigurationDA.pIdx.put((Object)this);
    }

    public synchronized void store() {
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            AlertClusterReconfigurationDA alertClusterReconfigurationDA = new AlertClusterReconfigurationDA();
            alertClusterReconfigurationDA.pIdx.put((Object)this);
            try {
                transaction.commit();
            }
            catch (LockConflictException lockConflictException) {
                Output.print("################# " + lockConflictException.getMessage() + " : caught Lock conflict");
                try {
                    if (transaction != null) {
                        transaction.abort();
                    }
                }
                catch (DatabaseException databaseException) {
                    Output.print("txn abort failed: " + databaseException.toString());
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("Initial Transaction Try failed: " + databaseException.toString());
            databaseException.printStackTrace();
        }
    }

    public void print() {
        Output.print("++++++ Alert Cluster Reconfig Start +++++");
        Output.print("Event Id: " + this.eventId);
        Output.print("File Name: " + this.getFileName());
        Output.print("Recon Time: " + this.getreconfigTime());
        Output.print("Nodes: " + this.getNodes().length);
        for (int i = 0; i < this.getNodes().length; ++i) {
            Output.print("Node Name: " + this.getNodes()[i]);
        }
        Output.print("++++++ Alert Cluster Reconfig  End +++++");
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("++++++ Alert Cluster Reconfig Start +++++");
        printWriter.println("Event Id: " + this.eventId);
        printWriter.println("File Name: " + this.getFileName());
        printWriter.println("Recon Time: " + this.getreconfigTime());
        printWriter.println("Nodes: " + this.getNodes().length);
        for (int i = 0; i < this.getNodes().length; ++i) {
            printWriter.println("Node Name: " + this.getNodes()[i]);
        }
        printWriter.println("++++++ Alert Cluster Reconfig  End +++++");
    }

    public static synchronized AlertClusterReconfiguration getEvent(String string) throws DatabaseException {
        AlertClusterReconfiguration alertClusterReconfiguration = null;
        AlertClusterReconfigurationDA alertClusterReconfigurationDA = new AlertClusterReconfigurationDA();
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(AlertClusterReconfiguration.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (AlertClusterReconfiguration alertClusterReconfiguration2 : entityCursor) {
                    if (!alertClusterReconfiguration2.eventId.equals(string)) continue;
                    alertClusterReconfiguration = alertClusterReconfiguration2;
                    break;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        return alertClusterReconfiguration;
    }

    public static synchronized void printEvents(PrintWriter printWriter, long l) throws DatabaseException {
        AlertClusterReconfigurationDA alertClusterReconfigurationDA = new AlertClusterReconfigurationDA();
        Transaction transaction = null;
        long l2 = 0L;
        String string = new Host().getHostname().trim();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(AlertClusterReconfiguration.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (AlertClusterReconfiguration alertClusterReconfiguration : entityCursor) {
                    long l3 = alertClusterReconfiguration.getreconfigTime().getTime();
                    long l4 = Calendar.getInstance().getTimeInMillis();
                    long l5 = (l4 - l3) / 1000L;
                    if (l5 > l) continue;
                    printWriter.println(alertClusterReconfiguration.eventId + "!" + string + "!Cluster Reconfiguration!" + simpleDateFormat.format(alertClusterReconfiguration.getreconfigTime()) + "!" + alertClusterReconfiguration.getFileName() + "!" + alertClusterReconfiguration.getNodes().length);
                    ++l2;
                }
                printWriter.println("Total Cluster Reconfigurations found in database: " + l2);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static synchronized void printXMLEvents(PrintWriter printWriter, long l, List<String> list) throws DatabaseException {
        String string = Properties.inventoryDir + File.separator;
        long l2 = 0L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        for (String string2 : list) {
            String string3 = string + string2 + "_AlertClusterReconfiguration.xml";
            if (!new File(string3).exists()) continue;
            try {
                AlertClusterReconfigurationXMLReader alertClusterReconfigurationXMLReader = new AlertClusterReconfigurationXMLReader(string3);
                for (AlertClusterReconfiguration alertClusterReconfiguration : alertClusterReconfigurationXMLReader.getAlertClusterReconfigurationEntities()) {
                    long l3 = alertClusterReconfiguration.getreconfigTime().getTime();
                    long l4 = Calendar.getInstance().getTimeInMillis();
                    long l5 = (l4 - l3) / 1000L;
                    if (l5 > l) continue;
                    printWriter.println(alertClusterReconfiguration.eventId + "!" + string2 + "!Cluster Reconfiguration!" + simpleDateFormat.format(alertClusterReconfiguration.getreconfigTime()) + "!" + alertClusterReconfiguration.getFileName() + "!" + alertClusterReconfiguration.getNodes().length);
                    ++l2;
                }
                printWriter.println("Total Cluster Reconfigurations found in database: " + l2);
            }
            catch (DatabaseException databaseException) {
                Output.print(databaseException.toString());
            }
        }
    }

    public static synchronized void printAll(PrintWriter printWriter) throws DatabaseException {
        AlertClusterReconfigurationDA alertClusterReconfigurationDA = new AlertClusterReconfigurationDA();
        Transaction transaction = null;
        long l = 0L;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(AlertClusterReconfiguration.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (AlertClusterReconfiguration alertClusterReconfiguration : entityCursor) {
                    alertClusterReconfiguration.print(printWriter);
                    ++l;
                }
                printWriter.println("Total Cluster Reconfigurations found in database: " + l);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public String dumpSimileData() {
        String string = "";
        String string2 = "Node : ";
        for (int i = 0; i < this.getNodes().length; ++i) {
            string2 = string2 + this.getNodes()[i] + " ";
        }
        string2 = string2 + " " + this.code + " " + this.text;
        string = string + "{\"start\":\"" + this.getreconfigTime() + "\", " + "\"icon\":\"blue-circle.png\", \"title\":\"Cluster Reconfiguration\", \"caption\":\"" + string2 + "\", \"description\":\"" + string2 + "\"}, ";
        return string;
    }

    public String dumpSimileXml() {
        String string = "";
        String string2 = "";
        for (int i = 0; i < this.getNodes().length; ++i) {
            string2 = string2 + this.getNodes()[i] + " ";
        }
        string = string + "<event start=\"" + this.getreconfigTime() + "\" icon=\"blue-circle.png\" title=\"Cluster Reconfiguration\">" + string2 + "</event>\n";
        return string;
    }

    public String dumpXml() {
        String string = "";
        string = string + "<alertcrsreconfig>" + "\n";
        string = string + "<eventid>" + this.eventId + "</eventid>" + "\n";
        string = string + "<filename>" + this.getFileName() + "</filename>" + "\n";
        string = string + "<reconfigtime>" + this.getreconfigTime() + "</reconfigtime>" + "\n";
        string = string + "<numberofnodes>" + this.getNodes().length + "</numberofnodes>" + "\n";
        string = string + "<nodes>" + "\n";
        for (int i = 0; i < this.getNodes().length; ++i) {
            Output.print("Node Name: " + this.getNodes()[i]);
            string = string + "<nodename>" + this.getNodes()[i] + "</nodename>" + "\n";
        }
        string = string + "</nodes>" + "\n";
        string = string + "<code>" + this.code + "</code>" + "\n";
        string = string + "<text>" + this.text + "</text>" + "\n";
        string = string + "</alertcrsreconfig>" + "\n";
        return string;
    }

    public void setCode(String string) {
        this.code = string;
    }

    public String getCode() {
        return this.code;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public static boolean deleteAllClusterReconfigurartions() {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(AlertClusterReconfigurationKey.class, AlertClusterReconfiguration.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (AlertClusterReconfiguration alertClusterReconfiguration : entityCursor) {
                    primaryIndex.delete((Object)alertClusterReconfiguration.key);
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteAllClusterReconfigurartions: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteAllClusterReconfigurartions: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean deleteClusterReconfigurartionEvent(String string) {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(AlertClusterReconfigurationKey.class, AlertClusterReconfiguration.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (AlertClusterReconfiguration alertClusterReconfiguration : entityCursor) {
                    if (!alertClusterReconfiguration.getFileName().equalsIgnoreCase(string)) continue;
                    primaryIndex.delete((Object)alertClusterReconfiguration.key);
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteClusterReconfigurartionEvent: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteClusterReconfigurartionEvent: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }
}

