/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.analysis.Globals.hAlrtCluEviction;
import oracle.rat.tfa.db.DataAccessor.AlertClusterEvictionDA;
import oracle.rat.tfa.db.DbPut;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.entitykey.AlertClusterEvictionKey;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SessionIdentifierGenerator;
import oracle.rat.tfa.xml.AlertClusterEvictionXMLReader;

@Entity(version=1)
public class AlertClusterEviction {
    @PrimaryKey
    AlertClusterEvictionKey key;
    Date evictCompleteTime;
    Integer percentHeartbeat;
    Integer initialPercentHeartbeat;
    Float initialTimeToEvict;
    Float timeToEvict;
    String code;
    String text;
    String eventId;

    public AlertClusterEviction() {
    }

    public AlertClusterEviction(String string, Date date, String string2, Integer n, Float f, Float f2, String string3, String string4) {
        this.key = new AlertClusterEvictionKey(string, date, string2);
        this.initialPercentHeartbeat = n;
        this.percentHeartbeat = n;
        this.initialTimeToEvict = f;
        this.timeToEvict = f2;
        this.evictCompleteTime = null;
        this.code = string3;
        this.text = string4;
        SessionIdentifierGenerator sessionIdentifierGenerator = new SessionIdentifierGenerator();
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        this.eventId = stringBuilder.append(Properties.getClusterName()).append(sessionIdentifierGenerator.nextSessionId()).toString();
    }

    public AlertClusterEviction(String string, Date date, String string2, Integer n, Float f, Float f2, String string3, String string4, String string5) {
        this.key = new AlertClusterEvictionKey(string, date, string2);
        this.initialPercentHeartbeat = n;
        this.percentHeartbeat = n;
        this.initialTimeToEvict = f;
        this.timeToEvict = f2;
        this.evictCompleteTime = null;
        this.code = string3;
        this.text = string4;
        this.eventId = string5;
    }

    public String getFileName() {
        return this.key.getFileName();
    }

    public String getNode() {
        return this.key.getNode();
    }

    public Date getEvictStartTime() {
        return this.key.getEvictStartTime();
    }

    public Date getEvictCompleteTime() {
        return this.evictCompleteTime;
    }

    public Float getInitialTimeToEvict() {
        return this.initialTimeToEvict;
    }

    public Float getTimeToEvict() {
        return this.timeToEvict;
    }

    public Integer getPercentHeartbeat() {
        return this.percentHeartbeat;
    }

    public Integer getInitialPercentHeartbeat() {
        return this.initialPercentHeartbeat;
    }

    public void setEvictCompleteTime(Date date) {
        this.evictCompleteTime = date;
    }

    public void setTimeToEvict(Float f) {
        this.timeToEvict = f;
    }

    public void setPercentHeartbeat(Integer n) {
        this.percentHeartbeat = n;
    }

    public void setInitialPercentHeartbeat(Integer n) {
        this.initialPercentHeartbeat = n;
    }

    public void store(DbPut dbPut) {
        AlertClusterEvictionDA alertClusterEvictionDA = new AlertClusterEvictionDA();
        alertClusterEvictionDA.pIdx.put((Object)this);
    }

    public synchronized void store() {
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            AlertClusterEvictionDA alertClusterEvictionDA = new AlertClusterEvictionDA();
            alertClusterEvictionDA.pIdx.put((Object)this);
            try {
                transaction.commit();
            }
            catch (LockConflictException lockConflictException) {
                Output.printTrace("################# " + lockConflictException.getMessage() + " : caught Lock conflict", 1);
                try {
                    if (transaction != null) {
                        transaction.abort();
                    }
                }
                catch (DatabaseException databaseException) {
                    Output.printTrace("txn abort failed: " + databaseException.toString(), 1);
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("Initial Transaction Try failed: " + databaseException.toString());
        }
    }

    public void print() {
        if (Global.printAllEntities.booleanValue() || hAlrtCluEviction.printEntity) {
            Output.print("++++++ Alert Cluster Eviction Start +++++");
            Output.print("Event Id           : " + this.eventId);
            Output.print("File Name          : " + this.getFileName());
            Output.print("Node Name          : " + this.getNode());
            Output.print("Evict Start Time   : " + this.key.getEvictStartTime());
            Output.print("Init Time to Evict : " + this.getInitialTimeToEvict());
            Output.print("Time to Evict      : " + this.getTimeToEvict());
            if (this.evictCompleteTime != null) {
                Output.print("Evict End Time     : " + this.evictCompleteTime);
            }
            Output.print("Init % HB          : " + this.initialPercentHeartbeat);
            Output.print("Final % HB         : " + this.percentHeartbeat);
            Output.print("++++++  Alert Cluster Eviction End +++++");
        }
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("++++++ Alert Cluster Eviction Start +++++");
        printWriter.println("Event Id           : " + this.eventId);
        printWriter.println("File Name          : " + this.getFileName());
        printWriter.println("Node Name          : " + this.getNode());
        printWriter.println("Evict Start Time   : " + this.key.getEvictStartTime());
        printWriter.println("Init Time to Evict : " + this.getInitialTimeToEvict());
        printWriter.println("Time to Evict      : " + this.getTimeToEvict());
        if (this.evictCompleteTime != null) {
            printWriter.println("Evict End Time     : " + this.evictCompleteTime);
        }
        printWriter.println("Init % HB          : " + this.initialPercentHeartbeat);
        printWriter.println("Final % HB         : " + this.percentHeartbeat);
        printWriter.println("++++++  Alert Cluster Eviction End +++++");
    }

    public String dumpXml() {
        String string = "";
        string = string + "<alertcrseviction>" + "\n";
        string = string + "<eventid>" + this.eventId + "</eventid>" + "\n";
        string = string + "<filename>" + this.getFileName() + "</filename>" + "\n";
        string = string + "<node>" + this.getNode() + "</node>" + "\n";
        string = string + "<evictstart>" + this.getEvictStartTime() + "</evictstart>" + "\n";
        string = string + "<initimetoevict>" + this.getInitialTimeToEvict() + "</initimetoevict>" + "\n";
        string = string + "<timetoevict>" + this.getTimeToEvict() + "</timetoevict>" + "\n";
        if (this.evictCompleteTime != null) {
            string = string + "<evictend>" + this.getEvictCompleteTime() + "</evictend>" + "\n";
        }
        string = string + "<initheartbeat>" + this.initialPercentHeartbeat + "</initheartbeat>" + "\n";
        string = string + "<finalheartbeat>" + this.percentHeartbeat + "</finalheartbeat>" + "\n";
        string = string + "<code>" + this.code + "</code>" + "\n";
        string = string + "<text>" + this.text + "</text>" + "\n";
        string = string + "</alertcrseviction>" + "\n";
        return string;
    }

    public static synchronized AlertClusterEviction getEvent(String string) throws DatabaseException {
        AlertClusterEviction alertClusterEviction = null;
        AlertClusterEvictionDA alertClusterEvictionDA = new AlertClusterEvictionDA();
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(AlertClusterEviction.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (AlertClusterEviction alertClusterEviction2 : entityCursor) {
                    if (!alertClusterEviction2.eventId.equals(string)) continue;
                    alertClusterEviction = alertClusterEviction2;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            entityCursor.close();
            entityCursor = null;
            transaction.commit();
            transaction = null;
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        return alertClusterEviction;
    }

    public static synchronized void printEvents(PrintWriter printWriter, long l) throws DatabaseException {
        AlertClusterEvictionDA alertClusterEvictionDA = new AlertClusterEvictionDA();
        Transaction transaction = null;
        long l2 = 0L;
        String string = new Host().getHostname().trim();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(AlertClusterEviction.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (AlertClusterEviction alertClusterEviction : entityCursor) {
                    long l3 = alertClusterEviction.getEvictStartTime().getTime();
                    long l4 = Calendar.getInstance().getTimeInMillis();
                    long l5 = (l4 - l3) / 1000L;
                    if (l5 > l) continue;
                    printWriter.println(alertClusterEviction.eventId + "!" + string + "!Cluster Eviction!" + simpleDateFormat.format(alertClusterEviction.getEvictStartTime()) + "!" + alertClusterEviction.getFileName() + "!" + alertClusterEviction.getNode());
                    ++l2;
                }
                printWriter.println("Total Cluster Evictions found in database: " + l2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            entityCursor.close();
            entityCursor = null;
            transaction.commit();
            transaction = null;
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static synchronized void printXMLEvents(PrintWriter printWriter, long l, List<String> list) throws DatabaseException {
        String string = Properties.inventoryDir + File.separator;
        long l2 = 0L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        for (String string2 : list) {
            String string3 = string + string2 + "_AlertClusterEviction.xml";
            if (!new File(string3).exists()) continue;
            try {
                AlertClusterEvictionXMLReader alertClusterEvictionXMLReader = new AlertClusterEvictionXMLReader(string3);
                for (AlertClusterEviction alertClusterEviction : alertClusterEvictionXMLReader.getAlertClusterEvictionEntities()) {
                    long l3 = alertClusterEviction.getEvictStartTime().getTime();
                    long l4 = Calendar.getInstance().getTimeInMillis();
                    long l5 = (l4 - l3) / 1000L;
                    if (l5 > l) continue;
                    printWriter.println(alertClusterEviction.eventId + "!" + string2 + "!Cluster Eviction!" + simpleDateFormat.format(alertClusterEviction.getEvictStartTime()) + "!" + alertClusterEviction.getFileName() + "!" + alertClusterEviction.getNode());
                    ++l2;
                }
                printWriter.println("Total Cluster Evictions found in database: " + l2);
            }
            catch (DatabaseException databaseException) {
                Output.print(databaseException.toString());
            }
        }
    }

    public static synchronized void printAll(PrintWriter printWriter) throws DatabaseException {
        AlertClusterEvictionDA alertClusterEvictionDA = new AlertClusterEvictionDA();
        Transaction transaction = null;
        long l = 0L;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(AlertClusterEviction.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (AlertClusterEviction alertClusterEviction : entityCursor) {
                    alertClusterEviction.print(printWriter);
                    ++l;
                }
                printWriter.println("Total Cluster Evictions found in database: " + l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            entityCursor.close();
            entityCursor = null;
            transaction.commit();
            transaction = null;
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public String dumpSimileData() {
        String string = "";
        String string2 = "Node : " + this.getNode() + " Time to evict : " + this.getTimeToEvict() + " Heart Beat : " + this.percentHeartbeat + " " + this.code + " " + this.text;
        string = string + "{\"start\":\"" + this.getEvictStartTime() + "\"," + "\"icon\":\"red-circle.png\", \"title\":\"Cluster Eviction\", \"caption\":\"" + string2 + "\", \"description\":\"" + string2 + "\"}, ";
        System.out.println("################## " + string);
        return string;
    }

    public void setCode(String string) {
        this.code = string;
    }

    public String getCode() {
        return this.code;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public static boolean deleteAllClusterEvictions() {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(AlertClusterEvictionKey.class, AlertClusterEviction.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (AlertClusterEviction alertClusterEviction : entityCursor) {
                    primaryIndex.delete((Object)alertClusterEviction.key);
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteAllClusterEvictions: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteAllClusterEvictions: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean deleteClusterEvictionEvent(String string) {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(AlertClusterEvictionKey.class, AlertClusterEviction.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (AlertClusterEviction alertClusterEviction : entityCursor) {
                    if (!alertClusterEviction.getFileName().equalsIgnoreCase(string)) continue;
                    primaryIndex.delete((Object)alertClusterEviction.key);
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteAllClusterEvictions: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteAllClusterEvictions: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }
}

