/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import oracle.rat.tfa.db.DataAccessor.AdrIncidentDA;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.entitykey.AdrIncidentKey;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SessionIdentifierGenerator;

@Entity(version=1)
public class AdrIncident {
    @PrimaryKey
    private AdrIncidentKey key;
    private String eventId;
    private String incidentFileName;
    private String database;
    private String instance;
    private String adrHomePath;
    private String component;

    public AdrIncident() {
    }

    public AdrIncident(String string, Date date, String string2, String string3, String string4, String string5, String string6) {
        this.key = new AdrIncidentKey(string, date);
        this.incidentFileName = string2;
        this.adrHomePath = string3;
        this.database = string4;
        this.instance = string5;
        this.component = string6;
        SessionIdentifierGenerator sessionIdentifierGenerator = new SessionIdentifierGenerator();
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        this.eventId = stringBuilder.append(Properties.getClusterName()).append(sessionIdentifierGenerator.nextSessionId()).toString();
    }

    public String getTraceFileName() {
        return this.key.getTraceFileName();
    }

    public Date getIncidentTime() {
        return this.key.getIncidentTime();
    }

    public String getIncidentFileName() {
        return this.incidentFileName;
    }

    public void setADRHomePath(String string) {
        this.adrHomePath = string;
    }

    public String getADRHomePath() {
        return this.adrHomePath;
    }

    public void setDatabase(String string) {
        this.database = string;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setInstance(String string) {
        this.instance = string;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getComponent() {
        return this.component;
    }

    public void store() {
        AdrIncidentDA adrIncidentDA = new AdrIncidentDA();
        adrIncidentDA.pIdx.put((Object)this);
    }

    public void print() {
        Output.print("++++++ ADR Incident Start +++++");
        Output.print("Event Id      : " + this.eventId);
        Output.print("Trace File    : " + this.getTraceFileName());
        Output.print("Component     : " + this.getComponent());
        Output.print("Database      : " + this.getDatabase());
        Output.print("Instance      : " + this.getInstance());
        Output.print("Incident Time : " + this.getIncidentTime().toString());
        Output.print("Incident File : " + this.getIncidentFileName());
        Output.print("ADR Home Path : " + this.getADRHomePath());
        Output.print("++++++ ADR Incident End +++++");
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("++++++ ADR Incident Start +++++");
        printWriter.println("Event Id      : " + this.eventId);
        printWriter.println("Trace File    : " + this.getTraceFileName());
        printWriter.println("Component     : " + this.getComponent());
        printWriter.println("Database      : " + this.getDatabase());
        printWriter.println("Instance      : " + this.getInstance());
        printWriter.println("Incident Time : " + this.getIncidentTime().toString());
        printWriter.println("Incident File : " + this.getIncidentFileName());
        printWriter.println("ADR Home Path : " + this.getADRHomePath());
        printWriter.println("++++++ ADR Incident End +++++");
    }

    public static synchronized AdrIncident getEvent(String string) throws DatabaseException {
        AdrIncident adrIncident = null;
        AdrIncidentDA adrIncidentDA = new AdrIncidentDA();
        Transaction transaction = null;
        transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(AdrIncidentKey.class, AdrIncident.class);
        EntityCursor entityCursor = primaryIndex.entities();
        try {
            for (AdrIncident adrIncident2 : entityCursor) {
                if (!adrIncident2.eventId.equals(string)) continue;
                adrIncident = adrIncident2;
                break;
            }
            entityCursor.close();
            entityCursor = null;
            transaction.commit();
            transaction = null;
        }
        catch (Exception exception) {
            if (entityCursor != null) {
                entityCursor.close();
            }
            if (transaction != null) {
                transaction.abort();
                transaction = null;
            }
            exception.printStackTrace();
        }
        return adrIncident;
    }

    public static synchronized void printEvents(PrintWriter printWriter, long l) throws DatabaseException {
        Transaction transaction = null;
        long l2 = 0L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        String string = new Host().getHostname().trim();
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(AdrIncidentKey.class, AdrIncident.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (AdrIncident adrIncident : entityCursor) {
                    long l3 = adrIncident.getIncidentTime().getTime();
                    long l4 = Calendar.getInstance().getTimeInMillis();
                    long l5 = (l4 - l3) / 1000L;
                    if (l5 > l) continue;
                    printWriter.println(adrIncident.eventId + "!" + string + "!ADR Incident!" + simpleDateFormat.format(adrIncident.getIncidentTime()) + "!" + adrIncident.getTraceFileName());
                    ++l2;
                }
                printWriter.println("Total ADR Incidents found in database: " + l2);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static synchronized void printAll(PrintWriter printWriter) throws DatabaseException {
        Transaction transaction = null;
        long l = 0L;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(AdrIncidentKey.class, AdrIncident.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (AdrIncident adrIncident : entityCursor) {
                    adrIncident.print(printWriter);
                    ++l;
                }
                printWriter.println("Total ADR Incidents found in database: " + l);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static boolean deleteAllADRIncidents() {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(AdrIncidentKey.class, AdrIncident.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (AdrIncident adrIncident : entityCursor) {
                    primaryIndex.delete((Object)adrIncident.key);
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteAllADRIncidents: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteAllADRIncidents: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean deleteADRIncident(String string) {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(AdrIncidentKey.class, AdrIncident.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (AdrIncident adrIncident : entityCursor) {
                    if (!adrIncident.getTraceFileName().equalsIgnoreCase(string)) continue;
                    primaryIndex.delete((Object)adrIncident.key);
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteADRIncident: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteADRIncident: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }
}

