/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityIndex;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import oracle.rat.tfa.db.DataAccessor.ActionDA;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.entitykey.ActionKey;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;

@Entity(version=2)
public class Action {
    @PrimaryKey
    ActionKey key;
    @SecondaryKey(relate=Relationship.MANY_TO_ONE)
    private String actionStatus;
    private Date actionCompleteTime;
    private Boolean actionComplete;
    private String actionRequestArgs;
    private List metadata;

    public Action() {
    }

    public Action(String string, String string2, String string3, String string4) {
        this.key = new ActionKey(string, string2, string3);
        this.actionComplete = false;
        this.actionStatus = "REQUESTED";
        this.actionRequestArgs = string4;
    }

    public String getActionName() {
        return this.key.getActionName();
    }

    public String getActionRequestHost() {
        return this.key.getActionRequestHost();
    }

    public String getActionRequestClient() {
        return this.key.getActionRequestClient();
    }

    public Date getActionRequestTime() {
        return this.key.getActionRequestTime();
    }

    public void setActionCompleteTime(Date date) {
        this.actionCompleteTime = date;
    }

    public Date getActionCompleteTime() {
        return this.actionCompleteTime;
    }

    public void setActionComplete(Boolean bl) {
        this.actionComplete = bl;
    }

    public void setActionFailed(String string) {
        this.actionComplete = true;
        this.actionCompleteTime = new Date();
        this.actionStatus = "FAILED-" + string;
    }

    public void setActionComplete() {
        this.actionComplete = true;
        this.actionCompleteTime = new Date();
        this.actionStatus = "COMPLETE";
    }

    public Boolean getActionComplete() {
        return this.actionComplete;
    }

    public void setActionStatus(String string) {
        this.actionStatus = string;
    }

    public String getActionStatus() {
        return this.actionStatus;
    }

    public synchronized void store() {
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            ActionDA actionDA = new ActionDA();
            try {
                actionDA.pIdx.put((Object)this);
                transaction.commit();
            }
            catch (LockConflictException lockConflictException) {
                Output.print("################# " + lockConflictException.getMessage() + " : caught Lock conflict");
                try {
                    if (transaction != null) {
                        transaction.abort();
                    }
                }
                catch (DatabaseException databaseException) {
                    Output.print("txn abort failed: " + databaseException.toString());
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("Initial Transaction Try failed: " + databaseException.toString());
            databaseException.printStackTrace();
        }
    }

    public static synchronized void printAll(PrintWriter printWriter, String string) throws DatabaseException {
        String string2;
        Object object;
        Object object2;
        Object object3;
        PrimaryIndex primaryIndex;
        Object object4;
        Object object5;
        String string3 = null;
        String string4 = null;
        if (string != null) {
            String[] stringArray = string.split(":");
            string3 = stringArray[0].trim();
            if (stringArray.length > 1) {
                string4 = stringArray[1].trim();
            }
        }
        long l = 3600L;
        if (string4 != null) {
            int n;
            object5 = null;
            if (string4.endsWith("h")) {
                object5 = string4.substring(0, string4.indexOf("h"));
                if (object5 != null) {
                    n = new Integer((String)object5);
                    l = n * 60 * 60;
                    Output.printTrace("timeInHours " + n + " diffInSecs " + l, 3);
                }
            } else if (string4.endsWith("d") && (object5 = string4.substring(0, string4.indexOf("d"))) != null) {
                n = new Integer((String)object5);
                l = n * 24 * 60 * 60;
                Output.printTrace("timeInDays " + n + " diffInSecs " + l, 3);
            }
        }
        object5 = new ArrayList();
        Transaction transaction = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm:ss zzz");
        Output.printTrace("status: " + string3 + " difference in seconds: " + l, 3);
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            object4 = new CursorConfig();
            object4.setReadUncommitted(true);
            primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(ActionKey.class, Action.class);
            object3 = primaryIndex.entities(transaction, object4);
            try {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    long l2;
                    long l3;
                    long l4;
                    object = (Action)object2.next();
                    string2 = Action.getActionStatus(((Action)object).getActionStatus());
                    if (string3 == null || string3.equals("")) {
                        l4 = ((Action)object).getActionRequestTime().getTime();
                        l3 = Calendar.getInstance().getTimeInMillis();
                        l2 = (l3 - l4) / 1000L;
                        if (string2.equalsIgnoreCase("RUNNING") || string2.equalsIgnoreCase("REQUESTED")) {
                            object5.add(object);
                            continue;
                        }
                        if (l2 > l) continue;
                        object5.add(object);
                        continue;
                    }
                    if (string3.contains(",")) {
                        String[] stringArray;
                        for (String string5 : stringArray = string3.split(",")) {
                            if (!(string5 = string5.trim()).equalsIgnoreCase(string2)) continue;
                            if (string4 == null) {
                                object5.add(object);
                                continue;
                            }
                            long l5 = ((Action)object).getActionRequestTime().getTime();
                            long l6 = Calendar.getInstance().getTimeInMillis();
                            long l7 = (l6 - l5) / 1000L;
                            if (l7 > l) continue;
                            object5.add(object);
                        }
                        continue;
                    }
                    if (!string2.equalsIgnoreCase(string3 = string3.trim())) continue;
                    if (string4 == null) {
                        object5.add(object);
                        continue;
                    }
                    l4 = ((Action)object).getActionRequestTime().getTime();
                    l3 = Calendar.getInstance().getTimeInMillis();
                    l2 = (l3 - l4) / 1000L;
                    if (l2 > l) continue;
                    object5.add(object);
                }
                object3.close();
                object3 = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (object3 != null) {
                    object3.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        Collections.sort(object5, new Comparator<Action>(){

            @Override
            public int compare(Action action, Action action2) {
                return action2.getActionRequestTime().compareTo(action.getActionRequestTime());
            }
        });
        object4 = new Host().getHostname().trim();
        primaryIndex = object5.iterator();
        while (primaryIndex.hasNext()) {
            object3 = (Action)primaryIndex.next();
            if (((Action)object3).getActionName().equalsIgnoreCase("donebuildingremotezip") || ((Action)object3).getActionName().equalsIgnoreCase("runinventory") && (((Action)object3).getActionRequestClient().equals("AddDirectoryThread") || ((Action)object3).getActionRequestClient().equals("RediscoveryThread"))) continue;
            object2 = Action.getActionName(((Action)object3).getActionName());
            object = Action.getActionStatus(((Action)object3).getActionStatus());
            string2 = Action.getComments(((Action)object3).getActionRequestArgs());
            if (((String)object).equalsIgnoreCase("FAILED")) {
                string2 = Action.getReasonForFailure(((Action)object3).getActionStatus());
            }
            if (string2.equals("Duplicate run") && ((String)object2).equalsIgnoreCase("Run inventory")) continue;
            if (((Action)object3).getActionCompleteTime() != null) {
                printWriter.println((String)object2 + "!" + (String)object4 + "!" + ((Action)object3).getActionRequestClient() + "!" + simpleDateFormat.format(((Action)object3).getActionRequestTime()) + "!" + simpleDateFormat.format(((Action)object3).getActionCompleteTime()) + "!" + (String)object + "!" + string2);
                continue;
            }
            printWriter.println((String)object2 + "!" + (String)object4 + "!" + ((Action)object3).getActionRequestClient() + "!" + simpleDateFormat.format(((Action)object3).getActionRequestTime()) + "!" + " " + "!" + (String)object + "!" + string2);
        }
    }

    public static synchronized void getOngoingCollections(PrintWriter printWriter) throws DatabaseException {
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(ActionKey.class, Action.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            String string = new Host().getHostname().trim();
            try {
                for (Action action : entityCursor) {
                    String string2 = Action.getActionName(action.getActionName());
                    String string3 = Action.getActionStatus(action.getActionStatus());
                    String string4 = Action.getComments(action.getActionRequestArgs());
                    if (!string2.contains("Collect traces") || !string3.equalsIgnoreCase("RUNNING")) continue;
                    printWriter.println(string2 + "!" + string + "!" + string3 + "!" + string4);
                }
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static synchronized List<String> getRunningAutoCollections() throws DatabaseException {
        Transaction transaction = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(ActionKey.class, Action.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                block4: for (Action action : entityCursor) {
                    String string = Action.getActionName(action.getActionName());
                    String string2 = Action.getActionStatus(action.getActionStatus());
                    if (!string.contains("Collect traces") || !string2.equalsIgnoreCase("RUNNING")) continue;
                    List list = action.getMetadata();
                    Output.printTrace("Collect traces metadata : " + list, 3);
                    if (list == null) continue;
                    for (Map map : list) {
                        if (map == null || !map.containsKey("collectionType") || !map.get("collectionType").equals("auto")) continue;
                        arrayList.add((String)map.get("collectionId"));
                        Output.printTrace("collectionId: " + (String)map.get("collectionId"), 3);
                        continue block4;
                    }
                }
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        return arrayList;
    }

    public String getActionRequestArgs() {
        return this.actionRequestArgs;
    }

    public ActionKey getKey() {
        return this.key;
    }

    public void setMetadata(List list) {
        this.metadata = list;
    }

    public List getMetadata() {
        return this.metadata;
    }

    private static String getActionName(String string) {
        String string2 = "";
        string2 = string.equalsIgnoreCase("runinventory") ? "Run inventory" : (string.equalsIgnoreCase("ziptracesfordates") ? "Collect traces & zip" : (string.equalsIgnoreCase("startrtscan") ? "Run Real Time scan" : (string.equalsIgnoreCase("runodscan") ? "Run On Demand scan" : (string.equalsIgnoreCase("changerepositorydir") ? "Change repository path" : (string.equalsIgnoreCase("changerepositorysize") ? "Change repository size" : (string.equalsIgnoreCase("startdiagcollection") ? "Collect traces" : (string.equalsIgnoreCase("processcollection") ? "Process Collection" : string)))))));
        return string2;
    }

    private static String getActionStatus(String string) {
        String string2 = "";
        string2 = string.contains("-") && !string.equalsIgnoreCase("FAILED-INTERRUPTED") ? string.split("-")[0] : string;
        return string2;
    }

    private static String getComments(String string) {
        if (string == null) {
            return "";
        }
        if ((string = string.trim()).equals("-c")) {
            string = "Requested in all nodes";
        }
        return string;
    }

    private static String getReasonForFailure(String string) {
        String[] stringArray;
        String string2 = "";
        if (string.contains("-") && (stringArray = string.split("-")).length > 1) {
            string2 = stringArray[1];
        }
        return string2;
    }

    public void setActionRequestArgs(String string) {
        this.actionRequestArgs = string;
    }

    public static List<Action> getIncompleteActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        Transaction transaction = null;
        Output.printTrace("Getting IncompleteActions", 3);
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(ActionKey.class, Action.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (Action action : entityCursor) {
                    List list;
                    String string = action.getActionStatus();
                    if (!action.getActionName().equalsIgnoreCase("startdiagcollection") && !action.getActionName().equalsIgnoreCase("zipTracesForDates") || (list = action.getMetadata()) == null) continue;
                    for (Map map : list) {
                        if (map == null || map.containsKey("collectionType") && (!map.containsKey("collectionType") || map.get("collectionType").equals("manual"))) continue;
                        if (string.equals("RUNNING")) {
                            Output.print("Action RUNNING : " + action.getActionName());
                            Output.print("Action getActionRequestArgs : " + action.getActionRequestArgs());
                            arrayList.add(action);
                        }
                        if (!string.equals("FAILED-INTERRUPTED")) continue;
                        Output.print("Action FAILED-INTERRUPTED : " + action.getActionName());
                        Output.print("Action getActionRequestArgs : " + action.getActionRequestArgs());
                        arrayList.add(action);
                    }
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        return arrayList;
    }

    public static List<Action> getAction(String string, String string2, boolean bl) {
        ArrayList<Action> arrayList;
        block5: {
            arrayList = new ArrayList<Action>();
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(ActionKey.class, Action.class);
            Transaction transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                Output.printTrace("Requested action " + string + " of status " + string2, 3);
                for (Action action : entityCursor) {
                    Output.printTrace("Action found in DB: " + action.getActionName() + ":" + action.getActionStatus(), 4);
                    if (!bl && action.getActionName().equalsIgnoreCase(string)) {
                        if (!action.getActionStatus().equalsIgnoreCase(string2)) continue;
                        arrayList.add(action);
                        continue;
                    }
                    if (!bl || !action.getActionName().startsWith(string) || !action.getActionStatus().equalsIgnoreCase(string2)) continue;
                    arrayList.add(action);
                }
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction == null) break block5;
                transaction.abort();
                transaction = null;
            }
        }
        Output.printTrace("No of requested actions found in DB = " + arrayList.size(), 3);
        return arrayList;
    }

    public static void setActionsInterrupted() {
        EntityCursor entityCursor = null;
        Transaction transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
        try {
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            EntityIndex entityIndex = new ActionDA().sIdx.subIndex((Object)"RUNNING");
            entityCursor = entityIndex.entities(transaction, cursorConfig);
            for (Action action : entityCursor) {
                Output.print("Action: " + action.getActionName());
                action.setActionFailed("INTERRUPTED");
                action.store();
            }
        }
        catch (Exception exception) {
            Output.print("Exception in setting action status before shutdown. " + exception.getMessage());
        }
    }
}

