/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.db;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.evolve.Deleter;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.evolve.Renamer;
import java.util.concurrent.TimeUnit;
import oracle.rat.tfa.db.DataAccessor.AlertClusterEvictionDA;
import oracle.rat.tfa.db.DataAccessor.ClusterDA;
import oracle.rat.tfa.db.DataAccessor.FileEntityDA;
import oracle.rat.tfa.db.DataAccessor.TFADirectoryDA;
import oracle.rat.tfa.db.DataAccessor.TFAHostDA;
import oracle.rat.tfa.db.DataAccessor.TFAMetaDataDA;
import oracle.rat.tfa.db.DataAccessor.TFAReceiverDA;
import oracle.rat.tfa.entity.AlertClusterEviction;
import oracle.rat.tfa.entity.Cluster;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.TFADirectory;
import oracle.rat.tfa.entity.TFAHost;
import oracle.rat.tfa.entity.TFAMetaData;
import oracle.rat.tfa.entity.TFAReceiver;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class DbPut {
    private Environment envmnt;
    private EntityStore store;
    private FileEntityDA sda;
    private TFAHostDA tha;
    private TFAMetaDataDA meta;
    private TFAReceiverDA tra;
    private TFADirectoryDA tda;
    private ClusterDA clu;
    private AlertClusterEvictionDA alertevictda;

    public void setup() throws DatabaseException {
        EnvironmentConfig environmentConfig = new EnvironmentConfig();
        StoreConfig storeConfig = new StoreConfig();
        environmentConfig.setAllowCreate(true);
        environmentConfig.setLockTimeout(5L, TimeUnit.SECONDS);
        environmentConfig.setTransactional(true);
        storeConfig.setAllowCreate(true);
        storeConfig.setTransactional(true);
        Mutations mutations = new Mutations();
        mutations.addRenamer(new Renamer("oracle.rat.tfa.entity.TFAHost", 0, "password", "pass"));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.Repository", 0, "currentSizeMegabytes"));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.Repository", 0, "currentSizeBytes"));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.Repository", 0, "isOpen"));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.TFADirectory", 2, "component"));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.TFADirectory", 4, "component"));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.TFADirectory", 5, "component"));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.TFALog", 0));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.FileCountInventorySwitch", 0));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.InventoryThreadPoolSize", 0));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.TFALog", 1));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.FileCountInventorySwitch", 1));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.InventoryThreadPoolSize", 1));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.TFAReceiver", 2, "tfaHomeDir"));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.TFAReceiver", 1, "tfaHomeDir"));
        mutations.addDeleter(new Deleter("oracle.rat.tfa.entity.TFAMetaData", 1, "tfaHomeDir"));
        storeConfig.setMutations(mutations);
        this.envmnt = new Environment(Properties.dbHome, environmentConfig);
        this.store = new EntityStore(this.envmnt, "EntityStore", storeConfig);
    }

    public EntityStore getStore() {
        return this.store;
    }

    public Environment getEnvmnt() {
        return this.envmnt;
    }

    public void storeFileEntity(FileEntity fileEntity) {
        block2: {
            TransactionConfig transactionConfig = new TransactionConfig();
            Durability durability = new Durability(Durability.SyncPolicy.NO_SYNC, Durability.SyncPolicy.NO_SYNC, Durability.ReplicaAckPolicy.NONE);
            transactionConfig.setDurability(durability);
            Transaction transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, transactionConfig);
            this.sda = new FileEntityDA();
            try {
                this.sda.pIdx.put(transaction, (Object)fileEntity);
                transaction.commit();
            }
            catch (Exception exception) {
                if (transaction == null) break block2;
                transaction.abort();
                transaction = null;
            }
        }
    }

    public void storeTFAHostEntity(TFAHost tFAHost) {
        this.tha = new TFAHostDA(this.store);
        this.tha.pIdx.put((Object)tFAHost);
    }

    public void storeTFAReceiverEntity(TFAReceiver tFAReceiver) {
        this.tra = new TFAReceiverDA(this.store);
        this.tra.pIdx.put((Object)tFAReceiver);
    }

    public void storeClusterEntity(Cluster cluster) {
        this.clu = new ClusterDA();
        this.clu.pIdx.put((Object)cluster);
    }

    public void storeTFADirectoryEntity(TFADirectory tFADirectory) {
        Transaction transaction = null;
        try {
            TransactionConfig transactionConfig = new TransactionConfig();
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, transactionConfig);
            this.tda = new TFADirectoryDA(this.store);
            try {
                this.tda.pIdx.put(transaction, (Object)tFADirectory);
                transaction.commit();
            }
            catch (LockConflictException lockConflictException) {
                Output.print("################# " + lockConflictException.getMessage() + " : caught Lock conflict");
                if (transaction != null) {
                    transaction.abort();
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("Initial Transaction Try failed: " + databaseException.toString());
            databaseException.printStackTrace();
        }
    }

    public void storeTFAMetaDataEntity(TFAMetaData tFAMetaData) {
        this.meta = new TFAMetaDataDA(this.store);
        this.meta.pIdx.put((Object)tFAMetaData);
    }

    public void storeAlertEvictionEntity(AlertClusterEviction alertClusterEviction) {
        this.alertevictda = new AlertClusterEvictionDA();
        this.alertevictda.pIdx.put((Object)alertClusterEviction);
    }
}

