/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.db;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.evolve.Renamer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import oracle.rat.tfa.db.DataAccessor.DatabaseParameterDA;
import oracle.rat.tfa.db.DataAccessor.FileEntityDA;
import oracle.rat.tfa.db.DataAccessor.InstanceShutdownDA;
import oracle.rat.tfa.db.DataAccessor.InstanceStartupDA;
import oracle.rat.tfa.db.DataAccessor.TFAHostDA;
import oracle.rat.tfa.db.OracleJdbc;
import oracle.rat.tfa.entity.DatabaseParameter;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.Instance;
import oracle.rat.tfa.entity.InstanceShutdown;
import oracle.rat.tfa.entity.TFAHost;
import oracle.rat.tfa.entity.entitykey.DatabaseParameterKey;
import oracle.rat.tfa.entity.entitykey.InstanceShutdownKey;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class DbEnv {
    private Environment envmnt;
    private EntityStore store;
    private FileEntityDA sda;
    private TFAHostDA hostda;
    private Instance instda;
    private InstanceStartupDA instupda;
    private InstanceShutdownDA instdownda;
    private DatabaseParameterDA dbparamda;

    public void setup() throws DatabaseException {
        EnvironmentConfig environmentConfig = new EnvironmentConfig();
        StoreConfig storeConfig = new StoreConfig();
        environmentConfig.setAllowCreate(true);
        environmentConfig.setLockTimeout(5L, TimeUnit.SECONDS);
        environmentConfig.setTransactional(true);
        storeConfig.setAllowCreate(true);
        storeConfig.setTransactional(true);
        Mutations mutations = new Mutations();
        mutations.addRenamer(new Renamer("oracle.rat.tfa.entity.TFAHost", 0, "password", "pass"));
        storeConfig.setMutations(mutations);
        this.envmnt = new Environment(Properties.dbHome, environmentConfig);
        this.store = new EntityStore(this.envmnt, "EntityStore", storeConfig);
    }

    public void setup(Properties properties) throws DatabaseException {
        EnvironmentConfig environmentConfig = new EnvironmentConfig();
        StoreConfig storeConfig = new StoreConfig();
        environmentConfig.setAllowCreate(true);
        environmentConfig.setTransactional(true);
        storeConfig.setAllowCreate(true);
        storeConfig.setTransactional(true);
        this.envmnt = new Environment(Properties.dbHome, environmentConfig);
        this.store = new EntityStore(this.envmnt, "EntityStore", storeConfig);
    }

    public EntityStore getStore() {
        return this.store;
    }

    public Environment getEnvmnt() {
        return this.envmnt;
    }

    public void shutdown() throws DatabaseException {
        if (this.store != null) {
            this.store.close();
        }
        if (this.envmnt != null) {
            this.envmnt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpFilesFromStoreToXML() throws DatabaseException {
        this.setup();
        long l = 0L;
        this.sda = new FileEntityDA();
        PrimaryIndex primaryIndex = this.store.getPrimaryIndex(String.class, FileEntity.class);
        try (EntityCursor entityCursor = primaryIndex.entities();){
            FileWriter fileWriter = new FileWriter(Properties.inventoryXMLFile);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("<files>\n");
            for (FileEntity fileEntity : entityCursor) {
                String string = "";
                String string2 = "";
                String string3 = fileEntity.dumpXML();
                bufferedWriter.write(string3);
                try {
                    string = fileEntity.getFirstTime().toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    string2 = fileEntity.getLastTime().toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Output.print("Found File in database: " + fileEntity.getFileName());
                Output.print("----> Type: " + fileEntity.getType());
                Output.print("----> Host: " + fileEntity.getHostInfo().getHostname());
                Output.print("----> Public IP: " + fileEntity.getHostInfo().getPublicIp());
                Output.print("----> Size: " + fileEntity.getFileSize());
                Output.print("----> Last Modified: " + fileEntity.getLastModified().toString());
                Output.print("----> Lines: " + fileEntity.getNumberOfLines());
                Output.print("----> First Time: " + string);
                Output.print("----> Last Time: " + string2);
                Output.print("----> Sampling rows scanned (first time): " + fileEntity.getSampleRowsFirst());
                Output.print("----> Sampling rows scanned (last time): " + fileEntity.getSampleRowsLast());
                Output.print("----> Sample size: " + fileEntity.getSampleSize());
                ++l;
            }
            bufferedWriter.write("</files>");
            bufferedWriter.close();
            Output.print("Total found File in database: " + l);
        }
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToOracle() throws DatabaseException {
        this.setup();
        long l = 0L;
        this.sda = new FileEntityDA();
        PrimaryIndex primaryIndex = this.store.getPrimaryIndex(String.class, FileEntity.class);
        EntityCursor entityCursor = primaryIndex.entities();
        Connection connection = null;
        Statement statement = null;
        try {
            FileWriter fileWriter = new FileWriter(Properties.inventoryXMLFile);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("<files>\n");
            connection = OracleJdbc.getConnection();
            statement = connection.prepareStatement("INSERT INTO LOG (LOG_TEXT) values (?)");
            for (FileEntity fileEntity : entityCursor) {
                String string = "";
                String string2 = "";
                String string3 = fileEntity.dumpXML();
                bufferedWriter.write(string3);
                try {
                    string = fileEntity.getFirstTime().toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    string2 = fileEntity.getLastTime().toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Output.print("Found File in database: " + fileEntity.getFileName());
                Output.print("----> Type: " + fileEntity.getType());
                Output.print("----> Host: " + fileEntity.getHostInfo().getHostname());
                Output.print("----> Public IP: " + fileEntity.getHostInfo().getPublicIp());
                Output.print("----> Size: " + fileEntity.getFileSize());
                Output.print("----> Last Modified: " + fileEntity.getLastModified().toString());
                Output.print("----> Lines: " + fileEntity.getNumberOfLines());
                Output.print("----> First Time: " + string);
                Output.print("----> Last Time: " + string2);
                Output.print("----> Sampling rows scanned (first time): " + fileEntity.getSampleRowsFirst());
                Output.print("----> Sampling rows scanned (last time): " + fileEntity.getSampleRowsLast());
                Output.print("----> Sample size: " + fileEntity.getSampleSize());
                statement.setString(1, fileEntity.getFileName());
                statement.execute();
                ++l;
            }
            connection.commit();
            bufferedWriter.write("</files>");
            bufferedWriter.close();
            Output.print("Total found File in database: " + l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            entityCursor.close();
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInstanceShutdownFromStore(BufferedWriter bufferedWriter) throws DatabaseException {
        Properties properties = Properties.getInstance("C:" + File.separator + "tfa_home");
        this.setup();
        long l = 0L;
        this.instdownda = new InstanceShutdownDA();
        Object var5_4 = null;
        PrimaryIndex primaryIndex = this.store.getPrimaryIndex(InstanceShutdownKey.class, InstanceShutdown.class);
        try (EntityCursor entityCursor = primaryIndex.entities();){
            InstanceShutdown instanceShutdown = new InstanceShutdown();
            String string = instanceShutdown.dumpEndXML();
            bufferedWriter.write(string);
        }
        this.shutdown();
    }

    public FileEntity lookupFile(String string) {
        this.setup();
        this.sda = new FileEntityDA();
        PrimaryIndex<String, FileEntity> primaryIndex = this.sda.pIdx;
        FileEntity fileEntity = (FileEntity)primaryIndex.get((Object)string);
        try {
            fileEntity.getFileName();
        }
        catch (NullPointerException nullPointerException) {
            this.shutdown();
            return null;
        }
        this.shutdown();
        return fileEntity;
    }

    public TFAHost lookupHost(String string) {
        this.setup();
        this.hostda = new TFAHostDA(this.store);
        PrimaryIndex<String, TFAHost> primaryIndex = this.hostda.pIdx;
        TFAHost tFAHost = (TFAHost)primaryIndex.get((Object)string);
        try {
            tFAHost.getHostname();
        }
        catch (NullPointerException nullPointerException) {
            this.shutdown();
            return null;
        }
        this.shutdown();
        return tFAHost;
    }

    public DatabaseParameter lookupKey(DatabaseParameterKey databaseParameterKey) {
        this.setup();
        this.dbparamda = new DatabaseParameterDA();
        PrimaryIndex<DatabaseParameterKey, DatabaseParameter> primaryIndex = this.dbparamda.pIdx;
        DatabaseParameter databaseParameter = (DatabaseParameter)primaryIndex.get((Object)databaseParameterKey);
        try {
            databaseParameter.getParameterName();
        }
        catch (NullPointerException nullPointerException) {
            this.shutdown();
            return null;
        }
        this.shutdown();
        return databaseParameter;
    }
}

