/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.browser;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.browser.Symlink;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.util.Properties;

public class BrowserManager {
    public static final String oneDayDir = Properties.getBrowserDir() + File.separator + "last_1_day" + File.separator;
    public static final String twoDaysDir = Properties.getBrowserDir() + File.separator + "last_2_days" + File.separator;
    public static final String threeDaysDir = Properties.getBrowserDir() + File.separator + "last_3_days" + File.separator;
    public static final String sevenDaysDir = Properties.getBrowserDir() + File.separator + "last_7_days" + File.separator;
    public static final String fourteenDaysDir = Properties.getBrowserDir() + File.separator + "last_14_days" + File.separator;
    public static final String twentyEightDaysDir = Properties.getBrowserDir() + File.separator + "last_28_days" + File.separator;
    Date fileDate;
    Calendar lastModifiedCal = Calendar.getInstance();
    Calendar compareCal = Calendar.getInstance();
    String fileNameFull;
    String fileNameShort;
    boolean keepChecking = true;

    private boolean checkTime(int n) {
        if (!this.keepChecking) {
            return false;
        }
        this.compareCal.setTime(this.fileDate);
        this.compareCal.add(5, n);
        int n2 = this.compareCal.compareTo(this.lastModifiedCal);
        return n2 >= 0;
    }

    private void oneDay(FileEntity fileEntity) {
        if (this.keepChecking && this.checkTime(1)) {
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, oneDayDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, twoDaysDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, threeDaysDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, sevenDaysDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, fourteenDaysDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, twentyEightDaysDir);
        }
    }

    private void twoDays(FileEntity fileEntity) {
        if (this.keepChecking && this.checkTime(2)) {
            this.keepChecking = false;
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, twoDaysDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, threeDaysDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, sevenDaysDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, fourteenDaysDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, twentyEightDaysDir);
        }
    }

    private void threeDays(FileEntity fileEntity) {
        if (this.keepChecking && this.checkTime(3)) {
            this.keepChecking = false;
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, threeDaysDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, sevenDaysDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, fourteenDaysDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, twentyEightDaysDir);
        }
    }

    private void sevenDays(FileEntity fileEntity) {
        if (this.keepChecking && this.checkTime(7)) {
            this.keepChecking = false;
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, sevenDaysDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, fourteenDaysDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, twentyEightDaysDir);
        }
    }

    private void fourteenDays(FileEntity fileEntity) {
        if (this.keepChecking && this.checkTime(14)) {
            this.keepChecking = false;
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, fourteenDaysDir);
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, twentyEightDaysDir);
        }
    }

    private void twentyEightDays(FileEntity fileEntity) {
        if (this.keepChecking && this.checkTime(28)) {
            this.keepChecking = false;
            Symlink.createSymlink(fileEntity, this.fileNameFull, this.fileNameShort, twentyEightDaysDir);
        }
    }

    public void addSymlinks(FileEntity fileEntity) {
        if (fileEntity.isTrimFile) {
            return;
        }
        if (!Global.createSymLinks.booleanValue()) {
            return;
        }
        this.keepChecking = true;
        this.fileDate = fileEntity.getLastTime();
        if (this.fileDate == null) {
            this.fileDate = fileEntity.getLastModified();
        }
        this.lastModifiedCal.setTime(this.fileDate);
        this.fileNameFull = fileEntity.getFileName();
        this.fileNameShort = fileEntity.getShortName();
        Symlink.createSymlink(fileEntity, fileEntity.getFileName(), fileEntity.getShortName(), Properties.getBrowserDir() + File.separator + "all_files" + File.separator);
        this.oneDay(fileEntity);
        this.twoDays(fileEntity);
        this.threeDays(fileEntity);
        this.sevenDays(fileEntity);
        this.fourteenDays(fileEntity);
        this.twentyEightDays(fileEntity);
    }
}

