/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.analysis;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import oracle.rat.tfa.ClassWrapper;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.analysis.Globals.hAlrtDbStartShut;
import oracle.rat.tfa.db.DataAccessor.FileEntityDA;
import oracle.rat.tfa.db.DataAccessor.InstanceShutdownDA;
import oracle.rat.tfa.db.DataAccessor.InstanceStartupDA;
import oracle.rat.tfa.db.DbGet;
import oracle.rat.tfa.db.DbPut;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.InstanceShutdown;
import oracle.rat.tfa.entity.InstanceStartup;
import oracle.rat.tfa.entity.entitykey.InstanceShutdownKey;
import oracle.rat.tfa.entity.entitykey.InstanceStartupKey;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.type.SearchString;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class handleAlertDbStartShut
extends ClassWrapper {
    @Override
    public void run(FileEntity fileEntity, DbPut dbPut, DbGet dbGet, String string, Date date, SearchString searchString, hAlrtDbStartShut hAlrtDbStartShut2) {
        String string2 = fileEntity.getHostname();
        String string3 = fileEntity.getInstance();
        String string4 = fileEntity.getDatabase();
        if (string2 == null) {
            string2 = "noHost";
        }
        if (string3 == null) {
            string3 = "noInstance";
        }
        if (string4 == null) {
            string4 = "noDatabase";
        }
        String string5 = fileEntity.getFileName();
        String string6 = "FALSE";
        InstanceStartup instanceStartup = new InstanceStartup(string5, date, string6);
        if (hAlrtDbStartShut2.getFirstTimestamp() == null) {
            hAlrtDbStartShut2.setFirstTimestamp(date);
        }
        try {
            Integer n;
            String string7;
            String string8;
            Object object;
            String string9;
            Output.printTrace("foundShut : " + hAlrtDbStartShut2.isShutdownFound(), 3);
            Output.printTrace("foundStart : " + hAlrtDbStartShut2.isStartupFound(), 3);
            Output.printTrace(string.toString(), 2);
            if (string.contains("Starting ORACLE instance")) {
                if (hAlrtDbStartShut2.isShutdownFound().equals("FALSE") && hAlrtDbStartShut2.isStartupFound().equals("TRUE")) {
                    string9 = "crash";
                    object = new InstanceShutdown(string5, date, hAlrtDbStartShut2.getStartup().getStartupTime(), string9, "", 0);
                    Output.printTrace("Created Crash Shutdown: " + string9 + " -- " + date.toString(), 3);
                    this.replaceOldShutdown(date, string5);
                    ((InstanceShutdown)object).store();
                    hAlrtDbStartShut2.setShutdown((InstanceShutdown)object);
                    if (Global.printAllEntities.booleanValue() || hAlrtDbStartShut2.isPrintEntity().booleanValue()) {
                        ((InstanceShutdown)object).print();
                    }
                }
                if (hAlrtDbStartShut2.isShutdownFound().equals("FALSE") && hAlrtDbStartShut2.isStartupFound().equals("FALSE") && hAlrtDbStartShut2.getFirstTimestamp() != date) {
                    Output.print("Inside the loop where there is no startup or shutdown in hadbst : " + hAlrtDbStartShut2.getFirstTimestamp() + " " + date);
                    string9 = "crash";
                    object = new InstanceShutdown(string5, date, hAlrtDbStartShut2.getFirstTimestamp(), string9, null, 0);
                    Output.printTrace("Created Crash Shutdown: " + string9 + " -- " + date.toString(), 3);
                    this.replaceOldShutdown(date, string5);
                    ((InstanceShutdown)object).store();
                    hAlrtDbStartShut2.setShutdown((InstanceShutdown)object);
                    if (Global.printAllEntities.booleanValue() || hAlrtDbStartShut2.isPrintEntity().booleanValue()) {
                        ((InstanceShutdown)object).print();
                    }
                }
                string6 = "FALSE";
                hAlrtDbStartShut2.setFoundStartup("TRUE");
                hAlrtDbStartShut2.setFoundShutdown("FALSE");
                instanceStartup = new InstanceStartup(string5, date, string6);
                Output.printTrace("Found Startup: " + date.toString(), 3);
                this.replaceOldStartup(date, string5);
                instanceStartup.store(DbManager.getInstance().getDbPut());
                hAlrtDbStartShut2.setStartup(instanceStartup);
                if (Global.printAllEntities.booleanValue() || hAlrtDbStartShut2.isPrintEntity().booleanValue()) {
                    instanceStartup.print();
                }
            }
            if (string.contains("Shutting down instance ")) {
                hAlrtDbStartShut2.setFoundShutdown("TRUE");
                if (!hAlrtDbStartShut2.isStartupFound().equals("TRUE")) {
                    string6 = "TRUE";
                    instanceStartup = new InstanceStartup(string5, hAlrtDbStartShut2.getFirstTimestamp(), string6);
                    Output.printTrace("Created Dummy Startup: " + hAlrtDbStartShut2.getFirstTimestamp().toString(), 3);
                    this.replaceOldStartup(date, string5);
                    instanceStartup.store(DbManager.getInstance().getDbPut());
                    hAlrtDbStartShut2.setStartup(instanceStartup);
                    if (Global.printAllEntities.booleanValue() || hAlrtDbStartShut2.isPrintEntity().booleanValue()) {
                        instanceStartup.print();
                    }
                }
                string9 = string.contains("immediate") ? "immediate" : (string.contains("abort") ? "abort" : "normal");
                object = new InstanceShutdown(string5, date, hAlrtDbStartShut2.getStartup().getStartupTime(), string9, "USER", 0);
                Output.printTrace("Found Shutdown: " + string9 + " -- " + date.toString(), 3);
                this.replaceOldShutdown(date, string5);
                ((InstanceShutdown)object).store();
                hAlrtDbStartShut2.setShutdown((InstanceShutdown)object);
                if (Global.printAllEntities.booleanValue() || hAlrtDbStartShut2.isPrintEntity().booleanValue()) {
                    ((InstanceShutdown)object).print();
                }
            }
            if (string.contains("Instance terminated by USER")) {
                string8 = string.replace("Instance terminated by ", "");
                string8 = string8.substring(0, string8.indexOf(44));
                string7 = string.substring(string.indexOf(61) + 1, string.length()).trim();
                Output.printTrace("strpid: " + string7, 4);
                n = Integer.valueOf(string7);
                object = new InstanceShutdownDA();
                if (hAlrtDbStartShut2.isShutdownFound().equals("TRUE")) {
                    InstanceShutdownKey instanceShutdownKey = new InstanceShutdownKey(string5, hAlrtDbStartShut2.getShutdown().getShutdownTime());
                    InstanceShutdown instanceShutdown = (InstanceShutdown)((InstanceShutdownDA)object).pIdx.get((Object)instanceShutdownKey);
                    Output.printTrace("Updated abort record", 4);
                    instanceShutdown.setTerminatingProcessID(n);
                    instanceShutdown.setTerminatingProcessName(string8);
                    Output.printTrace("Saving Updated abort record", 4);
                    this.replaceOldShutdown(date, string5);
                    instanceShutdown.store();
                    hAlrtDbStartShut2.setShutdown(instanceShutdown);
                    if (Global.printAllEntities.booleanValue() || hAlrtDbStartShut2.isPrintEntity().booleanValue()) {
                        instanceShutdown.print();
                    }
                } else {
                    hAlrtDbStartShut2.setFoundShutdown("TRUE");
                    if (hAlrtDbStartShut2.isStartupFound().equals("FALSE")) {
                        string6 = "TRUE";
                        instanceStartup = new InstanceStartup(string5, hAlrtDbStartShut2.getFirstTimestamp(), string6);
                        Output.printTrace("Created Dummy Startup: " + hAlrtDbStartShut2.getFirstTimestamp().toString(), 3);
                        this.replaceOldStartup(date, string5);
                        instanceStartup.store(DbManager.getInstance().getDbPut());
                        hAlrtDbStartShut2.setStartup(instanceStartup);
                        if (Global.printAllEntities.booleanValue() || hAlrtDbStartShut2.isPrintEntity().booleanValue()) {
                            instanceStartup.print();
                        }
                    }
                    string9 = "termination";
                    string8 = string.replace("Instance terminated by ", "");
                    string8 = string8.substring(0, string8.indexOf(44));
                    string7 = string.substring(string.indexOf(61) + 1, string.length()).trim();
                    Output.printTrace("strpid: " + string7, 4);
                    n = Integer.valueOf(string7);
                    InstanceShutdown instanceShutdown = new InstanceShutdown(string5, date, hAlrtDbStartShut2.getStartup().getStartupTime(), string9, string8, n);
                    Output.printTrace("Found Instance Termination: " + string9 + " -by : " + string8 + " - " + date.toString(), 3);
                    this.replaceOldShutdown(date, string5);
                    instanceShutdown.store();
                    hAlrtDbStartShut2.setShutdown(instanceShutdown);
                    if (Global.printAllEntities.booleanValue() || hAlrtDbStartShut2.isPrintEntity().booleanValue()) {
                        instanceShutdown.print();
                    }
                }
            }
            if (string.contains("Instance terminated by ") && !string.contains("USER")) {
                hAlrtDbStartShut2.setFoundShutdown("TRUE");
                if (!hAlrtDbStartShut2.isStartupFound().equals("TRUE")) {
                    string6 = "TRUE";
                    instanceStartup = new InstanceStartup(string5, hAlrtDbStartShut2.getFirstTimestamp(), string6);
                    Output.printTrace("Created Dummy Startup: " + hAlrtDbStartShut2.getFirstTimestamp().toString(), 3);
                    this.replaceOldStartup(date, string5);
                    instanceStartup.store(DbManager.getInstance().getDbPut());
                    hAlrtDbStartShut2.setStartup(instanceStartup);
                    if (Global.printAllEntities.booleanValue() || hAlrtDbStartShut2.isPrintEntity().booleanValue()) {
                        instanceStartup.print();
                    }
                }
                string9 = "termination";
                string8 = string.replace("Instance terminated by ", "");
                string8 = string8.substring(0, string8.indexOf(44));
                string7 = string.substring(string.indexOf(61) + 1, string.length()).trim();
                Output.printTrace("strpid: " + string7, 4);
                n = Integer.valueOf(string7);
                object = new InstanceShutdown(string5, date, hAlrtDbStartShut2.getStartup().getStartupTime(), string9, string8, n);
                Output.printTrace("Found Instance Termination by non-USER: " + string9 + " -by : " + string8 + " - " + date.toString(), 3);
                this.replaceOldShutdown(date, string5);
                ((InstanceShutdown)object).store();
                hAlrtDbStartShut2.setShutdown((InstanceShutdown)object);
                if (Global.printAllEntities.booleanValue() || hAlrtDbStartShut2.isPrintEntity().booleanValue()) {
                    ((InstanceShutdown)object).print();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void printAll() {
        handleAlertDbStartShut.printStartup();
        handleAlertDbStartShut.printShutdown();
    }

    public static void dumpXml() {
        Properties properties = Properties.getInstance("C:" + File.separator + "tfa_home");
        try {
            FileWriter fileWriter = new FileWriter(Properties.alertlogXMLFile);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            handleAlertDbStartShut.dumpStartXml(bufferedWriter);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void dumpStartXml(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("<startdb>\n");
            bufferedWriter.write("<startups>\n");
            handleAlertDbStartShut.dumpStartupXml(bufferedWriter);
            bufferedWriter.write("</startups>\n");
            bufferedWriter.write("</startdb>\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void dumpShutXml(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("<shutdb>\n");
            bufferedWriter.write("<shutdowns>\n");
            handleAlertDbStartShut.dumpShutdownXml(bufferedWriter);
            bufferedWriter.write("</shutdowns>\n");
            bufferedWriter.write("</shutdb>\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStartup() throws DatabaseException {
        Output.print("In printStartup");
        InstanceStartupDA instanceStartupDA = new InstanceStartupDA();
        Output.print("aaa" + instanceStartupDA.pIdx.count());
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(InstanceStartup.class);
        try (EntityCursor entityCursor = primaryIndex.entities();){
            for (InstanceStartup instanceStartup : entityCursor) {
                instanceStartup.print();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printShutdown() throws DatabaseException {
        InstanceShutdownDA instanceShutdownDA = new InstanceShutdownDA();
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(InstanceShutdown.class);
        try (EntityCursor entityCursor = primaryIndex.entities();){
            for (InstanceShutdown instanceShutdown : entityCursor) {
                instanceShutdown.print();
            }
        }
    }

    public static String generateHexColor() {
        Random random = new Random();
        Color color = Color.getHSBColor(random.nextFloat(), 1.0f, 1.0f);
        String string = "#" + Integer.toHexString(color.getRGB()).substring(2).toUpperCase();
        return string;
    }

    public static void dumpSimileJSON(BufferedWriter bufferedWriter, Map<String, String> map, Map<String, Integer> map2) {
        EntityCursor entityCursor = new FileEntityDA().pIdx.entities();
        for (FileEntity fileEntity : entityCursor) {
            if (fileEntity.getDatePattern() == null || !map.containsKey(fileEntity.getFileName())) continue;
            List<InstanceShutdown> list = handleAlertDbStartShut.getSortedShutdownsForFile(fileEntity);
            InstanceStartup instanceStartup = handleAlertDbStartShut.getIncompleteStartupForFile(fileEntity);
            String string = fileEntity.getFileName();
            String string2 = map.get(string);
            int n = map2.get(string2);
            Date date = fileEntity.getFirstTime();
            Date date2 = fileEntity.getLastTime();
            String string3 = "";
            for (int i = 0; i < list.size(); ++i) {
                InstanceStartupKey instanceStartupKey = new InstanceStartupKey(string, list.get(i).getStartupTime());
                InstanceStartup instanceStartup2 = (InstanceStartup)new InstanceStartupDA().pIdx.get((Object)instanceStartupKey);
                Date date3 = list.get(i).getShutdownTime();
                Output.print("shutdownTime : " + date3 + " startupTime : " + list.get(i).getStartupTime() + " instanceStartup : " + instanceStartup2);
                Date date4 = instanceStartup2.getStartupTime();
                if (i == 0) {
                    if (instanceStartup2.getDummyStartup().equals("FALSE")) {
                        string3 = string3 + "{\"start\":\"" + date + "\", \"end\":\"" + date4 + "\", \"durationEvent\":true, \"trackNum\":\"" + n + "\", \"title\":\"" + string2 + "\", \"caption\":\"" + string2 + "\"},";
                        string3 = string3 + "{\"start\":\"" + date4 + "\", \"end\":\"" + date3 + "\", \"durationEvent\":true, \"icon\":\"http://dadvip0001.us.oracle.com/tfaweb/icons/arrow-up-double-3.png\", \"trackNum\":\"" + n + "\", \"title\":\"" + string2 + "\", \"caption\":\"" + string2 + "\"},";
                        continue;
                    }
                    date4 = fileEntity.getFirstTime();
                    string3 = string3 + "{\"start\":\"" + date4 + "\", \"end\":\"" + date3 + "\", \"durationEvent\":true, \"trackNum\":\"" + n + "\", \"title\":\"" + string2 + "\", \"caption\":\"" + string2 + "\"},";
                    continue;
                }
                if (i == list.size() - 1) {
                    string3 = string3 + "{\"start\":\"" + date4 + "\", \"end\":\"" + date3 + "\", \"durationEvent\":true, \"icon\":\"http://dadvip0001.us.oracle.com/tfaweb/icons/arrow-up-double-3.png\", \"trackNum\":\"" + n + "\", \"title\":\"" + string2 + "\", \"caption\":\"" + string2 + "\"},";
                    if (instanceStartup != null) continue;
                    string3 = string3 + "{\"start\":\"" + date3 + "\", \"end\":\"" + date2 + "\"," + "\"durationEvent\":true, \"icon\":\"http://dadvip0001.us.oracle.com/tfaweb/icons/arrow-down-double-3.png\", \"trackNum\":\"" + n + "\", \"title\":\"" + string2 + "\", \"caption\":\"" + string2 + "\"},";
                    continue;
                }
                string3 = string3 + "{\"start\":\"" + date4 + "\", \"end\":\"" + date3 + "\", \"durationEvent\":true, \"icon\":\"http://dadvip0001.us.oracle.com/tfaweb/icons/arrow-up-double-3.png\", \"trackNum\":\"" + n + "\", \"title\":\"" + string2 + "\", \"caption\":\"" + string2 + "\"},";
            }
            if (instanceStartup != null) {
                Output.print("Incomplete startup time :  " + instanceStartup.getStartupTime());
                if (list.size() == 0) {
                    string3 = string3 + "{\"start\":\"" + date + "\", \"end\":\"" + instanceStartup.getStartupTime() + "\", \"durationEvent\":true, \"trackNum\":\"" + n + "\", \"title\":\"" + string2 + "\", \"caption\":\"" + string2 + "\"},";
                }
                string3 = string3 + "{\"start\":\"" + instanceStartup.getStartupTime() + "\", \"end\":\"" + date2 + "\", \"durationEvent\":true, \"icon\":\"http://dadvip0001.us.oracle.com/tfaweb/icons/arrow-up-double-3.png\", \"trackNum\":\"" + n + "\", \"title\":\"" + string2 + "\", \"caption\":\"" + string2 + "\"},";
            }
            if (list.size() == 0 && instanceStartup == null) {
                string3 = string3 + "{\"start\":\"" + date + "\", \"end\":\"" + date2 + "\", \"durationEvent\":true, \"trackNum\":\"" + n + "\", \"title\":\"" + string2 + "\", \"caption\":\"" + string2 + "\"},";
            }
            try {
                bufferedWriter.write(string3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        entityCursor.close();
    }

    public static void dumpSimileXml(BufferedWriter bufferedWriter) {
        Object object;
        Object object2;
        Object object32;
        Object object4;
        Object object5;
        Date date;
        EntityStore entityStore = DbManager.getInstance().getEntityStore();
        PrimaryIndex primaryIndex = entityStore.getPrimaryIndex(InstanceShutdownKey.class, InstanceShutdown.class);
        PrimaryIndex primaryIndex2 = entityStore.getPrimaryIndex(InstanceStartupKey.class, InstanceStartup.class);
        EntityCursor entityCursor = primaryIndex.entities();
        EntityCursor entityCursor2 = primaryIndex2.entities();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 1;
        for (Object object6 : entityCursor) {
            date = ((InstanceShutdown)object6).getStartupTime();
            object5 = ((InstanceShutdown)object6).getShutdownTime();
            String string = ((InstanceShutdown)object6).getFileName();
            object4 = "";
            object32 = "";
            if (hashMap.containsKey(string)) {
                object4 = (String)hashMap.get(string);
            } else {
                object4 = new Integer(n).toString();
                ++n;
                hashMap.put(string, (String)object4);
            }
            System.out.println("fileName : " + string + " shutdown = " + object5 + " startup = " + date + " isdummy = " + date.equals(object5));
            if (date.equals(object5)) {
                object2 = (InstanceStartup)primaryIndex2.get((Object)new InstanceStartupKey(string, date));
                if (((InstanceStartup)object2).getDummyStartup().equals("TRUE")) {
                    object = (FileEntity)entityStore.getPrimaryIndex(String.class, FileEntity.class).get((Object)string);
                    date = ((FileEntity)object).getFirstTime();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    calendar.add(12, 5);
                    object32 = "{\"start\":\"" + date + "\", \"end\":\"" + calendar.getTime() + "\", \"durationEvent\":true, \"trackNum\":\"" + (String)object4 + "\", \"color\":\"blue\", \"title\":\"" + string + "\", \"caption\":\"" + string + "\"},";
                    object32 = (String)object32 + "{\"start\":\"" + calendar.getTime() + "\", \"end\":\"" + object5 + "\", \"durationEvent\":true, \"trackNum\":\"" + (String)object4 + "\", \"title\":\"" + string + "\", \"caption\":\"" + string + "\"},";
                }
            } else {
                object32 = (String)object32 + "{\"start\":\"" + date + "\", \"end\":\"" + object5 + "\", \"durationEvent\":true, \"trackNum\":\"" + (String)object4 + "\", \"title\":\"" + string + "\", \"caption\":\"" + string + "\"},";
            }
            try {
                bufferedWriter.write((String)object32);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        entityCursor.close();
        entityCursor = primaryIndex.entities();
        for (Object object6 : entityCursor2) {
            date = ((InstanceStartup)object6).getStartupTime();
            object5 = ((InstanceStartup)object6).getFileName();
            boolean bl = false;
            System.out.println("startup = " + date + "isdummy = " + ((InstanceStartup)object6).getDummyStartup().equals("FALSE"));
            if (!((InstanceStartup)object6).getDummyStartup().equals("FALSE")) continue;
            for (Object object32 : entityCursor) {
                if (!((InstanceShutdown)object32).getStartupTime().equals(date)) continue;
                bl = true;
            }
            if (bl) continue;
            object4 = (FileEntity)entityStore.getPrimaryIndex(String.class, FileEntity.class).get(object5);
            object32 = ((FileEntity)object4).getLastTime();
            object2 = (String)hashMap.get(object5);
            object = "{\"start\":\"" + date + "\", \"end\":\"" + object32 + "\", \"durationEvent\":true, \"trackNum\":\"" + (String)object2 + "\", \"title\":\"" + (String)object5 + "\", \"caption\":\"" + (String)object5 + "\"},";
            try {
                bufferedWriter.write((String)object);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        entityCursor.close();
        entityCursor2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpShutdownSimileXml(BufferedWriter bufferedWriter) {
        EntityStore entityStore = DbManager.getInstance().getEntityStore();
        InstanceShutdownDA instanceShutdownDA = new InstanceShutdownDA();
        PrimaryIndex primaryIndex = entityStore.getPrimaryIndex(InstanceShutdownKey.class, InstanceShutdown.class);
        EntityCursor entityCursor = primaryIndex.entities();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        int n = 1;
        Object var8_8 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            for (InstanceShutdown instanceShutdown : entityCursor) {
                if (hashMap.containsKey(string = string == null ? instanceShutdown.getFileName() : instanceShutdown.getFileName())) {
                    string2 = (String)hashMap.get(string);
                } else {
                    string2 = new Integer(n).toString();
                    hashMap.put(string, string2);
                    ++n;
                }
                if (hashMap2.containsKey(string)) {
                    string3 = (String)hashMap2.get(string);
                } else {
                    string3 = handleAlertDbStartShut.generateHexColor();
                    hashMap2.put(string, string3);
                }
                System.out.println("SIMILE --->>> " + string + " " + string2 + " " + string3);
                String string4 = string;
                bufferedWriter.write(instanceShutdown.dumpSimileData(string2, string4, string3));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            entityCursor.close();
            System.out.println("tracks --->>> " + hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpStartupXml(BufferedWriter bufferedWriter) throws DatabaseException {
        String string = "EMPTY";
        Boolean bl = true;
        try (EntityCursor entityCursor = new InstanceStartupDA().pIdx.entities();){
            for (InstanceStartup instanceStartup : entityCursor) {
                if (!string.equalsIgnoreCase(instanceStartup.getFileName())) {
                    if (!bl.booleanValue()) {
                        bufferedWriter.write("</file>\n");
                    } else {
                        bl = false;
                    }
                    string = instanceStartup.getFileName();
                    bufferedWriter.write("<file name='" + string + "'>" + "\n");
                }
                bufferedWriter.write(instanceStartup.dumpXml());
            }
            bufferedWriter.write("</file>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpShutdownXml(BufferedWriter bufferedWriter) throws DatabaseException {
        String string = "EMPTY";
        Boolean bl = true;
        try (EntityCursor entityCursor = new InstanceShutdownDA().pIdx.entities();){
            for (InstanceShutdown instanceShutdown : entityCursor) {
                Output.printTrace("fileName         : " + string, 3);
                Output.printTrace("fileName from DB : " + instanceShutdown.getFileName(), 3);
                if (!string.equalsIgnoreCase(instanceShutdown.getFileName())) {
                    if (!bl.booleanValue()) {
                        bufferedWriter.write("</file>\n");
                    } else {
                        bl = false;
                    }
                    string = instanceShutdown.getFileName();
                    bufferedWriter.write("<file name='" + string + "'>" + "\n");
                }
                bufferedWriter.write(instanceShutdown.dumpXml());
            }
            bufferedWriter.write("</file>\n");
        }
    }

    public static void main(String[] stringArray) {
        Properties properties = Properties.getInstance("C:" + File.separator + "tfa_home");
        handleAlertDbStartShut.printAll();
        handleAlertDbStartShut.dumpXml();
    }

    private static List<InstanceShutdown> getSortedShutdownsForFile(FileEntity fileEntity) {
        String string = fileEntity.getFileName();
        ArrayList<Date> arrayList = new ArrayList<Date>();
        ArrayList<InstanceShutdown> arrayList2 = new ArrayList<InstanceShutdown>();
        ArrayList<InstanceShutdown> arrayList3 = new ArrayList<InstanceShutdown>();
        EntityCursor entityCursor = new InstanceShutdownDA().pIdx.entities();
        for (InstanceShutdown instanceShutdown : entityCursor) {
            if (!string.equalsIgnoreCase(instanceShutdown.getKey().getFileName())) continue;
            Date date = instanceShutdown.getShutdownTime();
            arrayList.add(date);
            arrayList2.add(instanceShutdown);
        }
        entityCursor.close();
        Collections.sort(arrayList);
        for (InstanceShutdown instanceShutdown : arrayList2) {
            int n = arrayList.indexOf(instanceShutdown.getShutdownTime());
            arrayList3.add(n, instanceShutdown);
        }
        return arrayList3;
    }

    private static InstanceStartup getIncompleteStartupForFile(FileEntity fileEntity) {
        InstanceStartup instanceStartup = null;
        String string = fileEntity.getFileName();
        EntityCursor entityCursor = new InstanceStartupDA().pIdx.entities();
        for (InstanceStartup instanceStartup2 : entityCursor) {
            boolean bl = false;
            if (!string.equals(instanceStartup2.getKey().getFileName()) || !instanceStartup2.getDummyStartup().equals("FALSE")) continue;
            EntityCursor entityCursor2 = new InstanceShutdownDA().pIdx.entities();
            for (InstanceShutdown instanceShutdown : entityCursor2) {
                if (!instanceShutdown.getStartupTime().equals(instanceStartup2.getStartupTime())) continue;
                bl = true;
            }
            entityCursor2.close();
            if (bl) continue;
            instanceStartup = instanceStartup2;
        }
        entityCursor.close();
        return instanceStartup;
    }

    public static Map<String, Integer> getSimileTracks() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = 1;
        EntityCursor entityCursor = new FileEntityDA().pIdx.entities();
        for (FileEntity fileEntity : entityCursor) {
            String string = fileEntity.getFileName();
            if (fileEntity.getDatePattern() == null || hashMap.containsKey(string)) continue;
            hashMap.put(string, n);
            ++n;
        }
        entityCursor.close();
        return hashMap;
    }

    public void replaceOldStartup(Date date, String string) {
        Date date2 = Calendar.getInstance().getTime();
        if (date2.after(date)) {
            if ((date2.getTime() - date.getTime()) / 1000L < 604800L) {
                return;
            }
            InstanceStartup instanceStartup = InstanceStartup.getLastStartup(string);
            if (instanceStartup != null) {
                InstanceStartup.deleteStartup(instanceStartup);
            }
        }
    }

    public void replaceOldShutdown(Date date, String string) {
        Date date2 = Calendar.getInstance().getTime();
        if (date2.after(date)) {
            if ((date2.getTime() - date.getTime()) / 1000L < 604800L) {
                return;
            }
            InstanceShutdown instanceShutdown = InstanceShutdown.getLastShutdown(string);
            if (instanceShutdown != null) {
                InstanceShutdown.deleteShutdown(instanceShutdown);
            }
        }
    }
}

