/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.analysis;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.persist.EntityCursor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import oracle.rat.tfa.ClassWrapper;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.analysis.Globals.hAlrtDbParam;
import oracle.rat.tfa.analysis.Globals.hAlrtDbStartShut;
import oracle.rat.tfa.db.DataAccessor.DatabaseParameterDA;
import oracle.rat.tfa.db.DbGet;
import oracle.rat.tfa.db.DbPut;
import oracle.rat.tfa.entity.DatabaseParameter;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.InstanceStartup;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.type.SearchString;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class handleAlertDbParameter
extends ClassWrapper {
    @Override
    public void run(FileEntity fileEntity, DbPut dbPut, DbGet dbGet, String string, Date date, SearchString searchString, hAlrtDbParam hAlrtDbParam2, hAlrtDbStartShut hAlrtDbStartShut2) {
        Output output = new Output();
        String string2 = fileEntity.getFileName();
        String string3 = "FALSE";
        InstanceStartup instanceStartup = new InstanceStartup(string2, date, string3);
        try {
            Output.printTrace("inparams : " + hAlrtDbParam2.getParamValue(), 4);
            Output.printTrace(string.toString(), 3);
            if (hAlrtDbStartShut2.isStartupFound() != null && hAlrtDbStartShut2.isStartupFound().equals("TRUE")) {
                instanceStartup = hAlrtDbStartShut2.getStartup();
                Output.printTrace("Loaded startup from saved Global", 4);
            }
            if (hAlrtDbParam2.getParamValue().equals("TRUE")) {
                Output.printTrace("Inside the TRUE loop" + string + string.contains("=") + hAlrtDbParam2.getParamValue(), 3);
                if (string.contains("=")) {
                    String string4 = string.substring(0, string.indexOf(61));
                    String string5 = string.substring(string.indexOf(61) + 1, string.length());
                    DatabaseParameter databaseParameter = new DatabaseParameter(instanceStartup.getFileName(), instanceStartup.getStartupTime(), string4, string5, "TRUE");
                    databaseParameter.store(dbPut);
                    Output.printTrace("Creating and storing DatabaseParameter : ", 3);
                    if (Global.printAllEntities.booleanValue() || hAlrtDbParam2.isPrintEntity().booleanValue()) {
                        databaseParameter.print();
                    }
                } else {
                    hAlrtDbParam2.setParamValue("FALSE");
                    Output.printTrace("Stopped Params", 3);
                }
            }
            if (string.contains("System parameters with non-default values")) {
                Output.printTrace("Inside System parameters with non-default values : " + hAlrtDbParam2.getParamValue(), 3);
                hAlrtDbParam2.setParamValue("TRUE");
                Output.printTrace("Found Start Params : " + hAlrtDbParam2.getParamValue(), 3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void printAll(DbGet dbGet) {
        handleAlertDbParameter.printParams();
    }

    public static void dumpXml() {
        try {
            FileWriter fileWriter = new FileWriter(Properties.alertlogXMLFile);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            handleAlertDbParameter.dumpXml(bufferedWriter);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpSimileData(BufferedWriter bufferedWriter) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        try (EntityCursor entityCursor = new DatabaseParameterDA().pIdx.entities();){
            Object object;
            Object object2;
            for (Object object3 : entityCursor) {
                object2 = ((DatabaseParameter)object3).getSetTime();
                if (hashMap.containsKey(object2)) {
                    object = (List)hashMap.get(object2);
                    object.add(((DatabaseParameter)object3).getParameterName() + " : " + ((DatabaseParameter)object3).getParameterValue());
                    continue;
                }
                object = new ArrayList();
                object.add(((DatabaseParameter)object3).getParameterName() + " : " + ((DatabaseParameter)object3).getParameterValue());
                hashMap.put(object2, object);
            }
            for (Object object3 : hashMap.keySet()) {
                object2 = (List)hashMap.get(object3);
                object = "";
                Object object4 = object2.iterator();
                while (object4.hasNext()) {
                    String string = (String)object4.next();
                    string = string.replaceAll("<", "&lt;");
                    string = string.replaceAll(">", "&gt;");
                    string = string.replaceAll("\"", "'");
                    object = (String)object + string + " &lt;br/&gt;";
                }
                object = "";
                object4 = "{\"start\":\"" + object3 + "\", \"icon\":\"gray-circle.png\", " + "\"title\":\"Non-Def Params\", \"description\":\"" + (String)object + "\", \"caption\":\"" + (String)object + "\"},";
                bufferedWriter.write((String)object4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpSimileXml(BufferedWriter bufferedWriter) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        try (EntityCursor entityCursor = new DatabaseParameterDA().pIdx.entities();){
            Object object;
            Object object2;
            for (Object object3 : entityCursor) {
                object2 = ((DatabaseParameter)object3).getSetTime();
                if (hashMap.containsKey(object2)) {
                    object = (List)hashMap.get(object2);
                    object.add(((DatabaseParameter)object3).getParameterName() + " : " + ((DatabaseParameter)object3).getParameterValue());
                    continue;
                }
                object = new ArrayList();
                object.add(((DatabaseParameter)object3).getParameterName() + " : " + ((DatabaseParameter)object3).getParameterValue());
                hashMap.put(object2, object);
            }
            for (Object object3 : hashMap.keySet()) {
                object2 = (List)hashMap.get(object3);
                bufferedWriter.write("<event start=\"" + object3 + "\" icon=\"gray-circle.png\" title=\"Non-Def Params\">\n");
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    string = string.replaceAll("<", "&lt;");
                    string = string.replaceAll(">", "&gt;");
                    bufferedWriter.write(string + " &lt;br/&gt;\n");
                }
                bufferedWriter.write("</event>\n");
            }
        }
    }

    public static void dumpXml(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("<databaseparameters>\n");
            handleAlertDbParameter.dumpParamsXml(bufferedWriter);
            bufferedWriter.write("</databaseparameters>\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void printParams() throws DatabaseException {
        try (EntityCursor entityCursor = new DatabaseParameterDA().pIdx.entities();){
            for (DatabaseParameter databaseParameter : entityCursor) {
                databaseParameter.print();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpParamsXml(BufferedWriter bufferedWriter) throws DatabaseException {
        String string = "EMPTY";
        Boolean bl = true;
        try (EntityCursor entityCursor = new DatabaseParameterDA().pIdx.entities();){
            for (DatabaseParameter databaseParameter : entityCursor) {
                if (!string.equalsIgnoreCase(databaseParameter.getFileName())) {
                    if (!bl.booleanValue()) {
                        bufferedWriter.write("</file>\n");
                    } else {
                        bl = false;
                    }
                    string = databaseParameter.getFileName();
                    bufferedWriter.write("<file name='" + string + "'>" + "\n");
                }
                bufferedWriter.write(databaseParameter.dumpXml());
            }
            bufferedWriter.write("</file>\n");
        }
    }

    public static void main(String[] stringArray) {
        Properties properties = Properties.getInstance("C:" + File.separator + "tfa_home");
        DbGet dbGet = DbManager.getInstance().getDbGet();
        handleAlertDbParameter.printAll();
        handleAlertDbParameter.dumpXml();
        DbManager.getInstance().closeConnections();
    }
}

