/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.analysis;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.rat.tfa.ClassWrapper;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.analysis.Globals.hAlrtDbGenErr;
import oracle.rat.tfa.analysis.Globals.hAlrtDbStartShut;
import oracle.rat.tfa.db.DataAccessor.DatabaseGeneralErrorDA;
import oracle.rat.tfa.db.DbGet;
import oracle.rat.tfa.db.DbPut;
import oracle.rat.tfa.entity.DatabaseGeneralError;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.InstanceStartup;
import oracle.rat.tfa.entity.entitykey.DatabaseGeneralErrorKey;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.type.SearchString;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class handleAlertDbGeneralError
extends ClassWrapper {
    @Override
    public void run(FileEntity fileEntity, DbPut dbPut, DbGet dbGet, String string, Date date, SearchString searchString, hAlrtDbGenErr hAlrtDbGenErr2, hAlrtDbStartShut hAlrtDbStartShut2) {
        Output output = new Output();
        String string2 = fileEntity.getHostname();
        String string3 = fileEntity.getInstance();
        String string4 = fileEntity.getDatabase();
        String string5 = fileEntity.getFileName();
        InstanceStartup instanceStartup = new InstanceStartup(string5, date, "TRUE");
        if (hAlrtDbStartShut2.getStartup().getKey() != null) {
            try {
                instanceStartup = hAlrtDbStartShut2.getStartup();
            }
            catch (Exception exception) {
                Output.printTrace("Using Dummy Startup", 2);
                Output.print("Using Dummy Startup due to caught exception");
            }
        }
        if (string2 == null) {
            string2 = "noHost";
        }
        if (string3 == null) {
            string3 = "noInstance";
        }
        if (string4 == null) {
            string4 = "noDatabase";
        }
        try {
            Output.printTrace(string.toString(), 3);
            if (string.contains("Errors in file")) {
                string = string.replaceAll("Errors in file ", "");
                string = string.replaceAll("trc\\s.*", "trc").trim();
                string = string.replaceAll("trc:.*", "trc");
                hAlrtDbGenErr2.setFileName(string);
                Output.printTrace("Saved Error File : " + string + " to Global", 4);
            }
            if (string.contains("ORA-")) {
                String string6 = "[:\\s].*";
                String string7 = "^ORA-\\d*(:\\s|\\s:\\s)";
                String string8 = string.replaceAll(string6, "");
                String string9 = string.replaceAll(string7, "");
                Output.printTrace("Handling Error Code : " + string8, 3);
                DatabaseGeneralError databaseGeneralError = new DatabaseGeneralError(instanceStartup.getFileName(), instanceStartup.getStartupTime(), date, string8, string9, hAlrtDbGenErr2);
                databaseGeneralError.store(dbPut);
                if (Global.printAllEntities.booleanValue() || hAlrtDbGenErr2.isPrintEntity().booleanValue()) {
                    databaseGeneralError.print();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void printAll() {
        handleAlertDbGeneralError.printErrors();
    }

    public static List<DatabaseGeneralError> getErrorsForFile(String string) {
        EntityStore entityStore = DbManager.getInstance().getEntityStore();
        PrimaryIndex primaryIndex = entityStore.getPrimaryIndex(DatabaseGeneralErrorKey.class, DatabaseGeneralError.class);
        EntityCursor entityCursor = primaryIndex.entities();
        ArrayList<DatabaseGeneralError> arrayList = new ArrayList<DatabaseGeneralError>();
        for (DatabaseGeneralError databaseGeneralError : entityCursor) {
            if (!databaseGeneralError.getFileName().equals(string)) continue;
            arrayList.add(databaseGeneralError);
        }
        entityCursor.close();
        return arrayList;
    }

    public static void dumpSimileJSON(BufferedWriter bufferedWriter, Map<String, Integer> map) {
        for (String string : map.keySet()) {
            Object object;
            int n = map.get(string);
            List<DatabaseGeneralError> list = handleAlertDbGeneralError.getErrorsForFile(string);
            System.out.println("fileName : " + string + " errors : " + list);
            HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
            for (DatabaseGeneralError databaseGeneralError : list) {
                long l = databaseGeneralError.getKey().getErrorTime().getTime();
                int n2 = (int)(l / 120000L);
                System.out.println("errorTime : " + databaseGeneralError.getKey().getErrorTime() + " " + l + " " + n2);
                if (hashMap.containsKey(n2)) {
                    object = (List)hashMap.get(n2);
                    object.add(databaseGeneralError);
                    continue;
                }
                object = new ArrayList();
                object.add(databaseGeneralError);
                hashMap.put(n2, object);
            }
            System.out.println("errorBuckets : " + hashMap);
            for (Integer n3 : hashMap.keySet()) {
                Object object22;
                List list2 = (List)hashMap.get(n3);
                String string2 = "";
                DatabaseGeneralError databaseGeneralError = (DatabaseGeneralError)list2.get(0);
                for (Object object22 : list2) {
                    System.out.println("--->>> " + ((DatabaseGeneralError)object22).getKey().getErrorTime());
                    string2 = string2 + ((DatabaseGeneralError)object22).getErrorCode() + " : " + ((DatabaseGeneralError)object22).getErrorText() + "\\r";
                }
                System.out.println("End of bucket");
                object = list2.size() == 1 ? databaseGeneralError.getErrorCode() : "ORA-*";
                object22 = databaseGeneralError.getKey().getErrorTime();
                string2 = string2 + "Error Time : " + object22 + "\\r";
                string2 = string2 + "TrackNum : " + n + "\\r";
                String string3 = "{\"start\":\"" + object22 + "\", \"end\":\"" + object22 + "\", \"durationEvent\":false, \"trackNum\":\"" + n + "\", \"title\":\"" + (String)object + "\", \"caption\":\"" + string2 + "\"},";
                try {
                    bufferedWriter.write(string3);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpSimileData(BufferedWriter bufferedWriter) {
        EntityStore entityStore = DbManager.getInstance().getEntityStore();
        DatabaseGeneralErrorDA databaseGeneralErrorDA = new DatabaseGeneralErrorDA();
        PrimaryIndex primaryIndex = entityStore.getPrimaryIndex(DatabaseGeneralErrorKey.class, DatabaseGeneralError.class);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try (EntityCursor entityCursor = primaryIndex.entities();){
            Object object;
            String string;
            for (Object object2 : entityCursor) {
                string = ((DatabaseGeneralError)object2).getErrorTime();
                if (hashMap.containsKey(string)) {
                    object = (List)hashMap.get(string);
                    object.add(((DatabaseGeneralError)object2).getErrorCode() + " : " + ((DatabaseGeneralError)object2).getErrorText());
                    continue;
                }
                object = new ArrayList();
                object.add(((DatabaseGeneralError)object2).getErrorCode() + " : " + ((DatabaseGeneralError)object2).getErrorText());
                hashMap.put(string, object);
            }
            for (Object object2 : hashMap.keySet()) {
                string = "";
                object = "";
                String string2 = "";
                List list = (List)hashMap.get(object2);
                if (list.size() == 1) {
                    String[] stringArray = ((String)list.get(0)).split(":");
                    object = stringArray[0];
                    string2 = stringArray[1];
                } else {
                    object = "ORA-*";
                    for (String string3 : list) {
                        string3 = string3.replaceAll("\"", "'");
                        string2 = string2 + string3 + "&lt;br/&gt;";
                    }
                }
                string = string + "{\"start\":\"" + (String)object2 + "\", \"icon\":\"red-circle.png\", \"title\":\"" + (String)object + "\", \"caption\":\"" + string2 + "\", \"description\":\"" + string2 + "\"}, ";
                bufferedWriter.write(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpSimileXml(BufferedWriter bufferedWriter) {
        EntityStore entityStore = DbManager.getInstance().getEntityStore();
        DatabaseGeneralErrorDA databaseGeneralErrorDA = new DatabaseGeneralErrorDA();
        PrimaryIndex primaryIndex = entityStore.getPrimaryIndex(DatabaseGeneralErrorKey.class, DatabaseGeneralError.class);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try (EntityCursor entityCursor = primaryIndex.entities();){
            Object object;
            String string;
            for (Object object2 : entityCursor) {
                string = ((DatabaseGeneralError)object2).getErrorTime();
                if (hashMap.containsKey(string)) {
                    object = (List)hashMap.get(string);
                    object.add(((DatabaseGeneralError)object2).getErrorCode() + " : " + ((DatabaseGeneralError)object2).getErrorText());
                    continue;
                }
                object = new ArrayList();
                object.add(((DatabaseGeneralError)object2).getErrorCode() + " : " + ((DatabaseGeneralError)object2).getErrorText());
                hashMap.put(string, object);
            }
            for (Object object2 : hashMap.keySet()) {
                string = "";
                object = "";
                String string2 = "";
                List list = (List)hashMap.get(object2);
                if (list.size() == 1) {
                    String[] stringArray = ((String)list.get(0)).split(":");
                    object = stringArray[0];
                    string2 = stringArray[1];
                } else {
                    object = "ORA-*";
                    for (String string3 : list) {
                        string2 = string2 + string3 + "&lt;br/&gt;";
                    }
                }
                string = string + "<event start=\"" + (String)object2 + "\" icon=\"red-circle.png\" title=\"" + (String)object + "\">" + string2 + "</event>\n";
                bufferedWriter.write(string);
            }
        }
    }

    public static void dumpXml() {
        try {
            FileWriter fileWriter = new FileWriter(Properties.alertlogXMLFile);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            handleAlertDbGeneralError.dumpXml(bufferedWriter);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void dumpXml(BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write("<databasegeneralerrors>\n");
            handleAlertDbGeneralError.dumpErrorsXml(bufferedWriter);
            bufferedWriter.write("</databasegeneralerrors>\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printErrors() throws DatabaseException {
        DatabaseGeneralErrorDA databaseGeneralErrorDA = new DatabaseGeneralErrorDA();
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(DatabaseGeneralError.class);
        try (EntityCursor entityCursor = primaryIndex.entities();){
            for (DatabaseGeneralError databaseGeneralError : entityCursor) {
                databaseGeneralError.print();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpErrorsXml(BufferedWriter bufferedWriter) throws DatabaseException {
        String string = "EMPTY";
        Boolean bl = true;
        DatabaseGeneralErrorDA databaseGeneralErrorDA = new DatabaseGeneralErrorDA();
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(DatabaseGeneralError.class);
        try (EntityCursor entityCursor = primaryIndex.entities();){
            for (DatabaseGeneralError databaseGeneralError : entityCursor) {
                if (!string.equalsIgnoreCase(databaseGeneralError.getFileName())) {
                    if (!bl.booleanValue()) {
                        bufferedWriter.write("</file>\n");
                    } else {
                        bl = false;
                    }
                    string = databaseGeneralError.getFileName();
                    bufferedWriter.write("<file name='" + string + "'>" + "\n");
                }
                bufferedWriter.write(databaseGeneralError.dumpXml());
            }
            bufferedWriter.write("</file>\n");
        }
    }

    public static void main(String[] stringArray) {
        Properties properties = Properties.getInstance("C:" + File.separator + "tfa_home");
        DbGet dbGet = DbManager.getInstance().getDbGet();
        handleAlertDbGeneralError.printAll();
        handleAlertDbGeneralError.dumpXml();
    }
}

