/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.analysis;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.rat.tfa.ClassWrapper;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.analysis.Globals.GlobalWrapper;
import oracle.rat.tfa.analysis.Globals.hAlrtCluEviction;
import oracle.rat.tfa.analysis.Globals.hAlrtDbGenErr;
import oracle.rat.tfa.analysis.Globals.hAlrtDbParam;
import oracle.rat.tfa.analysis.Globals.hAlrtDbStartShut;
import oracle.rat.tfa.analysis.Globals.hGeneric;
import oracle.rat.tfa.analysis.handleAdrIncident;
import oracle.rat.tfa.db.DataAccessor.EventMapDA;
import oracle.rat.tfa.db.DataAccessor.FileEntityDA;
import oracle.rat.tfa.db.DbGet;
import oracle.rat.tfa.db.DbPut;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.EventMapEntity;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.Generic;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.InstanceShutdown;
import oracle.rat.tfa.entity.InstanceStartup;
import oracle.rat.tfa.entity.entitykey.EventMapKey;
import oracle.rat.tfa.singletons.AllSearchStrings;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.singletons.MatchDates;
import oracle.rat.tfa.type.DateFormatType;
import oracle.rat.tfa.type.InternalSearchString;
import oracle.rat.tfa.type.SearchString;
import oracle.rat.tfa.util.BogusException;
import oracle.rat.tfa.util.DateSearchResult;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.RandomFileReader;
import oracle.rat.tfa.util.TimeZoneUtil;
import oracle.rat.tfa.util.Utilities;

public class DriverClassMT
extends Thread {
    private FileEntity fileEntity;
    private Vector<SearchString> allSearchStrings;
    private MatchDates dateMatcher;
    private DbGet ssg;
    private Vector<SearchString> mySearchStrings;
    private Vector<InternalSearchString> internalSearchStrings;
    private String RTFlag;
    private List<Integer> timestampOffset;
    private int phase = 1;
    private Date lastTimestamp;
    private boolean keepReading = true;
    private String printfac = "SCAN";

    public DriverClassMT(FileEntity fileEntity, Vector<SearchString> vector, MatchDates matchDates, String string) {
        this.fileEntity = fileEntity;
        this.createPrivateCopy(vector);
        this.dateMatcher = MatchDates.getInstance();
        this.RTFlag = string;
    }

    @Override
    public void run() {
        Output output = new Output();
        Utilities utilities = new Utilities();
        boolean bl = true;
        boolean bl2 = this.RTFlag.contentEquals("RT");
        boolean bl3 = false;
        String string = this.fileEntity.getFileName();
        String string2 = this.fileEntity.getType();
        DbPut dbPut = DbManager.getInstance().getDbPut();
        this.timestampOffset = new ArrayList<Integer>();
        if (bl2) {
            Output.printTrace("Running in Real Time Tail Mode for :" + string, this.printfac, 3);
        } else {
            Output.printTrace("Running in On Demand Mode for :" + string, this.printfac, 3);
        }
        try {
            if (string2 == null) {
                Output.printTrace("Type is null for : " + string, this.printfac, 3);
                throw new BogusException("");
            }
            Output.printTrace("File Being Processed by Driver : " + string, this.printfac, 3);
            Output.printTrace("Type for this file : " + string2, this.printfac, 3);
            this.mySearchStrings = new Vector();
            for (SearchString object : this.allSearchStrings) {
                if (object.getSearchFiles().size() <= 0) continue;
                for (String string3 : object.getSearchFiles()) {
                    if (!string3.equalsIgnoreCase(string2)) continue;
                    this.mySearchStrings.add(object);
                }
            }
            if (this.mySearchStrings.isEmpty()) {
                Output.printTrace("Ignoring this file : " + string + ". No Search Strings specified " + "for this file type : " + string2, this.printfac, 3);
                throw new BogusException();
            }
            Output.printTrace("About to check analysis started", this.printfac, 3);
            if (this.fileEntity.getAnalysisStarted().booleanValue()) {
                Output.printTrace("We have already started analysis for this file", this.printfac, 3);
                Output.printTrace("Looping through dates up to : " + this.fileEntity.getAnalysisTimestamp(), this.printfac, 3);
                this.lastTimestamp = this.fileEntity.getAnalysisTimestamp();
                bl = false;
            } else {
                Output.printTrace("First Analysis for this file", this.printfac, 3);
                this.lastTimestamp = this.fileEntity.getFirstTime();
                this.fileEntity.setAnalysisStarted();
                this.fileEntity.setAnalysisTimestamp(this.lastTimestamp);
                bl3 = true;
            }
            if (bl2) {
                bl3 = true;
                if (Global.isInternalSearchString().booleanValue()) {
                    this.internalSearchStrings = new Vector();
                    for (InternalSearchString internalSearchString : AllSearchStrings.getInstance().getInternalSearchStrings()) {
                        if (internalSearchString.getSearchFile() == null || !internalSearchString.getSearchFile().equalsIgnoreCase(string2)) continue;
                        this.internalSearchStrings.add(internalSearchString);
                    }
                }
                this.runRTScan(bl3, bl, dbPut, output);
            } else {
                this.runODScan(bl3, bl, dbPut, output);
            }
        }
        catch (BogusException bogusException) {
            Output.printTrace("File Type is Null or No Search strings specified for this file type", 1);
            bogusException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (Global.getSaveRestartPoint().booleanValue()) {
            Output.printTrace("Saving the restart point for this file : " + this.lastTimestamp, this.printfac, 3);
            this.fileEntity.setAnalysisStarted();
            this.fileEntity.setAnalysisTimestamp(this.lastTimestamp);
            this.fileEntity.store(new FileEntityDA());
        }
        Properties.getInstance();
        if (Properties.isSupportMode) {
            this.fileEntity.setTimestampOffset(this.timestampOffset);
            dbPut.storeFileEntity(this.fileEntity);
        }
        LogFile.writeLog("DriverMT: Completed : " + utilities.getDateTime());
        Output.printTrace("DriverMT: Completed : " + utilities.getDateTime(), this.printfac, 3);
    }

    public void interruptRTScan() {
        try {
            if (Global.getSaveRestartPoint().booleanValue()) {
                this.fileEntity.setAnalysisStarted();
                this.fileEntity.setAnalysisTimestamp(this.lastTimestamp);
                this.fileEntity.store(new FileEntityDA());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.keepReading = false;
    }

    public void interruptODScan() {
        this.keepReading = false;
    }

    private void runRTScan(boolean bl, boolean bl2, DbPut dbPut, Output output) {
        int n = 0;
        int n2 = 0;
        String string = this.fileEntity.getFileName();
        DateSearchResult dateSearchResult = null;
        DateFormatType dateFormatType = null;
        Date date = null;
        hAlrtDbStartShut hAlrtDbStartShut2 = new hAlrtDbStartShut();
        hAlrtDbGenErr hAlrtDbGenErr2 = new hAlrtDbGenErr();
        hAlrtDbParam hAlrtDbParam2 = new hAlrtDbParam();
        hGeneric hGeneric2 = new hGeneric();
        hAlrtCluEviction hAlrtCluEviction2 = new hAlrtCluEviction();
        hAlrtDbGenErr2.setFileName(null);
        hAlrtDbGenErr2.setParamValue("FALSE");
        hAlrtDbParam2.setParamValue("FALSE");
        hAlrtDbStartShut2.setFoundShutdown("FALSE");
        hAlrtDbStartShut2.setFoundStartup("FALSE");
        hAlrtDbStartShut2.setStartup(new InstanceStartup());
        hAlrtDbStartShut2.setShutdown(new InstanceShutdown());
        hAlrtDbStartShut2.setFirstTimestamp(null);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            long l = new File(this.fileEntity.getFileName()).length() / 0x100000L;
            Output.printTrace("fileSizeInMB: " + l, this.printfac, 3);
            if (l > Global.getSkipScanThreshold()) {
                try {
                    long l2 = new File(this.fileEntity.getFileName()).length();
                    long l3 = l2 - 1000000L;
                    Output.printTrace("fileSize start pos: " + l3, this.printfac, 3);
                    bufferedReader.skip(l3);
                }
                catch (Exception exception) {}
            } else if (!bl2) {
                try {
                    Date date2 = this.fileEntity.getAnalysisTimestamp();
                    Iterator<InternalSearchString> iterator = new RandomFileReader(this.fileEntity);
                    long l4 = ((RandomFileReader)((Object)iterator)).binarySearch(date2);
                    Output.printTrace("Date Found start pos: " + l4, this.printfac, 3);
                    bufferedReader.skip(l4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            while (this.keepReading) {
                Object object;
                Comparable<Date> comparable;
                Object object2;
                Object object3;
                String string2;
                int n3;
                ++n;
                String string3 = bufferedReader.readLine();
                if (string3 == null || string3.length() == 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Output.printTrace("Thread Interrupted will break from Read loop and complete", this.printfac, 3);
                        this.keepReading = false;
                    }
                    continue;
                }
                string3 = string3.trim();
                if (dateFormatType != null) {
                    dateSearchResult = this.dateMatcher.searchReuseFormat(string3, dateFormatType);
                } else {
                    dateSearchResult = this.dateMatcher.searchForDate(string3, this.fileEntity);
                    if (dateSearchResult != null) {
                        dateFormatType = dateSearchResult.getDft();
                    }
                }
                date = dateSearchResult != null ? dateSearchResult.getDateFound() : null;
                boolean bl3 = false;
                if (date != null) {
                    Output.printTrace("Date Found: " + date.toString() + this.fileEntity.getFileName(), this.printfac, 3);
                    bl3 = this.checkForValidString(string3, dateFormatType);
                    Properties.getInstance();
                    if (Properties.isSupportMode) {
                        this.timestampOffset.add(n);
                    }
                    this.lastTimestamp = date;
                    if (this.fileEntity.getFirstTime() == null) {
                        this.fileEntity.setFirstTimestamp(date);
                        dbPut.storeFileEntity(this.fileEntity);
                    }
                } else {
                    Output.printTrace(" String: " + string3, this.printfac, 4);
                    Output.printTrace(" Not Date Found: ", this.printfac, 4);
                }
                if (date != null && (n3 = TimeZoneUtil.getDifferenceBetweenDefaultAndSessionTZ()) != 0) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(this.lastTimestamp);
                    Output.printTrace("lastTimestamp: " + this.lastTimestamp, this.printfac, 4);
                    calendar.add(11, n3);
                    this.lastTimestamp = calendar.getTime();
                    Output.printTrace("lastTimestamp after timezone change: " + this.lastTimestamp, this.printfac, 4);
                }
                if (!bl || date != null && !bl3) continue;
                if (Global.isInternalSearchString().booleanValue() && this.internalSearchStrings != null && this.internalSearchStrings.size() > 0) {
                    for (InternalSearchString internalSearchString : this.internalSearchStrings) {
                        if (!internalSearchString.ismatch(string3)) continue;
                        Output.printTrace("Match found " + string3 + " in file:" + this.fileEntity.getFileName(), this.printfac, 3);
                        StringBuilder stringBuilder = new StringBuilder();
                        Properties.getInstance();
                        string2 = stringBuilder.append(Properties.tfaHome).append(File.separator).append("internal").append(File.separator).append("scripts").append(File.separator).append(".").append(internalSearchString.getScript()).toString();
                        if (!new File(string2).exists()) continue;
                        Output.printTrace("Executing script " + string2, this.printfac, 3);
                        String[] stringArray = new String[]{"/bin/sh", "-c", string2};
                        object3 = Runtime.getRuntime().exec(stringArray);
                        StringBuilder stringBuilder2 = new StringBuilder();
                        Properties.getInstance();
                        object2 = stringBuilder2.append(Properties.tfaHome).append(File.separator).append("internal").append(File.separator).append("scripts").append(File.separator).append("searchStrings_internal.log").toString();
                        comparable = new File((String)object2);
                        if (!((File)comparable).exists()) {
                            ((File)comparable).createNewFile();
                        }
                        object = null;
                        object = ((File)comparable).length() > 0xA00000L ? new BufferedWriter(new FileWriter((String)object2, false)) : new BufferedWriter(new FileWriter((String)object2, true));
                        ((Writer)object).write(Properties.getLogTime() + "  Search String : " + internalSearchString.getSearchString() + " found in file : " + this.fileEntity.getFileName() + " at line : " + this.lastTimestamp + string3 + ". Script executed : " + internalSearchString.getScript());
                        ((BufferedWriter)object).newLine();
                        ((BufferedWriter)object).close();
                        LogFile.writeLog("Search String : " + internalSearchString.getSearchString() + " found in file : " + this.fileEntity.getFileName() + " at line : " + this.lastTimestamp + string3 + ". Script executed : " + internalSearchString.getScript());
                        this.fileEntity.setAnalysisTimestamp(this.lastTimestamp);
                        dbPut.storeFileEntity(this.fileEntity);
                    }
                }
                for (SearchString searchString : this.mySearchStrings) {
                    string2 = searchString.getUseClass();
                    if (string2.contains("handleGeneric") && bl2) {
                        Output.printTrace("Deleting Generic Events for : " + this.fileEntity.getFileName(), this.printfac, 2);
                        Generic.deleteAllbyFile(this.fileEntity.getFileName(), dbPut, this.ssg);
                        bl2 = false;
                    }
                    if (searchString.getUseGlobalClass().equalsIgnoreCase("oracle.rat.tfa.analysis.Globals.hGeneric")) {
                        searchString.setGlobalWrapper(hGeneric2);
                    } else if (searchString.getUseGlobalClass().equalsIgnoreCase("oracle.rat.tfa.analysis.Globals.hAlrtDbParam")) {
                        searchString.setGlobalWrapper(hAlrtDbParam2);
                    } else {
                        searchString.setGlobalWrapper(new GlobalWrapper());
                    }
                    if (searchString.isDisableInADE()) continue;
                    boolean bl4 = searchString.ismatchString(string3);
                    if (!searchString.isLineAfterEvent() && !bl4) continue;
                    if (Global.isAllowZips().booleanValue() && Global.isFireZipsInRT().booleanValue() && searchString.getGenerateTrim() && bl4) {
                        LogFile.writeLog("addCriticalEvent: " + this.lastTimestamp + ":" + this.fileEntity.getFileName() + " " + string3);
                        this.addCriticalEvent(this.lastTimestamp, string3, searchString);
                    }
                    Output.printTrace("We got a Match", this.printfac, 4);
                    Output.printTrace("Will run Class : " + searchString.getUseClass(), this.printfac, 4);
                    object3 = Class.forName(searchString.getUseClass());
                    object2 = (ClassWrapper)((Class)object3).newInstance();
                    comparable = Calendar.getInstance().getTime();
                    if (((Date)comparable).after(this.lastTimestamp) && (((Date)comparable).getTime() - this.lastTimestamp.getTime()) / 1000L < 604800L) {
                        if (string2.equalsIgnoreCase("oracle.rat.tfa.analysis.handleAlertDbGeneralError")) {
                            ((ClassWrapper)object2).run(this.fileEntity, dbPut, this.ssg, string3, this.lastTimestamp, searchString, hAlrtDbGenErr2, hAlrtDbStartShut2);
                        } else if (searchString.getUseGlobalClass().equalsIgnoreCase("oracle.rat.tfa.analysis.Globals.hGeneric")) {
                            ((ClassWrapper)object2).run(this.fileEntity, dbPut, this.ssg, string3, this.lastTimestamp, searchString, hGeneric2);
                        } else if (searchString.getUseGlobalClass().equalsIgnoreCase("oracle.rat.tfa.analysis.Globals.hAlrtDbParam")) {
                            ((ClassWrapper)object2).run(this.fileEntity, dbPut, this.ssg, string3, this.lastTimestamp, searchString, hAlrtDbParam2, hAlrtDbStartShut2);
                        } else if (searchString.getUseClass().equalsIgnoreCase("oracle.rat.tfa.analysis.handleAlertClusterEviction")) {
                            ((ClassWrapper)object2).run(this.fileEntity, dbPut, this.ssg, string3, this.lastTimestamp, searchString, hAlrtCluEviction2);
                        } else if (searchString.getUseClass().equalsIgnoreCase("oracle.rat.tfa.analysis.handleAlertClusterReconfiguration")) {
                            ((ClassWrapper)object2).run(this.fileEntity, dbPut, this.ssg, string3, this.lastTimestamp, searchString);
                        } else if (searchString.getUseClass().equalsIgnoreCase("oracle.rat.tfa.analysis.handleAdrIncident")) {
                            object = new handleAdrIncident();
                            ((handleAdrIncident)object).run(this.fileEntity, dbPut, this.ssg, string3, this.lastTimestamp, searchString);
                        } else if (searchString.getUseGlobalClass().equalsIgnoreCase("NONE")) {
                            ((ClassWrapper)object2).run(this.fileEntity, dbPut, this.ssg, string3, this.lastTimestamp, searchString);
                        }
                    }
                    if (!string2.equalsIgnoreCase("oracle.rat.tfa.analysis.handleAlertDbStartShut")) continue;
                    ((ClassWrapper)object2).run(this.fileEntity, dbPut, this.ssg, string3, this.lastTimestamp, searchString, hAlrtDbStartShut2);
                }
                if (n - n2 != 500) continue;
                Output.printTrace("Saving restart point lastTimestamp: " + this.lastTimestamp, this.printfac, 3);
                if (Global.getSaveRestartPoint().booleanValue()) {
                    this.fileEntity.setAnalysisTimestamp(this.lastTimestamp);
                    dbPut.storeFileEntity(this.fileEntity);
                }
                n2 = n;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void runODScan(boolean bl, boolean bl2, DbPut dbPut, Output output) {
        int n = 0;
        int n2 = 0;
        String string = this.fileEntity.getFileName();
        DateSearchResult dateSearchResult = null;
        DateFormatType dateFormatType = null;
        Date date = null;
        hAlrtDbStartShut hAlrtDbStartShut2 = new hAlrtDbStartShut();
        hAlrtDbGenErr hAlrtDbGenErr2 = new hAlrtDbGenErr();
        hAlrtDbParam hAlrtDbParam2 = new hAlrtDbParam();
        hGeneric hGeneric2 = new hGeneric();
        hAlrtCluEviction hAlrtCluEviction2 = new hAlrtCluEviction();
        hAlrtDbGenErr2.setFileName(null);
        hAlrtDbGenErr2.setParamValue("FALSE");
        hAlrtDbParam2.setParamValue("FALSE");
        hAlrtDbStartShut2.setFoundShutdown("FALSE");
        hAlrtDbStartShut2.setFoundStartup("FALSE");
        hAlrtDbStartShut2.setStartup(new InstanceStartup());
        hAlrtDbStartShut2.setShutdown(new InstanceShutdown());
        hAlrtDbStartShut2.setFirstTimestamp(null);
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null && this.keepReading) {
                ++n;
                Output.printTrace("String is : " + string2, this.printfac, 4);
                if ((string2 = string2.trim()).length() <= 0) continue;
                if (dateFormatType != null) {
                    dateSearchResult = this.dateMatcher.searchReuseFormat(string2, dateFormatType);
                } else {
                    dateSearchResult = this.dateMatcher.searchForDate(string2, this.fileEntity);
                    if (dateSearchResult != null) {
                        dateFormatType = dateSearchResult.getDft();
                    }
                }
                date = dateSearchResult != null ? dateSearchResult.getDateFound() : null;
                if (date != null) {
                    Output.printTrace("Date Found: " + date.toString(), this.printfac, 4);
                    Properties.getInstance();
                    if (Properties.isSupportMode) {
                        this.timestampOffset.add(n);
                    }
                    this.lastTimestamp = date;
                    bl = !this.fileEntity.getAnalysisStarted().booleanValue() || !date.before(this.fileEntity.getAnalysisTimestamp());
                } else {
                    Output.printTrace(" String: " + string2, this.printfac, 4);
                    Output.printTrace(" Not Date Found: ", this.printfac, 4);
                }
                Output.printTrace(" Might Process: " + string2, this.printfac, 3);
                if (!bl || date != null) continue;
                Output.printTrace(" Will Process: ", this.printfac, 3);
                for (SearchString searchString : this.mySearchStrings) {
                    String string3 = searchString.getUseClass();
                    if (string3.contains("handleGeneric") && bl2) {
                        Output.printTrace("Deleting Generic Events for : " + this.fileEntity.getFileName(), this.printfac, 2);
                        Generic.deleteAllbyFile(this.fileEntity.getFileName(), dbPut, this.ssg);
                        bl2 = false;
                    }
                    if (searchString.getUseGlobalClass().equalsIgnoreCase("oracle.rat.tfa.analysis.Globals.hGeneric")) {
                        searchString.setGlobalWrapper(hGeneric2);
                    } else if (searchString.getUseGlobalClass().equalsIgnoreCase("oracle.rat.tfa.analysis.Globals.hAlrtDbParam")) {
                        searchString.setGlobalWrapper(hAlrtDbParam2);
                    } else {
                        searchString.setGlobalWrapper(new GlobalWrapper());
                    }
                    boolean bl3 = searchString.ismatchString(string2);
                    if (!searchString.isLineAfterEvent() && !bl3) continue;
                    if (Global.isAllowZips().booleanValue() && Global.isFireZipsInOD().booleanValue() && searchString.getGenerateTrim() && bl3) {
                        this.addCriticalEvent(this.lastTimestamp, string2, searchString);
                    }
                    Output.printTrace("We got a Match", this.printfac, 4);
                    Output.printTrace("Will run Class : " + searchString.getUseClass(), this.printfac, 4);
                    Class<?> clazz = Class.forName(searchString.getUseClass());
                    ClassWrapper classWrapper = (ClassWrapper)clazz.newInstance();
                    Output.printTrace("searchString : " + searchString.getSearchString() + " string : " + string2 + " timestamp : " + this.lastTimestamp, this.printfac, 3);
                    LogFile.writeLog("searchString : " + searchString.getSearchString() + " string : " + string2 + " timestamp : " + this.lastTimestamp);
                    if (searchString.getUseClass().equalsIgnoreCase("oracle.rat.tfa.analysis.handleAlertDbStartShut")) {
                        classWrapper.run(this.fileEntity, dbPut, this.ssg, string2, this.lastTimestamp, searchString, hAlrtDbStartShut2);
                        continue;
                    }
                    if (searchString.getUseClass().equalsIgnoreCase("oracle.rat.tfa.analysis.handleAlertDbGeneralError")) {
                        classWrapper.run(this.fileEntity, dbPut, this.ssg, string2, this.lastTimestamp, searchString, hAlrtDbGenErr2, hAlrtDbStartShut2);
                        continue;
                    }
                    if (searchString.getUseGlobalClass().equalsIgnoreCase("oracle.rat.tfa.analysis.Globals.hGeneric")) {
                        classWrapper.run(this.fileEntity, dbPut, this.ssg, string2, this.lastTimestamp, searchString, hGeneric2);
                        continue;
                    }
                    if (searchString.getUseGlobalClass().equalsIgnoreCase("oracle.rat.tfa.analysis.Globals.hAlrtDbParam")) {
                        classWrapper.run(this.fileEntity, dbPut, this.ssg, string2, this.lastTimestamp, searchString, hAlrtDbParam2, hAlrtDbStartShut2);
                        continue;
                    }
                    if (searchString.getUseClass().equalsIgnoreCase("oracle.rat.tfa.analysis.handleAlertClusterEviction")) {
                        classWrapper.run(this.fileEntity, dbPut, this.ssg, string2, this.lastTimestamp, searchString, hAlrtCluEviction2);
                        continue;
                    }
                    if (searchString.getUseClass().equalsIgnoreCase("oracle.rat.tfa.analysis.handleAlertClusterReconfiguration")) {
                        classWrapper.run(this.fileEntity, dbPut, this.ssg, string2, this.lastTimestamp, searchString);
                        continue;
                    }
                    if (!searchString.getUseGlobalClass().equalsIgnoreCase("NONE")) continue;
                    classWrapper.run(this.fileEntity, dbPut, this.ssg, string2, this.lastTimestamp, searchString);
                }
                if (n - n2 != 500) continue;
                Output.printTrace("Saving restart point after 500 lines", 3);
                if (Global.getSaveRestartPoint().booleanValue()) {
                    this.fileEntity.setAnalysisTimestamp(this.lastTimestamp);
                    dbPut.storeFileEntity(this.fileEntity);
                }
                n2 = n;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        Output output = new Output();
        Properties properties = Properties.getInstance("C:" + File.separator + "tfa_home");
        DbGet dbGet = new DbGet();
        File file = new File("C:" + File.separator + "temp" + File.separator + "alert" + File.separator + "alert_OVS1.log");
        Global.tracingOn = true;
        Global.setSaveRestartPoint(false);
        FileEntity fileEntity = dbGet.lookupFile(file.getAbsolutePath());
        Vector<Object> vector = new Vector();
        Output.printTrace("Loading All Seach Strings", 3);
        vector = AllSearchStrings.getInstance().getSearchStrings();
    }

    private Long getMax(long l, long l2) {
        int n = new Long(l).compareTo(new Long(l2));
        if (n >= 0) {
            return l;
        }
        return l2;
    }

    private void fireTrimZip(Map<String, Object> map, boolean bl) {
        Date date = (Date)map.get("timestamp");
        long l = (Long)map.get("event_start_trim_buffer");
        long l2 = date.getTime() - l;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        Date date2 = calendar.getTime();
        Output.print("Firing trim zip : " + date2 + " " + date);
        if (bl) {
            date = Calendar.getInstance().getTime();
        }
        String string = new Host().getHostname().trim();
        String string2 = System.currentTimeMillis() + ".zip";
        String string3 = new SimpleDateFormat("MMM/dd/yyyy HH:mm:ss").format(date2);
        String string4 = new SimpleDateFormat("MMM/dd/yyyy HH:mm:ss").format(date);
        String string5 = " -s " + string3 + " -e " + string4 + " -z " + string2;
        Output.print("Args for trim zip : " + string5);
        Action action = new Action("ziptracesfordates", string, "TFAScanning", string5);
        action.setMetadata((List)map.get("events"));
        action.store();
    }

    private void addCriticalEvent(Date date, String string, SearchString searchString) {
        EventMapKey eventMapKey = new EventMapKey(date, this.fileEntity.getFileName().trim(), string.trim(), searchString.getSearchString().trim());
        EventMapDA eventMapDA = new EventMapDA();
        EventMapEntity eventMapEntity = (EventMapEntity)eventMapDA.pIdx.get((Object)eventMapKey);
        if (eventMapEntity == null) {
            EventMapEntity eventMapEntity2 = new EventMapEntity(date, string.trim(), searchString.getSearchString().trim(), searchString.getEventStartTrimBuffer(), searchString.getEventEndTrimBuffer(), this.fileEntity.getFileName().trim(), searchString.getExtraFilesToCollect());
            Output.printTrace("SearchString " + searchString.getSearchString(), this.printfac, 3);
            Output.printTrace("Adding critical event to criticalEvents at : " + eventMapEntity2.getTimestamp() + ":" + string + ":" + this.fileEntity.getFileName(), this.printfac, 3);
            Output.printTrace("Storing eventMapEntity", this.printfac, 3);
            eventMapEntity2.setNotify(searchString.isNotify());
            eventMapEntity2.setClusterwide(searchString.isClusterwide());
            eventMapEntity2.store();
            Global.addToCriticalEvents(eventMapEntity2);
        } else {
            Output.printTrace("eventMapEntity already exists in BDB", this.printfac, 3);
            Output.printTrace("SearchString " + searchString.getSearchString(), this.printfac, 3);
            Output.printTrace("Adding critical event to criticalEvents at : " + eventMapEntity.getTimestamp() + ":" + string + ":" + this.fileEntity.getFileName(), this.printfac, 3);
            eventMapEntity.setNotify(searchString.isNotify());
            eventMapEntity.setClusterwide(searchString.isClusterwide());
            eventMapEntity.store();
            Global.addToCriticalEvents(eventMapEntity);
        }
    }

    private void createPrivateCopy(Vector<SearchString> vector) {
        this.allSearchStrings = new Vector();
        for (SearchString searchString : vector) {
            SearchString searchString2 = new SearchString();
            searchString2.setClass(searchString.getUseClass());
            searchString2.setEventEndTrimBuffer(searchString.getEventEndTrimBuffer());
            searchString2.setEventStartTrimBuffer(searchString.getEventStartTrimBuffer());
            searchString2.setEventId(searchString.getEventId());
            searchString2.setGenerateTrim(searchString.getGenerateTrim());
            searchString2.setGlobalClass(searchString.getUseGlobalClass());
            searchString2.setGlobalWrapper(new GlobalWrapper());
            searchString2.setLinesToProcess(searchString.getLinesToProcess());
            searchString2.setSearchFiles(searchString.getSearchFiles());
            searchString2.setSearchString(searchString.getSearchString());
            searchString2.setSearchEndString(searchString.getSearchEndString());
            searchString2.setExtraFilesToCollect(searchString.getExtraFilesToCollect());
            searchString2.setDisableInADE(searchString.isDisableInADE());
            this.allSearchStrings.add(searchString2);
        }
    }

    private boolean checkForValidString(String string, DateFormatType dateFormatType) {
        String[] stringArray;
        boolean bl = false;
        for (String string2 : stringArray = string.split(dateFormatType.getDatePatternExpression())) {
            if (string2 == null || string2.length() <= 0) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

