/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import oracle.rat.tfa.ClassWrapper;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.analysis.Globals.hAlrtDbGenErr;
import oracle.rat.tfa.analysis.Globals.hAlrtDbParam;
import oracle.rat.tfa.analysis.Globals.hAlrtDbStartShut;
import oracle.rat.tfa.db.DbGet;
import oracle.rat.tfa.db.DbPut;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.Generic;
import oracle.rat.tfa.entity.InstanceShutdown;
import oracle.rat.tfa.entity.InstanceStartup;
import oracle.rat.tfa.singletons.AllSearchStrings;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.singletons.MatchDates;
import oracle.rat.tfa.type.DateFormatType;
import oracle.rat.tfa.type.SearchString;
import oracle.rat.tfa.util.BogusException;
import oracle.rat.tfa.util.DateSearchResult;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.xml.SearchStringPatternXMLReader;

public class DriverClass {
    /*
     * WARNING - void declaration
     */
    public static void run(FileEntity fileEntity, Vector<SearchString> vector) {
        hAlrtDbGenErr hAlrtDbGenErr2 = new hAlrtDbGenErr();
        hAlrtDbGenErr2.setFileName(null);
        hAlrtDbGenErr2.setParamValue("FALSE");
        hAlrtDbParam hAlrtDbParam2 = new hAlrtDbParam();
        hAlrtDbParam2.setParamValue("FALSE");
        hAlrtDbStartShut hAlrtDbStartShut2 = new hAlrtDbStartShut();
        hAlrtDbStartShut2.setFoundShutdown("FALSE");
        hAlrtDbStartShut2.setFoundStartup("FALSE");
        hAlrtDbStartShut2.setShutdown(new InstanceShutdown());
        hAlrtDbStartShut2.setStartup(new InstanceStartup());
        hAlrtDbStartShut2.setFirstTimestamp(null);
        boolean bl = true;
        try {
            boolean bl2 = false;
            boolean bl3 = false;
            if (fileEntity.getType() == null) {
                throw new BogusException("");
            }
            String string = fileEntity.getType();
            DbPut dbPut = DbManager.getInstance().getDbPut();
            DbGet dbGet = DbManager.getInstance().getDbGet();
            String string2 = fileEntity.getFileName();
            Date object = null;
            String string3 = null;
            Output output = new Output();
            object = fileEntity.getAnalysisStarted() != false ? fileEntity.getAnalysisTimestamp() : fileEntity.getFirstTime();
            Vector<SearchString> vector2 = new Vector<SearchString>();
            for (SearchString object2 : vector) {
                Output.print("Search String: " + object2);
                for (String string4 : object2.getSearchFiles()) {
                    if (!string4.equalsIgnoreCase(string)) continue;
                    vector2.add(object2);
                }
            }
            SearchStringPatternXMLReader.listSearchStrings(vector2);
            try {
                String string5;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
                Object object2 = false;
                Object var20_25 = null;
                MatchDates matchDates = MatchDates.getInstance();
                if (fileEntity.getAnalysisStarted().booleanValue()) {
                    Output.printTrace("We have already started analysis for this file", 3);
                    Output.printTrace("Looping through dates up to : " + fileEntity.getAnalysisTimestamp(), 3);
                } else {
                    Output.printTrace("First Analysis for this file", 3);
                    object2 = true;
                }
                DateSearchResult dateSearchResult = null;
                DateFormatType dateFormatType = null;
                while ((string5 = bufferedReader.readLine()) != null) {
                    void var20_26;
                    String string6 = string5.trim();
                    if (dateFormatType != null) {
                        dateSearchResult = matchDates.searchReuseFormat(string6, dateFormatType);
                    } else {
                        dateSearchResult = matchDates.searchForDate(string6, fileEntity);
                        if (dateSearchResult != null) {
                            dateFormatType = dateSearchResult.getDft();
                        }
                    }
                    if (dateSearchResult != null) {
                        Date date = dateSearchResult.getDateFound();
                    }
                    if (var20_26 != null) {
                        Output.printTrace("Date Found: " + var20_26.toString(), 4);
                        object = var20_26;
                        object2 = fileEntity.getAnalysisStarted().booleanValue() && var20_26.before(fileEntity.getAnalysisTimestamp()) ? Boolean.valueOf(false) : Boolean.valueOf(true);
                    } else {
                        Output.printTrace(" String: " + string6, 4);
                        Output.printTrace(" Not Date Found: ", 4);
                    }
                    if (!((Boolean)object2).booleanValue()) continue;
                    Iterator<SearchString> iterator = vector2.iterator();
                    string3 = null;
                    while (iterator.hasNext() && string3 == null) {
                        SearchString searchString = iterator.next();
                        if (searchString.getUseClass().contains("handleGeneric") && bl) {
                            Output.printTrace("Deleting Generic Events for : " + fileEntity.getFileName(), 2);
                            Generic.deleteAllbyFile(fileEntity.getFileName(), dbPut, dbGet);
                            bl = false;
                        }
                        if (!searchString.ismatchString(string6)) continue;
                        string3 = "YES";
                        Output.printTrace("We got a Match", 2);
                        Output.printTrace("Will run Class : " + searchString.getUseClass(), 2);
                        Class<?> clazz = Class.forName(searchString.getUseClass());
                        ClassWrapper classWrapper = (ClassWrapper)clazz.newInstance();
                        classWrapper.run(fileEntity, dbPut, dbGet, string6, object, searchString);
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (Global.saveRestartPoint.booleanValue()) {
                fileEntity.setAnalysisStarted();
                fileEntity.setAnalysisTimestamp(object);
                dbPut.storeFileEntity(fileEntity);
            }
        }
        catch (BogusException bogusException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        Output output = new Output();
        Properties properties = Properties.getInstance("C:" + File.separator + "tfa_home");
        DbGet dbGet = new DbGet();
        File file = new File("C:" + File.separator + "temp" + File.separator + "alert" + File.separator + "alert_OVS1.log");
        Global.tracingOn = true;
        Global.saveRestartPoint = false;
        FileEntity fileEntity = dbGet.lookupFile(file.getAbsolutePath());
        Vector<SearchString> vector = new Vector();
        Output.printTrace("Loading All Seach Strings", 3);
        vector = AllSearchStrings.getInstance().getSearchStrings();
        DriverClass.run(fileEntity, vector);
    }
}

