/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.UserPrincipal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import oracle.rat.tfa.CollectionManager;
import oracle.rat.tfa.RepositoryManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DataAccessor.FileEntityDA;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.Collection;
import oracle.rat.tfa.entity.EventMapEntity;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Notification;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.StringUtil;

public class TrimZipHandler
extends Thread {
    private long zip_min_wait_time = 300L;
    private long zip_event_check_time = 30L;
    private long zip_max_wait_time = 600L;
    private boolean isNotify = false;
    private boolean isClusterwide = false;

    @Override
    public void run() {
        try {
            this.zip_min_wait_time = Global.getMinTimeForAutoDiagCollection();
            Output output = new Output();
            LogFile.writeLog("Sleeping for " + this.zip_min_wait_time / 60L + " minutes to collect events");
            Thread.sleep(this.zip_min_wait_time * 1000L);
            List<EventMapEntity> list = Global.getCriticalEvents();
            Output.printTrace("Getting all critical events now : " + list.size(), 3);
            boolean bl = false;
            EventMapEntity eventMapEntity = list.get(0);
            Output.printTrace("First event at : " + eventMapEntity.getTimestamp(), 3);
            if (Calendar.getInstance().getTimeInMillis() - eventMapEntity.getTimestamp().getTime() >= 1800000L) {
                this.zip_event_check_time = 300L;
                bl = true;
            }
            Output.printTrace("Sleeping for " + this.zip_event_check_time + " seconds to check for more events", 3);
            Thread.sleep(this.zip_event_check_time * 1000L);
            if (Global.criticalEvents.size() > 0) {
                boolean bl2 = true;
                if (bl) {
                    while (bl2) {
                        Date date = list.get(list.size() - 1).getTimestamp();
                        long l = Calendar.getInstance().getTimeInMillis() - date.getTime();
                        if (l >= 1800000L) {
                            if (Global.criticalEvents.size() > 0) {
                                EventMapEntity eventMapEntity2 = Global.criticalEvents.poll();
                                Output.printTrace("Adding this critical event : " + eventMapEntity2.getTimestamp(), 3);
                                list.add(eventMapEntity2);
                                Output.printTrace("Sleeping for " + this.zip_event_check_time + " seconds to check for more events", 3);
                                Thread.sleep(this.zip_event_check_time * 1000L);
                                continue;
                            }
                            bl2 = false;
                            continue;
                        }
                        bl2 = false;
                    }
                } else {
                    long l = Global.criticalEvents.peek().getTimestamp().getTime() - eventMapEntity.getTimestamp().getTime();
                    Output.printTrace("initial diff in minutes : " + l / 60000L, 3);
                    while (bl2 && l <= this.zip_max_wait_time * 1000L) {
                        Output.printTrace("diff in minutes: " + l / 60000L, 3);
                        Date date = list.get(list.size() - 1).getTimestamp();
                        if (Global.criticalEvents.size() > 0) {
                            Date date2 = Global.criticalEvents.peek().getTimestamp();
                            if ((date2.getTime() - date.getTime()) / 1000L <= 30L) {
                                EventMapEntity eventMapEntity3 = Global.criticalEvents.poll();
                                Output.printTrace("Adding this critical event : " + eventMapEntity3.getTimestamp(), 3);
                                list.add(eventMapEntity3);
                                Output.printTrace("Sleeping for " + this.zip_event_check_time + " seconds to check for more events", 3);
                                Thread.sleep(this.zip_event_check_time * 1000L);
                            } else {
                                bl2 = false;
                            }
                        } else {
                            bl2 = false;
                        }
                        l = Global.criticalEvents.peek().getTimestamp().getTime() - eventMapEntity.getTimestamp().getTime();
                    }
                }
            }
            Output.printTrace("Out of while loop, now we can process events", 3);
            this.processEvents(list);
            Output.printTrace("Done processing events", 3);
            Global.setTrimzipHandlerThread(null);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void processEvents(List<EventMapEntity> list) {
        int n = 1;
        Date date = null;
        LinkedList<Object> linkedList = null;
        for (int i = 0; i < list.size(); ++i) {
            Object e;
            Cloneable cloneable;
            Output.printTrace("Processing event " + list.get(i).getStr() + " at .... " + list.get(i).getTimestamp(), 3);
            EventMapEntity eventMapEntity = list.get(i);
            if (eventMapEntity == null) continue;
            Date date2 = eventMapEntity.getTimestamp();
            if (linkedList == null) {
                Output.printTrace("Adding the first event to processedEvents : " + eventMapEntity.getTimestamp(), 3);
                linkedList = new LinkedList<Object>();
                linkedList.add(eventMapEntity);
                date = eventMapEntity.getTimestamp();
                continue;
            }
            Date date3 = date;
            long l = 0L;
            if (n == 1) {
                l = (date2.getTime() - date3.getTime()) / 1000L;
                if (l <= this.zip_min_wait_time) {
                    Output.printTrace("Creating a composite event at " + date2, 3);
                    cloneable = new ArrayList();
                    e = linkedList.removeLast();
                    if (e != null) {
                        if (e instanceof List) {
                            cloneable.addAll((List)e);
                        } else {
                            cloneable.add(e);
                        }
                    }
                    cloneable.add(eventMapEntity);
                    date = eventMapEntity.getTimestamp();
                    linkedList.add(cloneable);
                } else {
                    n = 2;
                    cloneable = Calendar.getInstance();
                    ((Calendar)cloneable).setTime(date3);
                    ((Calendar)cloneable).add(12, (int)this.zip_min_wait_time / 60);
                    date3 = ((Calendar)cloneable).getTime();
                    Output.printTrace("Added " + (int)(this.zip_min_wait_time / 60L) + " min to timestamp of last event in processedEvents : " + date3, 3);
                }
            }
            if (n != 2) continue;
            l = (date2.getTime() - date3.getTime()) / 1000L;
            if (l < this.zip_event_check_time && (date2.getTime() - date.getTime()) / 1000L <= this.zip_max_wait_time) {
                Output.printTrace("Creating a composite event at : " + date2, 3);
                cloneable = new ArrayList();
                e = linkedList.removeLast();
                if (e != null) {
                    if (e instanceof List) {
                        cloneable.addAll((List)e);
                    } else {
                        cloneable.add(e);
                    }
                }
                cloneable.add(eventMapEntity);
                linkedList.add(cloneable);
                date3 = date2;
                continue;
            }
            n = 1;
            linkedList.add(eventMapEntity);
            date = eventMapEntity.getTimestamp();
        }
        if (Global.allowZips.booleanValue()) {
            this.fireTrimZips(linkedList);
        }
    }

    private void fireTrimZips(LinkedList linkedList) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ss");
        String string = new Host().getHostname().trim();
        for (Object e : linkedList) {
            boolean bl;
            Object object;
            Object object2;
            Object object3;
            Object object5;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            Object object12;
            ArrayList arrayList = new ArrayList();
            long l = 0L;
            long l2 = 0L;
            Date date = null;
            Date date2 = null;
            String string2 = "";
            if (e instanceof List) {
                object12 = (List)e;
                object11 = object12.iterator();
                while (object11.hasNext()) {
                    object10 = (EventMapEntity)object11.next();
                    Output.printTrace("compositeEvents: " + ((EventMapEntity)object10).getTimestamp(), 3);
                }
                object11 = new TreeSet(object12);
                object10 = object11.iterator();
                int n = 0;
                while (object10.hasNext()) {
                    object9 = (EventMapEntity)object10.next();
                    if (object9 == null || ((EventMapEntity)object9).getTimestamp() == null) continue;
                    object8 = new FileEntityDA();
                    object7 = (FileEntity)((FileEntityDA)object8).pIdx.get((Object)((EventMapEntity)object9).getFileName());
                    l = this.getMax(l, ((EventMapEntity)object9).getEventStartTrimBuffer());
                    l2 = this.getMax(l2, ((EventMapEntity)object9).getEventEndTrimBuffer());
                    HashMap<String, Object> object62 = new HashMap<String, Object>();
                    object62.put("str", ((EventMapEntity)object9).getStr());
                    object62.put("timestamp", ((EventMapEntity)object9).getTimestamp());
                    object62.put("searchString", ((EventMapEntity)object9).getSearchString());
                    object62.put("fileName", ((EventMapEntity)object9).getFileName());
                    object62.put("host", ((FileEntity)object7).getHostname());
                    object62.put("database", ((FileEntity)object7).getDatabase());
                    object62.put("instance", ((FileEntity)object7).getInstance());
                    object62.put("component", ((FileEntity)object7).getComponent());
                    object62.put("alsoCollectFor", ((FileEntity)object7).getAlsoCollectFor());
                    if (((EventMapEntity)object9).getExtraComponents() != null && ((EventMapEntity)object9).getExtraComponents().size() > 0) {
                        object62.put("extraFilesToCollect", ((EventMapEntity)object9).getExtraComponents());
                    }
                    object62.put("requestClient", "TFAScanning");
                    object62.put("collectionType", "auto");
                    arrayList.add(object62);
                    if (!this.isNotify || !this.isClusterwide) {
                        if (((EventMapEntity)object9).isNotify()) {
                            this.isNotify = true;
                        }
                        if (((EventMapEntity)object9).isClusterwide()) {
                            this.isClusterwide = true;
                        }
                    }
                    Output.printTrace("compositeEvent " + ((EventMapEntity)object9).getSearchString() + " " + ((EventMapEntity)object9).getFileName() + " " + ((EventMapEntity)object9).getTimestamp(), 3);
                    Output.printTrace("compositeEvent " + n++ + " timestamp : " + ((EventMapEntity)object9).getStr(), 3);
                    ((EventMapEntity)object9).setProcessTime(new Date());
                    ((EventMapEntity)object9).setProcessStatus(false);
                    ((EventMapEntity)object9).store();
                }
                object9 = ((EventMapEntity)object12.get(0)).getTimestamp();
                long l3 = ((Date)object9).getTime() - l;
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(l3);
                date = calendar.getTime();
                long l4 = ((Date)object9).getTime() + l2;
                calendar.setTimeInMillis(l4);
                date2 = calendar.getTime();
                if (Global.fireZipsInRT.booleanValue() && ((Date)object9).getTime() > Calendar.getInstance().getTimeInMillis() - 1800000L) {
                    date2 = Calendar.getInstance().getTime();
                }
                string2 = simpleDateFormat.format((Date)object9) + ".zip";
                string2 = string2.replaceAll("-", "_");
            } else {
                LogFile.writeLog("Solitary Event : " + ((EventMapEntity)e).getTimestamp());
                l = ((EventMapEntity)e).getEventStartTrimBuffer();
                l2 = ((EventMapEntity)e).getEventEndTrimBuffer();
                object12 = ((EventMapEntity)e).getTimestamp();
                long l5 = ((Date)object12).getTime() - l;
                object5 = Calendar.getInstance();
                ((Calendar)object5).setTimeInMillis(l5);
                date = ((Calendar)object5).getTime();
                long l6 = ((Date)object12).getTime() + l2;
                ((Calendar)object5).setTimeInMillis(l6);
                date2 = ((Calendar)object5).getTime();
                if (Global.fireZipsInRT.booleanValue() && ((Date)object12).getTime() > Calendar.getInstance().getTimeInMillis() - 1800000L) {
                    date2 = Calendar.getInstance().getTime();
                }
                object7 = new FileEntityDA();
                FileEntity fileEntity = (FileEntity)((FileEntityDA)object7).pIdx.get((Object)((EventMapEntity)e).getFileName());
                string2 = simpleDateFormat.format((Date)object12) + ".zip";
                string2 = string2.replaceAll("-", "_");
                object3 = new HashMap<String, Object>();
                object3.put("str", ((EventMapEntity)e).getStr());
                object3.put("timestamp", ((EventMapEntity)e).getTimestamp());
                object3.put("searchString", ((EventMapEntity)e).getSearchString());
                object3.put("fileName", ((EventMapEntity)e).getFileName());
                object3.put("host", fileEntity.getHostname());
                object3.put("database", fileEntity.getDatabase());
                object3.put("instance", fileEntity.getInstance());
                object3.put("component", fileEntity.getComponent());
                object3.put("alsoCollectFor", fileEntity.getAlsoCollectFor());
                if (((EventMapEntity)e).getExtraComponents() != null && ((EventMapEntity)e).getExtraComponents().size() > 0) {
                    object3.put("extraFilesToCollect", ((EventMapEntity)e).getExtraComponents());
                }
                object3.put("requestClient", "TFAScanning");
                object3.put("collectionType", "auto");
                arrayList.add(object3);
                if (!this.isNotify || !this.isClusterwide) {
                    if (((EventMapEntity)e).isNotify()) {
                        this.isNotify = true;
                    }
                    if (((EventMapEntity)e).isClusterwide()) {
                        this.isClusterwide = true;
                    }
                }
                ((EventMapEntity)e).setProcessTime(new Date());
                ((EventMapEntity)e).setProcessStatus(false);
                ((EventMapEntity)e).store();
            }
            Output.printTrace("Firing trim zip with start : " + date + " and end : " + date2, 3);
            object12 = new SimpleDateFormat("MMM/dd/yyyy HH:mm:ss").format(date);
            object11 = null;
            if (date2 != null) {
                object11 = new SimpleDateFormat("MMM/dd/yyyy HH:mm:ss").format(date2);
            }
            object10 = "collection_" + simpleDateFormat.format(date).replaceAll("-", "_") + "_node_" + string;
            object5 = "" + Calendar.getInstance().getTimeInMillis();
            object9 = new HashSet();
            object8 = new HashSet();
            for (Map map : arrayList) {
                String string3 = (String)map.get("component");
                if (string3.equalsIgnoreCase("RDBMS")) {
                    object2 = ((String)map.get("database")).trim();
                    object8.add(object2);
                }
                object9.add(string3.toLowerCase());
                object2 = (List)map.get("extraFilesToCollect");
                if (object2 == null) continue;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    object9.add(((String)object).toLowerCase());
                }
            }
            Output.printTrace("Components to collect : " + object9, 3);
            object7 = " -node local";
            boolean bl2 = true;
            if (this.isClusterwide) {
                object7 = " -node all -copy";
                List<String> list = Action.getRunningAutoCollections();
                LogFile.writeLog("RunningAutoCollections: " + list);
                for (String string4 : list) {
                    object = CollectionManager.getCollection(string4);
                    Output.printTrace("Current Components to collect : " + object9, 1);
                    Output.printTrace("Running autocollection components : " + ((Collection)object).getComponentList(), 1);
                    if (!((Collection)object).getComponentList().containsAll((java.util.Collection<?>)object9)) continue;
                    Output.printTrace("current end time: " + date2.getTime(), 3);
                    Output.printTrace("current start time: " + date.getTime(), 3);
                    double d = (double)(date2.getTime() - date.getTime()) * 0.8;
                    Output.printTrace("cutoff range: " + d, 3);
                    long l5 = date.getTime() + (long)d;
                    Output.printTrace("cutoff: " + l5, 1);
                    Output.printTrace("Previous end time: " + ((Collection)object).getEndTime().getTime(), 1);
                    if (((Collection)object).getEndTime().getTime() < l5) continue;
                    bl = false;
                    LogFile.writeLog("Ignoring AutoCollect");
                    break;
                }
            }
            if (!bl) {
                return;
            }
            object3 = " -from " + (String)object12 + " -to " + (String)object11 + " -z " + string2 + (String)object7 + " -tag " + (String)object10 + " -logid " + (String)object5;
            object2 = object9.iterator();
            while (object2.hasNext()) {
                String string5 = object2.next();
                if (string5.equalsIgnoreCase("rdbms")) {
                    if (object8.size() > 0) {
                        object3 = (String)object3 + " -database ";
                        object = object8.iterator();
                        while (object.hasNext()) {
                            String string6 = (String)object.next();
                            object3 = (String)object3 + string6 + ",";
                        }
                    } else {
                        object3 = (String)object3 + " -database all";
                    }
                }
                object3 = (String)object3 + " -" + string5;
            }
            object2 = (String)object5 + StringUtil.getReplacementFor(string);
            object3 = (String)object3 + ":" + (String)object2;
            LogFile.writeLog("Args for trim zip : " + (String)object3);
            if (this.isNotify) {
                String string7 = Global.notificationAddress;
                object = "TFA Event Notification from " + string;
                String string8 = "";
                for (Map map : arrayList) {
                    string8 = string8 + "Event: " + map.get("searchString") + "\n";
                    string8 = string8 + "Event time: " + map.get("timestamp") + "\n\n";
                    string8 = string8 + "File containing event: " + map.get("fileName") + "\n\n";
                    string8 = string8 + "String containing event: " + map.get("str") + "\n\n";
                    string8 = string8 + "Logs will be collected at: " + RepositoryManager.getInstance().getDirectory() + File.separator + (String)object10;
                    try {
                        Path path = Paths.get((String)map.get("fileName"), new String[0]);
                        UserPrincipal userPrincipal = Files.getOwner(path, new LinkOption[0]);
                        String string9 = userPrincipal.getName();
                        String string10 = Global.userAddresses.get(string9);
                        LogFile.writeLog("File Owner: " + string9 + " User Address: " + string10);
                        if (string10 == null) continue;
                        Notification notification = new Notification("tfa@localhost.com", string10, null, null, (String)object, string8);
                        notification.sendMail();
                    }
                    catch (Exception exception) {}
                }
                if (string7 != null) {
                    Notification notification = new Notification("tfa@localhost.com", string7, null, null, (String)object, string8);
                    notification.sendMail();
                }
            }
            Action action = new Action("startdiagcollection", string, "TFAScanning", (String)object3);
            action.setMetadata(arrayList);
            Output.printTrace("Metadata : " + arrayList, 3);
            action.store();
        }
    }

    private Long getMax(long l, long l2) {
        int n = new Long(l).compareTo(new Long(l2));
        if (n >= 0) {
            return l;
        }
        return l2;
    }
}

