/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import oracle.rat.tfa.InstanceMonitor;
import oracle.rat.tfa.analysis.DriverClassMT;
import oracle.rat.tfa.db.DataAccessor.FileEntityDA;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.ScanFileEntity;
import oracle.rat.tfa.singletons.AllSearchStrings;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.singletons.MatchDates;
import oracle.rat.tfa.type.SearchString;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Utilities;

public class TFAScanningMainRT
extends Thread {
    private String[] args;
    private boolean stopThreads = false;
    private String printfac = "SCAN";

    public TFAScanningMainRT() {
    }

    public TFAScanningMainRT(String[] stringArray) {
        this.args = stringArray;
    }

    private Thread[] expandThreads(Thread[] threadArray, int n) {
        Thread[] threadArray2 = new Thread[n];
        System.arraycopy(threadArray, 0, threadArray2, 0, threadArray.length);
        return threadArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Integer n = 5;
        Thread[] threadArray = new Thread[n.intValue()];
        Utilities utilities = new Utilities();
        Output output = new Output();
        boolean bl = false;
        try {
            Serializable serializable;
            Object object;
            Serializable serializable2;
            LogFile.writeLog("RT SCAN: Start : " + utilities.getDateTime());
            Output.printTrace("RT SCAN: Start : " + utilities.getDateTime(), this.printfac, 3);
            Output.print("Scanner Start : " + utilities.getDateTime());
            MatchDates matchDates = MatchDates.getInstance();
            Vector<SearchString> vector = new Vector();
            Output.printTrace("RT SCAN: Loading All Seach Strings", this.printfac, 3);
            vector = AllSearchStrings.getInstance().getSearchStrings();
            Output.printTrace("RT SCAN: Completed Loading All Seach Strings", this.printfac, 3);
            while (InstanceMonitor.instances.size() == 0) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {}
            }
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(String.class, ScanFileEntity.class);
            EntityCursor entityCursor = primaryIndex.entities(null, cursorConfig);
            try {
                serializable2 = new Vector();
                block12: for (ScanFileEntity scanFileEntity : entityCursor) {
                    int n2;
                    object = new FileEntityDA();
                    serializable = (FileEntity)((FileEntityDA)object).pIdx.get((Object)scanFileEntity.getFileName());
                    if (serializable == null) {
                        ((Vector)serializable2).add(scanFileEntity.getFileName());
                        continue;
                    }
                    boolean bl2 = ((FileEntity)serializable).isTrimFile;
                    bl = false;
                    Output.printTrace("Found File in database: " + ((FileEntity)serializable).getFileName() + " -- Size: " + ((FileEntity)serializable).getFileSize() + " -- Last Modified: " + ((FileEntity)serializable).getLastModified().toString() + " -- Lines: " + ((FileEntity)serializable).getNumberOfLines() + " -- Type: " + ((FileEntity)serializable).getType(), this.printfac, 3);
                    Output.printTrace("Check if we want to Tail this file", this.printfac, 3);
                    if (((FileEntity)serializable).getComponent() != null && !((FileEntity)serializable).getComponent().equalsIgnoreCase("crs")) {
                        if (!InstanceMonitor.instances.contains(((FileEntity)serializable).getInstance())) {
                            LogFile.writeLog("Not tailing alert log " + ((FileEntity)serializable).getFileName() + " since instance " + ((FileEntity)serializable).getInstance() + " is not running");
                            continue;
                        }
                        if (!((FileEntity)serializable).getShortName().equals("alert_" + ((FileEntity)serializable).getInstance() + ".log")) {
                            Output.printTrace("Not tailing alert log " + ((FileEntity)serializable).getFileName() + " since inactive", this.printfac, 3);
                            ((Vector)serializable2).add(scanFileEntity.getFileName());
                            continue;
                        }
                    }
                    if (((FileEntity)serializable).getFileName().contains("asmcmd") || ((FileEntity)serializable).getFileName().contains("asmtool") || !new File(scanFileEntity.getFileName()).exists()) {
                        ((Vector)serializable2).add(scanFileEntity.getFileName());
                        continue;
                    }
                    if (bl2) continue;
                    LogFile.writeLog("SCAN: File to process: " + ((FileEntity)serializable).getFileName() + " : " + ((FileEntity)serializable).getInstance());
                    for (n2 = 0; n2 < threadArray.length; ++n2) {
                        if (threadArray[n2] != null) continue;
                        threadArray[n2] = new DriverClassMT((FileEntity)serializable, vector, matchDates, "RT");
                        threadArray[n2].start();
                        Output.printTrace("Started New Thread : " + threadArray[n2].getName(), this.printfac, 3);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    n = threadArray.length + 5;
                    Output.printTrace("All threads were started :: Expanding array to : " + n, this.printfac, 3);
                    threadArray = this.expandThreads(threadArray, n);
                    for (n2 = 0; n2 < threadArray.length; ++n2) {
                        if (threadArray[n2] != null) continue;
                        threadArray[n2] = new DriverClassMT((FileEntity)serializable, vector, matchDates, "RT");
                        threadArray[n2].start();
                        Output.printTrace("Started New Thread : " + threadArray[n2].getName(), this.printfac, 3);
                        bl = true;
                        continue block12;
                    }
                }
                entityCursor.close();
                if (((Vector)serializable2).size() > 0) {
                    ScanFileEntity.deleteScanEntities((Vector<String>)serializable2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            serializable2 = Boolean.valueOf(true);
            Object object2 = 0;
            while (((Boolean)serializable2).booleanValue()) {
                try {
                    for (int i = 0; i < threadArray.length; ++i) {
                        if (this.stopThreads && threadArray[i] != null) {
                            Output.printTrace("Waiting for Real Time Scanner to stop...", this.printfac, 3);
                            ((DriverClassMT)threadArray[i]).interruptRTScan();
                        }
                        if (threadArray[i] == null || !threadArray[i].isAlive()) continue;
                        Output.printTrace("Thread :: " + threadArray[i].getName() + " is Alive", this.printfac, 4);
                        object = object2;
                        object2 = (Integer)object2 + 1;
                        serializable = object2;
                    }
                    if ((Integer)object2 == 0) {
                        serializable2 = Boolean.valueOf(false);
                    }
                    Output.printTrace("Threads Still runnning", this.printfac, 4);
                    object2 = 0;
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    Output.printTrace("Received Message to shutdown through Interrupt - waiting for Threads to stop", this.printfac, 3);
                    this.stopThreads = true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            Output.printTrace("RT SCAN: Finish : " + utilities.getDateTime(), this.printfac, 3);
            Output.print("Scanner Finish : " + utilities.getDateTime());
        }
    }

    public void stopRTScanner() {
        Output.printTrace("Stopping Real Time Scanner", this.printfac, 3);
        this.stopThreads = true;
    }

    public static void main(String[] stringArray) {
        Thread thread = new Thread(new TFAScanningMainRT(stringArray));
        thread.start();
    }
}

