/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.io.File;
import java.util.Vector;
import oracle.rat.tfa.analysis.DriverClassMT;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.DatabaseGeneralError;
import oracle.rat.tfa.entity.DatabaseParameter;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.Generic;
import oracle.rat.tfa.entity.InstanceShutdown;
import oracle.rat.tfa.entity.InstanceStartup;
import oracle.rat.tfa.singletons.AllSearchStrings;
import oracle.rat.tfa.singletons.MatchDates;
import oracle.rat.tfa.type.SearchString;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.Utilities;
import oracle.rat.tfa.xml.DumpXml;
import oracle.rat.tfa.xml.ScanFileListXMLReader;

public class TFAScanningMainOD
implements Runnable {
    private String[] args;
    private Action callingAction;
    private String tfaHome = "";
    private String srFileDir = "";
    private boolean stopThreads = false;

    public TFAScanningMainOD(Action action) {
        this.callingAction = action;
    }

    public TFAScanningMainOD(String[] stringArray) {
        this.args = stringArray;
        if (stringArray.length == 0) {
            this.tfaHome = "C:/tfa_home/";
            this.srFileDir = "C:/tfa_home/";
        } else {
            this.tfaHome = stringArray[0];
            this.srFileDir = stringArray[1];
        }
        Properties properties = Properties.getInstance(this.srFileDir);
        Properties.fileTypesXml = Properties.resourcesDir + File.separator + "file_type_patterns.xml";
        Properties.datePatternsXml = Properties.resourcesDir + File.separator + "date_patterns.xml";
        Properties.extensionsFile = Properties.resourcesDir + File.separator + "ignore_extensions.txt";
    }

    private Thread[] expandThreads(Thread[] threadArray, int n) {
        Thread[] threadArray2 = new Thread[n];
        System.arraycopy(threadArray, 0, threadArray2, 0, threadArray.length);
        return threadArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        Integer n = 5;
        Thread[] threadArray = new Thread[n.intValue()];
        Utilities utilities = new Utilities();
        Output output = new Output();
        boolean bl = false;
        boolean bl2 = false;
        try {
            int n2;
            LogFile.writeLog("OD SCAN: Start : " + utilities.getDateTime());
            Output.printTrace("OD SCAN: Start : " + utilities.getDateTime(), 3);
            Vector<FileEntity> vector = new Vector<FileEntity>();
            MatchDates matchDates = null;
            Output.printTrace("About to read files XML", 3);
            bl = ScanFileListXMLReader.processXML(vector);
            if (bl) {
                Output.printTrace("Set to do ALL files", 3);
            } else {
                Output.printTrace("Not Set to do ALL files", 3);
            }
            if (!bl && vector.size() == 0) {
                LogFile.writeLog("SCAN: Exiting due to lack of files to process");
                return;
            }
            Vector<SearchString> vector2 = new Vector();
            Output.printTrace("OD SCAN: Loading All Seach Strings", 3);
            vector2 = AllSearchStrings.getInstance().getSearchStrings();
            Output.printTrace("OD SCAN: Completed Loading All Seach Strings", 3);
            if (bl) {
                try {
                    for (FileEntity serializable2 : Global.scanFileList) {
                        int n3;
                        bl2 = false;
                        n2 = serializable2.isTrimFile;
                        Output.printTrace("Found File in database: " + serializable2.getFileName() + " -- Size: " + serializable2.getFileSize() + " -- Last Modified: " + serializable2.getLastModified().toString() + " -- Lines: " + serializable2.getNumberOfLines(), 3);
                        if (serializable2.getType() == null) {
                            Output.printTrace("File has a null fileType cannot process", 2);
                            continue;
                        }
                        Output.printTrace("Check if we want to Scan this file", 3);
                        if (n2 != 0) continue;
                        LogFile.writeLog("SCAN: File to process: " + serializable2.getFileName());
                        for (n3 = 0; n3 < threadArray.length; ++n3) {
                            if (threadArray[n3] != null) continue;
                            threadArray[n3] = new DriverClassMT(serializable2, vector2, matchDates, "OD");
                            threadArray[n3].start();
                            Output.printTrace("Started New Thread : " + threadArray[n3].getName(), 3);
                            bl2 = true;
                            break;
                        }
                        while (!bl2) {
                            Output.printTrace("All threads were started", 3);
                            for (n3 = 0; n3 < threadArray.length; ++n3) {
                                if (!threadArray[n3].isAlive()) {
                                    Output.printTrace("THR: " + n3 + " is not alive", 3);
                                    threadArray[n3] = new DriverClassMT(serializable2, vector2, matchDates, "OD");
                                    threadArray[n3].start();
                                    Output.printTrace("Started Again for Thread : " + threadArray[n3].getName(), 3);
                                    bl2 = true;
                                } else {
                                    Output.printTrace("THR: " + n3 + " was alive", 3);
                                }
                                if (bl2) break;
                            }
                            if (bl2) continue;
                            Output.printTrace("Sleeping for 5 seconds", 3);
                            Thread.sleep(5000L);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                try {
                    for (FileEntity fileEntity : vector) {
                        LogFile.writeLog("SCAN: File to process: " + fileEntity.getFileName());
                        for (n2 = 0; n2 < threadArray.length; ++n2) {
                            if (threadArray[n2] != null) continue;
                            threadArray[n2] = new DriverClassMT(fileEntity, vector2, matchDates, "OD");
                            threadArray[n2].start();
                            bl2 = true;
                            break;
                        }
                        while (!bl2) {
                            for (n2 = 0; n2 < threadArray.length; ++n2) {
                                if (threadArray[n2].isAlive()) continue;
                                threadArray[n2] = new DriverClassMT(fileEntity, vector2, matchDates, "OD");
                                threadArray[n2].start();
                                bl2 = true;
                                break;
                            }
                            Thread.sleep(5000L);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            Object object = true;
            Integer n4 = 0;
            while (((Boolean)object).booleanValue()) {
                try {
                    void var11_19;
                    for (int i = 0; i < threadArray.length; ++i) {
                        Integer n5;
                        if (this.stopThreads && threadArray[i] != null) {
                            Output.printTrace("Waiting for On Demand Scanner to complete...", 3);
                            ((DriverClassMT)threadArray[i]).interruptODScan();
                        }
                        if (threadArray[i] == null || !threadArray[i].isAlive()) continue;
                        Output.printTrace("Thread :: " + threadArray[i].getName() + " is Alive", 3);
                        void var13_27 = var11_19;
                        Integer n6 = n5 = Integer.valueOf(var11_19.intValue() + 1);
                    }
                    if (var11_19.intValue() == 0) {
                        object = false;
                    }
                    Output.printTrace("Threads Still runnning", 3);
                    Integer n7 = 0;
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    Output.printTrace("Received Message to shutdown through Interrupt - waiting for Threads to stop", 3);
                    this.stopThreads = true;
                }
            }
            DumpXml.DumpAllXml();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            LogFile.writeLog("SCAN: Finish : " + utilities.getDateTime());
            if (this.callingAction != null) {
                this.callingAction.setActionComplete();
                this.callingAction.store();
            }
            Output.print("************** COMPLETE ****************");
        }
    }

    public void stopODScanner() {
        Output.printTrace("Stopping On Demand Scanner", 3);
        this.stopThreads = true;
    }

    public static void main(String[] stringArray) {
        Thread thread = new Thread(new TFAScanningMainOD(stringArray));
        thread.start();
        try {
            thread.join();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        InstanceStartup.dumpToOracle();
        InstanceShutdown.dumpToOracle();
        DatabaseParameter.dumpToOracle();
        DatabaseGeneralError.dumpToOracle();
        Generic.dumptoOracle();
        DumpXml.DumpAllXml();
    }
}

