/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import oracle.rat.tfa.analysis.DriverClass;
import oracle.rat.tfa.analysis.handleAlertDbStartShut;
import oracle.rat.tfa.entity.DatabaseGeneralError;
import oracle.rat.tfa.entity.DatabaseParameter;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.Generic;
import oracle.rat.tfa.entity.InstanceShutdown;
import oracle.rat.tfa.entity.InstanceStartup;
import oracle.rat.tfa.singletons.AllSearchStrings;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.type.SearchString;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.xml.ScanFileListXMLReader;

public class TFAScanningMain {
    private static String getDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Output output = new Output();
        boolean bl = false;
        try {
            Vector<SearchString> vector;
            Object object;
            LogFile.writeLog("SCAN: Start : " + TFAScanningMain.getDateTime());
            Properties properties = Properties.getInstance(stringArray[0]);
            if (stringArray.length == 2) {
                Output.printTrace("In the args 2 section", 3);
                object = stringArray[1];
                Output.printTrace("Dir File Full: " + (String)object, 3);
                properties.setTfaPropertiesFile((String)object);
                Output.printTrace("File List: " + Properties.scanFileListXml, 3);
            }
            if (stringArray.length == 3) {
                Output.printTrace("In the args 3 section", 3);
                object = stringArray[1];
                Output.printTrace("Dir File Full: " + (String)object, 3);
                vector = stringArray[2];
                properties.setTfaPropertiesFile((String)object);
                Properties.setScanFileListXml((String)((Object)vector));
                Output.printTrace("File List: " + Properties.scanFileListXml, 3);
            }
            if (!(bl = ScanFileListXMLReader.processXML(object = new Vector<FileEntity>())) && ((Vector)object).size() == 0) {
                LogFile.writeLog("SCAN: Exiting due to lack of files to process");
                return;
            }
            StringBuilder stringBuilder = new StringBuilder().append("SCAN: SrfileId : ");
            Properties.getInstance();
            LogFile.writeLog(stringBuilder.append(Properties.srFileId).toString());
            vector = new Vector();
            Output.printTrace("Loading All Seach Strings", 3);
            vector = AllSearchStrings.getInstance().getSearchStrings();
            if (bl) {
                PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(FileEntity.class);
                EntityCursor entityCursor = primaryIndex.entities();
                try {
                    for (FileEntity fileEntity : entityCursor) {
                        Output.printTrace("Found File in database: " + fileEntity.getFileName() + " -- Size: " + fileEntity.getFileSize() + " -- Last Modified: " + fileEntity.getLastModified().toString() + " -- Lines: " + fileEntity.getNumberOfLines(), 3);
                        LogFile.writeLog("SCAN: File to process: " + fileEntity.getFileName());
                        DriverClass.run(fileEntity, vector);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                entityCursor.close();
            } else {
                Iterator iterator = ((Vector)object).iterator();
                while (iterator.hasNext()) {
                    FileEntity fileEntity = (FileEntity)iterator.next();
                    LogFile.writeLog("SCAN: File to process: " + fileEntity.getFileName());
                    DriverClass.run(fileEntity, vector);
                }
            }
            handleAlertDbStartShut.printAll();
            Generic.dumptoOracle();
            DatabaseParameter.dumpToOracle();
            DatabaseGeneralError.dumpToOracle();
            InstanceShutdown.dumpToOracle();
            InstanceStartup.dumpToOracle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            LogFile.writeLog("SCAN: Finish : " + TFAScanningMain.getDateTime());
        }
    }
}

