/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.BroadcastMessage;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DataAccessor.TFAReceiverDA;
import oracle.rat.tfa.db.DbGet;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.TFAHost;
import oracle.rat.tfa.entity.TFAReceiver;
import oracle.rat.tfa.receiver.RGlobal;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;

public class TFAReceiverManager {
    public static void syncRNodes(String string) {
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        String string2 = new Host().getHostname().trim();
        String string3 = string2 + ":updaternodes:" + string + ":pr";
        new BroadcastMessage(string3).broadcast();
        Output.printTrace("Successfully synced R Objects", 1);
    }

    public static String afterAddHost(String string) {
        Output.printTrace("TFAReceiverManager.afterAddHost(): Start", 3);
        String string2 = new Host().getHostname().trim();
        Output.printTrace("Sync R Objects in current cluster(CC/RC)", 3);
        String string3 = "FAILED";
        TFAReceiverManager.syncRNodes(string2);
        String string4 = Properties.TFARunMode.toUpperCase();
        if (string4.equals("COLLECTOR")) {
            Socket socket = null;
            PrintWriter printWriter = null;
            BufferedReader bufferedReader = null;
            Object var7_10 = null;
            String string5 = string2;
            String string6 = RGlobal.mainReceiver;
            int n = RGlobal.receiverPortForCollectors;
            String string7 = RGlobal.collectorKeys.get(string2);
            Output.printTrace("TFAReceiverManager.afterAddHost with " + string6 + " " + n, 1);
            TFAReceiver tFAReceiver = new TFAReceiver(string6, n, string7);
            try {
                socket = SocketManager.getAuthenticatedSocketConnectionR(string5, string6, n, string7);
                if (socket == null) {
                    Output.printTrace("Failed to get socket connection to " + string6, 1);
                    string3 = "FAILED TO CONNECT SECURELY TO " + string6;
                    return string3;
                }
                printWriter = new PrintWriter(socket.getOutputStream(), true);
                bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                Output.printTrace("Updating collectors in Receiver cluster", 1);
                String string8 = string2 + ":addcollectornode:" + string2;
                TFAHost.printAllToMHandler(printWriter, string8, string7);
                string8 = string2 + ":syncreceivernodes:" + string6;
                printWriter.println(string8);
                if (!socket.isClosed()) {
                    socket.close();
                }
                Output.printTrace("Closed connect to receiver " + string6, 3);
                string3 = "SUCCESS";
            }
            catch (UnknownHostException unknownHostException) {
                Output.printTrace("Don't know about receiver:" + string6, 1);
            }
            catch (IOException iOException) {
                Output.printTrace("Couldn't get I/O for the connection to: " + string6, 1);
                iOException.printStackTrace();
            }
            Output.printTrace("TFAReceiverManager.afterAddHost():[" + string2 + "] End ", 3);
            return string3;
        }
        String string9 = string2 + "~action_name=updatereceivers~run_mode=Receiver~action_args=updatereceivers_" + string2;
        Action action = new Action("updatereceivers", string2, "Receiver", string9);
        action.store();
        String string10 = string2 + ":storeaction:" + string9;
        new BroadcastMessage(string10).broadcast();
        string3 = "SUCCESS";
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void afterRemoveHost(String string) {
        Output.printTrace("TFAReceiverManager.afterRemoveHost(): Start", 3);
        String string2 = new Host().getHostname().trim();
        Output.printTrace("For each opp cluster,connect to one of the node and update RObjects", 3);
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        Object var5_5 = null;
        EntityCursor entityCursor = null;
        String string3 = null;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAReceiver.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            String string4 = null;
            for (TFAReceiver tFAReceiver : entityCursor) {
                string3 = tFAReceiver.getAttr("group").trim();
                if (string4 != null && string4.equals(string3)) continue;
                Output.printTrace("Send update request to the cluster " + string3, 3);
                Output.printTrace("Making Socket connection to :" + string3, 3);
                Properties.getInstance();
                String string5 = Properties.trustStore;
                Properties.getInstance();
                String string6 = Properties.trustStorePassword;
                sSLSocket = SocketManager.getSecureSocketConnection(string3.trim(), Global.getSocketPort(), string5, string6);
                if (null == sSLSocket) continue;
                printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                String string7 = string2 + ":updaternodes:" + string2 + "~" + string + ":ph";
                Output.printTrace("request1 = " + string7, 3);
                printWriter.println(string7);
                if (!sSLSocket.isClosed()) {
                    sSLSocket.close();
                }
                string4 = string3;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string3, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string3, 1);
            iOException.printStackTrace();
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
        Output.printTrace("TFAReceiverManager.afterRemoveHost(): End", 3);
    }

    public static String addReceiver(String string, String string2, int n, String string3) {
        String string4 = "FAILED";
        Socket socket = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        String string5 = null;
        String string6 = new Host().getHostname();
        string2 = string2.trim();
        Output.printTrace("TFAReceiverManager.addReceiver():[" + string6 + "] Start ", 3);
        TFAReceiver tFAReceiver = new TFAReceiver(string2, n, string3);
        try {
            Properties.getInstance();
            String string7 = Properties.trustStore;
            Properties.getInstance();
            String string8 = Properties.trustStorePassword;
            Output.printTrace("Making socket connection to R node " + string2 + " on port " + n, 1);
            socket = SocketManager.getAuthenticatedSocketConnectionR(string, string2, n, string3);
            if (socket == null) {
                Output.printTrace("Failed to get socket connection to " + string2, 1);
                string4 = "FAILED TO CONNECT SECURELY TO " + string2;
                return string4;
            }
            printWriter = new PrintWriter(socket.getOutputStream(), true);
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String string9 = "COLLECTOR";
            Output.printTrace("Sending request getTFARunMode to " + string2, 3);
            printWriter.println(string6 + ":getTFARunMode");
            while ((string5 = bufferedReader.readLine()) != null) {
                if (string5.contains("TFA_RUN_MODE")) {
                    string9 = string5.substring(string5.lastIndexOf(":") + 1);
                    continue;
                }
                if (!string5.equals("DONE")) continue;
            }
            Output.printTrace("Run mode of " + tFAReceiver + " is " + string9, 3);
            if (!string9.equals("RECEIVER")) {
                Output.printTrace("FAILED-TFA Should run in receiver mode in " + string2, 1);
                string4 = "FAILED - TFA Should run in receiver mode in " + string2;
                return string4;
            }
            Output.printTrace("Updating R Objects in current node from " + string2, 3);
            string4 = TFAReceiverManager.updateRNodes(string2, "php", false, n, string, string3);
            Output.printTrace("Status : " + string4, 3);
            Output.printTrace("Updating collectors in Receiver cluster", 3);
            String string10 = string6 + ":addcollectornode:" + string6;
            TFAHost.printAllToMHandler(printWriter, string10, string3);
            string10 = string6 + ":syncreceivernodes:" + string2;
            printWriter.println(string10);
            if (!socket.isClosed()) {
                socket.close();
            }
            Output.printTrace("Closed connect to receiver " + string2, 3);
            Output.printTrace("Updating R nodes in other nodes of CC", 3);
            TFAReceiverManager.syncRNodes(string6);
            string4 = "SUCCESS";
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about receiver:" + string2, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to: " + string2, 1);
            iOException.printStackTrace();
        }
        Output.printTrace("TFAReceiverManager.addReceiver():[" + string6 + "] End ", 3);
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeGroup_collector(String string, String string2) {
        String string3 = new Host().getHostname().trim();
        String string4 = "FAILED TO REMOVE COLLECTOR";
        Output.printTrace("TFAReceiverManager.removeGroup_collector():[" + string3 + "] Start", 3);
        Output.printTrace("Node of a cluster to remove : " + string, 3);
        EntityCursor entityCursor = null;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = "receiver";
        string8 = Properties.TFARunMode.toUpperCase();
        Object var11_10 = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object42;
            boolean bl = false;
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAReceiver.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            for (Object object42 : entityCursor) {
                string7 = ((TFAReceiver)object42).getAttr("receivername").trim();
                if (!string7.equalsIgnoreCase(string)) continue;
                object3 = ((TFAReceiver)object42).getAttr("group");
                if (object3 == null) {
                    bl = true;
                    string6 = string;
                    break;
                }
                string6 = ((TFAReceiver)object42).getAttr("group").trim();
                break;
            }
            try {
                entityCursor.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Output.printTrace("Group to remove: " + string6, 3);
            if (string2.equalsIgnoreCase(string3) && string8.equalsIgnoreCase("receiver") && !bl) {
                object2 = "tfar_" + string6.trim() + "_removecollector";
                object42 = string3 + "~action_name=" + (String)object2 + "~run_mode=Receiver~action_args=removecollector_" + string3;
                object3 = new Action((String)object2, string3, "Receiver", (String)object42);
                ((Action)object3).store();
                object = string3 + ":storeaction:" + (String)object42;
                new BroadcastMessage((String)object).broadcast();
                try {
                    Thread.sleep(45000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            entityCursor = primaryIndex.entities(null, cursorConfig);
            if (bl) {
                object2 = DbManager.getInstance().getEntityStore();
                object42 = new TFAReceiverDA((EntityStore)object2);
                RGlobal.collectorKeys.remove(string6);
                boolean bl2 = ((TFAReceiverDA)object42).pIdx.delete((Object)string6);
                if (!bl2) {
                    Output.printTrace("Not able to remove the node " + string6 + " from " + string3, 3);
                }
            } else {
                for (Object object42 : entityCursor) {
                    string7 = ((TFAReceiver)object42).getAttr("receivername").trim();
                    string5 = ((TFAReceiver)object42).getAttr("group").trim();
                    Output.printTrace("R Object Name :" + string7, 1);
                    if (!string5.equalsIgnoreCase(string6)) continue;
                    object3 = DbManager.getInstance().getEntityStore();
                    object = new TFAReceiverDA((EntityStore)object3);
                    Output.printTrace("Removing node: " + string7, 3);
                    RGlobal.collectorKeys.remove(string7);
                    Output.printTrace("Removing node from Hash: " + string7, 3);
                    boolean bl3 = ((TFAReceiverDA)object).pIdx.delete((Object)string7);
                    if (bl3) continue;
                    Output.printTrace("Not able to remove the node " + string7 + " from " + string3, 3);
                }
            }
            if (string2.equalsIgnoreCase(string3)) {
                object2 = string2 + ":removecollector:" + string6;
                new BroadcastMessage((String)object2).broadcast();
            }
            string4 = "SUCCESS";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
        Output.printTrace("TFAReceiverManager.removeGroup_collector():[" + string3 + "] End", 3);
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeGroup(String string, String string2) {
        String string3 = new Host().getHostname().trim();
        String string4 = "FAILED TO REMOVE RECEIVER";
        Output.printTrace("TFAReceiverManager.removeGroup():[" + string3 + "] Start", 3);
        Output.printTrace("Node of a cluster to remove : " + string, 3);
        EntityCursor entityCursor = null;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = "collector";
        string8 = Properties.TFARunMode.toUpperCase();
        String string9 = null;
        try {
            Object object;
            Object object2;
            if (string2.equalsIgnoreCase(string3) && string8.equalsIgnoreCase("collector")) {
                object2 = null;
                object = null;
                Output.printTrace("Making Socket connection to :" + string, 3);
                int n = Global.getPortMapping().get(string);
                object2 = SocketManager.getAuthenticatedSocketConnectionR(string, n, RGlobal.collectorKeys.get(string3));
                if (object2 == null) {
                    Output.printTrace("Failed to get secure socket connection to : " + string, 3);
                    String string10 = string9 = "FAILED TO CONNECT SECURELY TO " + string;
                    return string10;
                }
                object = new PrintWriter(((Socket)object2).getOutputStream(), true);
                ((PrintWriter)object).println(string + ":removereceiver:" + string3);
                if (!((Socket)object2).isClosed()) {
                    ((Socket)object2).close();
                }
            }
            object2 = DbManager.getInstance().getAllEntities(TFAReceiver.class);
            if (string2.equalsIgnoreCase(string3)) {
                entityCursor = object2.entities(null, cursorConfig);
                for (TFAReceiver tFAReceiver : entityCursor) {
                    string7 = tFAReceiver.getAttr("receivername").trim();
                    if (!string7.equalsIgnoreCase(string)) continue;
                    string6 = tFAReceiver.getAttr("group").trim();
                    break;
                }
            } else {
                string6 = string;
            }
            Output.printTrace("Group to remove: " + string6, 3);
            entityCursor = object2.entities(null, cursorConfig);
            for (TFAReceiver tFAReceiver : entityCursor) {
                string7 = tFAReceiver.getAttr("receivername").trim();
                string5 = tFAReceiver.getAttr("group").trim();
                Output.printTrace("R Object Name :" + string7, 3);
                if (!string5.equalsIgnoreCase(string6)) continue;
                EntityStore entityStore = DbManager.getInstance().getEntityStore();
                TFAReceiverDA tFAReceiverDA = new TFAReceiverDA(entityStore);
                Output.printTrace("Removing node: " + string7, 3);
                if (string8.equals("COLLECTOR")) {
                    RGlobal.collectorKeys.remove(string7);
                }
                Output.printTrace("Removing node from Hash: " + string7, 3);
                boolean bl = tFAReceiverDA.pIdx.delete((Object)string7);
                if (bl) continue;
                Output.printTrace("Not able to remove the node " + string7 + " from " + string3, 3);
            }
            if (string2.equalsIgnoreCase(string3)) {
                object = string2 + ":removereceiver:" + string6;
                new BroadcastMessage((String)object).broadcast();
            }
            string4 = "SUCCESS";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
        Output.printTrace("TFAReceiverManager.removeGroup():[" + string3 + "] End", 3);
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpReceivers() {
        EntityCursor entityCursor = null;
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAReceiver.class);
            entityCursor = primaryIndex.entities();
            for (TFAReceiver tFAReceiver : entityCursor) {
                Output.printTrace("Receiver: " + tFAReceiver.getAttr("username") + "@" + tFAReceiver.getAttr("receivername"), 3);
                Output.printTrace("  --> TFA Home: " + tFAReceiver.getAttr("tfahome"), 3);
                if (tFAReceiver.getAttr("pass") == null) {
                    Output.printTrace("  --> password *NOT* supplied", 3);
                    continue;
                }
                Output.printTrace("  --> password supplied", 3);
            }
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 6) {
            Output.printTrace("Not Enough Arguments", 1);
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        String string6 = stringArray[5];
        String string7 = new Host().getHostname().trim();
        Properties properties = Properties.getInstance(string);
        Output.printTrace("Flag: *" + string2 + "*", 3);
        if (!(string2.equals("-a") || string2.equals("-r") || string2.equals("-l"))) {
            Output.printTrace("you forgot the -a <add> or -r <remove> flag", 1);
            System.exit(1);
        }
        if (string2.equals("-a")) {
            TFAReceiverManager.dumpReceivers();
        } else if (string2.equals("-l")) {
            TFAReceiverManager.dumpReceivers();
        } else if (string2.equals("-r")) {
            TFAReceiverManager.removeGroup(string3, string7);
        }
    }

    public static void registerReceiver(Host host, String string) {
        DbGet dbGet = DbManager.getInstance().getDbGet();
        TFAReceiver tFAReceiver = dbGet.lookupReceiver(host.getHostname().trim());
        if (tFAReceiver == null) {
            tFAReceiver = new TFAReceiver(host.getHostname().trim(), "", "", string);
            DbManager.getInstance().getDbPut().storeTFAReceiverEntity(tFAReceiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReceiverRegistered() {
        EntityCursor entityCursor = null;
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAReceiver.class);
            entityCursor = primaryIndex.entities();
            Iterator iterator = entityCursor.iterator();
            if (iterator.hasNext()) {
                TFAReceiver tFAReceiver = (TFAReceiver)iterator.next();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static String updateRNodes(String string, String string2, boolean bl, int n, String string3, String string4) {
        String string5 = "FAILED";
        Socket socket = null;
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        String string6 = null;
        String string7 = null;
        boolean bl2 = true;
        String string8 = new Host().getHostname();
        TFAReceiver tFAReceiver = null;
        String string9 = null;
        String string10 = "COLLECTOR";
        string10 = Properties.TFARunMode.toUpperCase();
        string = string.trim();
        int n2 = 0;
        int n3 = -1;
        String string11 = null;
        Output.printTrace("Input:(source,action,port,hostkey)=(" + string + "," + string2 + "," + n + ",)", 3);
        try {
            String[] stringArray;
            String string12;
            Output.printTrace("Making a socket connection to: " + string, 3);
            if (!bl) {
                socket = string3 != null ? SocketManager.getAuthenticatedSocketConnectionR(string3, string, n, string4) : SocketManager.getAuthenticatedSocketConnectionR(string, n, string4);
                if (socket == null) {
                    Output.printTrace("Failed to get socket connection to : " + string, 1);
                    string5 = "FAILED TO CONNECT SECURELY TO " + string;
                    return string5;
                }
                printWriter = new PrintWriter(socket.getOutputStream(), true);
                bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            } else {
                Properties.getInstance();
                string12 = Properties.trustStore;
                Properties.getInstance();
                stringArray = Properties.trustStorePassword;
                sSLSocket = SocketManager.getSecureSocketConnection(string, Global.getSocketPort(), string12, (String)stringArray);
                if (sSLSocket == null) {
                    Output.printTrace("Failed to get secure socket connection to : " + string, 3);
                    string5 = "FAILED TO CONNECT SECURELY TO " + string;
                    return string5;
                }
                printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
            }
            string12 = null;
            string12 = string2.equals("pr") ? string8 + ":printrobjects:full" : (string2.equals("php") ? string8 + ":printhostsandport" : string8 + ":printhosts");
            Output.printTrace("Sending action " + string12 + " to " + string, 3);
            printWriter.println(string12);
            while ((string6 = bufferedReader.readLine()) != null) {
                if (string6.contains("Host Name") || string6.contains("Receiver Object")) {
                    string6 = string6.substring(string6.lastIndexOf(":") + 1);
                    string9 = string6.trim();
                    if (string2.equals("pr")) {
                        String[] stringArray2 = string9.split("~", -1);
                        for (int i = 1; i < stringArray2.length; ++i) {
                            if (stringArray2[i].split("=")[0].equals("group")) {
                                string7 = stringArray2[i].split("=")[1];
                                continue;
                            }
                            if (stringArray2[i].split("=")[0].equals("load")) {
                                n2 = new Integer(stringArray2[i].split("=")[1]);
                                continue;
                            }
                            if (stringArray2[i].split("=")[0].equals("port")) {
                                n3 = new Integer(stringArray2[i].split("=")[1]);
                                continue;
                            }
                            if (!stringArray2[i].split("=")[0].equals("hostkey")) continue;
                            string11 = stringArray2[i].split("=")[1];
                        }
                        if (string10.equals("COLLECTOR")) {
                            // empty if block
                        }
                        tFAReceiver = new TFAReceiver(stringArray2[0], string7, n2, n3, string11);
                    } else if (string2.equals("ph")) {
                        if (bl2) {
                            string7 = string9;
                            bl2 = false;
                        }
                        Output.printTrace("(source,port,objecttoadd)=(" + string + "," + n + "," + string9 + ")", 3);
                        tFAReceiver = n != -1 && string.equalsIgnoreCase(string9) ? new TFAReceiver(string9, string7, n, string4) : new TFAReceiver(string9, string7, string4);
                    } else if (string2.equals("php")) {
                        stringArray = string9.split(",");
                        if (bl2) {
                            string7 = stringArray[0].trim();
                            bl2 = false;
                        }
                        Output.printTrace("(source,port,objecttoadd)=(" + string + "," + n + "," + string9 + ")", 1);
                        tFAReceiver = new TFAReceiver(stringArray[0].trim(), string7, Integer.parseInt(stringArray[1].trim()), string4);
                    }
                    DbManager.getInstance().getDbPut().storeTFAReceiverEntity(tFAReceiver);
                }
                if (!string6.contentEquals("DONE")) continue;
                Output.printTrace("Received Done for the request", 3);
                break;
            }
            Output.printTrace("Successfully udpated R nodes in " + string8, 3);
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
            if (sSLSocket != null && !sSLSocket.isClosed()) {
                sSLSocket.close();
            }
            Output.printTrace("Loading ports and keys into memory", 1);
            TFAReceiver.loadRObjectsData("port");
            TFAReceiver.loadRObjectsData("hostkey");
            string5 = "SUCCESS";
            TFAReceiverManager.printForDebug();
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about receiver:" + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to: " + string, 1);
            iOException.printStackTrace();
        }
        return string5;
    }

    public static void addCollectorNode(String string) {
        String[] stringArray = string.split("~");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 1; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i].split("=")[0].trim(), stringArray[i].split("=")[1].trim());
        }
        String string2 = new Host().getHostname().trim();
        String string3 = (String)hashMap.get("node");
        TFAReceiver tFAReceiver = new TFAReceiver((String)hashMap.get("node"), (String)hashMap.get("group"), (String)hashMap.get("hostkey"));
        DbManager.getInstance().getDbPut().storeTFAReceiverEntity(tFAReceiver);
        RGlobal.collectorKeys.put((String)hashMap.get("node"), (String)hashMap.get("hostkey"));
    }

    public static void printForDebug() {
        Output.printTrace("Print RGlobal.collectorKeys data", 3);
        for (String string : RGlobal.collectorKeys.keySet()) {
            Output.printTrace("(key,value) = " + string, 3);
        }
        Output.printTrace("Port Mapping=" + Global.getPortMapping(), 3);
    }
}

