/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.util.Date;
import oracle.rat.tfa.PurgeTFACollections;
import oracle.rat.tfa.PurgeTFAMetadata;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.PurgeTFALogs;

public class TFAPurgeManager
extends Thread {
    private boolean stopThread = false;
    private Date lastRun = null;

    public void setLastRun(Date date) {
        this.lastRun = date;
    }

    public Date getLastRun() {
        return this.lastRun;
    }

    public void stopThread() {
        this.stopThread = true;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("TFAPurgeManager");
        Output.printTrace("Starting TFAPurgeManager...", 3);
        while (!this.stopThread) {
            try {
                Thread.sleep(60000L);
                new PurgeTFACollections().start();
                new PurgeTFALogs().start();
                if (this.lastRun == null) {
                    new PurgeTFAMetadata(0L).start();
                } else {
                    new PurgeTFAMetadata().start();
                }
                this.lastRun = new Date();
                Thread.sleep(Global.purgeFrequency * 60 * 60 * 1000);
            }
            catch (InterruptedException interruptedException) {
                Output.printTrace("InterruptedException in TFAPurgeManager", 3);
                this.stopThread = true;
            }
            catch (Exception exception) {
                Output.print("Exception in TFAPurgeManager : " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }
}

