/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import oracle.rat.tfa.BroadcastMessage;
import oracle.rat.tfa.TFAReceiverManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DataAccessor.TFAReceiverDA;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.TFAReceiver;
import oracle.rat.tfa.receiver.RGlobal;
import oracle.rat.tfa.receiver.TopicManager;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.tfar15.FileMonitor15;
import oracle.rat.tfa.util.ConfigManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;

public class TFAPollingThread
implements Runnable {
    public static boolean keeprunning = true;

    @Override
    public void run() {
        Output.printTrace("Started TFAPollingThread:", 1);
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        String string = new Host().getHostname().trim();
        Properties.getInstance();
        String string2 = Properties.trustStore;
        Properties.getInstance();
        String string3 = Properties.trustStorePassword;
        while (keeprunning) {
            Output.printTrace("Check TFAPollingThread:", 3);
            if (Global.master_node != null && Global.master_node.equals(string)) {
                Output.printTrace("Check TFAPollingThread ok:", 3);
                String string4 = this.getTask();
                if (!string4.equals("NONE")) {
                    this.process_action(string4);
                }
            }
            try {
                Thread.sleep(25000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTask() {
        Object var1_1 = null;
        int n = 9999;
        EntityCursor entityCursor = null;
        CursorConfig cursorConfig = new CursorConfig();
        String string = null;
        String string2 = null;
        int n2 = 0;
        int n3 = 0;
        String string3 = "NONE";
        String string4 = null;
        Output.printTrace("getTopic: Input group is " + string4, 3);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAReceiver.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            for (TFAReceiver tFAReceiver : entityCursor) {
                string = tFAReceiver.getAttr("receivername");
                string2 = tFAReceiver.getAttr("group");
                n2 = tFAReceiver.getAttrI("load");
                n3 = tFAReceiver.getAttrI("port");
                Output.printTrace("TopicManager: Load of " + string + " is " + n2, 3);
                if (n3 == -1 || string4 != null && !string4.equals(string2)) continue;
                string3 = TFAPollingThread.isTaskAvailable(string, n3);
                Output.printTrace("got task:" + string3 + " from node:" + string, 3);
                if (string3 == "NONE") continue;
                break;
            }
        }
        catch (Exception exception) {
            Output.printTrace("Exception in TopicManager.getTopic()", 3);
            exception.printStackTrace();
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {
                Output.printTrace("TopicManager: Exception while closing cursor", 1);
                exception.printStackTrace();
            }
        }
        Output.printTrace("TaskManager: task=" + string3, 3);
        return string3;
    }

    public static String isTaskAvailable(String string, int n) {
        String string2 = "NONE";
        Socket socket = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        String string3 = new Host().getHostname().trim();
        socket = SocketManager.getAuthenticatedSocketConnectionR(string, n, RGlobal.collectorKeys.get(string3));
        if (null == socket) {
            string2 = "NONE";
        } else {
            try {
                String string4;
                String string5 = string3 + ":getpollingthreadaction:" + string3;
                printWriter = new PrintWriter(socket.getOutputStream(), true);
                printWriter.println(string5);
                bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (string4.contentEquals("DONE")) {
                        Output.printTrace("Received Done for the request", 3);
                        break;
                    }
                    if (string4 != "NONE") {
                        Output.printTrace("setting retval:" + string4.trim(), 3);
                        string2 = string4.trim();
                        continue;
                    }
                    Output.printTrace("setting retval:NONE", 3);
                    string2 = "NONE";
                }
            }
            catch (Exception exception) {
                Output.print("Exception in isTaskAvailable" + exception.getMessage());
            }
        }
        try {
            if (!socket.isClosed()) {
                socket.close();
            }
        }
        catch (Exception exception) {
            Output.print(" Can not close socket " + exception.getMessage());
        }
        return string2;
    }

    public void process_action(String string) {
        String string2 = new Host().getHostname().trim();
        Output.printTrace("polling process_action:" + string, 1);
        if (string.contains("updatereceivers")) {
            String string3;
            Object object2;
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAReceiver.class);
            EntityCursor entityCursor = primaryIndex.entities(null, cursorConfig);
            EntityStore entityStore = DbManager.getInstance().getEntityStore();
            TFAReceiverDA tFAReceiverDA = new TFAReceiverDA(entityStore);
            for (Object object2 : entityCursor) {
                string3 = ((TFAReceiver)object2).getAttr("receivername");
                boolean bl = tFAReceiverDA.pIdx.delete((Object)string3);
            }
            String string4 = Properties.tfaHome;
            object2 = (String)string4 + File.separator + "internal" + File.separator + "rcollectorkey.store";
            if (RGlobal.mainReceiver == null) {
                TopicManager.get_mainreceiver();
            }
            string3 = RGlobal.mainReceiver;
            String string5 = this.getKey(string3, (String)object2);
            int n = Global.getPortMapping().get(string3);
            String string6 = new Host().getHostname();
            Output.printTrace("process_action:" + string6 + string3 + n + string5, 3);
            TFAReceiverManager.addReceiver(string6, string3, n, string5);
        } else if (string.contains("stopproducer")) {
            this.stopProducer();
            ConfigManager.set("r.send.data.realtime", "false", "BOOLEAN");
            String string7 = string2 + ":stopproducer:" + string2;
            new BroadcastMessage(string7).broadcast();
        } else if (string.contains("startmonitor")) {
            FileMonitor15.keeprunning = true;
            ConfigManager.set("r.send.data.realtime", "true", "BOOLEAN");
            this.startProducer();
            String string8 = string2 + ":startmonitor:" + string2;
            new BroadcastMessage(string8).broadcast();
        } else if (string.contains("removecollector")) {
            String[] stringArray = string.split("~");
            String string9 = stringArray[0].trim();
            this.stopProducer();
            ConfigManager.set("r.send.data.realtime", "false", "BOOLEAN");
            TFAReceiverManager.removeGroup_collector(string9, string2);
        } else if (string.contains("resetoosmonitor")) {
            Object var3_7 = null;
            Output.printTrace("actionArgs in resetoosmonitor: ", 3);
            ConfigManager.set("r.send.data.realtime", "true", "BOOLEAN");
            FileMonitor15.keeprunning = true;
            this.resetAndStartMonitor();
            String string10 = string2 + ":resetoosmonitor:" + string2;
            new BroadcastMessage(string10).broadcast();
        }
    }

    private String getKey(String string, String string2) {
        BufferedReader bufferedReader = null;
        String string3 = null;
        String string4 = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string2));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string3.startsWith(string)) continue;
                String[] stringArray = string3.split("=");
                string4 = stringArray[1];
                break;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Output.printTrace("MessageHandler : File " + string2 + " not found", 3);
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            Output.printTrace("MessageHandler : IOException in getKey call", 3);
            iOException.printStackTrace();
        }
        return string4;
    }

    private void stopProducer() {
        try {
            int n = RGlobal.activeThreads.size();
            Output.printTrace("No of activeThreads befroe stop=" + n, 3);
            Output.printTrace("stopping monitor", 3);
            FileMonitor15.monitor.stop();
            if (n > 0) {
                for (String string : RGlobal.activeThreads.keySet()) {
                    RGlobal.activeThreads.get(string).cancel();
                }
            }
            n = RGlobal.activeFAMThreads.size();
            Output.printTrace("No of activeFAMThreads before stop=" + n, 3);
            if (n > 0) {
                for (String string : RGlobal.activeFAMThreads.keySet()) {
                    Output.printTrace("(Key,Value)=" + string + "," + RGlobal.activeFAMThreads.get(string), 3);
                    RGlobal.activeFAMThreads.get(string).stop();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private void startProducer() {
        try {
            int n = RGlobal.activeThreads.size();
            Output.printTrace("In startProducer=" + n, 1);
            FileMonitor15.monitor.start();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private void resetAndStartMonitor() {
        String string = RGlobal.mainReceiver;
        boolean bl = false;
        int n = RGlobal.receiverPortForCollectors;
        String string2 = new Host().getHostname().trim();
        String string3 = RGlobal.collectorKeys.get(string2);
        FileMonitor15 fileMonitor15 = new FileMonitor15(string, n, string3, bl);
        Thread thread = new Thread(fileMonitor15);
        thread.start();
        try {
            Output.printTrace("In resetAndStartMonitor:start", 3);
            FileMonitor15.monitor.start();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        Output.printTrace("In resetAndStartMonitor:end", 3);
    }
}

