/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;
import org.apache.commons.io.FileUtils;

public class TFAMonitor
extends Thread {
    private boolean keeprunning = true;

    public void stopThread() {
        this.keeprunning = false;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("TFAMonitor");
        int n = 0;
        while (this.keeprunning) {
            try {
                Thread.sleep(30000L);
                n = !this.isCAListening() ? ++n : 0;
                if (n <= 3) continue;
                String string = Properties.tfaHome + File.separator + "internal" + File.separator + ".initRestartTFA";
                Output.printTrace("ConnectionAcceptor is not listening for commands", 1);
                Output.print("ConnectionAcceptor is not listening for commands");
                File file = new File(string);
                FileUtils.touch((File)file);
            }
            catch (InterruptedException interruptedException) {
                Output.printTrace("InterruptedException in TFAMonitor", 1);
                this.keeprunning = false;
            }
            catch (IOException iOException) {
                Output.print("I/O Exception in TFAMonitor: " + iOException.getMessage());
            }
            catch (Exception exception) {
                Output.print("Exception in TFAMonitor: " + exception.getMessage());
            }
        }
    }

    public boolean isCAListening() {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        String string = new Host().getHostname().trim();
        Properties.getInstance();
        String string2 = Properties.trustStore;
        Properties.getInstance();
        String string3 = Properties.trustStorePassword;
        boolean bl = false;
        try {
            String string4;
            String string5 = string + ":checkTFAMain";
            sSLSocket = SocketManager.getSecureSocketConnection(string, Global.getSocketPort(), string2, string3);
            if (sSLSocket == null) {
                Socket socket;
                try {
                    socket = new Socket(string, Global.getSocketPort());
                    if (!socket.isClosed()) {
                        socket.close();
                    }
                }
                catch (Exception exception) {
                    socket = null;
                }
                if (null == socket) {
                    Output.printTrace("Not able to create normal socket. Check interface", 1);
                    return true;
                }
                Output.printTrace("Not able to create SSL socket", 1);
                return false;
            }
            printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
            printWriter.println(string5);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
            while ((string4 = bufferedReader.readLine()) != null) {
                Output.printTrace("Server response - " + string4, 3);
                if (!string4.equals("CheckOK")) continue;
                bl = true;
            }
            printWriter.close();
            bufferedReader.close();
            if (!sSLSocket.isClosed()) {
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Unknown host - " + string, 1);
        }
        catch (Exception exception) {
            Output.printTrace("Exception Occurred", 1);
        }
        return bl;
    }
}

