/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Calendar;
import java.util.Date;
import oracle.rat.tfa.ActionHandler;
import oracle.rat.tfa.AddNodesThread;
import oracle.rat.tfa.CellDiscoveryThread;
import oracle.rat.tfa.ConnectionAcceptor;
import oracle.rat.tfa.DBGProfileAccessManager;
import oracle.rat.tfa.DiskUsageMonitor;
import oracle.rat.tfa.ExadataVMChecker;
import oracle.rat.tfa.InstanceMonitor;
import oracle.rat.tfa.ManageLogsAutoPurge;
import oracle.rat.tfa.NonRootConnectionAcceptor;
import oracle.rat.tfa.ODAChecker;
import oracle.rat.tfa.PeriodicChecker;
import oracle.rat.tfa.PrivateConnAcceptor;
import oracle.rat.tfa.RepositoryChecker;
import oracle.rat.tfa.SecureTFA;
import oracle.rat.tfa.TFAAccessManager;
import oracle.rat.tfa.TFADirectoryManager;
import oracle.rat.tfa.TFAHostManager;
import oracle.rat.tfa.TFAInventoryManager;
import oracle.rat.tfa.TFAMonitor;
import oracle.rat.tfa.TFAPurgeManager;
import oracle.rat.tfa.TFAScanningMainRT;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DataAccessor.InventoryRunDA;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.AdrIncident;
import oracle.rat.tfa.entity.AlertClusterEviction;
import oracle.rat.tfa.entity.AlertClusterReconfiguration;
import oracle.rat.tfa.entity.DatabaseGeneralError;
import oracle.rat.tfa.entity.DatabaseParameter;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.Generic;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.InstanceShutdown;
import oracle.rat.tfa.entity.InstanceStartup;
import oracle.rat.tfa.entity.InventoryRun;
import oracle.rat.tfa.entity.Profile;
import oracle.rat.tfa.nls.Omsg;
import oracle.rat.tfa.nls.Oprint;
import oracle.rat.tfa.receiver.RGlobal;
import oracle.rat.tfa.util.BogusException;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.TFASignalHandler;
import oracle.rat.tfa.util.Utilities;

public class TFAMain {
    private static File f;
    private static FileChannel channel;
    private static FileLock lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        String string;
        Thread thread;
        Thread thread2;
        Thread thread3;
        Thread thread4;
        Thread thread5;
        Thread thread6;
        Thread thread7;
        ManageLogsAutoPurge manageLogsAutoPurge;
        DiskUsageMonitor diskUsageMonitor;
        Thread thread8;
        TFAScanningMainRT tFAScanningMainRT;
        Thread thread9;
        Thread thread10;
        BufferedReader bufferedReader;
        block123: {
            Oprint oprint = new Oprint("en-US", "en", "UTF-8", "US");
            Omsg omsg = new Omsg("en-US", "en", "UTF-8", "US");
            try {
                Object object;
                Object object2;
                String string2 = "";
                string2 = stringArray.length == 0 ? "C:" + File.separator + "tfa_home" + File.separator : stringArray[0];
                Thread.currentThread().setName("TFAMain");
                f = new File(string2 + File.separator + "tfa.lock");
                if (f.exists()) {
                    f.delete();
                }
                if ((lock = (channel = new RandomAccessFile(f, "rw").getChannel()).tryLock()) == null) {
                    channel.close();
                    Output.printTrace("Only one instance of TFA can run!", 1);
                    throw new RuntimeException("Only one instance of TFA can run.");
                }
                Utilities utilities = new Utilities();
                Output output = new Output();
                Host host = new Host();
                bufferedReader = null;
                thread10 = null;
                thread9 = null;
                tFAScanningMainRT = null;
                thread8 = null;
                diskUsageMonitor = null;
                manageLogsAutoPurge = null;
                thread7 = null;
                thread6 = null;
                thread5 = null;
                thread4 = null;
                Object var20_19 = null;
                Global.pollingThread = null;
                thread3 = null;
                thread2 = null;
                thread = null;
                Properties properties = Properties.getInstance(string2);
                String string3 = null;
                try {
                    object2 = ManagementFactory.getRuntimeMXBean();
                    object = object2.getName();
                    LogFile.writeLog("JVM Name = " + (String)object);
                    string3 = String.valueOf(((String)object).split("@")[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                LogFile.writeLog("PID of TFAMain : " + string3);
                Output.print("PID of TFAMain : " + string3);
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2 + File.separator + "internal" + File.separator + ".pidfile"));
                    bufferedWriter.write(string3 + "\n");
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                LogFile.writeLog("TFAMain Version : " + Properties.tfaVersion);
                LogFile.writeLog("TFA Build ID : " + Properties.getTFABuildID());
                Output.print("TFA Version: " + Properties.tfaVersion);
                Output.print("TFA Build ID " + Properties.getTFABuildID());
                Output.print("OS Name " + Properties.platform);
                Output.print("OS Version " + System.getProperty("os.version"));
                Output.print("OS Architecture " + System.getProperty("os.arch"));
                Output.print("Java Version " + System.getProperty("java.version"));
                Output.print("Java Vendor " + System.getProperty("java.vendor"));
                Output.print("Java Home " + System.getProperty("java.home"));
                LogFile.writeLog("TFAMain: Starting : " + utilities.getDateTime());
                Output.printTrace("TFAMain: Starting : " + utilities.getDateTime(), 3);
                TFAHostManager.registerHost(host, string2);
                if (stringArray.length == 2) {
                    Output.printTrace("In the args 2 section", 3);
                    object2 = stringArray[1];
                    Output.printTrace("Dir File Full: " + (String)object2, 3);
                    properties.setTfaPropertiesFile((String)object2);
                    Output.printTrace("File List: " + Properties.scanFileListXml, 3);
                }
                if (stringArray.length == 3) {
                    Output.printTrace("In the args 3 section", 3);
                    object2 = stringArray[1];
                    Output.printTrace("Dir File Full: " + (String)object2, 3);
                    object = stringArray[2];
                    properties.setTfaPropertiesFile((String)object2);
                    Properties.setScanFileListXml((String)object);
                    Output.printTrace("File List: " + Properties.scanFileListXml, 3);
                }
                try {
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    bufferedReader = new BufferedReader(new FileReader(Properties.statusFileName));
                    bufferedReader.mark(1000);
                    string = bufferedReader.readLine();
                    string = string.trim();
                    if (string.equalsIgnoreCase("stop")) {
                        throw new BogusException();
                    }
                    bufferedReader.close();
                    TFASignalHandler.install("TERM");
                    TFASignalHandler.install("ALRM");
                    TFASignalHandler.install("INT");
                    Output.print("Starting the Connection Acceptor thread...");
                    thread10 = new Thread((Runnable)new ConnectionAcceptor(), "ConnAcceptor");
                    thread10.start();
                    Output.print("Starting the Non Root Connection Acceptor thread...");
                    thread9 = new Thread((Runnable)new NonRootConnectionAcceptor(), "NonRootConnAcceptor");
                    thread9.start();
                    Output.print("Starting the TFAMonitor thread...");
                    thread = new TFAMonitor();
                    thread.start();
                    RGlobal.tfaHome = Properties.tfaHome;
                    Output.print("Reading tfa_directories.txt...");
                    TFAMain.readDirectoriesFile();
                    Output.print("Done reading tfa_directories.txt in TFAMain");
                    object2 = new InventoryRunDA();
                    Output.printTrace("Checking if inventory run exists for this host already : " + ((InventoryRunDA)object2).pIdx.get((Object)host.getHostname()), 3);
                    InventoryRun inventoryRun = (InventoryRun)((InventoryRunDA)object2).pIdx.get((Object)host.getHostname());
                    if (inventoryRun == null) {
                        inventoryRun = new InventoryRun(host.getHostname());
                        Output.printTrace("Creating new Inventory Run Record for this host", 3);
                        Output.print("Creating new Inventory Run Record for this host");
                        Output.print("status of invRun object in TFAMain " + inventoryRun.getStatus());
                        inventoryRun.store();
                    } else {
                        Output.printTrace("Inventory Run already exists : " + inventoryRun.isRunning() + " " + inventoryRun.getStatus(), 3);
                        if (inventoryRun.isRunning()) {
                            Output.printTrace("Previously started Inventory Run is still RUNNING. Updating status as FAILED.", 2);
                            inventoryRun.setStatusFailed("INTERRUPTED");
                            inventoryRun.store();
                            Output.printTrace("After updation, status = " + inventoryRun.getStatus(), 3);
                        }
                    }
                    thread7 = new Thread((Runnable)new ActionHandler(), "ActionHandlerThread");
                    thread7.start();
                    thread5 = new RepositoryChecker();
                    thread5.start();
                    Global.setRepositoryCheckerThread((RepositoryChecker)thread5);
                    if (Properties.isExadata()) {
                        object = new Thread((Runnable)new CellDiscoveryThread(), "CellDiscoveryThread");
                        ((Thread)object).start();
                    }
                    if (!Properties.getInstance().getNodeType().equals("ODADom0") && !Properties.getInstance().getNodeType().equals("ExadataDom0")) {
                        thread6 = new PeriodicChecker();
                        thread6.start();
                        Global.setPeriodicCheckerThread((PeriodicChecker)thread6);
                        thread4 = new AddNodesThread();
                        thread4.setName("AddNodesThread");
                        thread4.start();
                        Global.setAddNodesThread((AddNodesThread)thread4);
                        Properties.getInstance();
                        if (!Properties.isSupportMode) {
                            if (Global.isRtScanOn()) {
                                thread8 = new InstanceMonitor();
                                thread8.start();
                                Output.printTrace("Starting RT Scanner in TFAMain", 3);
                                tFAScanningMainRT = new TFAScanningMainRT(stringArray);
                                tFAScanningMainRT.start();
                                Global.setRtScanThread(tFAScanningMainRT);
                                Global.setRtScanRunning(true);
                            }
                            if (Global.isDiskUsageMonOn()) {
                                diskUsageMonitor = new DiskUsageMonitor();
                                diskUsageMonitor.setName("DiskUsageMonitorThread");
                                diskUsageMonitor.start();
                                Global.setDiskUsageMonitor(diskUsageMonitor);
                                Global.setDiskUsageMonRunning(true);
                            }
                            if (Global.isManageLogsAutoPurgeOn()) {
                                manageLogsAutoPurge = new ManageLogsAutoPurge();
                                manageLogsAutoPurge.setName("ManageLogsAutoPurgeThread");
                                manageLogsAutoPurge.start();
                                Global.setManageLogsAutoPurge(manageLogsAutoPurge);
                                Global.setManageLogsAutoPurgeRunning(true);
                            }
                        }
                    }
                    if (Properties.getInstance().getNodeType().equals("ODADom0")) {
                        Output.print("Setting ODADom0");
                        object = new Thread((Runnable)new PrivateConnAcceptor(), "PrivateConnAcceptor");
                        ((Thread)object).start();
                    }
                    if (Properties.getInstance().getNodeType().equals("ODAVMGuest")) {
                        object = new Thread((Runnable)new ODAChecker(), "ODAChecker");
                        ((Thread)object).start();
                    }
                    if (Properties.getInstance().getNodeType().equals("ExadataDom0")) {
                        thread3 = new Thread((Runnable)new ExadataVMChecker(), "ExadataVMChecker");
                        thread3.start();
                    }
                    if ((object = Action.getIncompleteActions()).size() > 0) {
                        object6 = object.iterator();
                        while (object6.hasNext()) {
                            object5 = (Action)object6.next();
                            ((Action)object5).setActionStatus("REQUESTED");
                            ((Action)object5).store();
                        }
                    }
                    if (Global.invalidateBDB) {
                        object6 = FileEntity.deleteAllFileEntities();
                        if (((Boolean)object6).booleanValue()) {
                            object5 = new Action("runinventory", "localhost", "tfactl", "");
                            object4 = new TFAInventoryManager((Action)object5);
                            object3 = new Thread((Runnable)object4, "InventoryThread");
                            Global.inventoryManagerThread = object4;
                            Global.inventoryThread = object3;
                            Output.print("Inventory Thread starting on Host : " + new Host().getHostname());
                            ((Thread)object3).start();
                            InstanceStartup.deleteAllStartups();
                            InstanceShutdown.deleteAllShutdowns();
                            DatabaseParameter.deleteAllDatabaseParameters();
                            DatabaseGeneralError.deleteAllDatabaseErrors();
                            AlertClusterEviction.deleteAllClusterEvictions();
                            AlertClusterReconfiguration.deleteAllClusterReconfigurartions();
                            Generic.deleteAllGenerics();
                            AdrIncident.deleteAllADRIncidents();
                        }
                        Global.invalidateBDB = false;
                    }
                    thread2 = new TFAPurgeManager();
                    thread2.setName("TFAPurgeManager");
                    thread2.start();
                    object6 = Properties.tfaHome + File.separator + "server.jks";
                    object5 = new File((String)object6);
                    if (!((File)object5).exists()) {
                        Output.printTrace("Starting secureTFAThread", 3);
                        object4 = new SecureTFA();
                        Global.secureTFAThread = object4;
                        ((Thread)object4).start();
                    }
                    if (new File((String)(object4 = Properties.internalDir + File.separator + "ssl.properties")).exists()) {
                        TFAAccessManager.createKeysForUser();
                    }
                    object3 = DBGProfileAccessManager.getAllProfiles();
                    Calendar calendar = Calendar.getInstance();
                    String string4 = "";
                    String string5 = "";
                    if (new File(Properties.perlexe).exists()) {
                        string5 = Properties.perlexe;
                    }
                    for (int i = 0; i < object3.size(); ++i) {
                        Profile profile = (Profile)object3.get(i);
                        Output.printTrace(profile.getProfileName() + " " + profile.getTimeout(), 3);
                        if (profile.getInfiniteTimeoutFlag() == 0) {
                            calendar.setTime(new Date());
                            long l = profile.getTimeout().getTime();
                            l = (l - calendar.getTimeInMillis()) / 1000L;
                            if (l > 0L) {
                                string4 = string5 + " " + Properties.tfaHome + File.separator + "bin" + File.separator + "tfactl.pl dbglevel -set " + profile.getProfileName() + " -timeout " + l + "s";
                            } else {
                                DBGProfileAccessManager.removeTFAProfile(profile.getProfileName());
                            }
                        } else {
                            string4 = string5 + " " + Properties.tfaHome + File.separator + "bin" + File.separator + "tfactl.pl dbglevel -set " + profile.getProfileName();
                        }
                        Output.printTrace("FileHelper : Command : " + string4, 3);
                        try {
                            Output.printTrace("Setting the profile...", 3);
                            Runtime.getRuntime().exec(string4);
                            continue;
                        }
                        catch (Exception exception) {
                            Output.printTrace("Perl command run failed...", 3);
                        }
                    }
                    break block123;
                }
                catch (BogusException bogusException) {
                    Output.printTrace("Entered code with Stop flag set - exitting immediately", 2);
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    tFAScanningMainRT = Global.getRtScanThread();
                    if (tFAScanningMainRT != null && tFAScanningMainRT.isAlive()) {
                        Output.printTrace("Interrupting Scan Thread due to caught Exception in Main TFAMain Block", 2);
                        tFAScanningMainRT.stopRTScanner();
                        tFAScanningMainRT.interrupt();
                    }
                    if ((diskUsageMonitor = Global.getDiskUsageMonitor()) != null && diskUsageMonitor.isAlive()) {
                        Output.printTrace("Interrupting Disk Usage Monitor Thread due to caught Exception in Main TFAMain Block", 2);
                        diskUsageMonitor.interrupt();
                    }
                    if ((manageLogsAutoPurge = Global.getManageLogsAutoPurge()) != null && manageLogsAutoPurge.isAlive()) {
                        Output.printTrace("Interrupting Manage Logs Auto Purge Thread due to caught Exception in Main TFAMain Block", 2);
                        manageLogsAutoPurge.interrupt();
                    }
                    if (thread8 != null && thread8.isAlive()) {
                        Output.printTrace("Interrupting Instance Thread due to caught Exception in Main TFAMain Block", 2);
                        thread8.interrupt();
                    }
                    if (thread7 != null && thread7.isAlive()) {
                        Output.printTrace("Interrupting Action Handler Thread due to caught Exception in Main TFAMain Block", 2);
                        thread7.interrupt();
                    }
                    if (thread6 != null && thread6.isAlive()) {
                        Output.printTrace("Interrupting Periodic Checker Thread due to caught Exception in Main TFAMain Block", 2);
                        thread6.interrupt();
                    }
                    if (thread5 != null && thread5.isAlive()) {
                        Output.printTrace("Interrupting Repository Checker due to caught Exception in Main TFAMain Block", 2);
                        thread5.interrupt();
                    }
                    if (thread4 != null && thread4.isAlive()) {
                        Output.printTrace("Interrupting Add Node Thread due to caught Exception in Main TFAMain Block", 2);
                        thread4.interrupt();
                    }
                    if (thread2 != null && thread2.isAlive()) {
                        Output.printTrace("Interrupting Purge Manager Thread due to caught Exception in Main TFAMain Block", 2);
                        thread2.interrupt();
                    }
                    if (thread3 != null && thread3.isAlive()) {
                        Output.printTrace("Interrupting Exa-VM Checker Thread due to caught Exception in Main TFAMain Block", 2);
                        thread3.interrupt();
                    }
                    if ((object = Global.secureTFAThread) != null && ((Thread)object).isAlive()) {
                        Output.printTrace("Interrupting SecureTFA Thread due to caught Exception in Main TFAMain Block", 2);
                        ((Thread)object).interrupt();
                    }
                    if (thread9 != null && thread9.isAlive()) {
                        Output.printTrace("Interrupting Non Root Connection Acceptor Thread due to caught Exception in Main TFAMain Block", 2);
                        thread9.interrupt();
                    }
                    if (thread != null && thread.isAlive()) {
                        Output.printTrace("Interrupting Monitor Thread due to caught Exception in Main TFAMain Block", 2);
                        thread.interrupt();
                    }
                    if (thread10 != null && thread10.isAlive()) {
                        Output.printTrace("Interrupting ConnAccept Thread due to caught Exception in Main TFAMain Block", 2);
                        thread10.interrupt();
                    }
                    if (Global.pollingThread == null) return;
                    if (!Global.pollingThread.isAlive()) return;
                    Output.printTrace("Interrupting pollingThread Thread due to caught Exception in Main TFAMain Block", 2);
                    Global.pollingThread.interrupt();
                    return;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        while (true) {
            bufferedReader = new BufferedReader(new FileReader(Properties.statusFileName));
            string = bufferedReader.readLine();
            bufferedReader.close();
            string = string.trim();
            if (string.equalsIgnoreCase("stop")) {
                SecureTFA secureTFA;
                Output.printTrace("Shutting down TFAMain and all TFA threads...", 1);
                Output.print("Shutting down TFAMain and all TFA threads...");
                Action.setActionsInterrupted();
                tFAScanningMainRT = Global.getRtScanThread();
                if (tFAScanningMainRT != null && tFAScanningMainRT.isAlive()) {
                    Output.printTrace("Interrupting scanThread from TFAMain", 3);
                    tFAScanningMainRT.stopRTScanner();
                    tFAScanningMainRT.interrupt();
                }
                if (thread8 != null && thread8.isAlive()) {
                    Output.printTrace("Interrupting instanceMonitor from TFAMain", 3);
                    ((InstanceMonitor)thread8).stopInstanceMonitor();
                    thread8.interrupt();
                }
                if ((diskUsageMonitor = Global.getDiskUsageMonitor()) != null && diskUsageMonitor.isAlive()) {
                    Output.printTrace("Interrupting diskUsageMonitor from TFAMain", 3);
                    diskUsageMonitor.interrupt();
                }
                if ((manageLogsAutoPurge = Global.getManageLogsAutoPurge()) != null && manageLogsAutoPurge.isAlive()) {
                    Output.printTrace("Interrupting manageLogsAutoPurge from TFAMain", 3);
                    manageLogsAutoPurge.interrupt();
                }
                if (thread7 != null && thread7.isAlive()) {
                    Output.printTrace("Interrupting ActionHandlerThread from TFAMain", 3);
                    thread7.interrupt();
                }
                if (Properties.TFARunMode.equals("Collector") && Global.pollingThread != null && Global.pollingThread.isAlive()) {
                    Output.printTrace("Interrupting pollingThread Thread from TFAMain", 3);
                    Global.pollingThread.interrupt();
                }
                if (thread5 != null && thread5.isAlive()) {
                    Output.printTrace("Stopping Repository Checker from TFAMain", 3);
                    ((RepositoryChecker)thread5).stopRepositoryThread();
                    thread5.interrupt();
                }
                if (thread6 != null && thread6.isAlive()) {
                    Output.printTrace("Stopping Periodic Checker from TFAMain", 3);
                    ((PeriodicChecker)thread6).stopPeriodicChecker();
                    thread6.interrupt();
                }
                if (thread4 != null && thread4.isAlive()) {
                    Output.printTrace("Interrupting Add Nodes Thread from TFAMain", 3);
                    thread4.interrupt();
                }
                if (thread3 != null && thread3.isAlive()) {
                    Output.printTrace("Interrupting Exa-VM Checker Thread from TFAMain", 3);
                    thread3.interrupt();
                }
                if (thread2 != null && thread2.isAlive()) {
                    Output.printTrace("Stopping TFAPurge Manager Thread from TFAMain", 3);
                    ((TFAPurgeManager)thread2).stopThread();
                    thread2.interrupt();
                }
                if ((secureTFA = Global.secureTFAThread) != null && secureTFA.isAlive()) {
                    Output.printTrace("Stopping SecureTFA Thread from TFAMain", 2);
                    secureTFA.stopThread();
                    secureTFA.interrupt();
                }
                if (thread9 != null && thread9.isAlive()) {
                    Output.printTrace("Interrupting NonRoot Connection Acceptor Thread from TFAMain", 3);
                    thread9.interrupt();
                }
                try {
                    while (tFAScanningMainRT != null && tFAScanningMainRT.isAlive() || thread7 != null && thread7.isAlive() || thread6 != null && thread6.isAlive() || thread5 != null && thread5.isAlive() || thread4 != null && thread4.isAlive()) {
                        if (tFAScanningMainRT != null && tFAScanningMainRT.isAlive()) {
                            Output.printTrace("Scan Thread still running", 3);
                            tFAScanningMainRT.interrupt();
                        }
                        if (thread7 != null && thread7.isAlive()) {
                            Output.printTrace("Action Handler Thread still running", 3);
                            thread7.interrupt();
                        }
                        if (thread6 != null && thread6.isAlive()) {
                            Output.printTrace("Periodic Checker Thread still running", 3);
                            thread6.interrupt();
                        }
                        if (thread5 != null && thread5.isAlive()) {
                            Output.printTrace("Repository Checker Thread still running", 3);
                            thread5.interrupt();
                        }
                        if (thread4 != null && thread4.isAlive()) {
                            Output.printTrace("Add Nodes Thread still running", 3);
                            thread4.interrupt();
                        }
                        Thread.sleep(1000L);
                    }
                    if (thread9 != null && thread9.isAlive()) {
                        Output.printTrace("Interrupting Non Root Connection Acceptor Thread from TFAMain", 3);
                        thread9.interrupt();
                    }
                    while (thread9 != null && thread9.isAlive()) {
                        if (thread9 != null && thread9.isAlive()) {
                            Output.printTrace("Interrupting Non Root Connection Acceptor Thread from TFAMain", 3);
                            thread9.interrupt();
                        }
                        Thread.sleep(500L);
                    }
                    if (thread != null && thread.isAlive()) {
                        Output.printTrace("Interrupting Monitor Thread from TFAMain", 3);
                        thread.interrupt();
                    }
                    if (thread10 != null && thread10.isAlive()) {
                        Output.printTrace("Interrupting Connection Acceptor Thread from TFAMain", 3);
                        thread10.interrupt();
                    }
                    while (thread10 != null) {
                        if (!thread10.isAlive()) return;
                        if (thread10 != null && thread10.isAlive()) {
                            Output.printTrace("Interrupting Connection Acceptor Thread from TFAMain", 3);
                            thread10.interrupt();
                        }
                        Thread.sleep(500L);
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            Thread.sleep(2000L);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Output.printTrace("failed to close inputstream", 2);
                }
            }
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(Properties.statusFileName));
                bufferedWriter.write("stopped");
                bufferedWriter.newLine();
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            LogFile.writeLog("TFAMain: Completed : " + utilities.getDateTime());
            Output.printTrace("TFAMain: Completed : " + utilities.getDateTime(), 3);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            finally {
                TFAMain.unlockFile();
            }
        }
    }

    private static void readDirectoriesFile() {
        try {
            String string;
            Output.printTrace("Reading File: " + Properties.tfaDirectoriesFile, 3);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(Properties.tfaDirectoriesFile));
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.contains("DIAGDEST")) continue;
                TFADirectoryManager.addFromFileLine(string);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void unlockFile() {
        try {
            if (lock != null) {
                lock.release();
                channel.close();
                f.delete();
                lock = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            TFAMain.unlockFile();
        }
    }
}

