/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.TFAHost;
import oracle.rat.tfa.nls.Omsg;
import oracle.rat.tfa.nls.Oprint;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;

public class TFALogManager {
    public static boolean updateTFALogSize(long l) {
        boolean bl = false;
        try {
            FileInputStream fileInputStream = new FileInputStream(Properties.configPropertiesFile);
            java.util.Properties properties = new java.util.Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            properties.setProperty("maxLogSize", "" + l / 0x100000L);
            FileOutputStream fileOutputStream = new FileOutputStream(Properties.configPropertiesFile);
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
            bl = true;
        }
        catch (IOException iOException) {
            Output.print("MessageHandler : IOException while updating config file: " + iOException.getMessage());
        }
        catch (Exception exception) {
            Output.print("MessageHandler : Exception while updating config file " + exception.getMessage());
        }
        return bl;
    }

    public static boolean updateTFALogCount(int n) {
        boolean bl = false;
        try {
            FileInputStream fileInputStream = new FileInputStream(Properties.configPropertiesFile);
            java.util.Properties properties = new java.util.Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            properties.setProperty("maxLogCount", "" + n);
            FileOutputStream fileOutputStream = new FileOutputStream(Properties.configPropertiesFile);
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
            bl = true;
        }
        catch (IOException iOException) {
            Output.print("MessageHandler : IOException while updating config file: " + iOException.getMessage());
        }
        catch (Exception exception) {
            Output.print("MessageHandler : Exception while updating config file " + exception.getMessage());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performActionsInRemoteNodes(String string, PrintWriter printWriter, String string2, String string3, String string4) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string5 = null;
        String string6 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        String string7 = Properties.trustStore;
        String string8 = Properties.trustStorePassword;
        Oprint oprint = new Oprint("en-US", "en", "UTF-8", "US");
        Omsg omsg = new Omsg("en-US", "en", "UTF-8", "US");
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(String.class, TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            String string9 = string6 + ":" + string2.trim() + ":" + string;
            for (TFAHost tFAHost : entityCursor) {
                String string10;
                string5 = tFAHost.getHostname();
                if (string5.equalsIgnoreCase(string6)) continue;
                Output.printTrace("Making Socket connection to :" + string5, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string5.trim(), Global.getSocketPort(), string7, string8);
                if (sSLSocket == null) {
                    oprint.print("TFA11681", string5);
                    continue;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string9);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string10 = bufferedReader.readLine()) != null) {
                    if (!string10.equals("DONE") && !string10.startsWith(string3.trim()) && !string10.startsWith(string4.trim())) continue;
                    Output.printTrace("TFALogManager: Status from " + string5 + " : " + string10, 3);
                    break;
                }
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("TFALogManager : Don't know about host: " + string5, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("TFALogManager : Couldn't get I/O for the connection to Host : " + string5, 1);
            Output.print("TFALogManager : IOException in performActionsInRemoteNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {
                Output.print("TFALogManager : Exception while closing the cursor in performActionsInRemoteNodes");
            }
        }
    }
}

