/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import oracle.rat.tfa.db.DataAccessor.TFAIpsDA;
import oracle.rat.tfa.entity.TFAIps;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;

public class TFAIpsManager {
    private static boolean addTFAIps(TFAIps tFAIps) {
        return new TFAIpsDA().pIdx.putNoOverwrite((Object)tFAIps);
    }

    public static boolean addTFAIps(String string, Date date, String string2) {
        boolean bl = false;
        TFAIps tFAIps = new TFAIps(string, date, string2);
        Output.print("collection id: " + string);
        Output.print("cmdArgs: " + string2);
        try {
            if (TFAIpsManager.addTFAIps(tFAIps)) {
                LogFile.writeLog("TFAIpsManager: Added " + tFAIps.getCollectionId());
                bl = true;
            }
        }
        catch (Exception exception) {
            Output.print("TFAIpsManager: Unable to add " + tFAIps.getCollectionId() + " to TFAIps");
            Output.print("Exception: " + exception.getMessage());
        }
        return bl;
    }

    private static boolean removeTFAIps(TFAIps tFAIps) {
        return new TFAIpsDA().pIdx.delete((Object)tFAIps.getCollectionId());
    }

    public static String resumeTFAIps(String string) {
        Object var1_1 = null;
        TFAIps tFAIps = TFAIpsManager.getTFAIps(string);
        return tFAIps.getCmdArgs();
    }

    public static boolean removeTFAIps(String string) {
        boolean bl = false;
        TFAIps tFAIps = TFAIpsManager.getTFAIps(string);
        if (tFAIps != null) {
            bl = TFAIpsManager.removeTFAIps(tFAIps);
            LogFile.writeLog("TFAIpsManager: Removed " + tFAIps.getCollectionId());
        }
        return bl;
    }

    private static TFAIps getTFAIps(String string) {
        return (TFAIps)new TFAIpsDA().pIdx.get((Object)string);
    }

    public static List<TFAIps> getAllTFAIps() {
        ArrayList<TFAIps> arrayList = new ArrayList<TFAIps>();
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(String.class, TFAIps.class);
            EntityCursor entityCursor = primaryIndex.entities();
            for (TFAIps tFAIps : entityCursor) {
                arrayList.add(tFAIps);
            }
            entityCursor.close();
        }
        catch (Exception exception) {
            Output.print("TFAIpsManager: Exception in getAllTFAIps " + exception.getMessage());
            exception.printStackTrace();
        }
        return arrayList;
    }
}

