/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityIndex;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.TFADirectoryManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DataAccessor.FileEntityDA;
import oracle.rat.tfa.db.DataAccessor.InventoryRunDA;
import oracle.rat.tfa.db.DataAccessor.ScanFileEntityDA;
import oracle.rat.tfa.db.DataAccessor.TFADirectoryDA;
import oracle.rat.tfa.db.DbPut;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.ComponentEntity;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.InventoryRun;
import oracle.rat.tfa.entity.ScanFileEntity;
import oracle.rat.tfa.entity.TFADirectory;
import oracle.rat.tfa.entity.TFAHost;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.singletons.DirectoryMappings;
import oracle.rat.tfa.singletons.IgnoreExtensions;
import oracle.rat.tfa.singletons.IgnoreFilesList;
import oracle.rat.tfa.singletons.MatchFileTypes;
import oracle.rat.tfa.singletons.SpecialFilePatterns;
import oracle.rat.tfa.type.DirectoryMappingType;
import oracle.rat.tfa.type.FileType;
import oracle.rat.tfa.util.FileHelper;
import oracle.rat.tfa.util.FileList;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.RegexFilter;
import oracle.rat.tfa.util.SocketManager;
import oracle.rat.tfa.util.StringUtil;
import oracle.rat.tfa.util.Utilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class TFAInventoryManager
implements Runnable {
    private Action callingAction = null;
    private Set<String> dirList = null;
    public volatile boolean keeprunning = true;
    private boolean isNewAlertLog = false;
    private String tracefac = "INVENTORY";
    public static LinkedBlockingQueue<DumpInventoryXMLThread> dumpXmlQueue = new LinkedBlockingQueue(2);
    public static final long MINUTE_MILLIS = 60000L;
    private LinkedBlockingQueue<String> queue = new LinkedBlockingQueue();
    int thread_pool_size = Global.getThreadPoolSizeForInventory();
    int numWorkers = 0;
    int count = 0;
    int numProcessedDirs = 0;

    public TFAInventoryManager() {
    }

    public TFAInventoryManager(Action action) {
        this.callingAction = action;
    }

    public TFAInventoryManager(Action action, Set<String> set) {
        this.callingAction = action;
        this.dirList = set;
    }

    private static String getDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    private static String getFileType(String string) {
        int n;
        String string2 = null;
        Vector<FileType> vector = MatchFileTypes.getInstance().getFileTypes();
        Vector<FileType> vector2 = new Vector<FileType>();
        Vector<FileType> vector3 = new Vector<FileType>();
        for (FileType object : vector) {
            if (object.getName().contains("- ASM")) {
                vector2.add(object);
                continue;
            }
            vector3.add(object);
        }
        for (FileType fileType : vector2) {
            int n2 = fileType.getNumberNamePatterns();
            if (n2 <= 0 || (n = fileType.checkNamePatterns(string)) == 0) continue;
            string2 = fileType.getName();
            return string2;
        }
        for (FileType fileType : vector3) {
            boolean bl;
            n = fileType.getNumberNamePatterns();
            if (n <= 0 || !(bl = fileType.checkNamePatterns(string))) continue;
            string2 = fileType.getName();
            return string2;
        }
        return string2;
    }

    private void processDir(String string) {
        boolean bl = true;
        long l = System.currentTimeMillis();
        Vector<FileType> vector = MatchFileTypes.getInstance().getFileTypes();
        HashMap<String, FileType> hashMap = new HashMap<String, FileType>();
        for (FileType fileType : vector) {
            hashMap.put(fileType.getName(), fileType);
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return true;
            }
        };
        long l2 = System.currentTimeMillis();
        Collection<File> collection = FileList.listFiles(new File(string), filenameFilter, true);
        long l3 = System.currentTimeMillis();
        Output.print("Time taken to list files in milliseconds : " + (l3 - l2) + " for : " + string);
        Output.printTrace("Got list of files to process : " + collection.size(), this.tracefac, 3);
        DbPut dbPut = DbManager.getInstance().getDbPut();
        FileEntity fileEntity = null;
        for (File file : collection) {
            long l4 = System.currentTimeMillis();
            fileEntity = (FileEntity)new FileEntityDA().pIdx.get((Object)file.getAbsolutePath());
            long l5 = System.currentTimeMillis();
            Output.print("Time taken to look up entity in milliseconds : " + (l5 - l4) + " for : " + file.getAbsolutePath());
            if (Thread.currentThread().isInterrupted()) {
                Output.printTrace("InventoryThread interrupted while iterating files.", 1);
                return;
            }
            if (fileEntity == null) {
                Output.printTrace("Adding new file to TFA: " + file.getAbsolutePath(), this.tracefac, 3);
                fileEntity = new FileEntity(file);
            } else {
                Output.printTrace("Updating file in TFA: " + file.getAbsolutePath(), this.tracefac, 3);
                fileEntity.updateFromFile(file);
            }
            long l6 = System.currentTimeMillis();
            if (fileEntity.getType() == null) {
                fileEntity.setFileType();
            }
            long l7 = System.currentTimeMillis();
            Output.print("Time taken to set file type in milliseconds : " + (l7 - l6) + " for : " + file.getAbsolutePath());
            if (fileEntity.getType() != null && bl) {
                Properties.getInstance();
                if (Properties.samplingEnabled) {
                    boolean bl2 = false;
                    FileType fileType = (FileType)hashMap.get(fileEntity.getType());
                    if (fileType.getInventoryAction() != null && fileType.getInventoryAction().equalsIgnoreCase("SAMPLE")) {
                        bl2 = true;
                    }
                    try {
                        fileEntity.setNumberOfLines(FileList.countLines(file.getPath()));
                    }
                    catch (IOException iOException) {
                        Output.printTrace("Cannot count lines for file " + file.getPath(), 1);
                        iOException.printStackTrace();
                    }
                    boolean bl3 = TFAInventoryManager.isSpecialFile(fileEntity.getFileName());
                    if (bl2 && !bl3) {
                        Output.printTrace("Sampling file : " + fileEntity.getFileName(), this.tracefac, 3);
                        long l8 = System.currentTimeMillis();
                        fileEntity.lookForFirstTimestamp(false);
                        long l9 = System.currentTimeMillis();
                        Output.printTrace("Done looking for first timestamp : " + fileEntity.getFirstTime(), this.tracefac, 3);
                        if (fileEntity.getFirstTime() == null && fileEntity.getDatePattern() != null) {
                            LogFile.writeLog("Could not find first time stamp for " + fileEntity.getFileName() + " with date pattern : " + fileEntity.getDatePattern());
                            fileEntity.lookForFirstTimestamp(true);
                        }
                        if (fileEntity.getFirstTime() != null) {
                            Output.printTrace("Started looking for lastTimestamp : " + System.currentTimeMillis() / 1000L, this.tracefac, 3);
                            long l10 = System.currentTimeMillis();
                            fileEntity.setLastTimestamp(false);
                            long l11 = System.currentTimeMillis();
                            Output.printTrace("Done looking for lastTimestamp : " + fileEntity.getLastTime() + " " + System.currentTimeMillis() / 1000L, this.tracefac, 3);
                            if (fileEntity.getLastTime() == null && fileEntity.getDatePattern() != null) {
                                LogFile.writeLog("Could not find last time stamp for " + fileEntity.getFileName() + " with date pattern : " + fileEntity.getDatePattern());
                                fileEntity.setLastTimestamp(true);
                            }
                            LogFile.writeLog("Time taken to get firstTimestamp in milliseconds : " + (l9 - l8) + " Time taken to get lastTimestamp in milliseconds : " + (l11 - l10) + " for file : " + fileEntity.getFileName());
                        } else {
                            LogFile.writeLog("Could not find first time stamp for " + fileEntity.getFileName() + " after bruteforce");
                        }
                    }
                    if (bl3) {
                        String string2 = fileEntity.getFileName();
                        Output.printTrace("Found special file : " + string2, this.tracefac, 3);
                        try {
                            String string3 = string2.substring(string2.lastIndexOf("_") + 1, string2.lastIndexOf(".dat"));
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy.MM.dd.HHmm");
                            Date date = null;
                            try {
                                date = simpleDateFormat.parse(string3);
                            }
                            catch (ParseException parseException) {
                                parseException.printStackTrace();
                            }
                            fileEntity.setFirstTimestamp(date);
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(date);
                            calendar.add(11, 1);
                            fileEntity.setLastTimestamp(calendar.getTime());
                            Output.printTrace("First timestamp : " + fileEntity.getFirstTime(), this.tracefac, 3);
                            Output.printTrace("Last timestamp : " + fileEntity.getLastTime(), this.tracefac, 3);
                        }
                        catch (Exception exception) {
                            Output.printTrace("Exception in getting dates from special file: " + string2, this.tracefac, 3);
                        }
                    }
                    Output.printTrace("Storing Entity: " + fileEntity.getFileName(), this.tracefac, 3);
                }
            }
            long l12 = System.currentTimeMillis();
            dbPut.storeFileEntity(fileEntity);
            long l13 = System.currentTimeMillis();
            Output.printTrace("Time taken to store file entity in milliseconds : " + (l13 - l12) + " for : " + file.getAbsolutePath(), this.tracefac, 3);
            long l14 = System.currentTimeMillis();
            Output.printTrace("Time taken to process entity in milliseconds : " + (l14 - l4) + " for : " + file.getAbsolutePath(), this.tracefac, 3);
        }
        long l15 = System.currentTimeMillis();
        Output.printTrace("Time taken to process directory in seconds : " + (l15 - l) / 1000L + " for : " + string, this.tracefac, 3);
    }

    /*
     * WARNING - void declaration
     */
    private void processDirectory(String string, IOFileFilter iOFileFilter, Boolean bl) throws ThreadInterruptedException {
        long l = System.currentTimeMillis();
        boolean bl2 = true;
        Vector<FileType> vector = MatchFileTypes.getInstance().getFileTypes();
        HashMap<String, FileType> hashMap = new HashMap<String, FileType>();
        for (FileType object2 : vector) {
            hashMap.put(object2.getName(), object2);
        }
        if (!this.keeprunning) {
            Output.printTrace("keeprunning is false, return from processDirectory", this.tracefac, 3);
            return;
        }
        DbPut dbPut = DbManager.getInstance().getDbPut();
        Object var10_10 = null;
        ScanFileEntity scanFileEntity = null;
        try {
            long l2 = System.currentTimeMillis();
            Iterator iterator = FileUtils.iterateFiles((File)new File(string), (IOFileFilter)iOFileFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
            long l3 = System.currentTimeMillis();
            Output.printTrace("Time taken to get list of files in milliseconds : " + (l3 - l2) + " for : " + string, 3);
            while (iterator.hasNext()) {
                void var10_14;
                File file = (File)iterator.next();
                boolean bl3 = false;
                if (!this.keeprunning) {
                    Output.printTrace("keeprunning is false, return from processDirectory", this.tracefac, 3);
                    return;
                }
                if (file.getName().matches("core_.*_stack")) {
                    Output.printTrace("Ignoring TFA Stack File : " + file.getAbsolutePath(), this.tracefac, 3);
                    continue;
                }
                Output.printTrace("Looking up file in BDb : " + file.getAbsolutePath(), this.tracefac, 3);
                long l4 = System.currentTimeMillis();
                FileEntity fileEntity = (FileEntity)new FileEntityDA().pIdx.get((Object)file.getAbsolutePath());
                long l5 = System.currentTimeMillis();
                Output.printTrace("Time taken to look up file in bdb in milliseconds : " + (l5 - l4) + " for : " + file.getAbsolutePath(), this.tracefac, 4);
                ScanFileEntityDA scanFileEntityDA = new ScanFileEntityDA();
                if (fileEntity != null) {
                    if (fileEntity.getFileSize() == 0L) continue;
                    if (fileEntity.isRealTimeTail().booleanValue() && (scanFileEntity = (ScanFileEntity)scanFileEntityDA.pIdx.get((Object)fileEntity.getFileName())) == null) {
                        scanFileEntity = new ScanFileEntity(fileEntity.getFileName());
                        scanFileEntity.store(scanFileEntityDA);
                        this.isNewAlertLog = true;
                    }
                    if (fileEntity.getType() != null) {
                        FileType fileType = (FileType)hashMap.get(fileEntity.getType());
                        if (fileType != null) {
                            fileEntity.setUseDfOnly(fileType.isUseDfOnly());
                            fileEntity.setKeepHeaderLines(fileType.getKeepHeaderLines());
                            Output.printTrace("Set New Attributes : " + fileEntity.getFileName() + " use_df_only: " + fileEntity.isUseDfOnly() + " keep_header_lines: " + fileEntity.getKeepHeaderLines(), this.tracefac, 3);
                            if (fileEntity.getDatePattern() != null && fileType.getDatePatterns().size() > 0 && !fileType.getDatePatterns().contains(fileEntity.getDatePattern())) {
                                Output.printTrace("Old datepattern : " + fileEntity.getFileName() + fileEntity.getDatePattern(), this.tracefac, 3);
                                fileEntity.setDatePattern(null);
                                Output.printTrace("Set New datepattern : " + fileEntity.getFileName() + null, this.tracefac, 3);
                            }
                        }
                    } else {
                        fileEntity.setComponent("NULL");
                    }
                    Output.printTrace("Updating file in TFA: " + file.getAbsolutePath(), this.tracefac, 3);
                    fileEntity.updateFromFile(file);
                }
                long l6 = System.currentTimeMillis();
                boolean bl4 = false;
                if (fileEntity == null) {
                    block41: {
                        if (!file.exists() || file.length() == 0L) continue;
                        if (file.getName().endsWith(".trc.gz") || file.getName().endsWith(".evtx")) {
                            bl4 = true;
                        } else if (!(file.getName().endsWith(".trc") || file.getName().endsWith(".log") || file.getName().endsWith(".trm") || file.getName().endsWith(".trw"))) {
                            try {
                                if (FileHelper.isAsciiText(file.getAbsolutePath())) break block41;
                                if (!bl.booleanValue()) continue;
                                LogFile.writeLog("This file failed ASCII test : " + file.getAbsolutePath() + " but will be inventoried because the collection policy" + " of its parent directory is set to noexclusions");
                                bl4 = true;
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                continue;
                            }
                        }
                    }
                    Output.printTrace("Adding new file to TFA: " + file.getAbsolutePath(), this.tracefac, 3);
                    FileEntity fileEntity2 = new FileEntity(file);
                    bl3 = true;
                }
                if (Thread.currentThread().isInterrupted()) {
                    Output.printTrace("InventoryThread interrupted while iterating files.", 1);
                    return;
                }
                long l7 = System.currentTimeMillis();
                if (var10_14.getType() == null) {
                    var10_14.setFileType();
                }
                long l8 = System.currentTimeMillis();
                Output.printTrace("Time taken to set file type in milliseconds : " + (l8 - l7) + " for : " + file.getAbsolutePath(), this.tracefac, 4);
                Output.printTrace("Done Setting file type for entry : " + file.getAbsolutePath(), this.tracefac, 3);
                boolean bl5 = true;
                if (var10_14.getType() != null && bl2) {
                    String string2;
                    Properties.getInstance();
                    if (Properties.samplingEnabled) {
                        boolean bl6 = false;
                        FileType fileType = (FileType)hashMap.get(var10_14.getType());
                        if (fileType != null && fileType.getInventoryAction() != null && fileType.getInventoryAction().equalsIgnoreCase("SAMPLE")) {
                            bl6 = true;
                        }
                        try {
                            if (!bl4) {
                                int n = var10_14.getNumberOfLines();
                                if (n == 0) {
                                    n = FileList.countLines(file.getPath());
                                    var10_14.setNumberOfLines(n);
                                }
                                if (n == -1) {
                                    LogFile.writeLog("File " + var10_14.getFileName() + " is not fit for sampling");
                                    bl5 = false;
                                }
                            }
                        }
                        catch (IOException iOException) {
                            Output.printTrace("Cannot count lines for file " + file.getPath(), 1);
                            iOException.printStackTrace();
                        }
                        if (bl6 && bl5 && !bl4) {
                            Output.printTrace("Sampling file : " + var10_14.getFileName(), this.tracefac, 3);
                            long l9 = System.currentTimeMillis();
                            var10_14.lookForFirstTimestamp(false);
                            long l10 = System.currentTimeMillis();
                            Output.printTrace("Done looking for first timestamp : " + var10_14.getFirstTime(), this.tracefac, 3);
                            if (var10_14.getFirstTime() == null && var10_14.getDatePattern() != null && !var10_14.isUseDfOnly()) {
                                LogFile.writeLog("Could not find first time stamp for " + var10_14.getFileName() + " with date pattern : " + var10_14.getDatePattern());
                                var10_14.lookForFirstTimestamp(true);
                            }
                            if (var10_14.getFirstTime() == null && var10_14.isUseDfOnly() && var10_14.getDatePattern() != null) {
                                LogFile.writeLog("Could not find first time stamp for " + var10_14.getFileName() + " with date pattern : " + var10_14.getDatePattern() + "in file_type_patterns");
                                LogFile.writeLog("use_df_only is set to true and hence will not set first time stamp");
                            }
                            if (var10_14.getFirstTime() != null) {
                                Output.printTrace("Started looking for lastTimestamp : " + System.currentTimeMillis() / 1000L, this.tracefac, 3);
                                long l11 = System.currentTimeMillis();
                                var10_14.setLastTimestamp(false);
                                long l12 = System.currentTimeMillis();
                                Output.printTrace("Done looking for lastTimestamp : " + var10_14.getLastTime() + " " + System.currentTimeMillis() / 1000L, this.tracefac, 3);
                                if (var10_14.getLastTime() == null && var10_14.getDatePattern() != null && !var10_14.isUseDfOnly()) {
                                    LogFile.writeLog("Could not find last time stamp for " + var10_14.getFileName() + " with date pattern : " + var10_14.getDatePattern());
                                    var10_14.setLastTimestamp(true);
                                }
                                Output.printTrace("Time taken to get firstTimestamp in milliseconds : " + (l10 - l9) + " Time taken to get lastTimestamp in milliseconds : " + (l12 - l11) + " for file : " + var10_14.getFileName(), this.tracefac, 4);
                            } else {
                                LogFile.writeLog("Could not find first time stamp for " + var10_14.getFileName() + " after bruteforce");
                            }
                            if (var10_14.getLastTime() == null && var10_14.isUseDfOnly() && var10_14.getDatePattern() != null) {
                                LogFile.writeLog("Could not find last time stamp for " + var10_14.getFileName() + " with date pattern : " + var10_14.getDatePattern() + "in file_type_patterns");
                                LogFile.writeLog("use_df_only is set to true and hence will not set last time stamp");
                            }
                        }
                    }
                    if (bl3 && var10_14.getComponent() != null && ((string2 = var10_14.getComponent()).equalsIgnoreCase("RDBMS") || string2.equalsIgnoreCase("ASM") || string2.equalsIgnoreCase("ASMPROXY") || string2.equalsIgnoreCase("CRS"))) {
                        var10_14.setIsCore();
                    }
                    Output.printTrace("Storing Entity: " + var10_14.getFileName(), this.tracefac, 3);
                }
                long l13 = System.currentTimeMillis();
                if (var10_14.getBaseDirectory() != null) {
                    dbPut.storeFileEntity((FileEntity)var10_14);
                    if (var10_14.isRealTimeTail().booleanValue() && (scanFileEntity = (ScanFileEntity)scanFileEntityDA.pIdx.get((Object)var10_14.getFileName())) == null) {
                        scanFileEntity = new ScanFileEntity(var10_14.getFileName());
                        scanFileEntity.store(scanFileEntityDA);
                        this.isNewAlertLog = true;
                    }
                } else {
                    LogFile.writeLog("Directory Mapping is null for file: " + var10_14.getFileName() + ". Not adding to TFA");
                }
                long l14 = System.currentTimeMillis();
                Output.printTrace("Time taken to store file entity in BDb in milliseconds : " + (l14 - l13) + " for : " + var10_14.getFileName(), this.tracefac, 4);
            }
            this.processSpecialFiles(string);
            long l15 = System.currentTimeMillis();
            Output.printTrace("Time taken to process directory in seconds : " + (l15 - l) / 1000L + " for : " + string, this.tracefac, 4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Output.printTrace("Caught Exception " + illegalArgumentException.getMessage() + " in processing directory : " + string, this.tracefac, 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void processDirectoriesInParallel(String string) {
        Object object;
        ++this.numWorkers;
        ++this.count;
        if (this.numWorkers <= this.thread_pool_size) {
            object = new DirectoryProcessorThread("Thr " + this.count, string);
            ((Thread)object).start();
            Output.print("Started new directory processor thread : " + this.numWorkers);
        }
        if (this.numWorkers == this.thread_pool_size) {
            Output.print("Limit reached, waiting for threads to be free... " + Calendar.getInstance().getTime());
            object = null;
            do {
                try {
                    object = this.queue.poll(1L, TimeUnit.SECONDS);
                    Output.print("Output from queue : " + (String)object);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } while (object == null);
            --this.numWorkers;
        }
    }

    private void processDirectoryFilesInParallel(TFADirectory tFADirectory, long l) throws FileNotFoundException, IOException, InterruptedException {
        Vector<FileType> vector = MatchFileTypes.getInstance().getFileTypes();
        HashMap<String, FileType> hashMap = new HashMap<String, FileType>();
        for (FileType object2 : vector) {
            hashMap.put(object2.getName(), object2);
        }
        DbPut dbPut = DbManager.getInstance().getDbPut();
        String string = tFADirectory.getDirectoryPath();
        if (Global.offlineMode.booleanValue()) {
            Output.print("Creating filelist for " + string);
        }
        long l2 = System.currentTimeMillis();
        File file = FileList.createFileList(string, l);
        long l3 = System.currentTimeMillis();
        Output.printTrace("Length of the FileList : " + file.length(), this.tracefac, 3);
        if (Global.offlineMode.booleanValue()) {
            Output.print("Time taken in seconds to create filelist for : " + string + " is : " + (l3 - l2) / 1000L);
        }
        boolean bl = false;
        if (tFADirectory.collectionPolicy != null && tFADirectory.collectionPolicy.equals("noexclusions")) {
            LogFile.writeLog("Not performing ignoreFiles and ignoreExtensions checks on this directory : " + string + " because its collection policy is set to : " + tFADirectory.collectionPolicy);
            bl = true;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            Object object;
            boolean bl2 = false;
            List<String> list = tFADirectory.getInvPatterns();
            if (list != null) {
                Output.printTrace("Size of dirInvPatterns : " + list.size(), this.tracefac, 3);
            } else {
                Output.printTrace("dirInvPatterns is null", this.tracefac, 3);
            }
            if (list != null && list.size() > 0) {
                object = new Pattern[list.size()];
                int n = 2;
                int n2 = 0;
                for (String string3 : list) {
                    object[n2++] = Pattern.compile(string3, n);
                }
                String string4 = string2.trim();
                for (Pattern pattern : object) {
                    if (!pattern.matcher(string4).matches()) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
            }
            ++this.numWorkers;
            ++this.count;
            if (this.numWorkers <= this.thread_pool_size) {
                Output.printTrace("Started new FileProcessorThread : " + string2, 4);
                object = new FileProcessorThread("Thr " + this.count, string2, hashMap, dbPut, bl);
                ((Thread)object).start();
            }
            if (this.numWorkers != this.thread_pool_size) continue;
            Output.printTrace("Limit reached for files, waiting for threads to be free... ", this.tracefac, 4);
            object = null;
            do {
                object = this.queue.poll(1L, TimeUnit.SECONDS);
                Output.printTrace("Output from queueForFiles : " + (String)object, this.tracefac, 4);
            } while (object == null);
            --this.numWorkers;
        }
        Output.printTrace("numWorkers : " + this.numWorkers + " count : " + this.count, this.tracefac, 3);
        while (this.numWorkers > 0) {
            String string5 = null;
            do {
                string5 = this.queue.poll(1L, TimeUnit.SECONDS);
                Output.printTrace("Output from queueForFiles : " + string5, this.tracefac, 4);
            } while (string5 == null);
            --this.numWorkers;
        }
        bufferedReader.close();
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRemote(String string) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        String string2 = null;
        String string3 = new Host().getHostname();
        EntityCursor entityCursor = null;
        String string4 = null;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            string2 = string3 + ":runinventory:" + string;
            for (TFAHost tFAHost : entityCursor) {
                string4 = tFAHost.getHostname();
                Output.printTrace("I AM : " + string3 + "TFAHOST is : " + string4, this.tracefac, 3);
                if (!string4.equalsIgnoreCase(string3)) {
                    Output.printTrace("Making Socket connection to :" + string4, this.tracefac, 3);
                    Properties.getInstance();
                    String string5 = Properties.trustStore;
                    Properties.getInstance();
                    String string6 = Properties.trustStorePassword;
                    sSLSocket = SocketManager.getSecureSocketConnection(string4.trim(), Global.getSocketPort(), string5, string6);
                    if (sSLSocket == null) continue;
                    printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                    printWriter.println(string2);
                    if (sSLSocket.isClosed()) continue;
                    sSLSocket.close();
                    continue;
                }
                Output.printTrace("Not sending Zip Request to myself - I am : " + tFAHost.getHostname(), this.tracefac, 3);
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string4, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string4, 1);
            iOException.printStackTrace();
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        Object object;
        Object object2;
        boolean bl = false;
        long l = System.currentTimeMillis() / 1000L;
        Properties.getInstance();
        String string = Properties.getSrOrBugNum();
        String string2 = this.callingAction.getActionRequestArgs();
        LogFile.writeLog("arguments in TFAInventoryManager:" + string2);
        List<Object> list = new ArrayList();
        if (string2 != null) {
            if ((string2 = string2.trim()).startsWith("-c:")) {
                string2 = string2.replace("-c:", "");
                LogFile.writeLog("Call to runRemote with arguments = " + string2);
                this.runRemote(string2);
            }
            if (string2.equals("-c")) {
                string2 = string2.replace("-c", "");
                LogFile.writeLog("Call to runRemote with arguments = " + string2);
                this.runRemote(string2);
            }
            if (string2.startsWith("<components>")) {
                list = StringUtil.parseXmlString(string2);
            }
        }
        LogFile.writeLog("components in TFAInventoryManager : " + list);
        Host host = new Host();
        InventoryRunDA inventoryRunDA = new InventoryRunDA();
        InventoryRun inventoryRun = (InventoryRun)inventoryRunDA.pIdx.get((Object)host.getHostname());
        boolean bl2 = false;
        if (inventoryRun == null) {
            Output.printTrace("Creating new inventory Run Object", this.tracefac, 3);
            inventoryRun = new InventoryRun(host.getHostname());
            inventoryRun.store();
        } else if (inventoryRun.isRunning()) {
            LogFile.writeLog("Inventory is already running with arguments : " + inventoryRun.getArguments());
            LogFile.writeLog("Current Inventory request arguments : " + string2);
            boolean bl3 = false;
            boolean bl4 = false;
            if (inventoryRun.getArguments() == null || inventoryRun.getArguments().trim().equals("")) {
                bl4 = true;
            }
            if (string2 == null || string2.trim().equals("")) {
                bl3 = true;
            }
            if (bl4 && bl3) {
                LogFile.writeLog("Duplicate Inventory run");
                this.callingAction.setActionFailed("Duplicate run");
                this.callingAction.store();
                return;
            }
            if (bl4 && !bl3) {
                LogFile.writeLog("Interrupting Previous Inventory");
                inventoryRun.setStatusFailed("INTERRUPTED");
                inventoryRun.store();
                Output.printTrace("Calling interrupt on Inventory Thread", this.tracefac, 3);
                if (Global.inventoryManagerThread != null) {
                    Output.printTrace("inventoryManagerThread Args: " + Global.inventoryManagerThread.callingAction.getActionRequestArgs(), this.tracefac, 3);
                    Global.inventoryManagerThread.keeprunning = false;
                    Global.inventoryManagerThread.callingAction.setActionFailed("Interrupted");
                    Global.inventoryManagerThread.callingAction.store();
                    Global.inventoryManagerThread = null;
                    inventoryRun.setStatusFailed("INTERRUPTED");
                    inventoryRun.store();
                    Global.inventoryAborted = true;
                    try {
                        Global.inventoryThread.join();
                    }
                    catch (Exception exception) {
                        Output.printTrace("Calling interrupt on Thread exception : ", this.tracefac, 3);
                        exception.printStackTrace();
                    }
                    Global.inventoryThread = null;
                }
            } else {
                LogFile.writeLog("Waiting for previous inventory to complete ");
                while (inventoryRun.getStatus().equalsIgnoreCase("RUNNING")) {
                    try {
                        Thread.sleep(5000L);
                        inventoryRun = (InventoryRun)inventoryRunDA.pIdx.get((Object)new Host().getHostname());
                    }
                    catch (InterruptedException interruptedException) {
                        Output.printTrace("DiagCollection : InterruptedException in sleep thread while waiting to check invrun status", this.tracefac, 3);
                    }
                }
                Output.printTrace("Out of while loop, run inventory completed...", this.tracefac, 3);
                if (this.dirList == null && !inventoryRun.getArguments().equals("dirSpecific")) {
                    Output.printTrace("Current Inventory Arguments changed to" + string2, 3);
                    list = StringUtil.parseXmlString(string2);
                    bl2 = true;
                }
            }
        }
        if (bl2 && string2.equals("")) {
            this.callingAction.setActionFailed("Duplicate run");
            this.callingAction.store();
            return;
        }
        Output.printTrace("Updating inventory Run Object to RUNNING ", this.tracefac, 3);
        inventoryRun.setStatus("RUNNING");
        inventoryRun.setArguments(string2);
        inventoryRun.store();
        this.callingAction.setActionStatus("RUNNING");
        this.callingAction.store();
        try {
            boolean bl5;
            String string3;
            Object object3;
            Properties.getInstance();
            if (Properties.isSupportMode() && string == null) {
                throw new Exception("You must supply an SR Number when you're in Support Mode");
            }
            object2 = DbManager.getInstance().getDbPut();
            object = DbManager.getInstance().getEntityStore();
            TFADirectoryDA tFADirectoryDA = new TFADirectoryDA((EntityStore)object);
            if (this.dirList != null) {
                object3 = this.dirList.iterator();
                while (object3.hasNext()) {
                    string3 = (String)object3.next();
                    if (!this.keeprunning) {
                        Output.printTrace("keeprunning is false, exit from run()", this.tracefac, 3);
                        return;
                    }
                    this.inventoryByDirectory(string3, false);
                }
            } else {
                block88: {
                    object3 = "";
                    string3 = null;
                    try {
                        Vector vector;
                        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFADirectory.class);
                        HashSet<Object> hashSet = new HashSet<Object>();
                        if (list.size() != 0) {
                            vector = DbManager.getInstance().getEntityStore().getSecondaryIndex(primaryIndex, String.class, "components");
                            for (ComponentEntity objectArray22 : list) {
                                String string4 = objectArray22.getComponent();
                                EntityIndex entityIndex = vector.subIndex(string4.toUpperCase());
                                string3 = entityIndex.entities();
                                Iterator iterator = string3.iterator();
                                while (iterator.hasNext()) {
                                    Map<String, String> map;
                                    Map<String, String> map2;
                                    TFADirectory tFADirectory = (TFADirectory)iterator.next();
                                    boolean bl3 = true;
                                    if (hashSet.contains(tFADirectory)) {
                                        bl3 = false;
                                    }
                                    if ((map2 = objectArray22.getSubComponents()) != null && map2.size() > 0 && bl3 && (map = tFADirectory.getSubComponentByComponent(string4)) != null && map.size() > 0) {
                                        for (Map.Entry<String, String> entry : map.entrySet()) {
                                            String string5 = entry.getKey();
                                            String string6 = entry.getValue();
                                            if (string5.equals("database") && !map2.containsKey("instance")) {
                                                if (!map2.containsKey(string5) || !map2.get(string5).equalsIgnoreCase(string6)) continue;
                                                bl3 = true;
                                                break;
                                            }
                                            if (map2.containsKey(string5) && map2.get(string5).equalsIgnoreCase(string6)) continue;
                                            bl3 = false;
                                        }
                                    }
                                    if (!bl3) continue;
                                    hashSet.add(tFADirectory);
                                }
                                string3.close();
                            }
                            List<TFADirectory> list2 = new ArrayList(hashSet);
                            Collections.sort(list2);
                            Object[] objectArray3 = list2.toArray();
                            list2 = this.removeSubDirectories(objectArray3, list2);
                            for (TFADirectory tFADirectory : list2) {
                                object3 = tFADirectory.getDirectoryPath();
                                if (!new File((String)object3).exists()) {
                                    String string7 = TFADirectoryManager.removeDirectory((String)object3, null, true);
                                    Output.printTrace("Deleting directory " + (String)object3 + " from TFA. " + string7, this.tracefac, 3);
                                    continue;
                                }
                                LogFile.writeLog("Directory to process: " + (String)object3 + " with component : " + tFADirectory.getComponents() + " lastInventory : " + tFADirectory.lastInventoryTime);
                                if (!this.keeprunning) {
                                    Output.printTrace("keeprunning is false, exit from run()", this.tracefac, 3);
                                    return;
                                }
                                if (Thread.currentThread().isInterrupted()) {
                                    Output.printTrace("InventoryThread received an interrupt signal.", 2);
                                    this.keeprunning = false;
                                    break block88;
                                }
                                try {
                                    if (Global.offlineMode.booleanValue() && !Properties.getInstance().getNodeType().equals("CELL")) {
                                        this.processDirectoryFilesInParallel(tFADirectory, 0L);
                                    } else {
                                        long l2 = FileList.countFilesInDirectory(tFADirectory.getDirectoryPath());
                                        if (l2 > Global.getFileCountInventorySwitch()) {
                                            Date date = tFADirectory.getLastInventoryTime();
                                            long l3 = 43200L;
                                            if (date != null && (l3 = Calendar.getInstance().getTimeInMillis() / 60000L - date.getTime() / 60000L) > 43200L) {
                                                l3 = 43200L;
                                            }
                                            LogFile.writeLog("Process directory files in parallel for " + l2 + " files");
                                            LogFile.writeLog("FileCount limit to switch Inventory: " + Global.getFileCountInventorySwitch());
                                            LogFile.writeLog("Thread Pool Size: " + this.thread_pool_size);
                                            this.processDirectoryFilesInParallel(tFADirectory, l3);
                                        } else {
                                            this.filterAndProcess(tFADirectory);
                                        }
                                    }
                                    tFADirectory.setLastInventoryTime();
                                    ((DbPut)object2).storeTFADirectoryEntity(tFADirectory);
                                }
                                catch (ThreadInterruptedException threadInterruptedException) {
                                    Output.printTrace("InventoryThread received ThreadInterruptException while trying to process directory.", 2);
                                    this.keeprunning = false;
                                    threadInterruptedException.printStackTrace();
                                    if (string3 != null) {
                                        string3.close();
                                    }
                                    return;
                                }
                            }
                            break block88;
                        }
                        vector = DirectoryMappings.getInstance().getDirectories();
                        for (DirectoryMappingType directoryMappingType : vector) {
                            TFADirectory tFADirectory = (TFADirectory)tFADirectoryDA.pIdx.get((Object)directoryMappingType.directoryPath);
                            List<String> list2 = tFADirectory.getComponents();
                            if (list2 == null || list2.size() == 0) {
                                void var22_41;
                                Output.printTrace("Component is null for " + tFADirectory.getDirectoryPath(), 3);
                                Map<String, String> map = TFADirectoryManager.getDirectoryMapping(tFADirectory.getDirectoryPath());
                                HashMap<String, String> hashMap = new HashMap<String, String>();
                                for (String string8 : map.keySet()) {
                                    int n;
                                    String[] stringArray;
                                    if (string8.startsWith("comps")) {
                                        ArrayList<String> arrayList = new ArrayList<String>();
                                        if (map.get(string8).contains(Properties.TFAARGSEP)) {
                                            String[] stringArray2 = stringArray = map.get(string8).split(Properties.TFAARGSEP);
                                            n = stringArray2.length;
                                            for (int i = 0; i < n; ++i) {
                                                String string9 = stringArray2[i];
                                                arrayList.add(string9.trim());
                                            }
                                        } else {
                                            arrayList.add(map.get(string8).trim());
                                        }
                                    }
                                    if (string8.startsWith("component") && map.get(string8).contains("%")) {
                                        stringArray = map.get(string8).split("%");
                                        String string10 = stringArray[0].trim();
                                        if (stringArray.length > 1) {
                                            for (n = 1; n < stringArray.length; ++n) {
                                                String[] stringArray3 = stringArray[n].trim().split("\\|");
                                                if (stringArray3 == null || stringArray3.length != 2) continue;
                                                hashMap.put(string10 + "|" + stringArray3[0], stringArray3[1]);
                                            }
                                        }
                                    }
                                    if (!string8.startsWith("collectall")) continue;
                                    tFADirectory.setCollectAll(true);
                                    tFADirectory.setCollectionPolicy("collectall");
                                }
                                tFADirectory.setComponents((List<String>)var22_41);
                                if (hashMap.size() > 0) {
                                    tFADirectory.setSubcomponents(hashMap);
                                }
                                ((DbPut)object2).storeTFADirectoryEntity(tFADirectory);
                                Output.printTrace("Updated directory : " + tFADirectory.getDirectoryPath(), 3);
                                Output.printTrace("Database : " + tFADirectory.database + " Instance : " + tFADirectory.instance + " component : " + var22_41 + " subcomponent : " + hashMap + " permission : " + tFADirectory.permission + " owner : " + tFADirectory.owner, 3);
                            }
                            hashSet.add(tFADirectory);
                        }
                        List<TFADirectory> list3 = new ArrayList(hashSet);
                        Collections.sort(list3);
                        Object[] objectArray = list3.toArray();
                        list3 = this.removeSubDirectories(objectArray, list3);
                        for (TFADirectory tFADirectory : list3) {
                            object3 = tFADirectory.getDirectoryPath();
                            if (!new File((String)object3).exists()) {
                                String string11 = TFADirectoryManager.removeDirectory((String)object3, null, true);
                                Output.printTrace("Deleting directory " + (String)object3 + " from TFA. " + string11, this.tracefac, 3);
                                continue;
                            }
                            LogFile.writeLog("Directory to process: " + (String)object3 + " with component : " + tFADirectory.getComponents() + " lastInventory : " + tFADirectory.lastInventoryTime);
                            if (!this.keeprunning) {
                                Output.printTrace("keeprunning is false, exit from run()", this.tracefac, 3);
                                return;
                            }
                            if (Thread.currentThread().isInterrupted()) {
                                Output.printTrace("InventoryThread received an interrupt signal.", 2);
                                this.keeprunning = false;
                                break;
                            }
                            try {
                                if (Global.offlineMode.booleanValue() && !Properties.getInstance().getNodeType().equals("CELL")) {
                                    this.processDirectoryFilesInParallel(tFADirectory, 0L);
                                } else {
                                    long l4 = FileList.countFilesInDirectory(tFADirectory.getDirectoryPath());
                                    if (l4 > Global.getFileCountInventorySwitch()) {
                                        Date date = tFADirectory.getLastInventoryTime();
                                        long l5 = 43200L;
                                        if (date != null && (l5 = Calendar.getInstance().getTimeInMillis() / 60000L - date.getTime() / 60000L) > 43200L) {
                                            l5 = 43200L;
                                        }
                                        LogFile.writeLog("Process directory files in parallel for " + l4 + " files");
                                        LogFile.writeLog("FileCount limit to switch Inventory: " + Global.getFileCountInventorySwitch());
                                        LogFile.writeLog("Thread Pool Size: " + this.thread_pool_size);
                                        this.processDirectoryFilesInParallel(tFADirectory, l5);
                                    } else {
                                        this.filterAndProcess(tFADirectory);
                                    }
                                }
                                tFADirectory.setLastInventoryTime();
                                ((DbPut)object2).storeTFADirectoryEntity(tFADirectory);
                            }
                            catch (ThreadInterruptedException threadInterruptedException) {
                                Output.printTrace("InventoryThread received ThreadInterruptException while trying to process directory.", 2);
                                this.keeprunning = false;
                                threadInterruptedException.printStackTrace();
                                if (string3 != null) {
                                    string3.close();
                                }
                                return;
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        if (string3 != null) {
                            string3.close();
                        }
                    }
                }
                if (!this.keeprunning) {
                    Output.printTrace("keeprunning is false, exit from run()2", this.tracefac, 3);
                    return;
                }
            }
            if (bl5 = dumpXmlQueue.offer((DumpInventoryXMLThread)(object3 = new DumpInventoryXMLThread()))) {
                ((Thread)object3).start();
            }
            if (Global.offlineMode.booleanValue()) {
                Output.print("Dumping files to Oracle DB");
                Properties.getInstance();
                if (Properties.getEnvironment().length() != 0) {
                    long l6 = System.currentTimeMillis();
                    FileEntity.dumpFilestoOracle();
                    long l7 = System.currentTimeMillis();
                    Output.print("Time taken in seconds to dump files to Oracle DB : " + (l7 - l6) / 1000L);
                }
            }
        }
        catch (ThreadInterruptedException threadInterruptedException) {
            Output.printTrace("InventoryThread received ThreadInterruptException.", 2);
            threadInterruptedException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.callingAction.setActionFailed("Exception occurred");
            this.callingAction.store();
            inventoryRun.setStatusFailed("EXCEPTION");
            inventoryRun.store();
            return;
        }
        try {
            Output.printTrace("Complete.. Updating inventory Run Object to NOTRUNNING . and Action to COMPLETED", this.tracefac, 3);
            this.callingAction.setActionComplete();
            this.callingAction.store();
            inventoryRun.setStatusComplete();
            inventoryRun.store();
            object2 = this.callingAction.getActionRequestClient();
            if (!this.keeprunning) {
                Output.printTrace("keeprunning is false, exit before scan", this.tracefac, 3);
                return;
            }
            if (!Properties.getInstance().getNodeType().equals("ODADom0") && !Global.offlineMode.booleanValue() && !((String)object2).equalsIgnoreCase("DiagCollectionThread") && !((String)object2).equalsIgnoreCase("AutoDiagCollectionThread") && Global.isRtScanOn() && this.isNewAlertLog) {
                Output.printTrace("Restarting RT Scanner due to new inventory completion", this.tracefac, 3);
                object = new Action("startrtscan", host.getHostname(), "InventoryManager", "");
                ((Action)object).store();
                this.isNewAlertLog = false;
            }
            long l8 = System.currentTimeMillis() / 1000L;
            LogFile.writeLog("Time taken to run Inventory in seconds : " + (l8 - l));
        }
        catch (ThreadInterruptedException threadInterruptedException) {
            Output.printTrace("InventoryThread interrupted when trying to update action.", 2);
            threadInterruptedException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        if (stringArray.length == 0) {
            string = "C:/tfa_home/";
            string2 = "C:/tfa_home/";
        } else {
            string = stringArray[0];
            string2 = stringArray[1];
        }
        Global.setSymLinksOff();
        Properties properties = Properties.getInstance(string2);
        Properties.fileTypesXml = string + File.separator + "resources" + File.separator + "file_type_patterns.xml";
        Properties.datePatternsXml = string + File.separator + "resources" + File.separator + "date_patterns.xml";
        Properties.extensionsFile = string + File.separator + "resources" + File.separator + "ignore_extensions.txt";
        LogFile.writeLog("TFAInventory Manager Main: Starting : " + Utilities.getDateTime());
        LogFile.writeLog("TFAInventory Manager Main: TFAHOME set to " + string);
        Output.printTrace("TFAInventory Manager Main: Starting  : " + Utilities.getDateTime(), 3);
        Vector vector = DirectoryMappings.getInstance().getDirectories();
        Iterator iterator = vector.iterator();
        String string3 = "";
        Action action = new Action("runinventory", "localhost", "tfactl", "");
        TFAInventoryManager tFAInventoryManager = new TFAInventoryManager(action);
        while (iterator.hasNext()) {
            DirectoryMappingType directoryMappingType = (DirectoryMappingType)iterator.next();
            string3 = directoryMappingType.directoryPath;
            LogFile.writeLog("Directory to process: " + string3);
            tFAInventoryManager.processDir(string3);
        }
        Output.printTrace("Dumping files with no file types...", 3);
        TFAInventoryManager.dumpFilesWithNoFileTypes();
        FileEntity.dumpFilesFromStoreToXML();
        FileEntity.dumpFilestoOracle();
        LogFile.writeLog("Finish TFAInventoryManager Main : " + TFAInventoryManager.getDateTime());
    }

    public static void printInventory(PrintWriter printWriter) {
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(FileEntity.class);
        EntityCursor entityCursor = primaryIndex.entities();
        Properties.getInstance();
        String string = Properties.getSrContext();
        for (FileEntity fileEntity : entityCursor) {
            if (string != null && fileEntity.srNumber.equals(string)) {
                fileEntity.printFileDetails(printWriter, null);
                continue;
            }
            fileEntity.printFileDetails(printWriter, null);
        }
        entityCursor.close();
    }

    public static FileEntity getFileEntity(String string) {
        string = string.trim();
        FileEntity fileEntity = null;
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(FileEntity.class);
        EntityCursor entityCursor = primaryIndex.entities();
        Properties.getInstance();
        String string2 = Properties.getSrContext();
        for (FileEntity fileEntity2 : entityCursor) {
            if (!fileEntity2.getFileName().equals(string)) continue;
            fileEntity = fileEntity2;
        }
        entityCursor.close();
        return fileEntity;
    }

    public static void printInvFilesForMerge(PrintWriter printWriter, String string) {
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(FileEntity.class);
        EntityCursor entityCursor = primaryIndex.entities();
        for (FileEntity fileEntity : entityCursor) {
            if (string != null && fileEntity.srNumber.equals(string) && fileEntity.isAlertLog().booleanValue()) {
                printWriter.println(fileEntity.getFileName());
                continue;
            }
            printWriter.println(fileEntity.getFileName());
        }
        entityCursor.close();
    }

    private static void dumpFilesWithNoFileTypes() {
        try {
            FileWriter fileWriter = new FileWriter(Properties.filesWithNoFileTypes);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("<?xml version=\"1.0\" ?>\n");
            bufferedWriter.write("<files>\n");
            FileEntityDA fileEntityDA = new FileEntityDA();
            EntityCursor entityCursor = fileEntityDA.pIdx.entities();
            for (FileEntity fileEntity : entityCursor) {
                if (fileEntity.getType() != null) continue;
                bufferedWriter.write("<file>\n");
                bufferedWriter.write("<filename>" + fileEntity.getFileName() + "</filename>\n");
                bufferedWriter.write("</file>\n");
            }
            bufferedWriter.write("</files>\n");
            bufferedWriter.close();
            fileWriter.close();
            entityCursor.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean isSpecialFile(String string) {
        List<String> list = SpecialFilePatterns.getInstance().getNamePatterns();
        for (String string2 : list) {
            string2 = string2.toUpperCase().trim();
            if (!string.toUpperCase().trim().matches(string2)) continue;
            return true;
        }
        return false;
    }

    private String analyseInvArgs(String string, String string2) {
        String[] stringArray = string.split(Properties.TFAARGSEP);
        String[] stringArray2 = string2.split(Properties.TFAARGSEP);
        String string3 = "";
        boolean bl = false;
        for (int i = 0; i < stringArray2.length; ++i) {
            bl = false;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray2[i].equals(stringArray[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            Output.printTrace("Adding component : " + stringArray2[i], 3);
            string3 = string3 + ":" + stringArray2[i];
        }
        return string3;
    }

    private IOFileFilter createFilter(boolean bl, Date date, List<String> list) {
        Object object;
        Calendar calendar;
        Date date2 = date;
        if (date2 == null) {
            calendar = Calendar.getInstance();
            calendar.add(6, -30);
            date2 = calendar.getTime();
        }
        calendar = new AgeFileFilter(date2, false);
        RegexFilter regexFilter = new RegexFilter(IgnoreFilesList.getInstance().getPatterns(), IOCase.INSENSITIVE);
        SuffixFileFilter suffixFileFilter = new SuffixFileFilter(IgnoreExtensions.getInstance().getExtensions(), IOCase.INSENSITIVE);
        SuffixFileFilter suffixFileFilter2 = new SuffixFileFilter("filelist");
        WildcardFileFilter wildcardFileFilter = new WildcardFileFilter("*rat_timings*");
        RegexFilter regexFilter2 = new RegexFilter(SpecialFilePatterns.getInstance().getNamePatterns(), IOCase.INSENSITIVE);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter()));
        arrayList.add(calendar);
        if (!bl) {
            arrayList.add(FileFilterUtils.notFileFilter((IOFileFilter)regexFilter));
            arrayList.add(FileFilterUtils.notFileFilter((IOFileFilter)suffixFileFilter));
        }
        arrayList.add(HiddenFileFilter.VISIBLE);
        arrayList.add(CanReadFileFilter.CAN_READ);
        arrayList.add(FileFilterUtils.notFileFilter((IOFileFilter)suffixFileFilter2));
        arrayList.add(FileFilterUtils.notFileFilter((IOFileFilter)wildcardFileFilter));
        arrayList.add(FileFilterUtils.notFileFilter((IOFileFilter)regexFilter2));
        if (list != null) {
            object = new RegexFilter(list, IOCase.INSENSITIVE);
            arrayList.add(object);
        }
        object = new AndFileFilter(arrayList);
        return object;
    }

    private List<TFADirectory> removeSubDirectories(Object[] objectArray, List<TFADirectory> list) {
        for (int i = 0; i < objectArray.length; ++i) {
            String string;
            String string2 = ((TFADirectory)objectArray[i]).getDirectoryPath();
            for (int j = i + 1; j < objectArray.length && (string = ((TFADirectory)objectArray[j]).getDirectoryPath()).startsWith(string2); ++j) {
                if (!string.substring(string2.length()).startsWith(File.separator)) continue;
                list.remove((TFADirectory)objectArray[j]);
            }
        }
        return list;
    }

    private IOFileFilter filterAndProcess(TFADirectory tFADirectory) {
        String string = tFADirectory.getDirectoryPath();
        boolean bl = false;
        if (tFADirectory.collectionPolicy != null && tFADirectory.collectionPolicy.equals("noexclusions")) {
            LogFile.writeLog("Not performing ignoreFiles and ignoreExtensions checks on this directory : " + string + " because its collection policy is set to : " + tFADirectory.collectionPolicy);
            bl = true;
        }
        IOFileFilter iOFileFilter = null;
        iOFileFilter = tFADirectory.getInvPatterns() != null && tFADirectory.getInvPatterns().size() > 0 ? this.createFilter(bl, tFADirectory.lastInventoryTime, tFADirectory.getInvPatterns()) : this.createFilter(bl, tFADirectory.lastInventoryTime, null);
        long l = System.currentTimeMillis() / 1000L;
        this.processDirectory(string, iOFileFilter, bl);
        long l2 = System.currentTimeMillis() / 1000L;
        Output.printTrace("Time taken to processDirectory " + string + ": " + (l2 - l), 4);
        tFADirectory.setLastInventoryTime();
        return iOFileFilter;
    }

    private void processSpecialFiles(String string) {
        RegexFilter regexFilter = new RegexFilter(SpecialFilePatterns.getInstance().getNamePatterns(), IOCase.INSENSITIVE);
        DbPut dbPut = DbManager.getInstance().getDbPut();
        FileEntity fileEntity = null;
        try {
            Iterator iterator = FileUtils.iterateFiles((File)new File(string), (IOFileFilter)regexFilter, (IOFileFilter)TrueFileFilter.INSTANCE);
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                if (!this.keeprunning) {
                    Output.printTrace("keeprunning is false, return from processSpecialFiles", 3);
                    return;
                }
                Output.printTrace("Looking up file in BDb : " + file.getAbsolutePath(), 3);
                long l = System.currentTimeMillis();
                fileEntity = (FileEntity)new FileEntityDA().pIdx.get((Object)file.getAbsolutePath());
                long l2 = System.currentTimeMillis();
                Output.printTrace("Time taken to look up file in bdb in milliseconds : " + (l2 - l) + " for : " + file.getAbsolutePath(), 3);
                if (Thread.currentThread().isInterrupted()) {
                    Output.printTrace("InventoryThread interrupted while iterating files.", 1);
                    return;
                }
                if (fileEntity == null) {
                    Output.printTrace("Adding new file to TFA: " + file.getAbsolutePath(), 3);
                    fileEntity = new FileEntity(file);
                    String string2 = fileEntity.getFileName();
                    Output.printTrace("Found special file : " + string2, this.tracefac, 3);
                    try {
                        SimpleDateFormat simpleDateFormat;
                        String string3;
                        Pattern pattern = Pattern.compile("\\d{4}_\\d{2}_\\d{2}_\\d{2}_\\d{2}_\\d{2}");
                        Matcher matcher = pattern.matcher(string2);
                        if (matcher.find()) {
                            Output.printTrace("Found ExaWatcher file: " + string2, this.tracefac, 3);
                            string3 = matcher.group();
                            string3 = string3.replaceAll("_", ".");
                            simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
                        } else {
                            Output.printTrace("Found OSW file: " + string2, this.tracefac, 3);
                            string3 = string2.substring(string2.lastIndexOf("_") + 1, string2.lastIndexOf(".dat"));
                            simpleDateFormat = new SimpleDateFormat("yy.MM.dd.HHmm");
                        }
                        Date date = null;
                        try {
                            date = simpleDateFormat.parse(string3);
                        }
                        catch (ParseException parseException) {
                            parseException.printStackTrace();
                        }
                        fileEntity.setFirstTimestamp(date);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        calendar.add(11, 1);
                        fileEntity.setLastTimestamp(calendar.getTime());
                        Output.printTrace("First timestamp : " + fileEntity.getFirstTime(), this.tracefac, 3);
                        Output.printTrace("Last timestamp : " + fileEntity.getLastTime(), this.tracefac, 3);
                    }
                    catch (Exception exception) {
                        Output.printTrace("Exception in getting dates from special file: " + string2, this.tracefac, 3);
                    }
                } else {
                    Output.printTrace("Updating file in TFA: " + file.getAbsolutePath(), 3);
                    fileEntity.updateFromFile(file);
                }
                long l3 = System.currentTimeMillis();
                if (fileEntity.getType() == null) {
                    fileEntity.setFileType();
                }
                long l4 = System.currentTimeMillis();
                Output.printTrace("Time taken to set file type in milliseconds : " + (l4 - l3) + " for : " + file.getAbsolutePath(), 3);
                Output.printTrace("Done Setting file type for entry : " + file.getAbsolutePath(), 3);
                long l5 = System.currentTimeMillis();
                if (fileEntity.getBaseDirectory() != null) {
                    dbPut.storeFileEntity(fileEntity);
                } else {
                    LogFile.writeLog("Directory Mapping is null for file: " + fileEntity.getFileName() + ". Not adding to TFA");
                }
                long l6 = System.currentTimeMillis();
                Output.printTrace("Time taken to store file entity in BDb in milliseconds : " + (l6 - l5) + " for : " + fileEntity.getFileName(), this.tracefac, 4);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Output.printTrace("Caught Exception " + illegalArgumentException.getMessage() + " in processing directory : " + string, this.tracefac, 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Map<String, List<String>> buildComponentList(String string) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        String[] stringArray = string.split(Properties.TFAARGSEP);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (string2.contains(",")) {
                ArrayList<String> arrayList = new ArrayList<String>();
                String string3 = string2.split(" ")[1].trim();
                String[] stringArray2 = string3.split(",");
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string4 = stringArray2[j].trim().toLowerCase();
                    arrayList.add(string4);
                }
                hashMap.put(string2.split(" ")[0], arrayList);
                continue;
            }
            if (string2.equals("")) continue;
            hashMap.put(string2, null);
        }
        return hashMap;
    }

    public IOFileFilter inventoryByDirectory(String string, boolean bl) {
        IOFileFilter iOFileFilter = null;
        DbPut dbPut = DbManager.getInstance().getDbPut();
        EntityStore entityStore = DbManager.getInstance().getEntityStore();
        TFADirectoryDA tFADirectoryDA = new TFADirectoryDA(entityStore);
        boolean bl2 = false;
        Vector vector = DirectoryMappings.getInstance().getDirectories();
        for (DirectoryMappingType directoryMappingType : vector) {
            try {
                String string2 = null;
                if (directoryMappingType.directoryPath.equals(string)) {
                    string2 = string;
                    bl2 = true;
                } else if (directoryMappingType.directoryPath.contains(string)) {
                    string2 = directoryMappingType.directoryPath;
                }
                if (string2 == null) continue;
                TFADirectory tFADirectory = (TFADirectory)tFADirectoryDA.pIdx.get((Object)string2);
                if (tFADirectory != null) {
                    LogFile.writeLog("Directory to process " + string2);
                    long l = FileList.countFilesInDirectory(tFADirectory.getDirectoryPath());
                    if (!bl && l > Global.getFileCountInventorySwitch()) {
                        Date date = tFADirectory.getLastInventoryTime();
                        long l2 = 43200L;
                        if (date != null && (l2 = Calendar.getInstance().getTimeInMillis() / 60000L - date.getTime() / 60000L) > 43200L) {
                            l2 = 43200L;
                        }
                        LogFile.writeLog("Process directory files in parallel for " + l + " files");
                        LogFile.writeLog("FileCount limit to switch Inventory: " + Global.getFileCountInventorySwitch());
                        LogFile.writeLog("Thread Pool Size: " + this.thread_pool_size);
                        this.processDirectoryFilesInParallel(tFADirectory, l2);
                    } else if (bl) {
                        iOFileFilter = this.filterAndProcess(tFADirectory);
                    } else {
                        this.filterAndProcess(tFADirectory);
                    }
                    tFADirectory.setLastInventoryTime();
                    dbPut.storeTFADirectoryEntity(tFADirectory);
                }
                if (!bl2) continue;
                break;
            }
            catch (Exception exception) {
                Output.printTrace("Exception in process directory " + directoryMappingType.directoryPath, 1);
            }
        }
        return iOFileFilter;
    }

    private class DumpInventoryXMLThread
    extends Thread {
        private String status = "NOTRUNNING";

        private DumpInventoryXMLThread() {
        }

        public void setStatus(String string) {
            this.status = string;
        }

        public String getStatus() {
            return this.status;
        }

        @Override
        public void run() {
            DumpInventoryXMLThread dumpInventoryXMLThread = dumpXmlQueue.peek();
            if (dumpInventoryXMLThread != null) {
                if (dumpInventoryXMLThread.getStatus().equals("RUNNING")) {
                    while (dumpInventoryXMLThread.getStatus().equals("RUNNING")) {
                        LogFile.writeLog("Waiting for previous dumping to complete");
                        try {
                            Thread.sleep(20000L);
                            dumpInventoryXMLThread = dumpXmlQueue.peek();
                        }
                        catch (InterruptedException interruptedException) {
                            Output.print("DumpInventoryXmlManager: Interrupted while waiting for dump xml");
                        }
                    }
                }
                this.status = "RUNNING";
                if (Global.offlineMode.booleanValue()) {
                    Output.print("Dumping files with no file types...");
                    Output.print("Dumping files from store to XML");
                }
                LogFile.writeLog("Dumping files to XML");
                long l = System.currentTimeMillis();
                FileEntity.dumpFilesFromStoreToXML();
                long l2 = System.currentTimeMillis();
                LogFile.writeLog("Time taken in seconds to dump files to XML : " + (l2 - l) / 1000L);
                this.status = "COMPLETE";
                dumpXmlQueue.poll();
            }
        }
    }

    private class DirectoryProcessorThread
    extends Thread {
        private String directoryName;

        private DirectoryProcessorThread(String string, String string2) {
            super(string);
            this.directoryName = string2;
        }

        @Override
        public void run() {
            long l = System.currentTimeMillis();
            TFAInventoryManager.this.processDir(this.directoryName);
            long l2 = System.currentTimeMillis();
            Output.print("Done processing " + this.directoryName + " numProcessedDirs : " + TFAInventoryManager.this.numProcessedDirs + " time taken in seconds : " + (l2 - l) / 1000L);
            ++TFAInventoryManager.this.numProcessedDirs;
            TFAInventoryManager.this.queue.add(this.getName());
            Output.print("Queue : " + TFAInventoryManager.this.queue);
        }
    }

    private class FileProcessorThread
    extends Thread {
        private String filePath;
        private Map<String, FileType> fileTypesMap;
        private DbPut dbput;
        private boolean ignoreChecks;

        private FileProcessorThread(String string, String string2, Map<String, FileType> map, DbPut dbPut, boolean bl) {
            super(string);
            this.filePath = string2;
            this.fileTypesMap = map;
            this.dbput = dbPut;
            this.ignoreChecks = bl;
        }

        @Override
        public void run() {
            Object object;
            boolean bl;
            boolean bl2 = true;
            File file = new File(this.filePath);
            Output.printTrace("Processing file : " + file.getAbsolutePath(), TFAInventoryManager.this.tracefac, 3);
            Output.printTrace("Looking up file in BDb : " + file.getAbsolutePath(), TFAInventoryManager.this.tracefac, 3);
            Transaction transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            FileEntity fileEntity = (FileEntity)new FileEntityDA().pIdx.get(transaction, (Object)file.getAbsolutePath(), null);
            transaction.commit();
            transaction = null;
            ScanFileEntity scanFileEntity = null;
            ScanFileEntityDA scanFileEntityDA = new ScanFileEntityDA();
            if (fileEntity != null) {
                if (fileEntity.getFileSize() == 0L) {
                    TFAInventoryManager.this.queue.add(this.getName());
                    return;
                }
                if (!Global.offlineMode.booleanValue() && fileEntity.isRealTimeTail().booleanValue() && (scanFileEntity = (ScanFileEntity)scanFileEntityDA.pIdx.get((Object)fileEntity.getFileName())) == null) {
                    scanFileEntity = new ScanFileEntity(fileEntity.getFileName());
                    scanFileEntity.store(scanFileEntityDA);
                    TFAInventoryManager.this.isNewAlertLog = true;
                }
                if (fileEntity.getType() != null) {
                    FileType fileType = this.fileTypesMap.get(fileEntity.getType());
                    if (fileType != null) {
                        fileEntity.setUseDfOnly(fileType.isUseDfOnly());
                        fileEntity.setKeepHeaderLines(fileType.getKeepHeaderLines());
                        Output.printTrace("Set New Attributes : " + fileEntity.getFileName() + " use_df_only: " + fileEntity.isUseDfOnly() + " keep_header_lines: " + fileEntity.getKeepHeaderLines(), TFAInventoryManager.this.tracefac, 3);
                        if (fileEntity.getDatePattern() != null && fileType.getDatePatterns().size() > 0 && !fileType.getDatePatterns().contains(fileEntity.getDatePattern())) {
                            Output.printTrace("Old datepattern : " + fileEntity.getFileName() + fileEntity.getDatePattern(), TFAInventoryManager.this.tracefac, 3);
                            fileEntity.setDatePattern(null);
                            Output.printTrace("Set New datepattern : " + fileEntity.getFileName() + null, TFAInventoryManager.this.tracefac, 3);
                        }
                    }
                } else {
                    fileEntity.setComponent("NULL");
                }
            }
            if (!(bl = FileList.isFileWorthProcessing(file, fileEntity))) {
                TFAInventoryManager.this.queue.add(this.getName());
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                Output.printTrace("InventoryThread interrupted while iterating files.", 1);
                TFAInventoryManager.this.queue.add(this.getName());
                return;
            }
            boolean bl3 = false;
            boolean bl4 = TFAInventoryManager.isSpecialFile(file.getAbsolutePath());
            if (fileEntity == null) {
                Object object2;
                Object object3;
                if (!file.exists() || file.length() == 0L || file.isHidden() || file.isDirectory() || !file.canRead() || file.getName().endsWith("filelist") || file.getName().contains("rat_timings")) {
                    TFAInventoryManager.this.queue.add(this.getName());
                    return;
                }
                if (!this.ignoreChecks) {
                    object3 = IgnoreFilesList.getInstance();
                    if (((IgnoreFilesList)object3).ignoreThisFile(file.getAbsolutePath())) {
                        Output.printTrace("Ignore Files : " + file.getAbsolutePath(), TFAInventoryManager.this.tracefac, 3);
                        TFAInventoryManager.this.queue.add(this.getName());
                        return;
                    }
                    if (!Properties.isCloud && ((IgnoreExtensions)(object2 = IgnoreExtensions.getInstance())).ignoreThisFile(file.getName())) {
                        Output.printTrace("Ignore Extensions : " + file.getAbsolutePath(), TFAInventoryManager.this.tracefac, 3);
                        TFAInventoryManager.this.queue.add(this.getName());
                        return;
                    }
                }
                if (!(file.getName().endsWith(".trc") || file.getName().endsWith(".log") || file.getName().endsWith(".trm") || file.getName().endsWith(".trw") || file.getName().endsWith(".txt") || file.getName().endsWith(".properties"))) {
                    try {
                        if (!FileHelper.isAsciiText(file.getAbsolutePath())) {
                            Output.printTrace("Failed ASCII : " + file.getAbsolutePath(), TFAInventoryManager.this.tracefac, 3);
                            if (!(this.ignoreChecks || file.getName().endsWith(".trc.gz") || file.getName().endsWith(".evtx"))) {
                                TFAInventoryManager.this.queue.add(this.getName());
                                return;
                            }
                            bl3 = true;
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        TFAInventoryManager.this.queue.add(this.getName());
                        return;
                    }
                }
                Output.printTrace("Adding new file to TFA: " + file.getAbsolutePath(), TFAInventoryManager.this.tracefac, 3);
                fileEntity = new FileEntity(file);
                if (bl4) {
                    object3 = fileEntity.getFileName();
                    Output.printTrace("Found special file : " + (String)object3, TFAInventoryManager.this.tracefac, 3);
                    try {
                        Pattern pattern = Pattern.compile("\\d{4}_\\d{2}_\\d{2}_\\d{2}_\\d{2}_\\d{2}");
                        Matcher matcher = pattern.matcher((CharSequence)object3);
                        if (matcher.find()) {
                            Output.printTrace("Found ExaWatcher file: " + (String)object3, TFAInventoryManager.this.tracefac, 3);
                            object2 = matcher.group();
                            object2 = ((String)object2).replaceAll("_", ".");
                            object = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
                        } else {
                            Output.printTrace("Found OSW file: " + (String)object3, TFAInventoryManager.this.tracefac, 3);
                            object2 = ((String)object3).substring(((String)object3).lastIndexOf("_") + 1, ((String)object3).lastIndexOf(".dat"));
                            object = new SimpleDateFormat("yy.MM.dd.HHmm");
                        }
                        Date date = null;
                        try {
                            date = ((DateFormat)object).parse((String)object2);
                        }
                        catch (ParseException parseException) {
                            TFAInventoryManager.this.queue.add(this.getName());
                            parseException.printStackTrace();
                        }
                        fileEntity.setFirstTimestamp(date);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        calendar.add(11, 1);
                        fileEntity.setLastTimestamp(calendar.getTime());
                        Output.printTrace("First timestamp : " + fileEntity.getFirstTime(), TFAInventoryManager.this.tracefac, 3);
                        Output.printTrace("Last timestamp : " + fileEntity.getLastTime(), TFAInventoryManager.this.tracefac, 3);
                    }
                    catch (Exception exception) {
                        Output.printTrace("Exception in getting dates from special file: " + (String)object3, TFAInventoryManager.this.tracefac, 3);
                    }
                }
            } else {
                Output.printTrace("Updating file in TFA: " + file.getAbsolutePath(), TFAInventoryManager.this.tracefac, 3);
                fileEntity.updateFromFile(file);
            }
            if (fileEntity.getType() == null) {
                fileEntity.setFileType();
            }
            Output.printTrace("Done Setting file type for entry : " + file.getAbsolutePath(), TFAInventoryManager.this.tracefac, 3);
            boolean bl5 = true;
            if (fileEntity.getType() != null && bl2 && !bl4) {
                Properties.getInstance();
                if (Properties.samplingEnabled) {
                    boolean bl6 = false;
                    object = this.fileTypesMap.get(fileEntity.getType());
                    if (object != null && ((FileType)object).getInventoryAction() != null && ((FileType)object).getInventoryAction().equalsIgnoreCase("SAMPLE")) {
                        bl6 = true;
                    }
                    try {
                        if (!bl3) {
                            int n = fileEntity.getNumberOfLines();
                            if (n == 0) {
                                n = FileList.countLines(file.getPath());
                                fileEntity.setNumberOfLines(n);
                            }
                            if (n == -1) {
                                bl5 = false;
                                LogFile.writeLog("File " + fileEntity.getFileName() + " is not fit for sampling");
                            }
                        }
                    }
                    catch (IOException iOException) {
                        TFAInventoryManager.this.queue.add(this.getName());
                        Output.printTrace("Cannot count lines for file " + file.getPath(), 1);
                        iOException.printStackTrace();
                    }
                    try {
                        if (bl6 && bl5 && !bl3) {
                            Output.printTrace("Sampling file : " + fileEntity.getFileName(), TFAInventoryManager.this.tracefac, 3);
                            long l = System.currentTimeMillis() / 1000L;
                            fileEntity.lookForFirstTimestamp(false);
                            long l2 = System.currentTimeMillis() / 1000L;
                            Output.printTrace("Done looking for first timestamp : " + fileEntity.getFirstTime(), TFAInventoryManager.this.tracefac, 3);
                            if (fileEntity.getFirstTime() == null && fileEntity.getDatePattern() != null && !fileEntity.isUseDfOnly()) {
                                LogFile.writeLog("Could not find first time stamp for " + fileEntity.getFileName() + " with date pattern : " + fileEntity.getDatePattern());
                                fileEntity.lookForFirstTimestamp(true);
                            }
                            if (fileEntity.getFirstTime() == null && fileEntity.isUseDfOnly() && fileEntity.getDatePattern() != null) {
                                LogFile.writeLog("Could not find first time stamp for " + fileEntity.getFileName() + " with date pattern : " + fileEntity.getDatePattern() + "in file_type_patterns");
                                LogFile.writeLog("use_df_only is set to true and hence will not set first time stamp");
                            }
                            if (fileEntity.getFirstTime() != null) {
                                Output.printTrace("Started looking for lastTimestamp : " + System.currentTimeMillis() / 1000L, TFAInventoryManager.this.tracefac, 3);
                                long l3 = System.currentTimeMillis() / 1000L;
                                fileEntity.setLastTimestamp(false);
                                long l4 = System.currentTimeMillis() / 1000L;
                                Output.printTrace("Done looking for lastTimestamp : " + fileEntity.getLastTime() + " " + System.currentTimeMillis() / 1000L, TFAInventoryManager.this.tracefac, 3);
                                if (fileEntity.getLastTime() == null && fileEntity.getDatePattern() != null && !fileEntity.isUseDfOnly()) {
                                    Output.print("Could not find last time stamp for " + fileEntity.getFileName() + " with date pattern : " + fileEntity.getDatePattern());
                                    fileEntity.setLastTimestamp(true);
                                }
                                Output.printTrace("Time taken to get firstTimestamp : " + (l2 - l) + " Time taken to get lastTimestamp : " + (l4 - l3), TFAInventoryManager.this.tracefac, 3);
                            } else {
                                LogFile.writeLog("Could not find first time stamp for " + fileEntity.getFileName() + " after bruteforce");
                            }
                            if (fileEntity.getLastTime() == null && fileEntity.isUseDfOnly() && fileEntity.getDatePattern() != null) {
                                LogFile.writeLog("Could not find last time stamp for " + fileEntity.getFileName() + " with date pattern : " + fileEntity.getDatePattern() + "in file_type_patterns");
                                LogFile.writeLog("use_df_only is set to true and hence will not set last time stamp");
                            }
                        }
                    }
                    catch (Exception exception) {
                        TFAInventoryManager.this.queue.add(this.getName());
                        Output.printTrace("Cannot sample file " + file.getPath(), 1);
                        exception.printStackTrace();
                    }
                }
            }
            Output.printTrace("Storing Entity: " + fileEntity.getFileName(), TFAInventoryManager.this.tracefac, 3);
            if (fileEntity.getBaseDirectory() != null) {
                this.dbput.storeFileEntity(fileEntity);
                if (!Global.offlineMode.booleanValue() && fileEntity.isRealTimeTail().booleanValue() && (scanFileEntity = (ScanFileEntity)scanFileEntityDA.pIdx.get((Object)fileEntity.getFileName())) == null) {
                    scanFileEntity = new ScanFileEntity(fileEntity.getFileName());
                    scanFileEntity.store(scanFileEntityDA);
                    TFAInventoryManager.this.isNewAlertLog = true;
                }
            } else {
                Output.print("Directory Mapping is null for file: " + fileEntity.getFileName() + ". Not adding to TFA");
            }
            TFAInventoryManager.this.queue.add(this.getName());
        }
    }
}

