/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DataAccessor.TFAHostDA;
import oracle.rat.tfa.db.DbGet;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.TFAHost;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;

public class TFAHostManager {
    public static void addHostOnly(String string, String string2, String string3, String string4) {
        Object object;
        Output.printTrace("Inside addHostOnly : " + string, 3);
        String string5 = string;
        if (string.contains(":")) {
            string5 = string.split(":")[0];
            object = string.split(":")[1];
            Map<String, Integer> map = Global.getPortMapping();
            map.put(string5, (int)new Integer((String)object));
            Output.printTrace("After updating port mapping in node : " + Global.getPortMapping(), 3);
            Properties.getInstance();
            Properties.writePortMappingToFile(map);
        }
        object = new TFAHost(string5.trim(), string2, string3, string4);
        DbManager.getInstance().getDbPut().storeTFAHostEntity((TFAHost)object);
        Output.printTrace("Successfully added host : " + string, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncHosts() {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        String string = null;
        String string2 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        EntityCursor entityCursor2 = null;
        String string3 = null;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            for (TFAHost tFAHost : entityCursor) {
                string3 = tFAHost.getHostname().trim();
                Output.printTrace("I AM : " + string2 + " & TFAHOST is : " + string3, 3);
                if (!string3.equalsIgnoreCase(string2)) {
                    Output.printTrace("Making Socket connection to :" + string3, 3);
                    Properties.getInstance();
                    String string4 = Properties.trustStore;
                    Properties.getInstance();
                    String string5 = Properties.trustStorePassword;
                    sSLSocket = SocketManager.getSecureSocketConnection(string3.trim(), Global.getSocketPort(), string4, string5);
                    if (sSLSocket == null) {
                        Output.printTrace("Connection refused!" + string3, 3);
                        continue;
                    }
                    printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                    bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                    entityCursor2 = primaryIndex.entities(null, cursorConfig);
                    block16: for (TFAHost tFAHost2 : entityCursor2) {
                        Output.printTrace("Sending Add for Sync Host : " + tFAHost2.getHostname(), 3);
                        String string6 = tFAHost2.getHostname().trim();
                        Integer n = Global.getPortMapping().get(string6);
                        if (n == null) continue;
                        printWriter.println(string2 + ":hostsync:" + string6 + ":" + n);
                        Output.printTrace("Sending Add for Sync Host : " + tFAHost2.getHostname() + " with port : " + n, 3);
                        while ((string = bufferedReader.readLine()) != null) {
                            Output.printTrace("Received from socket inputStream : " + string, 3);
                            if (!string.equalsIgnoreCase("SUCCESS")) continue;
                            continue block16;
                        }
                    }
                    entityCursor2.close();
                    bufferedReader.close();
                    Output.printTrace("DONE receiving from socket inputStream. Closing it now...", 3);
                    if (sSLSocket.isClosed()) continue;
                    sSLSocket.close();
                    continue;
                }
                Output.printTrace("Not sending Add to myself - I am : " + tFAHost.getHostname(), 3);
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string3, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string3, 1);
            iOException.printStackTrace();
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String addHost(String string, String string2, String string3, String string4) {
        String string5 = "FAILED TO ADD HOST";
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        String string6 = null;
        String string7 = new Host().getHostname();
        string = string.trim();
        TFAHost tFAHost = new TFAHost(string, string2, string3, string4);
        String string8 = Properties.TFARunMode.toUpperCase();
        try {
            Properties.getInstance();
            String string9 = Properties.trustStore;
            Properties.getInstance();
            String string10 = Properties.trustStorePassword;
            Output.printTrace("Making a socket connection to : " + string, 3);
            sSLSocket = SocketManager.getSecureSocketConnection(string, Global.getSocketPort(), string9, string10);
            if (sSLSocket == null) {
                Output.printTrace("Failed to get secure socket connection to : " + string, 3);
                string5 = "FAILED TO CONNECT SECURELY TO " + string;
                return string5;
            }
            printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
            bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
            String string11 = "COLLECTOR";
            printWriter.println(string7 + ":getTFARunMode");
            while ((string6 = bufferedReader.readLine()) != null) {
                if (string6.contains("TFA_RUN_MODE")) {
                    string11 = string6.substring(string6.lastIndexOf(":") + 1);
                    continue;
                }
                if (!string6.equals("DONE")) continue;
            }
            if (!string8.equals(string11)) {
                string5 = "FAILED - TFA Should run in same mode in both the nodes";
                return string5;
            }
            printWriter.flush();
            printWriter.println(string7 + ":printhosts");
            while ((string6 = bufferedReader.readLine()) != null) {
                if (string6.contains("Host Name")) {
                    string6 = string6.substring(string6.lastIndexOf(":") + 1);
                    Output.printTrace("Host to Add" + string6, 3);
                    String string12 = string6.trim();
                    tFAHost = new TFAHost(string6.trim(), "blah", "blah", "/bah");
                    DbManager.getInstance().getDbPut().storeTFAHostEntity(tFAHost);
                    if (!Global.getPortMapping().containsKey(string12)) {
                        String string13 = SocketManager.getTFAPort(string12);
                        if (string13 == null) {
                            Output.printTrace("Could not determine the port on which TFA is running on node " + string12, 3);
                        } else {
                            Output.printTrace("Port on which TFA is listening in node " + string12 + " : " + string13, 3);
                            Map<String, Integer> map = Global.getPortMapping();
                            map.put(string12, (int)new Integer(string13));
                            Properties.getInstance();
                            Properties.writePortMappingToFile(map);
                            Output.printTrace("After determining remotePort, portMapping in Global : " + Global.getPortMapping(), 3);
                        }
                    }
                }
                if (!string6.contentEquals("DONE")) continue;
                Output.printTrace("Received Done for printhosts request", 3);
                break;
            }
            if (!sSLSocket.isClosed()) {
                sSLSocket.close();
            }
            TFAHostManager.syncHosts();
            string5 = "SUCCESS";
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host:" + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to: " + string, 1);
            iOException.printStackTrace();
        }
        return string5;
    }

    public static String removeHost(String string, String string2) {
        File file = new File(Properties.removedHostsFile);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                Output.printTrace("Error in creating " + Properties.removedHostsFile, 3);
            }
        }
        String[] stringArray = string.split(":");
        String string3 = stringArray[0].trim();
        Output.printTrace("hostname to remove : " + string3, 3);
        String string4 = new Host().getHostname().trim();
        String string5 = "FAILED TO REMOVE HOST";
        string3 = string3.trim();
        try {
            Output.printTrace("Trying to update remote node " + string3, 3);
            if (string2.equalsIgnoreCase(string4)) {
                TFAHostManager.updateRemovedNode(string3);
            }
            EntityStore entityStore = DbManager.getInstance().getEntityStore();
            TFAHostDA tFAHostDA = new TFAHostDA(entityStore);
            Output.printTrace("Removing Host: " + string3, 3);
            boolean bl = tFAHostDA.pIdx.delete((Object)string3);
            if (bl) {
                Output.printTrace("Host: " + string3 + " deleted", 3);
                string5 = "SUCCESS";
                if (string2.equalsIgnoreCase(string4)) {
                    TFAHostManager.removeFromOtherNodes(string3);
                }
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, true));
                bufferedWriter.write(string3 + "\n");
                bufferedWriter.close();
            } else {
                Output.printTrace("Host: " + string3 + " *NOT* deleted", 3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpHosts() {
        EntityCursor entityCursor = null;
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities();
            for (TFAHost tFAHost : entityCursor) {
                Output.printTrace("Host: " + tFAHost.getUsername() + "@" + tFAHost.getHostname(), 3);
                Output.printTrace("  --> TFA Home: " + tFAHost.getTfaHomeDir(), 3);
                if (tFAHost.getPassword() == null) {
                    Output.printTrace("  --> password *NOT* supplied", 3);
                    continue;
                }
                Output.printTrace("  --> password supplied", 3);
            }
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 6) {
            Output.printTrace("Not Enough Arguments", 1);
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        String string6 = stringArray[5];
        String string7 = new Host().getHostname().trim();
        Properties properties = Properties.getInstance(string);
        Output.printTrace("Flag: *" + string2 + "*", 3);
        if (!(string2.equals("-a") || string2.equals("-r") || string2.equals("-l"))) {
            Output.printTrace("you forgot the -a <add> or -r <remove> flag", 1);
            System.exit(1);
        }
        if (string2.equals("-a")) {
            TFAHostManager.addHost(string3, string4, string5, string6);
            TFAHostManager.dumpHosts();
        } else if (string2.equals("-l")) {
            TFAHostManager.dumpHosts();
        } else if (string2.equals("-r")) {
            TFAHostManager.removeHost(string3, string7);
        }
    }

    public static void registerHost(Host host, String string) {
        DbGet dbGet = DbManager.getInstance().getDbGet();
        TFAHost tFAHost = dbGet.lookupHost(host.getHostname().trim());
        if (tFAHost == null) {
            tFAHost = new TFAHost(host.getHostname().trim(), "", "", string);
            DbManager.getInstance().getDbPut().storeTFAHostEntity(tFAHost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String updateHost() {
        File file = new File(Properties.removedHostsFile);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                Output.printTrace("Error in creating " + Properties.removedHostsFile, 3);
            }
        }
        String string = "DONE";
        String string2 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        String string3 = null;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            Output.printTrace("Trying to remove all nodes from " + string2, 3);
            for (TFAHost tFAHost : entityCursor) {
                string3 = tFAHost.getHostname().trim();
                Output.printTrace("I AM : " + string2 + " & TFAHOST is : " + string3, 3);
                if (!string3.equalsIgnoreCase(string2)) {
                    EntityStore entityStore = DbManager.getInstance().getEntityStore();
                    TFAHostDA tFAHostDA = new TFAHostDA(entityStore);
                    Output.printTrace("Removing Host: " + string3, 3);
                    boolean bl = tFAHostDA.pIdx.delete((Object)string3);
                    if (bl) {
                        Map<String, Integer> map = Global.getPortMapping();
                        map.remove(string3);
                        Global.setPortMapping(map);
                        Properties.getInstance();
                        Properties.writePortMappingToFile(map);
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, true));
                        bufferedWriter.write(string3 + "\n");
                        bufferedWriter.close();
                        continue;
                    }
                    Output.printTrace("Could not remove " + string3, 3);
                    continue;
                }
                Output.printTrace("Not removing myself - I am : " + tFAHost.getHostname(), 3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromOtherNodes(String string) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        String string2 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        String string3 = null;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            for (TFAHost tFAHost : entityCursor) {
                string3 = tFAHost.getHostname().trim();
                Output.printTrace("I AM : " + string2 + " & TFAHOST is : " + string3, 3);
                if (!string3.equalsIgnoreCase(string2)) {
                    Output.printTrace("Making Socket connection to :" + string3, 3);
                    Properties.getInstance();
                    String string4 = Properties.trustStore;
                    Properties.getInstance();
                    String string5 = Properties.trustStorePassword;
                    sSLSocket = SocketManager.getSecureSocketConnection(string3.trim(), Global.getSocketPort(), string4, string5);
                    if (sSLSocket == null) {
                        Output.printTrace("Unable to connect to " + string3, 3);
                        continue;
                    }
                    printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                    printWriter.println(string2 + ":removehost:" + string);
                    if (sSLSocket.isClosed()) continue;
                    sSLSocket.close();
                    continue;
                }
                Output.printTrace("Not sending Remove to myself - I am : " + tFAHost.getHostname(), 3);
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string3, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string3, 1);
            iOException.printStackTrace();
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void updateRemovedNode(String string) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        String string2 = new Host().getHostname().trim();
        try {
            Output.printTrace("Making Socket connection to :" + string, 3);
            Properties.getInstance();
            String string3 = Properties.trustStore;
            Properties.getInstance();
            String string4 = Properties.trustStorePassword;
            sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string3, string4);
            if (sSLSocket == null) {
                Output.print("Cannot update the host list in " + string);
                return;
            }
            printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
            printWriter.println(string2 + ":updatehost");
            if (!sSLSocket.isClosed()) {
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string, 1);
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void isLocalNodeRemovedFromTFA() {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        String string = new Host().getHostname().trim();
        Transaction transaction = null;
        String string2 = null;
        File file = new File(Properties.removedHostsFile);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                Output.printTrace("Error in creating " + Properties.removedHostsFile, 3);
            }
        }
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (TFAHost tFAHost : entityCursor) {
                    string2 = tFAHost.getHostname();
                    Output.printTrace("I AM : " + string + " & TFAHOST is : " + string2, 3);
                    if (!string2.trim().equalsIgnoreCase(string)) {
                        String string3;
                        Output.printTrace("Making Socket connection to :" + string2, 3);
                        Properties.getInstance();
                        String string4 = Properties.trustStore;
                        Properties.getInstance();
                        String string5 = Properties.trustStorePassword;
                        sSLSocket = SocketManager.getSecureSocketConnection(string2.trim(), Global.getSocketPort(), string4, string5);
                        if (sSLSocket == null) continue;
                        printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                        printWriter.println(string + ":checkremovedhost:" + string);
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                        while ((string3 = bufferedReader.readLine()) != null && !string3.equals("DONE")) {
                            if (!string3.equals("REMOVED")) continue;
                            EntityStore entityStore = DbManager.getInstance().getEntityStore();
                            TFAHostDA tFAHostDA = new TFAHostDA(entityStore);
                            Output.printTrace("Removing Host: " + string2, 3);
                            boolean bl = tFAHostDA.pIdx.delete((Object)string2);
                            if (!bl) continue;
                            LogFile.writeLog(string2 + " is removed from TFA");
                            Map<String, Integer> map = Global.getPortMapping();
                            map.remove(string2);
                            Global.setPortMapping(map);
                            Properties.getInstance();
                            Properties.writePortMappingToFile(map);
                            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, true));
                            bufferedWriter.write(string2 + "\n");
                            bufferedWriter.close();
                        }
                        bufferedReader.close();
                        if (sSLSocket.isClosed()) continue;
                        sSLSocket.close();
                        continue;
                    }
                    Output.printTrace("Not sending Remove to myself - I am : " + tFAHost.getHostname(), 3);
                }
            }
            catch (UnknownHostException unknownHostException) {
                Output.printTrace("Don't know about host: " + string2, 1);
            }
            catch (IOException iOException) {
                Output.printTrace("Couldn't get I/O for the connection to Host : " + string2, 1);
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
            finally {
                try {
                    entityCursor.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            Output.printTrace("Caught Exception in synchosts after restart", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncHostsOnTFAStart() {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        String string = new Host().getHostname().trim();
        Transaction transaction = null;
        String string2 = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            try {
                String[] stringArray;
                Object object;
                EntityStore entityStore;
                for (TFAHost object2 : entityCursor) {
                    String string3;
                    entityStore = new ArrayList();
                    string2 = object2.getHostname();
                    Output.printTrace("I AM : " + string + " & TFAHOST is : " + string2, 3);
                    if (string2.trim().equalsIgnoreCase(string)) continue;
                    Output.printTrace("Making Socket connection to :" + string2, 3);
                    Properties.getInstance();
                    object = Properties.trustStore;
                    Properties.getInstance();
                    String string4 = Properties.trustStorePassword;
                    sSLSocket = SocketManager.getSecureSocketConnection(string2.trim(), Global.getSocketPort(), (String)object, string4);
                    if (sSLSocket == null) continue;
                    printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                    printWriter.println(string + ":printhosts");
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                    while ((string3 = bufferedReader.readLine()) != null && !string3.equals("DONE")) {
                        if (!string3.contains(":") || (stringArray = string3.split(":")).length <= 1) continue;
                        entityStore.add(stringArray[1].trim());
                    }
                    bufferedReader.close();
                    if (!sSLSocket.isClosed()) {
                        sSLSocket.close();
                    }
                    stringArray = TFAHost.getHostsInTFA();
                    if (entityStore.contains(string)) {
                        for (String string5 : entityStore) {
                            if (stringArray.contains(string5)) continue;
                            arrayList2.add(string5);
                        }
                        for (String string5 : stringArray) {
                            if (entityStore.contains(string5)) continue;
                            arrayList.add(string5);
                        }
                        break;
                    }
                    arrayList.add(string2);
                }
                for (String string6 : arrayList2) {
                    Output.printTrace("Add Node " + string6, 3);
                    TFAHostManager.addHost(string6, "blah", "blah", "/blah");
                }
                for (String string7 : arrayList) {
                    entityStore = DbManager.getInstance().getEntityStore();
                    object = new TFAHostDA(entityStore);
                    Output.printTrace("Removing Host: " + string7, 3);
                    boolean bl = ((TFAHostDA)object).pIdx.delete((Object)string7);
                    if (!bl) continue;
                    LogFile.writeLog(string7 + " is removed from TFA");
                    stringArray = Global.getPortMapping();
                    stringArray.remove(string7);
                    Global.setPortMapping(stringArray);
                    Properties.getInstance();
                    Properties.writePortMappingToFile(stringArray);
                }
            }
            catch (UnknownHostException unknownHostException) {
                Output.printTrace("Don't know about host: " + string2, 1);
            }
            catch (IOException iOException) {
                Output.printTrace("Couldn't get I/O for the connection to Host : " + string2, 1);
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
            finally {
                try {
                    entityCursor.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            Output.printTrace("Caught Exception in synchosts after restart", 1);
        }
    }

    public static boolean isRemoteNodeRemovedFromTFA(String string) {
        EntityStore entityStore = DbManager.getInstance().getEntityStore();
        TFAHostDA tFAHostDA = new TFAHostDA(entityStore);
        TFAHost tFAHost = (TFAHost)tFAHostDA.pIdx.get((Object)string);
        return tFAHost == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMasterNode(boolean bl) {
        SSLSocket sSLSocket = null;
        Object var2_2 = null;
        String string = new Host().getHostname().trim();
        Transaction transaction = null;
        String string2 = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (TFAHost tFAHost : entityCursor) {
                    ArrayList arrayList = new ArrayList();
                    string2 = tFAHost.getHostname();
                    Output.printTrace("I AM : " + string + " & TFAHOST is : " + string2, 3);
                    if (string2.trim().equalsIgnoreCase(string) && !bl) {
                        Global.master_node = string2;
                        break;
                    }
                    if (string2.trim().equalsIgnoreCase(string)) continue;
                    Output.printTrace("Making Socket connection to :" + string2, 3);
                    Properties.getInstance();
                    String string3 = Properties.trustStore;
                    Properties.getInstance();
                    String string4 = Properties.trustStorePassword;
                    sSLSocket = SocketManager.getSecureSocketConnection(string2.trim(), Global.getSocketPort(), string3, string4);
                    if (sSLSocket == null) continue;
                    Global.master_node = string2;
                    break;
                }
                Output.printTrace("Master node: " + Global.master_node, 1);
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
            finally {
                try {
                    entityCursor.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            Output.printTrace("Caught Exception in synchosts after restart", 1);
        }
        Output.printTrace("Master node set is :" + Global.master_node, 1);
    }
}

