/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityIndex;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.TFAInventoryManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DataAccessor.TFADirectoryDA;
import oracle.rat.tfa.db.DbGet;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.ComponentEntity;
import oracle.rat.tfa.entity.ComponentFilePattern;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.TFADirectory;
import oracle.rat.tfa.nls.Omsg;
import oracle.rat.tfa.nls.Oprint;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.singletons.DirectoryMappings;
import oracle.rat.tfa.type.Component;
import oracle.rat.tfa.type.DirectoryMappingType;
import oracle.rat.tfa.type.DirectoryPattern;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class TFADirectoryManager {
    Oprint screen = new Oprint("en-US", "en", "UTF-8", "US");
    Omsg xmlOut = new Omsg("en-US", "en", "UTF-8", "US");
    static long count;
    private static Vector<String> validDirs;

    public static void runInventoryThread(Set<String> set) {
        Oprint oprint = new Oprint("en-US", "en", "UTF-8", "US");
        String string = new Host().getHostname().trim();
        Action action = new Action("runinventory", string, "AddDirectoryThread", "dirSpecific");
        TFAInventoryManager tFAInventoryManager = new TFAInventoryManager(action, set);
        Thread thread = new Thread((Runnable)tFAInventoryManager, "TFAInventoryManager");
        thread.start();
        if (Global.inventoryAborted) {
            Action action2 = new Action("runinventory", new Host().getHostname().trim(), "AddDirectoryThread", "");
            TFAInventoryManager tFAInventoryManager2 = new TFAInventoryManager(action2);
            Thread thread2 = new Thread((Runnable)tFAInventoryManager2, "InventoryThread");
            Global.inventoryManagerThread = tFAInventoryManager2;
            Global.inventoryThread = thread2;
            Global.inventoryAborted = false;
            Output.printTrace("Inventory Thread resuming on Host : " + new Host().getHostname(), 3);
            thread2.start();
        }
    }

    public static String addDirectory(String string, String string2, String string3, List<String> list, String string4, boolean bl, String string5, String string6, boolean bl2) throws IOException {
        return TFADirectoryManager.addDirectory(string, string2, string3, list, null, string4, null, bl, string5, string6, bl2);
    }

    public static String addDirectory(String string, String string2, String string3, List<String> list, List<String> list2, String string4, PrintWriter printWriter, boolean bl, String string5, String string6, boolean bl2) throws IOException {
        Oprint oprint = new Oprint("en-US", "en", "UTF-8", "US");
        validDirs = null;
        if (!new File(string = string.trim()).exists()) {
            LogFile.writeLog("Directory " + string + " does not exist.");
            return "FAILED";
        }
        boolean bl3 = false;
        if (printWriter != null) {
            bl3 = true;
        }
        EntityStore entityStore = DbManager.getInstance().getEntityStore();
        TFADirectoryDA tFADirectoryDA = new TFADirectoryDA(entityStore);
        String string7 = TFADirectoryManager.getTFADirectory(string, tFADirectoryDA.pIdx);
        Output.printTrace("addDirectory: OfflineRun = " + Global.offlineMode, 3);
        Output.printTrace("addDirectory: Dir, comp = " + string7 + ", " + list, 3);
        String string8 = "FAILED";
        TFADirectory tFADirectory = null;
        if (string7 == null) {
            String[] stringArray;
            Cloneable cloneable;
            Output.printTrace("addDirectory: Dir is not found in bdb: " + string, 3);
            if (Global.offlineMode.booleanValue() && list != null && list.size() > 0) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (string2 != "") {
                    hashMap.put("database", string2);
                }
                if (string3 != "") {
                    hashMap.put("instance", string3);
                }
                if (hashMap.size() == 0) {
                    hashMap = null;
                }
                tFADirectory = new TFADirectory(string, string2, string3, list, string4, hashMap);
                tFADirectory.setCollectionPolicy(string6);
                DbManager.getInstance().getDbPut().storeTFADirectoryEntity(tFADirectory);
                DirectoryMappings.getInstance().resetMappings();
                Output.printTrace("Successfully added directory : " + string, 3);
                string8 = "SUCCESS";
                return string8;
            }
            List<Map<String, String>> list3 = TFADirectoryManager.getDirectoryInformation(string);
            String string9 = new Host().getHostname().trim();
            Output.printTrace("addDirectory: DirInfo = " + list3, 3);
            HashSet<String> hashSet = new HashSet<String>();
            if (list3.size() == 0) {
                if (list != null && list.size() > 0) {
                    cloneable = new HashMap();
                    if (list2 != null && list2.size() > 0) {
                        for (String object2 : list2) {
                            String[] stringArray2;
                            if (!object2.contains("%") || (stringArray2 = object2.split("%")) == null || stringArray2.length <= 1) continue;
                            for (int i = 1; i < stringArray2.length; ++i) {
                                stringArray = stringArray2[i].trim().split("\\|");
                                if (stringArray == null || stringArray.length != 2) continue;
                                cloneable.put(stringArray2[0] + "|" + stringArray[0], stringArray[1]);
                            }
                        }
                    }
                    if (cloneable.size() == 0) {
                        cloneable = null;
                    }
                    tFADirectory = new TFADirectory(string, string2, string3, list, string4, (Map<String, String>)((Object)cloneable));
                    if (bl) {
                        tFADirectory.setPermission("private");
                    }
                    tFADirectory.setOwner(string5);
                    if (string.matches(".*" + File.separator + "cdump")) {
                        tFADirectory.setCollectionPolicy("noexclusions");
                    } else {
                        tFADirectory.setCollectionPolicy(string6);
                    }
                    tFADirectory.setCollectAll(bl2);
                    DbManager.getInstance().getDbPut().storeTFADirectoryEntity(tFADirectory);
                    DirectoryMappings.getInstance().resetMappings();
                    Output.printTrace("Successfully added directory : " + string + "|" + list + "|" + cloneable + "|" + string2 + "|" + string3, 3);
                    string8 = "SUCCESS";
                    hashSet.add(string);
                } else {
                    string8 = "FAILED. Unable to determine component from directory : " + string;
                    return string8;
                }
            }
            cloneable = new ArrayList();
            boolean bl4 = false;
            for (Map<String, String> map : list3) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                stringArray = map.get("directory").trim();
                String string10 = TFADirectoryManager.getTFADirectory((String)stringArray, tFADirectoryDA.pIdx);
                boolean bl5 = false;
                ArrayList<String> arrayList = new ArrayList<String>();
                if (string10 == null) {
                    for (String string11 : map.keySet()) {
                        String[] stringArray3;
                        int n;
                        Object object;
                        String[] stringArray4;
                        if (string11.startsWith("comps")) {
                            list = new ArrayList<String>();
                            if (map.get(string11).contains(Properties.TFAARGSEP)) {
                                object = stringArray4 = map.get(string11).split(Properties.TFAARGSEP);
                                int n2 = ((String[])object).length;
                                for (n = 0; n < n2; ++n) {
                                    stringArray3 = object[n];
                                    list.add(stringArray3.trim());
                                }
                            } else {
                                list.add(map.get(string11).trim());
                            }
                        }
                        if (string11.startsWith("component") && map.get(string11).contains("%")) {
                            stringArray4 = map.get(string11).split("%");
                            object = stringArray4[0].trim();
                            ComponentEntity componentEntity = new ComponentEntity((String)object, string9);
                            if (stringArray4.length > 1) {
                                for (n = 1; n < stringArray4.length; ++n) {
                                    stringArray3 = stringArray4[n].trim().split("\\|");
                                    if (stringArray3 == null || stringArray3.length != 2) continue;
                                    hashMap.put((String)object + "|" + stringArray3[0], stringArray3[1]);
                                    componentEntity.addSubComponent(stringArray3[0], stringArray3[1]);
                                    if (stringArray3[0].equals("database")) {
                                        string2 = stringArray3[1];
                                    }
                                    if (!stringArray3[0].equals("instance")) continue;
                                    string3 = stringArray3[1];
                                }
                            }
                            try {
                                Output.printTrace("Storing " + (String)object + ":" + componentEntity.getSubComponents(), 3);
                                componentEntity.store();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (string11.startsWith("collectall")) {
                            bl5 = true;
                        }
                        if (!string11.startsWith("patterns") || (object = (stringArray4 = map.get("patterns")).split(",")) == null || ((String[])object).length <= 0) continue;
                        Object object2 = object;
                        n = ((String[])object2).length;
                        for (int i = 0; i < n; ++i) {
                            String string12 = object2[i];
                            arrayList.add(string12);
                        }
                    }
                    if (hashMap.size() == 0) {
                        hashMap = null;
                    }
                    Object object = null;
                    object = new TFADirectory((String)stringArray, string2, string3, list, string4, hashMap);
                    if (bl) {
                        ((TFADirectory)object).setPermission("private");
                    }
                    ((TFADirectory)object).setOwner(string5);
                    if (stringArray.matches(".*" + File.separator + "cdump")) {
                        ((TFADirectory)object).setCollectionPolicy("noexclusions");
                    } else {
                        ((TFADirectory)object).setCollectionPolicy(string6);
                    }
                    ((TFADirectory)object).setCollectAll(bl2);
                    if (bl5) {
                        ((TFADirectory)object).setCollectAll(bl5);
                        ((TFADirectory)object).setCollectionPolicy("collectall");
                    }
                    ((TFADirectory)object).setInvPatterns(arrayList);
                    DbManager.getInstance().getDbPut().storeTFADirectoryEntity((TFADirectory)object);
                    DirectoryMappings.getInstance().resetMappings();
                    Output.printTrace("Successfully added directory : " + (String)stringArray + "|" + list + "|" + hashMap + "|" + string2 + "|" + string3, 3);
                    cloneable.add(stringArray);
                    string8 = "SUCCESS";
                } else {
                    Output.printTrace("Directory is already present in TFA : " + (String)stringArray, 3);
                    tFADirectory = (TFADirectory)tFADirectoryDA.pIdx.get((Object)string10);
                    TFADirectoryManager.updateOnPatch(tFADirectory, list, string6);
                    bl4 = true;
                }
                string2 = "";
                string3 = "";
            }
            if (bl3) {
                if (list3.size() > 0) {
                    if (cloneable.size() == 0) {
                        if (bl4) {
                            printWriter.println("Directory or sub directories already present in TFA");
                        }
                        printWriter.println("No directories were added to TFA");
                        string8 = "FAILED";
                    } else {
                        hashSet = new HashSet(cloneable);
                        printWriter.println("The following directories were added to TFA: ");
                        Iterator iterator = cloneable.iterator();
                        while (iterator.hasNext()) {
                            String string13 = (String)iterator.next();
                            printWriter.println(string13);
                        }
                    }
                }
                if (string8.equalsIgnoreCase("SUCCESS")) {
                    printWriter.println("Running Inventory ...");
                    Output.printTrace("Running Inventory after successful addition of directory ...", 3);
                    TFADirectoryManager.runInventoryThread(hashSet);
                }
            }
        } else {
            tFADirectory = (TFADirectory)tFADirectoryDA.pIdx.get((Object)string7);
            TFADirectoryManager.updateOnPatch(tFADirectory, list, string6);
            Output.printTrace("Directory is already present in TFA : " + string, 3);
            if (printWriter != null) {
                try {
                    oprint.print("TFA10509", string);
                }
                catch (IOException iOException) {
                    throw new IOException(iOException.getMessage());
                }
            }
            string8 = "FAILED : Directory is already present in TFA : " + string;
        }
        return string8;
    }

    public static String removeDirectory(String string, PrintWriter printWriter, boolean bl) {
        Oprint oprint = new Oprint("en-US", "en", "UTF-8", "US");
        boolean bl2 = false;
        String string2 = new Host().getHostname().trim();
        File file = new File(Properties.removedDirectoriesFile);
        if (!bl && !file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                Output.printTrace("Error while creating " + Properties.removedDirectoriesFile, 3);
            }
        }
        Transaction transaction = null;
        String string3 = "DONE";
        String string4 = null;
        try {
            Object object;
            PrimaryIndex primaryIndex;
            block20: {
                transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
                CursorConfig cursorConfig = new CursorConfig();
                cursorConfig.setReadUncommitted(true);
                EntityStore entityStore = DbManager.getInstance().getEntityStore();
                primaryIndex = entityStore.getPrimaryIndex(String.class, TFADirectory.class);
                string = string.trim();
                try {
                    string4 = TFADirectoryManager.getTFADirectory(string, (PrimaryIndex<String, TFADirectory>)primaryIndex);
                    if (string4 != null) {
                        Output.printTrace("Removing Directory: " + string4, 3);
                        boolean bl3 = primaryIndex.delete((Object)string4);
                        if (bl3) {
                            Output.printTrace("Directory: " + string + " deleted", 3);
                            string3 = "SUCCESS";
                            if (!bl) {
                                object = new BufferedWriter(new FileWriter(file, true));
                                ((Writer)object).write(string2 + "%" + string + "\n");
                                ((BufferedWriter)object).close();
                                bl2 = true;
                            }
                            DirectoryMappings.getInstance().resetMappings();
                        } else {
                            string3 = "FAILED : Directory: " + string + " *NOT* deleted";
                        }
                    } else {
                        string3 = "FAILED : Directory not found in TFA";
                    }
                    transaction.commit();
                    transaction = null;
                }
                catch (IOException iOException) {
                    Output.print("TFADirectoryManager : IOException encountered while writing to removed directory file in removeDirectory");
                }
                catch (Exception exception) {
                    Output.print("TFADirectoryManager : Exception encountered in remove directory for " + string);
                    exception.printStackTrace();
                    if (transaction == null) break block20;
                    transaction.abort();
                    transaction = null;
                }
            }
            if (!bl) {
                EntityCursor entityCursor = primaryIndex.entities();
                object = new File(string);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Object object2 : entityCursor) {
                    File object3 = new File(((TFADirectory)object2).getDirectoryPath());
                    if (!TFADirectoryManager.isChild((File)object, object3)) continue;
                    arrayList.add(((TFADirectory)object2).getDirectoryPath());
                }
                entityCursor.close();
                if (arrayList.size() > 0) {
                    if (printWriter != null) {
                        printWriter.println();
                        printWriter.println("The following directories will be removed from TFA in node " + string2);
                        for (String string5 : arrayList) {
                            printWriter.println(string5);
                        }
                        printWriter.println();
                    }
                    if (string4 == null) {
                        Object object2;
                        object2 = new BufferedWriter(new FileWriter(file, true));
                        ((Writer)object2).write(string2 + "%" + string + "\n");
                        ((BufferedWriter)object2).close();
                    }
                    return "FAILED : Subdirectories found in TFA in node " + string2;
                }
                if (bl2) {
                    TFADirectoryManager.updateInventory();
                }
            }
        }
        catch (Exception exception) {
            Output.print("TFADirectoryManager : Exception encountered in delete directory for " + string);
            exception.printStackTrace();
        }
        return string3;
    }

    public static String modifyDirectoryPermission(String string, String string2, String string3, boolean bl) {
        EntityStore entityStore = DbManager.getInstance().getEntityStore();
        PrimaryIndex primaryIndex = entityStore.getPrimaryIndex(String.class, TFADirectory.class);
        string = string.trim();
        if (string2.startsWith("-")) {
            string2 = string2.replace("-", "").trim();
        } else if (string2.equals("")) {
            string2 = null;
        }
        if (string3 != null && string3.startsWith("-")) {
            string3 = string3.replace("-", "").trim();
        }
        String string4 = "DONE";
        LogFile.writeLog("Inside TFADirectoryManager : " + string2 + " " + string3 + " " + bl);
        try {
            Output.printTrace("Inside modify dir permission : " + string + " ... " + string2, 3);
            TFADirectory tFADirectory = TFADirectoryManager.getTFADirectoryEntity(string, (PrimaryIndex<String, TFADirectory>)primaryIndex);
            Output.printTrace("directory entity : " + tFADirectory, 3);
            Output.printTrace("directory path : " + TFADirectoryManager.getTFADirectory(string, (PrimaryIndex<String, TFADirectory>)primaryIndex), 3);
            if (tFADirectory != null) {
                if (string2 != null && string3 != null) {
                    if (tFADirectory.getPermission().equals(string2) && tFADirectory.getCollectionPolicy().equals(string3)) {
                        string4 = "FAILED. TRYING TO SET PERMISSION AND COLLECTION POLICY TO SAME VALUES";
                    } else if (tFADirectory.getPermission().equals(string2)) {
                        tFADirectory.setCollectionPolicy(string3);
                        tFADirectory.setCollectAll(false);
                        DbManager.getInstance().getDbPut().storeTFADirectoryEntity(tFADirectory);
                        DirectoryMappings.getInstance().resetMappings();
                        string4 = "SUCCESS. UPDATED COLLECTION POLICY";
                    } else if (tFADirectory.getCollectionPolicy().equals(string3)) {
                        tFADirectory.setPermission(string2);
                        DbManager.getInstance().getDbPut().storeTFADirectoryEntity(tFADirectory);
                        DirectoryMappings.getInstance().resetMappings();
                        string4 = "SUCCESS. UPDATED PERMISSION";
                    } else {
                        tFADirectory.setCollectionPolicy(string3);
                        tFADirectory.setPermission(string2);
                        tFADirectory.setCollectAll(false);
                        DbManager.getInstance().getDbPut().storeTFADirectoryEntity(tFADirectory);
                        DirectoryMappings.getInstance().resetMappings();
                        string4 = "SUCCESS. UPDATED PERMISSION AND COLLECTION POLICY";
                    }
                } else if (string2 != null) {
                    if (tFADirectory.getPermission().equals(string2)) {
                        string4 = "FAILED. TRYING TO SET PERMISSION TO SAME VALUE";
                    } else {
                        tFADirectory.setPermission(string2);
                        DbManager.getInstance().getDbPut().storeTFADirectoryEntity(tFADirectory);
                        DirectoryMappings.getInstance().resetMappings();
                        string4 = "SUCCESS. UPDATED PERMISSION";
                    }
                } else if (string3 != null) {
                    if (tFADirectory.getCollectionPolicy().equals(string3)) {
                        string4 = "FAILED. TRYING TO SET COLLECTION POLICY TO SAME VALUE";
                    } else {
                        tFADirectory.setCollectionPolicy(string3);
                        tFADirectory.setCollectAll(false);
                        DbManager.getInstance().getDbPut().storeTFADirectoryEntity(tFADirectory);
                        DirectoryMappings.getInstance().resetMappings();
                        string4 = "SUCCESS. UPDATED COLLECTION POLICY";
                    }
                }
                if (bl) {
                    tFADirectory.setCollectAll(bl);
                    tFADirectory.setCollectionPolicy("collectall");
                    string4 = "SUCCESS. UPDATED COLLECTALL TRUE";
                    DbManager.getInstance().getDbPut().storeTFADirectoryEntity(tFADirectory);
                    DirectoryMappings.getInstance().resetMappings();
                }
            } else {
                string4 = "FAILED. DIRECTORY DOES NOT EXIST IN TFA.";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string4;
    }

    private static void updateInventory() {
        Output.printTrace("Updating inventory after directory removal...", 3);
        Vector<String> vector = new Vector<String>();
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(FileEntity.class);
        EntityCursor entityCursor = primaryIndex.entities();
        for (FileEntity object : entityCursor) {
            String string = object.getBaseDirectory();
            if (string == null || !DirectoryMappings.getInstance().lookForDeletedDirectory(string)) continue;
            vector.add(object.getFileName());
        }
        entityCursor.close();
        for (String string : vector) {
            boolean bl = primaryIndex.delete((Object)string);
            if (!bl) continue;
            Output.printTrace("Successfully deleted file : " + string, 3);
        }
    }

    public static String removeSubDirectories(String string, PrintWriter printWriter) throws IOException {
        Iterator iterator;
        String string22;
        Serializable serializable;
        Object object2;
        Oprint oprint = new Oprint("en-US", "en", "UTF-8", "US");
        boolean bl = false;
        EntityStore entityStore = DbManager.getInstance().getEntityStore();
        PrimaryIndex primaryIndex = entityStore.getPrimaryIndex(String.class, TFADirectory.class);
        string = string.trim();
        String string3 = "DONE";
        EntityCursor entityCursor = primaryIndex.entities();
        File file = new File(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : entityCursor) {
            serializable = new File(((TFADirectory)object2).getDirectoryPath());
            if (!TFADirectoryManager.isChild(file, (File)serializable)) continue;
            arrayList.add(((TFADirectory)object2).getDirectoryPath());
        }
        entityCursor.close();
        object2 = new ArrayList();
        serializable = new ArrayList();
        String string4 = new Host().getHostname().trim();
        for (String string22 : arrayList) {
            boolean bl2 = primaryIndex.delete((Object)string22);
            if (bl2) {
                Output.printTrace("Directory: " + string22 + " deleted", 3);
                object2.add(string22);
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(Properties.removedDirectoriesFile), true));
                    bufferedWriter.write(string4 + "%" + string22 + "\n");
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    Output.print("TFADirectoryManager : IOException encountered while writing to removed directories file");
                }
                DirectoryMappings.getInstance().resetMappings();
                bl = true;
                continue;
            }
            serializable.add(string22);
        }
        if (object2.size() > 0) {
            try {
                oprint.print("TFA11697");
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                string22 = (String)iterator.next();
                printWriter.println(string22);
            }
        }
        if (serializable.size() > 0) {
            try {
                oprint.print("10746");
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
            iterator = serializable.iterator();
            while (iterator.hasNext()) {
                string22 = (String)iterator.next();
                printWriter.println(string22);
            }
        }
        if (bl) {
            TFADirectoryManager.updateInventory();
        }
        return string3;
    }

    public static boolean isChild(File file, File file2) {
        for (File file3 = file2.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
            if (!file3.equals(file)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getDirectoriesWithCollectAll(Map<String, List<String>> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (EntityCursor entityCursor = null;){
            DbGet dbGet = DbManager.getInstance().getDbGet();
            EntityStore entityStore = dbGet.getStore();
            if (entityStore == null) {
                Output.printTrace("STORE IS NULL", 1);
                ArrayList<String> arrayList2 = arrayList;
                return arrayList2;
            }
            PrimaryIndex primaryIndex = entityStore.getPrimaryIndex(String.class, TFADirectory.class);
            entityCursor = primaryIndex.entities();
            for (TFADirectory tFADirectory : entityCursor) {
                if (!tFADirectory.isCollectAll() || tFADirectory.getComponents() == null) continue;
                for (String string : tFADirectory.getComponents()) {
                    if (!map.containsKey(string.toLowerCase())) continue;
                    LogFile.writeLog("Dir with collectAll set to true : " + tFADirectory.getDirectoryPath() + " component : " + string);
                    arrayList.add(tFADirectory.getDirectoryPath());
                }
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getDirectoriesWithNoExclusions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (EntityCursor entityCursor = null;){
            DbGet dbGet = DbManager.getInstance().getDbGet();
            EntityStore entityStore = dbGet.getStore();
            if (entityStore == null) {
                Output.printTrace("STORE IS NULL", 1);
                ArrayList<String> arrayList2 = arrayList;
                return arrayList2;
            }
            PrimaryIndex primaryIndex = entityStore.getPrimaryIndex(String.class, TFADirectory.class);
            entityCursor = primaryIndex.entities();
            for (TFADirectory tFADirectory : entityCursor) {
                if (!tFADirectory.getCollectionPolicy().equals("noexclusions")) continue;
                arrayList.add(tFADirectory.getDirectoryPath());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpDirectories(PrintWriter printWriter, String string, String string2, String string3) throws IOException {
        EntityCursor entityCursor = null;
        try {
            String[] stringArray;
            DbGet dbGet = DbManager.getInstance().getDbGet();
            EntityStore entityStore = dbGet.getStore();
            if (entityStore == null) {
                Output.printTrace("STORE IS NULL", 1);
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (string != null && !string.equals("")) {
                if (string.contains(",")) {
                    for (String string4 : string.split(",")) {
                        arrayList.add(string4.trim());
                    }
                } else {
                    arrayList.add(string.trim());
                }
            }
            if (arrayList.size() > 0) {
                stringArray = DbManager.getInstance().getAllEntities(TFADirectory.class);
                SecondaryIndex secondaryIndex = DbManager.getInstance().getEntityStore().getSecondaryIndex((PrimaryIndex)stringArray, String.class, "components");
                for (String string4 : arrayList) {
                    EntityIndex entityIndex = secondaryIndex.subIndex((Object)string4.toUpperCase());
                    entityCursor = entityIndex.entities();
                    TFADirectoryManager.printDirectories(printWriter, (EntityCursor<TFADirectory>)entityCursor, string2, string3);
                }
            } else {
                stringArray = entityStore.getPrimaryIndex(String.class, TFADirectory.class);
                entityCursor = stringArray.entities();
                TFADirectoryManager.printDirectories(printWriter, (EntityCursor<TFADirectory>)entityCursor, string2, string3);
            }
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {
                Output.print("TFADirectoryManager : Exception encountered while closing cursor in dumpDirectories");
            }
        }
    }

    public static void printDirectories(PrintWriter printWriter, EntityCursor<TFADirectory> entityCursor, String string, String string2) {
        String string3 = new Host().getHostname().trim();
        for (TFADirectory tFADirectory : entityCursor) {
            if (tFADirectory.getDirectoryPath().contains("cdmp_")) {
                Output.printTrace("Not printing directory : " + tFADirectory.getDirectoryPath(), 3);
                continue;
            }
            if (tFADirectory.getSubcomponents() != null && tFADirectory.getSubcomponents().size() > 0) {
                if (!((string != null && string.length() == 0 && string2 != null && string2.length() == 0) | (string != null && string.length() == 0 && string2 != null && tFADirectory.getPermission().equalsIgnoreCase(string2)) | (string2 != null && string2.length() == 0 && string != null && tFADirectory.getCollectionPolicy().equalsIgnoreCase(string)) | (string != null && tFADirectory.getCollectionPolicy().equalsIgnoreCase(string) && string2 != null && tFADirectory.getPermission().equalsIgnoreCase(string2)))) continue;
                printWriter.println(tFADirectory.getDirectoryPath() + "!" + string3 + "!" + tFADirectory.getComponents() + tFADirectory.getSubComponents() + "!" + tFADirectory.getPermission() + "!" + tFADirectory.owner + "!" + tFADirectory.getCollectionPolicy() + "!" + tFADirectory.isCollectAll());
                continue;
            }
            if (!((string != null && string.length() == 0 && string2 != null && string2.length() == 0) | (string != null && string.length() == 0 && string2 != null && tFADirectory.getPermission().equalsIgnoreCase(string2)) | (string2 != null && string2.length() == 0 && string != null && tFADirectory.getCollectionPolicy().equalsIgnoreCase(string)) | (string != null && tFADirectory.getCollectionPolicy().equalsIgnoreCase(string) && string2 != null && tFADirectory.getPermission().equalsIgnoreCase(string2)))) continue;
            printWriter.println(tFADirectory.getDirectoryPath() + "!" + string3 + "!" + tFADirectory.getComponents() + "!" + tFADirectory.getPermission() + "!" + tFADirectory.owner + "!" + tFADirectory.getCollectionPolicy() + "!" + tFADirectory.isCollectAll());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpDirectoriesinOffline(PrintWriter printWriter) throws IOException {
        Oprint oprint = new Oprint("en-US", "en", "UTF-8", "US");
        EntityCursor entityCursor = null;
        try {
            DbGet dbGet = DbManager.getInstance().getDbGet();
            EntityStore entityStore = dbGet.getStore();
            if (entityStore == null) {
                Output.printTrace("STORE IS NULL", 1);
                return;
            }
            PrimaryIndex primaryIndex = entityStore.getPrimaryIndex(String.class, TFADirectory.class);
            entityCursor = primaryIndex.entities();
            String string = new Host().getHostname().trim();
            int n = 1;
            for (TFADirectory tFADirectory : entityCursor) {
                if (tFADirectory.getDirectoryPath().contains("cdmp_")) {
                    Output.printTrace("Not printing directory : " + tFADirectory.getDirectoryPath(), 3);
                    continue;
                }
                printWriter.println("" + n++ + ". " + tFADirectory.getDirectoryPath());
                printWriter.println(tFADirectory.getComponents());
                if (tFADirectory.getSubcomponents() != null && tFADirectory.getSubcomponents().size() > 0) {
                    printWriter.println(tFADirectory.getSubComponents());
                }
                printWriter.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            }
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {
                Output.print("TFADirectoryManager : Exception encountered while closing cursor in dumpDirectories");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void dumpDirectories() throws IOException {
        EntityCursor entityCursor = null;
        Oprint oprint = new Oprint("en-US", "en", "UTF-8", "US");
        try {
            DbGet dbGet = DbManager.getInstance().getDbGet();
            EntityStore entityStore = dbGet.getStore();
            if (entityStore == null) {
                Output.printTrace("STORE IS NULL", 1);
                return;
            }
            PrimaryIndex primaryIndex = entityStore.getPrimaryIndex(String.class, TFADirectory.class);
            entityCursor = primaryIndex.entities();
            for (TFADirectory tFADirectory : entityCursor) {
                try {
                    System.out.println("Directory to Scan: " + tFADirectory.getDirectoryPath());
                    System.out.println("  --> Component: " + tFADirectory.getComponents());
                    System.out.println("  --> Cluster: " + tFADirectory.cluster);
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                    return;
                }
            }
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {
                Output.print("TFADirectoryManager : Exception encountered while closing cursor in dumpDirectories");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getDirectoryMappings() {
        Vector<DirectoryMappingType> vector = new Vector<DirectoryMappingType>();
        EntityCursor entityCursor = null;
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFADirectory.class);
            entityCursor = primaryIndex.entities();
            for (TFADirectory tFADirectory : entityCursor) {
                vector.add(tFADirectory.getDatabaseMapping());
            }
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
        return vector;
    }

    public static String addFromFileLine(String string) throws IOException {
        ArrayList<String> arrayList;
        Object object;
        String[] stringArray;
        String string2 = "FAILED";
        String string3 = string.split("=")[1];
        if ((string3 = new File(string3).getCanonicalPath()).equals(File.separator) || string3.equals(File.separator + "usr") || string3.startsWith(File.separator + "usr" + File.separator + "bin") || string3.startsWith(File.separator + "usr" + File.separator + "sbin") || string3.startsWith(File.separator + "usr" + File.separator + "local") || string3.startsWith(File.separator + "usr" + File.separator + "local" + File.separator + "bin") || string3.startsWith(File.separator + "bin") || string3.startsWith(File.separator + "boot") || string3.startsWith(File.separator + "var") && !string3.startsWith(File.separator + "var" + File.separator + "log") && !string3.startsWith(File.separator + "var" + File.separator + "opt") && !string3.startsWith(File.separator + "var" + File.separator + "adm") && !string3.startsWith(File.separator + "var" + File.separator + "opt" + File.separator + "oracle") || string3.startsWith(File.separator + "etc") && !string3.startsWith(File.separator + "etc" + File.separator + "oracle") || string3.equals(File.separator + "opt") || string3.startsWith(File.separator + "dev") || string3.startsWith(File.separator + "lib") || string3.startsWith(File.separator + "lib64") || string3.startsWith(File.separator + "media") || string3.startsWith(File.separator + "misc") || string3.startsWith(File.separator + "root") || string3.startsWith(File.separator + "net") && !Pattern.matches("/net/[^//]+/[^//]+.*", string3) || string3.startsWith(File.separator + "proc") || string3.startsWith(File.separator + "sbin") || string3.startsWith(File.separator + "selinux") || string3.startsWith(File.separator + "srv") || string3.startsWith(File.separator + "tmp")) {
            return string2;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (new File(Properties.removedDirectoriesFile).exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(Properties.removedDirectoriesFile));
                while ((stringArray = bufferedReader.readLine()) != null) {
                    arrayList2.add(stringArray.split("%")[1]);
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Output.print("TFADirectoryManager : FileNotFoundException encountered in addFromFileLine");
            }
            catch (IOException iOException) {
                Output.print("TFADirectoryManager : IOException encountered in addFromFileLine");
            }
        }
        Output.printTrace("adding Directory from line :" + string, 3);
        stringArray = string.split("%");
        String string4 = stringArray[0];
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "exclusions";
        boolean bl = false;
        if (stringArray.length > 1) {
            string5 = stringArray[1];
        }
        if (stringArray.length > 3) {
            string8 = stringArray[3];
        }
        if (stringArray.length > 4 && stringArray[4].equalsIgnoreCase("collectAll")) {
            bl = true;
            string8 = "collectall";
        }
        if (string5.contains("|")) {
            object = string5.split("\\|");
            if (((String[])object).length == 3) {
                string5 = object[0];
                string6 = object[1];
                string7 = object[2];
            } else if (((String[])object).length == 2) {
                string5 = object[0];
                string7 = object[1];
            }
        }
        Output.printTrace("resource : " + string5 + " database : " + string6 + " instance : " + string7, 3);
        object = string.substring(string.indexOf("=") + 1);
        if (((String)object).endsWith(File.separator)) {
            if (arrayList2.contains(object)) {
                return string2;
            }
            if (arrayList2.contains(((String)object).substring(0, ((String)object).length() - 1))) {
                return string2;
            }
        } else {
            if (arrayList2.contains(object)) {
                return string2;
            }
            if (arrayList2.contains((String)object + File.separator)) {
                return string2;
            }
        }
        if (((String)object).matches(".*" + File.separator + "cdump")) {
            string8 = "noexclusions";
        }
        String string9 = "";
        if (Global.offlineMode.booleanValue()) {
            Properties.getInstance();
            string9 = Properties.getSrOrBugNum();
        }
        Host host = new Host();
        String string10 = host.getHostname().trim();
        if (Global.offlineMode.booleanValue()) {
            Output.printTrace("Node: " + string4 + " Resource : " + string5 + " Directory : " + (String)object + " SrNum : " + string9, 3);
        } else {
            Output.printTrace("Node: " + string4 + " Resource : " + string5 + " Directory : " + (String)object, 3);
        }
        if (!new File((String)object).exists()) {
            Output.printTrace("Directory " + (String)object + " does not exist. Could not add directory to TFA.", 3);
            return string2;
        }
        if (!new File((String)object).isDirectory()) {
            Output.printTrace("Directory " + (String)object + " is not a directory. Could not add " + (String)object + " to TFA.", 1);
            return string2;
        }
        if (string4.contentEquals(string10)) {
            Output.printTrace("Adding Directory as it is for this host", 3);
            arrayList = new ArrayList<String>();
            if (!string5.equals("")) {
                arrayList.add(string5);
            }
            string2 = TFADirectoryManager.addDirectory((String)object, string6, string7, arrayList, "", false, "root", string8, bl);
        }
        if (string4.contentEquals("localnode")) {
            Output.printTrace("Adding Directory - localnode passed - storing: " + string10, 3);
            arrayList = new ArrayList();
            if (!string5.equals("")) {
                arrayList.add(string5);
            }
            string2 = TFADirectoryManager.addDirectory((String)object, string6, string7, arrayList, string9, false, "root", string8, bl);
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        Omsg omsg = new Omsg("en-US", "en", "UTF-8", "US");
        if (stringArray.length > 6) {
            System.err.println("Not Enough Arguments");
            System.exit(1);
        }
        Properties properties = Properties.getInstance("C:/tfa_home");
        try {
            TFADirectoryManager.addDirectory("C:/temp/alert", "mydb", "myinstance", null, "", false, "root", "exclusions", false);
            TFADirectoryManager.dumpDirectories();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Map<String, String> getDirectoryMapping(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            for (DirectoryPattern directoryPattern : DirectoryMappings.getInstance().getValidDirectoryPatterns()) {
                String string2 = directoryPattern.getDirPathPattern();
                Pattern pattern = Pattern.compile(string2);
                Matcher matcher = pattern.matcher(string);
                if (!matcher.find()) continue;
                hashMap.put("directory", string);
                if (directoryPattern.isCollectAll()) {
                    hashMap.put("collectall", "true");
                }
                String string3 = "";
                String string4 = "";
                int n = 0;
                for (Component component : directoryPattern.getComponents()) {
                    ++n;
                    String string5 = component.getComponentName();
                    string4 = string4 + string5 + ":";
                    String string6 = null;
                    if (component.getFilePattern() != null) {
                        string6 = component.getFilePattern();
                    }
                    if (component.getSubCompRegex() != null) {
                        for (Map.Entry<String, Integer> exception : component.getSubCompRegex().entrySet()) {
                            Object object;
                            Object object2;
                            Integer n2;
                            String string7 = exception.getKey();
                            if (string6 == null || string6 != null && !string6.equals(string7)) {
                                n2 = exception.getValue();
                                object2 = matcher.group(n2);
                                Output.printTrace("The key is: " + string7 + ",value is :" + (String)object2, 3);
                                string5 = string5 + "%" + string7 + "|" + (String)object2;
                                continue;
                            }
                            n2 = FileFilterUtils.suffixFileFilter((String)".trc");
                            object2 = FileUtils.iterateFiles((File)new File(string), (IOFileFilter)n2, (IOFileFilter)TrueFileFilter.INSTANCE);
                            String string8 = "";
                            if (object2.hasNext()) {
                                object = (File)object2.next();
                                string8 = ((File)object).getName();
                            }
                            object = string8.substring(0, string8.indexOf("."));
                            Output.printTrace("The subCompFileBased is: " + string6 + ",value is :" + (String)object, 3);
                            string5 = string5 + "%" + string6 + "|" + (String)object;
                        }
                    }
                    hashMap.put("component" + n, string5);
                    if (component.getInventoryPattern() == null || component.getInventoryPattern().size() <= 0) continue;
                    for (String string9 : component.getInventoryPattern()) {
                        string3 = string3 + "," + string9;
                    }
                    ComponentFilePattern componentFilePattern = new ComponentFilePattern(component.getComponentName(), string, component.getInventoryPattern());
                    try {
                        componentFilePattern.store();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                string4 = string4.substring(0, string4.length() - 1);
                hashMap.put("comps", string4);
                if (!string3.equals("")) {
                    hashMap.put("patterns", string3);
                }
                break;
            }
        }
        catch (Exception exception) {
            Output.printTrace("Exception in getDirectoryMapping() for path : " + string + " " + exception.getMessage(), 1);
        }
        return hashMap;
    }

    private static List<Map<String, String>> getDirectoryInformation(String string) {
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue(1000);
        GetValidDirsThread getValidDirsThread = new GetValidDirsThread("GetValidDirs", string, linkedBlockingQueue);
        getValidDirsThread.start();
        Output.printTrace("Started new getValidDrs thread", 3);
        while (getValidDirsThread.isAlive() || !linkedBlockingQueue.isEmpty()) {
            try {
                String string2 = (String)linkedBlockingQueue.poll(1L, TimeUnit.SECONDS);
                Output.printTrace("Taking path " + string2 + " from dirs Queue.", 3);
                if (string2 == null) continue;
                Map<String, String> map = TFADirectoryManager.getDirectoryMapping(string2);
                Output.printTrace("Dir Mapping size = " + map.size(), 3);
                if (map.size() <= 0) continue;
                Output.printTrace("dmp: " + map, 3);
                if (!TFADirectoryManager.childDirComponent(string2.trim(), map.get("comps"), arrayList)) continue;
                arrayList.add(map);
            }
            catch (InterruptedException interruptedException) {
                Output.printTrace("Interrupted processing valid dirs...", 3);
                getValidDirsThread.interrupt();
            }
            catch (Exception exception) {
                Output.printTrace("Exception: " + exception.getMessage() + " Failed process Valid Dirs", 3);
            }
        }
        if (arrayList.size() == 0) {
            Output.printTrace("Adding directory " + string + " to Global list of directoriesWithNoMappings", 3);
            Global.directoriesWithNoMappings.add(string);
        }
        return arrayList;
    }

    private static File[] getChildDirectories(String string) {
        Output.printTrace("Getting Child Dirs For : " + string, 3);
        File file = new File(string);
        Object object = file.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        if (object != null) {
            Output.printTrace("Number of Children : " + ((File[])object).length, 3);
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File file2 : object) {
                if (TFADirectoryManager.isSymLinkToCurDir(file2, file)) continue;
                arrayList.add(file2);
            }
            object = arrayList.size() > 0 ? arrayList.toArray(new File[arrayList.size()]) : null;
        }
        return object;
    }

    private static boolean isSymLinkToCurDir(File file, File file2) {
        boolean bl = false;
        try {
            String string = file.getAbsolutePath();
            String string2 = file.getCanonicalPath();
            Output.printTrace("isSymLinkToCurDir : Absolute Path : " + string + " Canonical Path : " + string2, 3);
            if (!string.equals(string2)) {
                String string3 = file2.getCanonicalPath();
                Output.printTrace("isSymLinkToCurDir : Canonical Path of Parent Directory : " + string3, 3);
                if (string2.equals(string3)) {
                    bl = true;
                }
            }
        }
        catch (IOException iOException) {
            Output.print("TFADirectoryManager : IOException encountered in isSymLinkToCurDir for " + file.getAbsolutePath());
        }
        Output.printTrace("isSymLinkToCurDir Status : " + bl, 3);
        return bl;
    }

    static void checkDirectory(String string, String string2) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        String string3 = new Host().getHostname();
        File file = string2.endsWith(File.separator) ? new File(string2 + "tfa_tmp_" + string3) : new File(string2 + File.separator + "tfa_tmp_" + string3);
        String string4 = new Host().getHostname() + ":donecheckingdirectory:" + string2 + ":" + file.exists();
        Output.printTrace("Making Socket connection to :" + string, 3);
        Properties.getInstance();
        String string5 = Properties.trustStore;
        Properties.getInstance();
        String string6 = Properties.trustStorePassword;
        try {
            sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string5, string6);
            printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
            printWriter.println(string4);
            if (!sSLSocket.isClosed()) {
                sSLSocket.close();
            }
        }
        catch (IOException iOException) {
            Output.print("TFADirectoryManager : IOException encountered in checkDirectory for " + string2);
        }
    }

    static void doneChecking(String string, String string2) {
        String[] stringArray = string2.split(Properties.TFAARGSEP);
        String string3 = stringArray[0].trim();
        String string4 = stringArray[1].trim();
        TFADirectory tFADirectory = null;
        if (string4.equalsIgnoreCase("true")) {
            EntityStore entityStore = DbManager.getInstance().getEntityStore();
            TFADirectoryDA tFADirectoryDA = new TFADirectoryDA(entityStore);
            tFADirectory = (TFADirectory)tFADirectoryDA.pIdx.get((Object)string3);
            if (tFADirectory != null) {
                tFADirectory.addSharedHost(string);
            }
        }
        if (tFADirectory != null) {
            // empty if block
        }
    }

    private static void setValidDirs(String string, final LinkedBlockingQueue linkedBlockingQueue) {
        Output.printTrace("In Set Valid Dirs For: " + string, 3);
        if (validDirs == null) {
            validDirs = new Vector();
        }
        Output.printTrace("Adding " + string + " To directories Queue", 3);
        count = 0L;
        try {
            Files.walkFileTree(FileSystems.getDefault().getPath(string, new String[0]), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    try {
                        Output.printTrace("Adding " + path.toString() + " to directories Queue", 3);
                        ++count;
                        linkedBlockingQueue.offer(path.toString(), 5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        Output.print("Exception while adding directory " + path.toString() + " to directories Queue");
                        interruptedException.printStackTrace();
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            Output.print("Exception while adding directory " + string + " to TFA");
            iOException.printStackTrace();
        }
        Output.printTrace("Total directories added to directories Queue : " + count, 3);
    }

    public static String getTFADirectory(String string, PrimaryIndex<String, TFADirectory> primaryIndex) {
        try {
            TFADirectory tFADirectory = (TFADirectory)primaryIndex.get((Object)string);
            if (tFADirectory == null) {
                tFADirectory = string.endsWith(File.separator) ? (TFADirectory)primaryIndex.get((Object)string.substring(0, string.length() - 1)) : (TFADirectory)primaryIndex.get((Object)(string + File.separator));
            }
            if (tFADirectory != null) {
                return tFADirectory.getDirectoryPath();
            }
        }
        catch (Exception exception) {
            Output.printTrace("Exception in getTFADirectory for dirPath: " + string, 1);
        }
        return null;
    }

    private static TFADirectory getTFADirectoryEntity(String string, PrimaryIndex<String, TFADirectory> primaryIndex) {
        try {
            TFADirectory tFADirectory = (TFADirectory)primaryIndex.get((Object)string);
            if (tFADirectory == null) {
                tFADirectory = string.endsWith(File.separator) ? (TFADirectory)primaryIndex.get((Object)string.substring(0, string.length() - 1)) : (TFADirectory)primaryIndex.get((Object)(string + File.separator));
            }
            if (tFADirectory != null) {
                return tFADirectory;
            }
        }
        catch (Exception exception) {
            Output.printTrace("Exception in getTFADirectoryEntity for dirPath: " + string, 1);
        }
        return null;
    }

    public static void dumpDirectoriesWithNoMappings() {
        try {
            FileWriter fileWriter = new FileWriter(Properties.directoriesWithNoMappings);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("<?xml version=\"1.0\" ?>\n");
            bufferedWriter.write("<directories>\n");
            for (String string : Global.directoriesWithNoMappings) {
                Output.printTrace("Writing directory " + string + " to directoriesWithNoMappings.xml", 3);
                bufferedWriter.write("<directory>\n");
                bufferedWriter.write("<dirPath>" + string + "</dirPath>\n");
                bufferedWriter.write("</directory>\n");
            }
            bufferedWriter.write("</directories>\n");
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean childDirComponent(String string, String string2, List<Map<String, String>> list) {
        boolean bl = true;
        for (Map<String, String> map : list) {
            if (!string.contains(map.get("directory").trim())) continue;
            for (String string3 : Arrays.asList(string2.split(Properties.TFAARGSEP))) {
                if (!map.get("comps").contains(string3)) continue;
                bl = false;
            }
        }
        if (bl) {
            Output.printTrace("isChildCompDiff :" + string, 3);
        }
        return bl;
    }

    private static void updateOnPatch(TFADirectory tFADirectory, List<String> list, String string) {
        if (tFADirectory.getComponents() == null || tFADirectory.getComponents().size() == 0) {
            Map<String, String> map = TFADirectoryManager.getDirectoryMapping(tFADirectory.getDirectoryPath());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string2 : map.keySet()) {
                int n;
                String[] stringArray;
                if (string2.startsWith("comps")) {
                    list = new ArrayList<String>();
                    if (map.get(string2).contains(Properties.TFAARGSEP)) {
                        String[] stringArray2 = stringArray = map.get(string2).split(Properties.TFAARGSEP);
                        n = stringArray2.length;
                        for (int i = 0; i < n; ++i) {
                            String string3 = stringArray2[i];
                            list.add(string3.trim());
                        }
                    } else {
                        list.add(map.get(string2).trim());
                    }
                }
                if (string2.startsWith("component") && map.get(string2).contains("%")) {
                    stringArray = map.get(string2).split("%");
                    String string4 = stringArray[0].trim();
                    if (stringArray.length > 1) {
                        for (n = 1; n < stringArray.length; ++n) {
                            String[] stringArray3 = stringArray[n].trim().split("\\|");
                            if (stringArray3 == null || stringArray3.length != 2) continue;
                            hashMap.put(string4 + "|" + stringArray3[0], stringArray3[1]);
                        }
                    }
                }
                if (!string2.startsWith("collectall")) continue;
                tFADirectory.setCollectAll(true);
                tFADirectory.setCollectionPolicy("collectall");
                string = "collectall";
            }
            tFADirectory.setComponents(list);
            if (hashMap.size() > 0) {
                tFADirectory.setSubcomponents(hashMap);
            }
            Output.printTrace("Successfully updated directory : " + tFADirectory.getDirectoryPath() + "|" + list + "|" + hashMap + "|" + tFADirectory.getDatabase() + "|" + tFADirectory.getInstance(), 3);
        }
        if (tFADirectory.getCollectionPolicy() == null) {
            LogFile.writeLog("Setting collectionPolicy of " + tFADirectory.getDirectoryPath() + " to : " + string);
            tFADirectory.setCollectionPolicy(string);
        }
        DbManager.getInstance().getDbPut().storeTFADirectoryEntity(tFADirectory);
        DirectoryMappings.getInstance().resetMappings();
    }

    static {
        validDirs = null;
    }

    private static class GetValidDirsThread
    extends Thread {
        private String directoryName;
        private LinkedBlockingQueue dirsQueue;

        private GetValidDirsThread(String string, String string2, LinkedBlockingQueue linkedBlockingQueue) {
            super(string);
            this.directoryName = string2;
            this.dirsQueue = linkedBlockingQueue;
        }

        @Override
        public void run() {
            Output.printTrace("Entering getValidDirsThread for " + this.directoryName, 3);
            TFADirectoryManager.setValidDirs(this.directoryName, this.dirsQueue);
            Output.printTrace("Finished getValidDirsThread for " + this.directoryName, 3);
        }
    }
}

