/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DataAccessor.TFAUserDA;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.TFAHost;
import oracle.rat.tfa.entity.TFAUser;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.ssh.KeyGen;
import oracle.rat.tfa.util.FileHelper;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;
import oracle.rat.tfa.util.Utilities;
import org.apache.commons.io.FileUtils;

public class TFAAccessManager {
    public static void listTFAUsers(PrintWriter printWriter) throws DatabaseException {
        List<TFAUser> list = TFAAccessManager.getAllUsers();
        String string = new Host().getHostname().trim();
        if (list != null) {
            try {
                for (TFAUser tFAUser : list) {
                    if (!Utilities.isUserExists(tFAUser.getUserName())) continue;
                    printWriter.println(string + "!" + tFAUser.getUserName() + "!" + tFAUser.getUserType() + "!" + tFAUser.isAllowed());
                }
            }
            catch (Exception exception) {
                Output.print("TFAAccessManager: Exception in listTFAUsers: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private static void addTFAUser(TFAUser tFAUser) {
        new TFAUserDA().pIdx.put((Object)tFAUser);
    }

    public static boolean addTFAUser(String string, String string2, boolean bl) {
        TFAUser tFAUser = new TFAUser(string, string2, bl);
        boolean bl2 = false;
        try {
            TFAAccessManager.addTFAUser(tFAUser);
            if (string2.equals("USER")) {
                TFAAccessManager.createKeysForUser(string);
                TFAAccessManager.createDirsForUser(string);
            }
            LogFile.writeLog("TFAAccessManager: Added access to user '" + tFAUser.getUserName() + "'");
            bl2 = true;
        }
        catch (Exception exception) {
            Output.print("TFAAccessManager: Unable to add User '" + tFAUser.getUserName() + "'");
        }
        return bl2;
    }

    public static boolean removeTFAUser(String string) {
        TFAUser tFAUser = TFAAccessManager.getTFAUser(string.trim());
        boolean bl = false;
        if (tFAUser != null) {
            bl = TFAAccessManager.removeTFAUser(tFAUser);
            if (bl && tFAUser.getUserType().equals("USER")) {
                LogFile.writeLog("TFAAccessManager: Removing keys for user " + tFAUser.getUserName());
                TFAAccessManager.removeKeysForUser(tFAUser.getUserName());
            }
            LogFile.writeLog("TFAAccessManager: Removing access for '" + tFAUser.getUserName() + "', Status : " + bl);
        }
        return bl;
    }

    private static boolean removeTFAUser(TFAUser tFAUser) {
        return new TFAUserDA().pIdx.delete((Object)tFAUser.getUserName());
    }

    public static boolean blockTFAUser(String string) {
        TFAUser tFAUser = TFAAccessManager.getTFAUser(string);
        boolean bl = false;
        if (tFAUser != null) {
            tFAUser.setAllowed(false);
            TFAAccessManager.addTFAUser(tFAUser);
            bl = true;
            LogFile.writeLog("TFAAccessManager: Access blocked for '" + tFAUser.getUserName() + "', Status : " + bl);
        }
        return bl;
    }

    public static boolean unblockTFAUser(String string) {
        TFAUser tFAUser = TFAAccessManager.getTFAUser(string);
        boolean bl = false;
        if (tFAUser != null && !tFAUser.isAllowed()) {
            tFAUser.setAllowed(true);
            TFAAccessManager.addTFAUser(tFAUser);
            bl = true;
            LogFile.writeLog("TFAAccessManager: Access unblocked for '" + tFAUser.getUserName() + "', Status : " + bl);
        }
        return bl;
    }

    public static TFAUser getTFAUser(String string) {
        return (TFAUser)new TFAUserDA().pIdx.get((Object)string.trim());
    }

    public static List<TFAUser> getAllUsers() {
        ArrayList<TFAUser> arrayList = new ArrayList<TFAUser>();
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(String.class, TFAUser.class);
            EntityCursor entityCursor = primaryIndex.entities();
            for (TFAUser tFAUser : entityCursor) {
                arrayList.add(tFAUser);
            }
            entityCursor.close();
        }
        catch (Exception exception) {
            Output.print("TFAAccessManager: Exception in getAllUsers: " + exception.getMessage());
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static boolean removeAllTFAUsers() {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(String.class, TFAUser.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (TFAUser tFAUser : entityCursor) {
                    LogFile.writeLog("TFAAccessManager: Removing Access for '" + tFAUser.getUserName() + "'");
                    primaryIndex.delete((Object)tFAUser.getUserName());
                    if (!tFAUser.getUserType().equals("USER")) continue;
                    TFAAccessManager.removeKeysForUser(tFAUser.getUserName());
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
                bl = true;
            }
            catch (Exception exception) {
                Output.print("TFAAccessManager: Exception in removeAllTFAUsers: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("TFAAccessManager: Exception in outer removeAllTFAUsers: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean addDefaultTFAUsers() {
        File file = new File(Properties.crsHome + File.separator + "crs" + File.separator + "install" + File.separator + "crsconfig_params");
        boolean bl = false;
        if (file.exists()) {
            String string = null;
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file.getAbsolutePath()));
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.startsWith("ORACLE_OWNER=")) continue;
                    String string2 = string.substring(13).trim();
                    bl = TFAAccessManager.addTFAUser(string2, "USER", true);
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Output.print("TFAAccessManager : FileNotFoundException for " + file.getAbsolutePath());
            }
            catch (IOException iOException) {
                Output.print("TFAAccessManager : IOException in getting default users");
            }
        } else {
            Output.print("TFAAccessManager: Unable to add default Users and Groups to TFA as file " + file.getAbsolutePath() + " not exist");
        }
        if (!Properties.isWindows()) {
            TFAAccessManager.addSIOracleUsers();
        }
        return bl;
    }

    public static boolean checkUserAccess(String string) {
        boolean bl = false;
        TFAUser tFAUser = TFAAccessManager.getTFAUser(string);
        if (tFAUser != null && tFAUser.isAllowed()) {
            bl = true;
        }
        bl = Utilities.isUserExists(string);
        Output.printTrace("TFAAccessManager: Checking access for '" + string + "',  Access Status :" + bl, 3);
        return bl;
    }

    public static boolean checkUserAccessOnRemote(String string, String string2, PrintWriter printWriter) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string3 = new Host().getHostname().trim();
        Properties.getInstance();
        String string4 = Properties.trustStore;
        Properties.getInstance();
        String string5 = Properties.trustStorePassword;
        boolean bl = false;
        try {
            String string6 = string + ":checktfaaccess:" + string2;
            if (!string.equals(string3)) {
                String string7;
                Output.printTrace("Making Socket connection to :" + string, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string4, string5);
                if (sSLSocket == null) {
                    Output.print("Connection refused! " + string);
                    return bl;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string6);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string7 = bufferedReader.readLine()) != null) {
                    Output.printTrace("checkUserAccessOnRemote: From " + string + " : " + string7, 3);
                    if (string7.equals("SUCCESS")) {
                        bl = true;
                        break;
                    }
                    if (string7.equals("FAILED")) {
                        bl = false;
                        break;
                    }
                    if (!string7.equals("TFA is not yet secured to run all commands") || printWriter == null) continue;
                    printWriter.println("TFA is not yet secured to run all commands");
                    break;
                }
                bufferedReader.close();
                if (!sSLSocket.isClosed()) {
                    sSLSocket.close();
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Unknown Host: " + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Unable to communicate with Host : " + string, 1);
            Output.print("TFAAccessManager : IOException in checkUserAccessOnRemote");
        }
        return bl;
    }

    public static boolean resetTFAUsers() {
        boolean bl = false;
        try {
            bl = TFAAccessManager.removeAllTFAUsers();
            if (bl) {
                bl = TFAAccessManager.addDefaultTFAUsers();
            }
        }
        catch (Exception exception) {
            Output.print("TFAAccessManager: Unable to restore TFA Users");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performActionsInRemoteNodes(String string, PrintWriter printWriter, String string2, String string3, String string4) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string5 = null;
        String string6 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        String string7 = Properties.trustStore;
        String string8 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(String.class, TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            String string9 = string6 + ":" + string2.trim() + ":" + string;
            for (TFAHost tFAHost : entityCursor) {
                String string10;
                string5 = tFAHost.getHostname();
                if (string5.equalsIgnoreCase(string6)) continue;
                Output.printTrace("Making Socket connection to :" + string5, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string5.trim(), Global.getSocketPort(), string7, string8);
                if (sSLSocket == null) {
                    printWriter.println("TFAAccessManager : Connection refused!" + string5);
                    continue;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string9);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string10 = bufferedReader.readLine()) != null) {
                    if (!string10.equals("DONE") && !string10.startsWith(string3.trim()) && !string10.startsWith(string4.trim())) continue;
                    Output.printTrace("TFAAccessManager: Status from " + string5 + " : " + string10, 3);
                    break;
                }
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("TFAAccessManager : Don't know about host: " + string5, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("TFAAccessManager : Couldn't get I/O for the connection to Host : " + string5, 1);
            Output.print("TFAAccessManager : IOException in performActionsInRemoteNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {
                Output.print("TFAAccessManager : Exception while closing the cursor in performActionsInRemoteNodes");
            }
        }
    }

    public static void createDirsForUser(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        String string2 = stringBuilder.append(Properties.tfaHome).append(File.separator).append("bin").append(File.separator).append("tfactl").toString();
        String string3 = string2 + " access setupdir -user " + string;
        Output.printTrace("Trying to execute command : " + string3, 3);
        try {
            String string4;
            Process process = Runtime.getRuntime().exec(string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string4 = bufferedReader.readLine()) != null) {
                Output.printTrace("Output : " + string4, 3);
            }
            Output.printTrace("Successfully setup dirs for user " + string, 3);
        }
        catch (Exception exception) {
            Output.print("MessageHandler : Exception in setupdirs");
        }
    }

    public static void createKeysForUser() throws Exception {
        List<TFAUser> list = TFAAccessManager.getAllUsers();
        for (TFAUser tFAUser : list) {
            if (!tFAUser.getUserType().equals("USER")) continue;
            String string = tFAUser.getUserName();
            String string2 = Properties.getEscapedUserName(string);
            StringBuilder stringBuilder = new StringBuilder();
            Properties.getInstance();
            String string3 = stringBuilder.append(Properties.internalDir).append(File.separator).append(".root").toString();
            String string4 = string3 + File.separator + string2 + "_mykey.rsa";
            boolean bl = new File(string4).exists();
            if (bl) continue;
            TFAAccessManager.createKeysForUser(string);
        }
    }

    private static void createKeysForUser(String string) throws Exception {
        String string2 = Properties.getUserName();
        String string3 = Properties.getEscapedUserName(string);
        if (Properties.isWindows()) {
            if (!Properties.isWindowsAdminUser()) {
                Output.printTrace("User '" + string2 + "' do not have permissions to run add user.", 3);
                Output.printTrace("DONE", 3);
                return;
            }
        } else if (!string2.equals("root")) {
            Output.printTrace("User '" + string2 + "' do not have permissions to run add user.", 3);
            Output.printTrace("DONE", 3);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        String string4 = stringBuilder.append(Properties.tfaHome).append(File.separator).append("internal").append(File.separator).append(".root").toString();
        String string5 = string4 + File.separator + string3 + "_mykey.rsa";
        File file = new File(string4);
        if (!file.exists()) {
            file.mkdirs();
            FileHelper.changePermission("700", string4);
        }
        KeyGen keyGen = new KeyGen();
        KeyGen.generateKeyFiles("rsa", string5, string);
        String string6 = string4 + File.separator + string3 + "_mykey.rsa.pub";
        FileHelper.changePermission("500", string5);
        FileHelper.changePermission("500", string6);
        StringBuilder stringBuilder2 = new StringBuilder();
        Properties.getInstance();
        String string7 = stringBuilder2.append(Properties.tfaHome).append(File.separator).append(".").append(string3).toString();
        File file2 = new File(string7);
        String string8 = "/usr/bin/id -g -n " + string;
        if (Properties.isSolaris()) {
            string8 = "/usr/xpg4/bin/id -g -n " + string;
        }
        if (Properties.isAIX()) {
            string8 = "/bin/id -g -n " + string;
        }
        String string9 = "";
        try {
            if (!Properties.isWindows()) {
                Process process = Runtime.getRuntime().exec(string8);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                string9 = bufferedReader.readLine();
                bufferedReader.close();
                process.waitFor();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        FileHelper.copy(string6, string7, "1");
        try {
            if (!Properties.isWindows()) {
                Runtime.getRuntime().exec("chown -R " + string + ":" + string9 + " " + string7);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        FileHelper.changePermission("700", string7);
    }

    private static void removeKeysForUser(String string) {
        String string2 = Properties.getUserName();
        String string3 = Properties.getEscapedUserName(string);
        if (Properties.isWindows()) {
            if (!Properties.isWindowsAdminUser()) {
                Output.printTrace("User '" + string2 + "' do not have permissions to run removeKeysForUser.", 3);
                Output.printTrace("DONE", 3);
                return;
            }
        } else if (!string2.equals("root")) {
            Output.printTrace("User '" + string2 + "' do not have permissions to run removeKeysForUser.", 3);
            Output.printTrace("DONE", 3);
            return;
        }
        try {
            String string4 = string3 + "_mykey.rsa";
            String string5 = string3 + "_mykey.rsa.pub";
            StringBuilder stringBuilder = new StringBuilder();
            Properties.getInstance();
            String string6 = stringBuilder.append(Properties.tfaHome).append(File.separator).append("internal").append(File.separator).append(".root").toString();
            File file = new File(string6 + File.separator + string4);
            LogFile.writeLog("TFAAccessManager: Removing Private Key " + file.getAbsolutePath());
            if (file.exists() && !file.delete()) {
                Output.print("Unable to remove Private Key : " + file.getAbsolutePath());
            }
            File file2 = new File(string6 + File.separator + string5);
            LogFile.writeLog("TFAAccessManager: Removing Private Key " + file2.getAbsolutePath());
            if (file2.exists() && !file2.delete()) {
                Output.print("Unable to remove Public Key : " + file2.getAbsolutePath());
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            Properties.getInstance();
            File file3 = new File(stringBuilder2.append(Properties.tfaHome).append(File.separator).append(".").append(string3).toString());
            LogFile.writeLog("TFAAccessManager: Removing User Public Key " + file3.getAbsolutePath());
            if (file3.exists()) {
                FileUtils.deleteDirectory((File)file3);
            }
        }
        catch (Exception exception) {
            Output.print("TFAAccessManager: Exception in removeKeysForUser : " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private static void addSIOracleUsers() {
        String string = File.separator + "etc" + File.separator + "oratab";
        String string2 = File.separator + "etc" + File.separator + "oraInst.loc";
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.exists()) {
            string = File.separator + "var" + File.separator + "opt" + File.separator + "oracle" + File.separator + "oratab";
            file = new File(string);
            string2 = File.separator + "var" + File.separator + "opt" + File.separator + "oracle" + File.separator + "oraInst.loc";
            file2 = new File(string2);
        }
        Output.printTrace("TFAAccessManager: Oratab File : " + string, 3);
        Output.printTrace("TFAAccessManager: OraInst File : " + string2, 3);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Object object;
            String string4;
            Object object2;
            if (file.exists()) {
                try {
                    object2 = new BufferedReader(new FileReader(file));
                    while ((string4 = ((BufferedReader)object2).readLine()) != null) {
                        if ((string4 = string4.trim()).length() <= 0 || string4.startsWith("#")) continue;
                        Output.printTrace("TFAAccessManager: LINE : " + string4, 3);
                        object = string4.split(":")[1].trim();
                        if (!new File((String)object).isDirectory()) continue;
                        arrayList.add(object);
                    }
                    ((BufferedReader)object2).close();
                }
                catch (Exception exception) {
                    Output.print("TFAAccessManager: Exception while adding SI Oracle Users :" + exception.getMessage());
                }
            } else {
                Output.print("TFAAccessManager: Oratab File " + string + " not exists");
            }
            if (file2.exists()) {
                try {
                    object2 = new BufferedReader(new FileReader(file2));
                    object = "";
                    while ((string4 = ((BufferedReader)object2).readLine()) != null) {
                        if ((string4 = string4.trim()).length() <= 0 || !string4.startsWith("inventory_loc=")) continue;
                        Output.printTrace("TFAAccessManager: LINE : " + string4, 3);
                        object = string4.split("=")[1].trim();
                        Output.printTrace("TFAAccessManager: Inventory Location: " + (String)object, 3);
                    }
                    ((BufferedReader)object2).close();
                    String string32 = (String)object + File.separator + "ContentsXML" + File.separator + "inventory.xml";
                    File file3 = new File(string32);
                    Output.printTrace("TFAAccessManager: Inventory File: " + string32, 3);
                    if (file3.exists()) {
                        object2 = new BufferedReader(new FileReader(file3));
                        while ((string4 = ((BufferedReader)object2).readLine()) != null) {
                            if ((string4 = string4.trim()).length() <= 0 || !string4.startsWith("<HOME NAME=")) continue;
                            Output.printTrace("TFAAccessManager: LINE : " + string4, 3);
                            object = string4.split(" ")[2].trim();
                            object = ((String)object).split("=")[1].trim();
                            object = ((String)object).replace("\"", "");
                            Output.printTrace("TFAAccessManager: Oracle Home Location: " + (String)object, 3);
                            if (!new File((String)object).isDirectory()) continue;
                            arrayList.add(object);
                        }
                    }
                    ((BufferedReader)object2).close();
                }
                catch (Exception exception) {
                    Output.print("TFAAccessManager: Exception while adding SI Oracle Users :" + exception.getMessage());
                }
            } else {
                Output.print("TFAAccessManager: OraInst File " + string2 + " not exists");
            }
            object2 = new HashSet();
            for (String string3 : arrayList) {
                string4 = FileHelper.getFileOwner(string3);
                Output.printTrace("TFAAccessManager: Owner of " + string3 + " : " + string4, 3);
                if (string4 == null || string4.startsWith("ERROR:") || string4.equalsIgnoreCase("root")) continue;
                object2.add(string4);
            }
            object = object2.iterator();
            while (object.hasNext()) {
                String string5 = (String)object.next();
                boolean bl = TFAAccessManager.addTFAUser(string5, "USER", true);
                if (bl) continue;
                Output.print("TFAAccessManager: Failed to add Oracle User :" + string5);
            }
        }
        catch (Exception exception) {
            Output.print("TFAAccessManager: Exception while adding SI Oracle Users :" + exception.getMessage());
        }
    }
}

