/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.AddNodesThread;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.TFAHost;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;

public class SecureTFA
extends Thread {
    private Set<String> clusterNodes = null;
    private long startTime;
    public volatile boolean keeprunning = true;

    SecureTFA() {
        if (this.clusterNodes == null) {
            AddNodesThread addNodesThread = new AddNodesThread();
            this.clusterNodes = addNodesThread.getClusterNodes();
        }
    }

    @Override
    public void run() {
        block8: {
            Thread.currentThread().setName("SecureTFAThread");
            this.startTime = Calendar.getInstance().getTimeInMillis();
            ArrayList<String> arrayList = new ArrayList();
            LogFile.writeLog("Cluster Nodes : " + this.clusterNodes);
            try {
                Object object;
                Object object2;
                Thread.sleep(180000L);
                boolean bl = false;
                Properties.getInstance();
                String string = Properties.tfaHome;
                String string2 = string + File.separator + "server.jks";
                File file = new File(string2);
                long l = Calendar.getInstance().getTimeInMillis();
                long l2 = (l - this.startTime) / 60000L;
                Output.printTrace("startTime: " + this.startTime, 3);
                Output.printTrace("currentTime: " + l, 3);
                Output.printTrace("diff: " + l2, 3);
                while (l2 < 1440L && !file.exists() && this.keeprunning) {
                    Output.printTrace("diff: " + l2, 3);
                    arrayList = TFAHost.getHostsInTFA();
                    if (this.isClusterNodesUpgraded()) {
                        Output.printTrace("All nodes Upgraded", 3);
                        bl = true;
                        break;
                    }
                    Thread.sleep(180000L);
                    l = Calendar.getInstance().getTimeInMillis();
                    l2 = (l - this.startTime) / 60000L;
                }
                LogFile.writeLog("secure: " + bl + " diff: " + l2 + " jks exists: " + file.exists());
                if (!bl && l2 < 1440L || file.exists() || !this.keeprunning) break block8;
                String string3 = null;
                try {
                    object2 = this.getJavaHome(string);
                    String string4 = string + File.separator + "bin" + File.separator + "tfactl";
                    string3 = string4 + " generatecerts " + string + " " + (String)object2 + " " + 0;
                    Output.printTrace("Generate Certificates command: " + string3, 3);
                    LogFile.writeLog("Generating Certificates");
                    this.notifyRemoteNodes(arrayList);
                    Properties.getInstance();
                    object = Properties.isWindows() ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", string3}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", string3});
                    ((Process)object).waitFor();
                }
                catch (Exception exception) {
                    Output.printTrace("Failed to generate certificates with command: " + string3, 1);
                    exception.printStackTrace();
                }
                if (this.keeprunning) {
                    this.copyKeystoresToRemoteNodes(string, arrayList);
                    this.restartRemoteNodes(arrayList);
                }
                Thread.sleep(120000L);
                object = string + File.separator + "bin" + File.separator + "tfactl";
                string3 = (String)object + " sslrestart ";
                Output.printTrace("Restarting Localhost: " + string3, 3);
                LogFile.writeLog("Restarting Localhost");
                Properties.getInstance();
                object2 = Properties.isWindows() ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", string3}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", string3});
            }
            catch (InterruptedException interruptedException) {
                Output.printTrace("Caught Interrupt Signal in SecureTFA Thread", 3);
                this.keeprunning = false;
            }
            catch (Exception exception) {
                Output.print("Exception in SecureTFA Thread : " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public void stopThread() {
        this.keeprunning = false;
    }

    private String getJavaHome(String string) {
        String string2 = null;
        String string3 = Properties.tfaBase;
        try {
            if (new File(string + File.separator + "jre").exists()) {
                string2 = string + File.separator + "jre";
            } else if (new File(string + File.separator + "tfa_setup.txt").exists()) {
                String string4;
                String string5;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string + File.separator + "tfa_setup.txt"));
                while ((string5 = bufferedReader.readLine()) != null) {
                    if (string5.startsWith("JAVA_HOME=")) {
                        string2 = string5.substring(10);
                    }
                    if (!string5.startsWith("TFA_BASE=")) continue;
                    string3 = string5.substring(9);
                }
                bufferedReader.close();
                if (string2 == null && new File(string4 = Properties.tfaBase + new Host().getHostname().trim() + File.separator + "java_install.out").exists()) {
                    String string6;
                    BufferedReader bufferedReader2 = new BufferedReader(new FileReader(string4));
                    while ((string6 = bufferedReader2.readLine()) != null) {
                        if (!string6.startsWith("JAVA_HOME=")) continue;
                        string2 = string6.substring(10);
                    }
                    bufferedReader2.close();
                }
            }
            if (string2 == null) {
                string2 = string + File.separator + "bin" + File.separator + "java";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private void copyKeystoresToRemoteNodes(String string, List<String> list) {
        String string2 = string + File.separator + "server.jks";
        String string3 = string + File.separator + "client.jks";
        String string4 = string + File.separator + "internal" + File.separator + "ssl.properties";
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        String string5 = null;
        String string6 = new Host().getHostname().trim();
        Properties.getInstance();
        String string7 = Properties.trustStore;
        Properties.getInstance();
        String string8 = Properties.trustStorePassword;
        boolean bl = true;
        File[] fileArray = new File[]{new File(string2), new File(string3), new File(string4)};
        for (File file : fileArray) {
            if (file.exists()) continue;
            Output.printTrace("The file " + file.getName() + " does not exist", 1);
            bl = false;
        }
        if (!bl) {
            for (File file : fileArray) {
                if (!file.exists()) continue;
                file.delete();
            }
            return;
        }
        for (File file : fileArray) {
            for (String string9 : list) {
                try {
                    String string10 = string6 + ":zipreadyfortransferusingtag:" + file.getName() + ":" + file.length();
                    string5 = string9;
                    if (string5.equalsIgnoreCase(string6)) continue;
                    Output.printTrace("remoterequest : " + string10, 3);
                    Output.printTrace("Making Socket connection to :" + string5, 3);
                    sSLSocket = SocketManager.getSecureSocketConnection(string5.trim(), Global.getSocketPort(), string7, string8);
                    if (sSLSocket == null) {
                        Output.printTrace("Failed to transfer certificates to Host : " + string5, 1);
                        continue;
                    }
                    LogFile.writeLog("Copying " + file.getName() + " to host " + string5);
                    printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                    printWriter.println(string10);
                    printWriter.close();
                    if (sSLSocket.isClosed()) continue;
                    sSLSocket.close();
                }
                catch (UnknownHostException unknownHostException) {
                    Output.printTrace("Failed to transfer certificates to Host : " + string5 + " " + unknownHostException.getMessage(), 1);
                    unknownHostException.printStackTrace();
                }
                catch (IOException iOException) {
                    Output.printTrace("Failed to transfer certificates to Host : " + string5 + " " + iOException.getMessage(), 1);
                    iOException.printStackTrace();
                }
                catch (Exception exception) {
                    Output.printTrace("Failed to transfer certificates to Host : " + string5 + " " + exception.getMessage(), 1);
                    exception.printStackTrace();
                }
            }
        }
    }

    private void restartRemoteNodes(List<String> list) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        String string = new Host().getHostname().trim();
        Properties.getInstance();
        String string2 = Properties.trustStore;
        Properties.getInstance();
        String string3 = Properties.trustStorePassword;
        for (String string4 : list) {
            try {
                String string5 = string + ":restartNode:";
                if (string4.equalsIgnoreCase(string)) continue;
                Output.printTrace("remoterequest : " + string5, 3);
                Output.printTrace("Making Socket connection to :" + string4, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string4, Global.getSocketPort(), string2, string3);
                if (sSLSocket == null) {
                    Output.printTrace("Failed to notify Host : " + string4 + " to restart TFA", 1);
                    continue;
                }
                printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter.println(string5);
                printWriter.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
            catch (UnknownHostException unknownHostException) {
                Output.printTrace("Failed to notify Host : " + string4 + " to restart TFA " + unknownHostException.getMessage(), 1);
                unknownHostException.printStackTrace();
            }
            catch (IOException iOException) {
                Output.printTrace("Failed to notify Host : " + string4 + " to restart TFA " + iOException.getMessage(), 1);
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                Output.printTrace("Failed to notify Host : " + string4 + " to restart TFA " + exception.getMessage(), 1);
                exception.printStackTrace();
            }
        }
    }

    private boolean isClusterNodesUpgraded() {
        List<Object> list = new ArrayList();
        list = TFAHost.getHostsInTFA();
        HashSet hashSet = new HashSet(list);
        LogFile.writeLog("TFA Hosts : " + hashSet);
        boolean bl = false;
        if (this.clusterNodes.equals(hashSet) || Properties.getInstance().getNodeType().equals("ODAVMGuest") && hashSet.containsAll(this.clusterNodes)) {
            if (this.clusterNodes.size() == 1) {
                bl = true;
                return bl;
            }
            String string = Properties.getTFABuildID();
            LogFile.writeLog("BuildId : " + string);
            SSLSocket sSLSocket = null;
            PrintWriter printWriter = null;
            Properties.getInstance();
            String string2 = Properties.trustStore;
            Properties.getInstance();
            String string3 = Properties.trustStorePassword;
            String string4 = new Host().getHostname().trim();
            for (String string5 : hashSet) {
                String string6 = "";
                String string7 = null;
                try {
                    String string8 = string4 + ":printbuildversion";
                    string7 = string5;
                    if (!string7.equalsIgnoreCase(string4)) {
                        String string9;
                        Output.printTrace("remoterequest : " + string8, 3);
                        Output.printTrace("Making Socket connection to :" + string7, 3);
                        sSLSocket = SocketManager.getSecureSocketConnection(string7.trim(), Global.getSocketPort(), string2, string3);
                        if (sSLSocket == null) {
                            bl = false;
                            Output.printTrace("Cannot establish Socket connection to Host : " + string7, 1);
                            break;
                        }
                        printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                        printWriter.println(string8);
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                        while ((string9 = bufferedReader.readLine()) != null && !string9.equals("DONE")) {
                            string6 = string9;
                        }
                        printWriter.close();
                        bufferedReader.close();
                        if (!sSLSocket.isClosed()) {
                            sSLSocket.close();
                        }
                        LogFile.writeLog("Host " + string7 + " BuildId : " + string6);
                        LogFile.writeLog("Is localBuildId and remoteBuildId same : " + string6.equals(string));
                        bl = string6.equals(string);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    bl = false;
                    Output.printTrace("Don't know about host: " + string7, 1);
                }
                catch (IOException iOException) {
                    bl = false;
                    Output.printTrace("Couldn't get I/O for the connection to Host : " + string7, 1);
                }
                catch (Exception exception) {
                    bl = false;
                    Output.printTrace("Exception in connecting to Host : " + string7, 1);
                }
                if (bl || string7.equalsIgnoreCase(string4)) continue;
                LogFile.writeLog("Host Not Yet Upgraded : " + string7);
                break;
            }
        }
        LogFile.writeLog("isClusterNodesUpgraded :" + bl);
        return bl;
    }

    private void notifyRemoteNodes(List<String> list) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        String string = new Host().getHostname().trim();
        Properties.getInstance();
        String string2 = Properties.trustStore;
        Properties.getInstance();
        String string3 = Properties.trustStorePassword;
        for (String string4 : list) {
            try {
                String string5 = string + ":stopSecureTFAThread:";
                if (string4.equalsIgnoreCase(string)) continue;
                Output.printTrace("remoterequest : " + string5, 3);
                Output.printTrace("Making Socket connection to :" + string4, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string4, Global.getSocketPort(), string2, string3);
                if (sSLSocket == null) {
                    Output.printTrace("Failed to notify Host : " + string4 + " to stop SecureTFA thread", 1);
                    continue;
                }
                printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter.println(string5);
                printWriter.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
            catch (UnknownHostException unknownHostException) {
                Output.printTrace("Failed to notify Host : " + string4 + " to stop SecureTFA thread " + unknownHostException.getMessage(), 1);
                unknownHostException.printStackTrace();
            }
            catch (IOException iOException) {
                Output.printTrace("Failed to notify Host : " + string4 + " to stop SecureTFA thread " + iOException.getMessage(), 1);
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                Output.printTrace("Failed to notify Host : " + string4 + " to stop SecureTFA thread " + exception.getMessage(), 1);
                exception.printStackTrace();
            }
        }
    }
}

