/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import oracle.rat.tfa.PeriodicChecker;
import oracle.rat.tfa.PurgeTFACollections;
import oracle.rat.tfa.TFAScanningMainRT;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DataAccessor.RepositoryDA;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.Repository;
import oracle.rat.tfa.entity.TFAHost;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.FileHelper;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.PurgeTFALogs;
import oracle.rat.tfa.util.SocketManager;
import oracle.rat.tfa.util.Utilities;
import org.apache.commons.io.FileSystemUtils;

public class RepositoryManager {
    private boolean isOpen = true;
    private String directory;
    private long currentSizeBytes;
    private long currentSizeMegabytes;
    private long maxSizeMegabytes;
    public static RepositoryManager instance;

    private RepositoryManager() {
        try {
            this.setup();
        }
        catch (Exception exception) {
            Output.print("RepositoryManager: Exception while configuring repository");
            exception.printStackTrace();
        }
    }

    public static RepositoryManager getInstance() {
        if (instance == null) {
            instance = new RepositoryManager();
        }
        return instance;
    }

    public Repository getRepository() {
        return (Repository)new RepositoryDA().pIdx.get((Object)this.directory);
    }

    public String getDirectory() {
        return this.directory;
    }

    public long getCurrentSizeBytes() {
        return this.currentSizeBytes;
    }

    public long getCurrentSizeMegabytes() {
        return this.currentSizeMegabytes;
    }

    public long getMaxSizeMegabytes() {
        return this.maxSizeMegabytes;
    }

    private void setup() {
        try {
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(Repository.class);
            EntityCursor entityCursor = primaryIndex.entities(null, cursorConfig);
            for (Repository repository : entityCursor) {
                this.directory = repository.getDirectory();
                this.maxSizeMegabytes = repository.getMaxSizeMegabytes();
                Output.printTrace("Repository already configured to " + repository.getDirectory(), 3);
            }
            entityCursor.close();
            if (this.directory == null) {
                long l;
                Output.print("Configuring Repository and setting it to default values...");
                this.createRepository();
                long l2 = 10240L;
                if (Properties.nodeType.equals("ODADom0") || Properties.nodeType.equals("ExadataDom0")) {
                    l2 = 1024L;
                }
                if ((l = FileSystemUtils.freeSpaceKb((String)this.directory)) != -1L) {
                    long l3 = Math.round(l / 2048L);
                    Output.printTrace("50% available space in repository " + l3 + " MB", 3);
                    if (l3 < l2) {
                        Output.printTrace("Updating the max repo size to " + l3 + "MB", 3);
                        Output.printTrace("Setting the default max repository size to " + l3 + "MB", 3);
                        l2 = l3;
                    }
                } else {
                    Output.print("RepositoryManager: Unable to determine free space in " + this.directory);
                }
                this.maxSizeMegabytes = l2;
                Repository repository = new Repository(this.directory, l2);
                new RepositoryDA().pIdx.put((Object)repository);
            }
            this.updateCurrentSize();
            Utilities.updateConfigPropertiesFile("repository", this.directory);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createRepository() {
        boolean bl;
        Object object;
        if (Properties.installType.equals("GI") || Properties.installType.equals("DB")) {
            if (Properties.getOracleBase() != null) {
                Output.printTrace("Oracle base is not null " + Properties.getOracleBase(), 3);
                this.directory = Properties.getOracleBase() + File.separator + "tfa" + File.separator + "repository";
                object = new File(Properties.getOracleBase() + File.separator + "tfa");
                if (((File)object).exists() && ((File)object).isDirectory()) {
                    Output.printTrace("Directory " + ((File)object).getAbsolutePath() + " already exists", 3);
                } else {
                    bl = ((File)object).mkdir();
                    Output.printTrace("Created : " + ((File)object).getAbsolutePath() + " isCreated " + bl, 3);
                }
            } else {
                object = Properties.tfaHome;
                this.directory = ((String)object).substring(0, ((String)object).substring(0, ((String)object).lastIndexOf(File.separator)).lastIndexOf(File.separator)) + File.separator + "repository";
            }
            LogFile.writeLog("Default TFA Repository for GI Install: " + this.directory);
        } else if (Properties.nodeType.equals("ODA") || Properties.nodeType.equals("ODADom0") || Properties.nodeType.equals("ODAVMGuest")) {
            this.directory = Properties.tfaHome + File.separator + "repository";
        } else if (Properties.nodeType.equals("FMW") || Properties.nodeType.equals("JCS") || Properties.nodeType.equals("SI") || Properties.nodeType.equals("ADE_ND")) {
            this.directory = Properties.tfaBase + File.separator + "repository";
        } else if (Properties.tfaHome.contains(new Host().getHostname().trim())) {
            object = Properties.tfaHome;
            this.directory = ((String)object).substring(0, ((String)object).substring(0, ((String)object).lastIndexOf(File.separator)).lastIndexOf(File.separator)) + File.separator + "repository";
        } else {
            this.directory = Properties.tfaHome + File.separator + "repository";
        }
        object = new File(this.directory);
        if (((File)object).exists() && ((File)object).isDirectory()) {
            Output.printTrace("Directory " + ((File)object).getAbsolutePath() + " already exists", 3);
        } else {
            bl = ((File)object).mkdirs();
            Output.printTrace("Creating " + ((File)object).getAbsolutePath() + " isCreated : " + bl, 3);
        }
        Output.printTrace("Default TFA Repository Location: " + this.directory, 3);
    }

    public void changeRepository(String string, long l) {
        try {
            Repository repository = this.getRepository();
            Transaction transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            try {
                Output.printTrace("RepositoryManager: Trying to update repository in changeRepository...", 3);
                repository.setDirectory(string);
                repository.setMaxSizeMegabytes(l);
                new RepositoryDA().pIdx.put(transaction, (Object)repository);
                if (!this.directory.equalsIgnoreCase(string)) {
                    boolean bl = new RepositoryDA().pIdx.delete(transaction, (Object)this.directory);
                    Output.printTrace("RepositoryManager: Trying to remove old repository in changeRepository: " + bl, 3);
                }
                this.directory = repository.getDirectory();
                this.maxSizeMegabytes = repository.getMaxSizeMegabytes();
                transaction.commit();
                Output.printTrace("RepositoryManager: Updated Repository to " + this.directory + " and Size to " + l, 3);
                this.updateCurrentSize();
                Utilities.updateConfigPropertiesFile("repository", this.directory);
            }
            catch (LockConflictException lockConflictException) {
                Output.printTrace("RepositoryManager: Lock Conflict Exception in changeRepository : " + lockConflictException.getMessage(), 1);
                lockConflictException.printStackTrace();
                try {
                    if (transaction != null) {
                        transaction.abort();
                        transaction = null;
                    }
                }
                catch (DatabaseException databaseException) {
                    Output.printTrace("RepositoryManager: Transaction abort failed in changeRepository : " + databaseException.getMessage(), 1);
                    databaseException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            Output.printTrace("RepositoryManager: Exception in changeRepository : " + exception.getMessage(), 1);
            exception.printStackTrace();
        }
    }

    public void printRepository(PrintWriter printWriter) {
        try {
            String string = "";
            String string2 = new Host().getHostname().trim();
            if (RepositoryManager.getInstance().isRepositoryOpen()) {
                string = "OPEN";
            } else {
                long l = FileSystemUtils.freeSpaceKb((String)this.directory);
                long l2 = l / 1024L;
                if (l < 0L) {
                    string = "REPOSITORY NOT FOUND";
                } else if (l2 <= 1024L) {
                    string = "CLOSED - FILESYSTEM SPACE LOW ( Less than 1 GB )";
                } else if (RepositoryManager.getInstance().getCurrentSizeMegabytes() >= this.maxSizeMegabytes) {
                    string = "FULL AND CLOSED";
                }
                if (string.length() == 0) {
                    long l3 = FileSystemUtils.freeSpaceKb((String)Properties.tfaHome);
                    if (l3 < 102400L) {
                        string = "CLOSED - FILESYSTEM SPACE LOW IN TFA_HOME " + Properties.tfaHome + " ( < 100 MB )";
                    }
                    if ((Properties.installType.equalsIgnoreCase("GI") || Properties.installType.equalsIgnoreCase("DB")) && (l3 = FileSystemUtils.freeSpaceKb((String)Properties.oracleBase)) < 102400L) {
                        string = "CLOSED - FILESYSTEM SPACE LOW IN ORACLE_BASE " + Properties.oracleBase + " ( < 100 MB )";
                    }
                }
            }
            printWriter.println(this.directory + "!" + this.maxSizeMegabytes + "!" + this.currentSizeMegabytes + "!" + this.currentSizeBytes + "!" + string + "!" + string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isRepositoryOpen() {
        return this.isOpen;
    }

    public boolean checkRepositoryIsOpen() {
        try {
            boolean bl = this.updateCurrentSize();
            if (bl) {
                this.isOpen = bl;
            } else {
                new PurgeTFACollections().start();
                new PurgeTFALogs().start();
                Thread.sleep(2000L);
                this.isOpen = this.updateCurrentSize();
            }
            Output.printTrace("RepositoryManager: Directory: " + this.directory + ", Size: " + this.currentSizeMegabytes + " MB, Status: " + this.isOpen, 3);
            if (!this.isOpen) {
                return this.isOpen;
            }
            String string = Properties.tfaHome;
            if (Properties.installType.equalsIgnoreCase("GI") || Properties.installType.equalsIgnoreCase("DB")) {
                string = Properties.oracleBase;
            }
            long l = FileSystemUtils.freeSpaceKb((String)string);
            long l2 = Global.getMinSpaceForRTScan() * 1024;
            Output.printTrace("RepositoryChecker : Directory to Monitor for RT Scan : " + string, 3);
            Output.printTrace("RepositoryChecker : Free Space : " + l + " KB Min Space For RTScan : " + l2 + " KB", 3);
            if (l < l2) {
                this.isOpen = false;
                TFAScanningMainRT tFAScanningMainRT = Global.getRtScanThread();
                if (tFAScanningMainRT != null && tFAScanningMainRT.isAlive()) {
                    LogFile.writeLog("RepositoryChecker: Stopping the Scanner as available disk space in " + string + " is less than " + l2 + " MB.");
                    tFAScanningMainRT.stopRTScanner();
                    Global.forceStopRTScanner = true;
                }
                if (Global.getPeriodicCheckerThread() != null) {
                    LogFile.writeLog("RepositoryChecker : Stopping Periodic Checker and Rediscovery Thread due to lack of space");
                    Global.getPeriodicCheckerThread().stopPeriodicChecker();
                    Global.setPeriodicCheckerThread(null);
                }
            } else {
                Thread thread;
                if (Global.forceStopRTScanner) {
                    thread = Global.getRtScanThread();
                    if (!Global.rtScanRunning.booleanValue() || !thread.isAlive()) {
                        LogFile.writeLog("RepositoryChecker: Scanner is not running. Restarting Scanner as available space in " + string + " is : " + l / 1024L + " MB");
                        String string2 = new Host().getHostname().trim();
                        Action action = new Action("startrtscan", string2, "RepositoryChecker", "");
                        action.store();
                    }
                    Global.forceStopRTScanner = false;
                }
                if (Global.getPeriodicCheckerThread() == null) {
                    LogFile.writeLog("RepositoryChecker : Restarting Periodic Checker and Rediscovery Thread");
                    thread = new PeriodicChecker();
                    thread.start();
                    Global.setPeriodicCheckerThread((PeriodicChecker)thread);
                }
            }
        }
        catch (Exception exception) {
            Output.printTrace("RepositoryManager: Exception in checkRepositoryIsOpen " + exception.getMessage(), 1);
            exception.printStackTrace();
        }
        return this.isOpen;
    }

    public boolean updateCurrentSize() {
        try {
            File file = new File(this.directory);
            if (!file.exists()) {
                return false;
            }
            this.currentSizeBytes = FileHelper.sizeOfDirectory(this.directory);
            this.currentSizeMegabytes = Math.round(this.currentSizeBytes / 1024L / 1024L);
            if (this.currentSizeMegabytes >= this.maxSizeMegabytes) {
                return false;
            }
            long l = FileSystemUtils.freeSpaceKb((String)this.directory) / 1024L;
            if (l <= 1024L) {
                return false;
            }
            if (this.currentSizeMegabytes < this.maxSizeMegabytes && l > 1024L) {
                return true;
            }
        }
        catch (IOException iOException) {
            Output.printTrace("Exception in Repository updateCurrentSize: " + iOException.getMessage(), 1);
        }
        catch (Exception exception) {
            Output.printTrace("Exception in Repository updateCurrentSize: " + exception.getMessage(), 1);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkRepositoryIsOpenInNodes(String string) {
        String string22;
        Object object;
        Object object2;
        String string3 = new Host().getHostname().trim();
        String string4 = null;
        String string5 = "";
        String string6 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        EntityCursor entityCursor = null;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        if (string != null) {
            Properties.getInstance();
            object2 = string.split(Properties.TFAARGSEP);
            string5 = ((String[])object2).length > 1 ? (object2[0].trim().equalsIgnoreCase("-c") ? string.substring(string.indexOf(":") + 1) : string) : string;
        }
        if (string5.contains("-node all")) {
            object2 = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = object2.entities(null, cursorConfig);
            for (TFAHost tFAHost : entityCursor) {
                string6 = tFAHost.getHostname().trim();
                arrayList.add(string6);
            }
        } else if (!string5.contains("-node local")) {
            object2 = string5.split(" ");
            object = null;
            for (int i = 0; i < ((String[])object2).length; ++i) {
                object = object2[i].trim();
                if (!((String)object).equalsIgnoreCase("-node")) continue;
                arrayList = new ArrayList();
                for (String string22 : object2[i + 1].split(",")) {
                    arrayList.add(string22.trim());
                }
                break;
            }
        }
        Output.printTrace("List of nodes for diagcollect : " + arrayList, 3);
        object2 = null;
        object = null;
        Properties.getInstance();
        String string7 = Properties.trustStore;
        Properties.getInstance();
        String[] stringArray = Properties.trustStorePassword;
        string22 = string3 + ":checkrepositoryisopen";
        try {
            for (String string8 : arrayList) {
                string6 = string8;
                if (!string6.equalsIgnoreCase(string3)) {
                    String string9;
                    Output.printTrace("Making Socket connection to :" + string6, 3);
                    object2 = SocketManager.getSecureSocketConnection(string6.trim(), Global.getSocketPort(), string7, (String)stringArray);
                    if (object2 == null) {
                        Output.printTrace("Connection refused!" + string6, 3);
                        continue;
                    }
                    object = new PrintWriter(((Socket)object2).getOutputStream(), true);
                    ((PrintWriter)object).println(string22);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Socket)object2).getInputStream()));
                    while ((string9 = bufferedReader.readLine()) != null && !string9.equals("DONE")) {
                        if (!string9.contains("Repository is full and closed")) continue;
                        string4 = string6;
                    }
                    bufferedReader.close();
                    if (!((Socket)object2).isClosed()) {
                        ((Socket)object2).close();
                    }
                }
                if (string4 == null) continue;
                break;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string6, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string6, 1);
            Output.print("RepositoryManager : IOException in checkRepositoryIsOpenInNodes");
        }
        finally {
            try {
                if (entityCursor != null) {
                    entityCursor.close();
                }
            }
            catch (Exception exception) {}
        }
        return string4;
    }

    public void printRepository() {
        Output.printTrace("#### Repository ####################################", 3);
        Output.printTrace("Location: " + this.directory, 3);
        Output.printTrace("Max Size: " + this.maxSizeMegabytes + " MB", 3);
        Output.printTrace("Current Size: " + this.currentSizeMegabytes + " MB", 3);
        Output.printTrace("####################################################", 3);
    }
}

