/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.CollectionManager;
import oracle.rat.tfa.RepositoryManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Collection;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.ZipEntity;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;
import oracle.rat.tfa.util.StringUtil;

public class RemoteCollectionMonitor
implements Runnable {
    private String collectionId;
    private LinkedBlockingQueue<String> messageQueue;
    private Set<String> nodes = new HashSet<String>();
    private String tracefac = "COLLECT";
    private Map<String, String> remoteSummary = new HashMap<String, String>();

    public RemoteCollectionMonitor() {
    }

    public RemoteCollectionMonitor(String string, LinkedBlockingQueue<String> linkedBlockingQueue, Set<String> set) {
        this.collectionId = string;
        this.messageQueue = linkedBlockingQueue;
        this.nodes = set;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setMessageQueue(LinkedBlockingQueue<String> linkedBlockingQueue) {
        this.messageQueue = linkedBlockingQueue;
    }

    public LinkedBlockingQueue<String> getMessageQueue() {
        return this.messageQueue;
    }

    public Map<String, String> getRemoteSummary() {
        return this.remoteSummary;
    }

    @Override
    public void run() {
        this.nodes.remove(new Host().getHostname().trim());
        while (this.nodes.size() > 0) {
            try {
                String string;
                String string2;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                String string3;
                Object object6;
                Thread.sleep(10000L);
                Collection collection = CollectionManager.getCollection(this.collectionId);
                Output.printTrace("Start Queue Size : " + collection.getRemoteCollectionMessages().size(), this.tracefac, 4);
                String string4 = collection.getRemoteCollectionMessages().peek();
                if (string4 != null) {
                    object6 = string4.split(":");
                    string3 = object6[0].trim();
                    object5 = object6[1].trim();
                    object4 = object6[2].trim();
                    if (this.collectionId.equals(string3)) {
                        Collection.remoteCollectionMessages.poll();
                        Output.printTrace("RemoteMonitor: " + string4, this.tracefac, 3);
                        if (((String)object4).startsWith("donebuildingremotezip")) {
                            object3 = ((String)object4).split(" ");
                            object2 = object3[1];
                            object = object3[2];
                            string2 = object3[3];
                            string = object3[4];
                            Object object7 = object3[5];
                            Object object8 = object3[6];
                            Object object9 = "";
                            int n = 0;
                            String[] stringArray = null;
                            if (((Object)object3).length > 7) {
                                object9 = object3[7];
                                n = new Integer((String)object9);
                                stringArray = new String[n];
                                int n2 = 8;
                                for (int i = 0; i < n; ++i) {
                                    stringArray[i] = object3[n2];
                                    ++n2;
                                }
                                Output.printTrace("additionalZipCounter: " + n, this.tracefac, 3);
                                Output.printTrace("zipLength: " + Arrays.asList(stringArray), this.tracefac, 3);
                            }
                            ZipEntity zipEntity = ZipEntity.getZipForUUID((String)object2);
                            String string5 = zipEntity.getHostname();
                            String string6 = zipEntity.getFileNameShort();
                            String string7 = RepositoryManager.getInstance().getDirectory();
                            String string8 = string7 + File.separator + (String)object8 + File.separator + string6;
                            if (new File(string8).exists()) {
                                Output.printTrace(string8 + " already exists in repository. Not copying from " + string5, this.tracefac, 3);
                                return;
                            }
                            Output.printTrace("Making a request to " + string5 + " to transfer " + string8, this.tracefac, 3);
                            if (RepositoryManager.getInstance().isRepositoryOpen()) {
                                try {
                                    this.doTransfer(string5, string6, (String)object, string2, (String)object8, (String)object7, string, n, stringArray);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    this.messageQueue.put((String)object5 + "!" + "Failed to transfer zip");
                                    this.nodes.remove(object5);
                                }
                            } else {
                                this.messageQueue.put((String)object5 + "!" + "Failed. Repository is full and closed in inititaing host");
                                Output.printTrace("The Repository is full and closed.", this.tracefac, 1);
                            }
                        } else {
                            object3 = this.remoteSummary.get(object5);
                            object2 = ((String)object4).split(" ");
                            if (((String)object4).startsWith("Zip") || ((String)object4).startsWith("Total")) {
                                object3 = object3 == null || ((String)object3).equals("") ? object2[((String[])object2).length - 1] : (String)object3 + "!" + (String)object2[((Object)object2).length - 1];
                                Output.printTrace("RemoteMonitor Summary1: " + (String)object3, this.tracefac, 3);
                                this.remoteSummary.put((String)object5, (String)object3);
                            } else if (((String)object4).startsWith("Failed") || ((String)object4).equals("Completed")) {
                                this.nodes.remove(object5);
                                Output.printTrace("RemoteMonitor: " + this.nodes, this.tracefac, 3);
                                object3 = object3 == null || ((String)object3).equals("") ? object4 : (String)object3 + "!" + (String)object4;
                                this.remoteSummary.put((String)object5, (String)object3);
                                Output.printTrace("RemoteMonitor Summary2: " + (String)object3, this.tracefac, 3);
                                this.messageQueue.put((String)object5 + "!" + (String)object3);
                            }
                        }
                    }
                } else {
                    Properties.getInstance();
                    object6 = Properties.trustStore;
                    Properties.getInstance();
                    string3 = Properties.trustStorePassword;
                    object5 = null;
                    object4 = null;
                    object = this.nodes.iterator();
                    while (object.hasNext()) {
                        string2 = object.next();
                        try {
                            object5 = SocketManager.getSecureSocketConnection(string2.trim(), Global.getSocketPort(), (String)object6, string3);
                            if (object5 == null) {
                                Output.printTrace("RemoteMonitor " + string2 + ":" + "Failed Collection", this.tracefac, 1);
                                this.messageQueue.put(string2 + "!" + "Failed Collection");
                                object.remove();
                                continue;
                            }
                            object4 = new PrintWriter(((Socket)object5).getOutputStream(), true);
                            string = new Host().getHostname().trim() + ":isCollectionRunning:" + this.collectionId;
                            ((PrintWriter)object4).println(string);
                            object3 = new BufferedReader(new InputStreamReader(((Socket)object5).getInputStream()));
                            object2 = ((BufferedReader)object3).readLine();
                            boolean bl = Boolean.parseBoolean(((String)object2).trim());
                            Output.printTrace("RemoteMonitor " + string2 + ": Collection " + this.collectionId + " running status : " + (String)object2 + " " + bl, this.tracefac, 3);
                            if (bl) continue;
                            Output.printTrace("RemoteMonitor " + string2 + ":" + "Failed RemoteRunning check", this.tracefac, 1);
                            this.messageQueue.put(string2 + "!" + "Failed Collection");
                            object.remove();
                        }
                        catch (Exception exception) {
                            Output.printTrace("RemoteMonitor " + string2 + ":" + "Failed RemoteRunning check", this.tracefac, 1);
                            this.messageQueue.put(string2 + "!" + "Failed Unable to connect to Node " + string2);
                            object.remove();
                        }
                    }
                }
                Output.printTrace("End Queue Size : " + collection.getRemoteCollectionMessages().size(), this.tracefac, 4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                try {
                    this.messageQueue.put("Failed Exception in remote collection monitor");
                    Output.printTrace("RemoteMonitor Failed Exception in remote collection monitor", this.tracefac, 1);
                }
                catch (Exception exception2) {
                    Output.printTrace("RemoteMonitor Failed Exception in remote collection monitor", this.tracefac, 1);
                }
                Output.printTrace("Exception in RemoteCollectionMonitor: " + exception.getMessage(), this.tracefac, 1);
                break;
            }
        }
        Output.printTrace("Closing TFA RemoteMonitor Thread...", this.tracefac, 3);
    }

    private void doTransfer(String string, String string2, String string3, String string4, String string5, String string6, String string7, int n, String[] stringArray) throws Exception {
        String string8 = new Host().getHostname();
        String string9 = RepositoryManager.getInstance().getDirectory();
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        Properties.getInstance();
        String string10 = Properties.trustStore;
        Properties.getInstance();
        String string11 = Properties.trustStorePassword;
        String string12 = Properties.getRemoteTFAVersion(string);
        Output.printTrace("TFA Version on " + string + " : " + string12, this.tracefac, 3);
        sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string10, string11);
        if (sSLSocket == null) {
            Output.printTrace("Unable to connect to " + string, this.tracefac, 3);
        } else {
            String string13;
            Output.printTrace("I AM :: " + string8 + "TFAHOST is : " + string, this.tracefac, 3);
            String[] stringArray2 = null;
            if (n > 0) {
                stringArray2 = new String[n];
                for (int i = 0; i < n; ++i) {
                    string13 = string2.replace(".zip", "");
                    stringArray2[i] = string13 = string13 + "_" + (i + 1) + ".zip";
                }
            }
            Output.printTrace("Making Socket connection to :" + string, this.tracefac, 3);
            printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
            InputStream inputStream = sSLSocket.getInputStream();
            string13 = string12.startsWith("12.1") ? string8 + ":doziptransfer:" + string2 + ":" + string5 : string8 + ":doziptransfer:" + "zip" + ":" + this.collectionId;
            Output.printTrace("remoterequest : " + string13, this.tracefac, 3);
            Output.printTrace("fileName to be transferred : " + string2 + ":" + string3, this.tracefac, 3);
            printWriter.println(string13);
            String string14 = string9 + File.separator + string5 + File.separator + string2;
            FileOutputStream fileOutputStream = new FileOutputStream(string14);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            Output.printTrace("Reading from socket input stream of " + string + " TO " + string14, this.tracefac, 3);
            this.readRemoteFile(inputStream, string3, bufferedOutputStream);
            this.doRemoteFileDelete(printWriter, string8, string2, string5);
            if (n > 0) {
                int n2 = 0;
                for (String string15 : stringArray2) {
                    string13 = string8 + ":doziptransfer:" + "extrazip" + ":" + this.collectionId + ":" + n2;
                    Output.printTrace("remoterequest : " + string13, this.tracefac, 3);
                    Output.printTrace("fileName to be transferred : " + string15 + ":" + stringArray[n2], this.tracefac, 3);
                    printWriter.println(string13);
                    string14 = string9 + File.separator + string5 + File.separator + string15;
                    fileOutputStream = new FileOutputStream(string14);
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    Output.printTrace("Reading from socket input stream of " + string + " TO " + string14, this.tracefac, 3);
                    this.readRemoteFile(inputStream, stringArray[n2], bufferedOutputStream);
                    this.doRemoteFileDelete(printWriter, string8, string15, string5);
                    ++n2;
                }
            }
            string2 = string2 + ".txt";
            Output.printTrace("fileName to be transferred : " + string2 + ":" + string4, this.tracefac, 3);
            String string16 = string12.startsWith("12.1") ? string8 + ":doziptransfer:" + string2 + ":" + string5 : string8 + ":doziptransfer:" + "ziptxt" + ":" + this.collectionId;
            Output.printTrace("remoteRequestForInfoFileTransfer : " + string16, this.tracefac, 3);
            printWriter.println(string16);
            string14 = string9 + File.separator + string5 + File.separator + string2;
            fileOutputStream = new FileOutputStream(string14);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            Output.printTrace("Reading from socket input stream of " + string + " TO " + string14, this.tracefac, 3);
            this.readRemoteFile(inputStream, string4, bufferedOutputStream);
            this.doRemoteFileDelete(printWriter, string8, string2, string5);
            String string17 = StringUtil.getReplacementFor(string);
            string2 = "diagcollect_" + string6 + "_" + string17 + ".log";
            Output.printTrace("fileName to be transferred : " + string2 + ":" + string7, this.tracefac, 3);
            String string18 = string12.startsWith("12.1") ? string8 + ":doziptransfer:" + string2 + ":" + string5 : string8 + ":doziptransfer:" + "log" + ":" + this.collectionId;
            Output.printTrace("remoteRequestForLogFileTransfer : " + string18, this.tracefac, 3);
            printWriter.println(string18);
            string14 = string9 + File.separator + string5 + File.separator + string2;
            fileOutputStream = new FileOutputStream(string14);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            Output.printTrace("Reading from socket input stream of " + string + " TO " + string14, this.tracefac, 3);
            this.readRemoteFile(inputStream, string7, bufferedOutputStream);
            this.doRemoteFileDelete(printWriter, string8, string2, string5);
            this.doRemoteFileDelete(printWriter, string8, string5, null);
            printWriter.close();
            inputStream.close();
            if (!sSLSocket.isClosed()) {
                sSLSocket.close();
            }
        }
    }

    private void doRemoteFileDelete(PrintWriter printWriter, String string, String string2, String string3) {
        String string4 = string + ":dozipdelete:" + string2;
        if (string3 != null) {
            string4 = string + ":dozipdelete:" + string2 + ":" + string3;
        }
        printWriter.println(string4);
    }

    private void readRemoteFile(InputStream inputStream, String string, BufferedOutputStream bufferedOutputStream) throws Exception {
        int n;
        byte[] byArray = new byte[8192];
        int n2 = 0;
        while ((n = inputStream.read(byArray)) != -1 && Long.valueOf(string) > (long)n2) {
            bufferedOutputStream.write(byArray, 0, n);
            bufferedOutputStream.flush();
            if ((long)(n2 += n) != Long.valueOf(string)) continue;
        }
        Output.printTrace("Total number of bytes written = " + n2, this.tracefac, 3);
        bufferedOutputStream.close();
    }
}

