/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import oracle.rat.tfa.TFADirectoryManager;
import oracle.rat.tfa.TFAInventoryManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class RediscoveryThread
extends Thread {
    private boolean keepReading = true;
    private Process p = null;
    private String mode = null;

    public RediscoveryThread() {
    }

    public RediscoveryThread(String string) {
        this.mode = string;
    }

    @Override
    public void run() {
        Object object;
        BufferedReader bufferedReader;
        Output.printTrace("Rediscovery started...", 3);
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        String string = stringBuilder.append(Properties.tfaHome).append(File.separator).append("bin").append(File.separator).append("tfactl").toString();
        Output.printTrace("pathToRediscoveryScript : " + string, 3);
        try {
            String string2;
            Properties.getInstance();
            this.p = Properties.isWindows() ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", string, "rediscover", "-mode", this.mode, "-auto"}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", string, "rediscover", "-mode", this.mode, "-auto"});
            bufferedReader = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
            while (this.keepReading && (string2 = bufferedReader.readLine()) != null) {
                Output.printTrace("Rediscovery script --->>> " + string2, 4);
            }
            Output.printTrace("Out of while loop in Rediscovery thread " + this.keepReading, 3);
            if (this.p != null) {
                Output.printTrace("Destroying " + this.p, 3);
                this.p.destroy();
            }
            object = new File(Properties.tmpDir + File.separator + ".discover_ora_stacksh");
            Output.printTrace("Prior to destroying process, checking for existence of " + ((File)object).getAbsolutePath() + " : " + ((File)object).exists(), 3);
            Output.printTrace("Checking for existence of " + ((File)object).getAbsolutePath() + " : " + ((File)object).exists(), 3);
            if (((File)object).exists()) {
                Output.printTrace("cleaning directory " + ((File)object).getAbsolutePath(), 3);
                for (File file : ((File)object).listFiles()) {
                    file.delete();
                }
            }
            bufferedReader.close();
            bufferedReader = null;
            Output.printTrace("Rediscovery completed...", 3);
            this.readDirectoriesFile();
            Output.printTrace("*******COMPLETED REDISCOVERY*******", 3);
            TFADirectoryManager.dumpDirectoriesWithNoMappings();
        }
        catch (IOException iOException) {
            Output.print("RediscoveryThread : IOException in running rediscovery");
        }
        Properties.getInstance();
        if (Properties.crsHome == null) {
            Output.printTrace("Reading Properties File: " + Properties.tfaPropertiesFile, 3);
            try {
                bufferedReader = new BufferedReader(new FileReader(Properties.tfaPropertiesFile));
                while ((object = bufferedReader.readLine()) != null) {
                    if (!((String)object).contains("CRS_HOME=")) continue;
                    Output.printTrace("Setting CRS_HOME = " + ((String)object).substring(9), 3);
                    Properties.getInstance().setCRSHome(((String)object).substring(9));
                    break;
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Output.print("RediscoveryThread : FileNotFoundException for " + Properties.tfaPropertiesFile);
            }
            catch (IOException iOException) {
                Output.print("RediscoveryThread : IOException while reading " + Properties.tfaPropertiesFile);
            }
        }
    }

    public void stopRediscovery() {
        Output.printTrace("Received signal to stop rediscovery from periodic checker", 3);
        this.keepReading = false;
        if (this.p != null) {
            Output.printTrace("Destroying " + this.p, 3);
            this.p.destroy();
        }
        File file = new File(Properties.tmpDir + File.separator + ".discover_ora_stacksh");
        Output.printTrace("Prior to destroying process, checking for existence of " + file.getAbsolutePath() + " : " + file.exists(), 3);
        Output.printTrace("Checking for existence of " + file.getAbsolutePath() + " : " + file.exists(), 3);
        if (file.exists()) {
            Output.printTrace("cleaning directory " + file.getAbsolutePath(), 3);
            for (File file2 : file.listFiles()) {
                file2.delete();
            }
        }
    }

    public void readDirectoriesFile() {
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            String string;
            Output.printTrace("Reading Directories File: " + Properties.tfaDirectoriesFile, 3);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(Properties.tfaDirectoriesFile));
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                if (!string.contains("DIAGDEST") || (string2 = TFADirectoryManager.addFromFileLine(string)).startsWith("FAIL")) continue;
                ++n;
                String string3 = string.substring(string.indexOf("=") + 1);
                Output.printTrace("Found new Directory during rediscovery: " + string3, 3);
                hashSet.add(string3);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            Output.print("RediscoveryThread : IOException in reading tfa_directories.txt");
        }
        if (n > 0) {
            Output.printTrace("Found new directories during rediscovery", 3);
            this.runInventoryThread(hashSet);
        }
    }

    private void runInventoryThread(Set<String> set) {
        String string = new Host().getHostname().trim();
        Output.printTrace("Running inventory after rediscovery...", 3);
        Action action = null;
        TFAInventoryManager tFAInventoryManager = null;
        if (this.mode != null && this.mode.equals("lite")) {
            action = new Action("runinventory", string, "RediscoveryThread", "dirSpecific");
            tFAInventoryManager = new TFAInventoryManager(action, set);
        } else {
            action = new Action("runinventory", string, "RediscoveryThread", "");
            tFAInventoryManager = new TFAInventoryManager(action);
        }
        Thread thread = new Thread((Runnable)tFAInventoryManager, "TFAInventoryManager");
        thread.start();
        if (this.mode != null && this.mode.equals("full")) {
            Global.inventoryManagerThread = tFAInventoryManager;
            Global.inventoryThread = thread;
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            Output.print("RediscoveryThread : InterruptedException in waiting for inventory thread to complete");
        }
        Output.printTrace("Run inventory completed ...", 3);
    }
}

