/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.TFAReceiverManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.TFAHost;
import oracle.rat.tfa.entity.TFAReceiver;
import oracle.rat.tfa.receiver.Bugfiles;
import oracle.rat.tfa.receiver.MetadataIndexer;
import oracle.rat.tfa.receiver.MetadataSearcher;
import oracle.rat.tfa.receiver.RGlobal;
import oracle.rat.tfa.receiver.RequestHelperString;
import oracle.rat.tfa.receiver.SearchJsonReceiver;
import oracle.rat.tfa.receiver.TopicManager;
import oracle.rat.tfa.receiver.TransferData;
import oracle.rat.tfa.receiver.TransferFile;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.EncryptionUtil;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.RandomString;
import oracle.rat.tfa.util.SocketManager;

public class ReceiverMessageHandler
implements Runnable {
    private Socket socket = null;
    private String repos = null;
    private String ipath = null;
    private String mpath = null;
    private SearchJsonReceiver sjr = null;
    private MetadataIndexer mi = null;
    private MetadataSearcher ms = null;

    public ReceiverMessageHandler(Socket socket, SearchJsonReceiver searchJsonReceiver, MetadataIndexer metadataIndexer, MetadataSearcher metadataSearcher) {
        String string;
        this.socket = socket;
        this.repos = RGlobal.kvStr.get("r.repository");
        String string2 = new Host().getHostname().trim();
        String string3 = this.repos.trim() + File.separator + "receiver" + File.separator + string2 + File.separator + "index" + File.separator + "metadataindex";
        this.ipath = string = this.repos.trim() + File.separator + "receiver" + File.separator + string2 + File.separator + "index" + File.separator + "dataindex";
        this.mpath = string3;
        this.sjr = null;
        this.mi = metadataIndexer;
        this.ms = metadataSearcher;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        Thread.currentThread().setName("ReceiverMessageHandler");
        Output.printTrace("Starting : ReceiverMessageHandler", 3);
        PrintWriter printWriter = null;
        boolean bl = false;
        String string = "COLLECTOR";
        string = Properties.TFARunMode.toUpperCase();
        String string2 = new Host().getHostname().trim();
        List<String> list = TFAHost.getHostsInTFA();
        String string3 = Properties.getUserName();
        String string4 = this.socket.getInetAddress().getCanonicalHostName().toString().split("\\.")[0];
        Output.printTrace("Starting : ReceiverMessageHandler - 2", 3);
        try {
            Object object;
            String[] stringArray;
            Object object2;
            String string5;
            Object object3;
            printWriter = new PrintWriter(this.socket.getOutputStream(), true);
            Output.printTrace("Starting : ReceiverMessageHandler - 4", 3);
            InputStream inputStream = this.socket.getInputStream();
            Output.printTrace("Starting : ReceiverMessageHandler - 3", 3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            Output.printTrace("Starting : ReceiverMessageHandler - 5", 3);
            String string6 = null;
            String string7 = null;
            String string8 = bufferedReader.readLine();
            String string9 = null;
            if (string8.contains("randomkey")) {
                object3 = string8.split(":");
                string7 = object3[0];
                string9 = object3[2];
                if (!RGlobal.collectorKeys.containsKey(string7)) {
                    printWriter.println("FAILED - Collector not registered ");
                    Output.printTrace(" Collector " + string7 + " not registered ", 3);
                    return;
                }
                string6 = EncryptionUtil.decrypt(RGlobal.collectorKeys.get(string7));
                string5 = EncryptionUtil.encryptStr(string9, string6);
                printWriter.println(string5);
                object2 = new RandomString(16);
                stringArray = ((RandomString)object2).nextString();
                string5 = EncryptionUtil.encryptStr((String)stringArray, string6);
                printWriter.println(string5);
                string8 = bufferedReader.readLine();
                string8 = string8.trim();
                object = EncryptionUtil.decryptStr(string8, string9);
                object = ((String)object).trim();
                if (!((String)object).equals(stringArray)) {
                    Output.printTrace("FAILED - Collector " + string7 + " server session authetication failed", 3);
                    printWriter.println("FAILED - Collector server session authetication failed");
                    return;
                }
                string8 = bufferedReader.readLine();
                string8 = string8.trim();
                object = EncryptionUtil.decryptStr(string8, string9);
                if (!((String)(object = ((String)object).trim())).equals(string6)) {
                    Output.printTrace("FAILED - Collector " + string7 + " key did not match ", 3);
                    printWriter.println("FAILED - Collector key did not match");
                    return;
                }
                printWriter.println("OK");
            } else {
                printWriter.println("FAILED - Key expected to start Communication");
                return;
            }
            while ((string8 = bufferedReader.readLine()) != null) {
                Object object4;
                List<Action> list2;
                Object object6;
                object3 = null;
                string5 = null;
                object2 = null;
                if (string8.contains("jsonsearch")) {
                    stringArray = string8.split("~");
                    object = new HashMap();
                    object.put(stringArray[1].split("::")[0].trim(), stringArray[1].split("::")[1].trim());
                    object6 = (String)object.get("query");
                    Output.printTrace("Fetching result for query ", 3);
                    Output.printTrace("Fetching result for query " + ((String)object6).trim(), 3);
                    if (this.sjr == null) {
                        Output.printTrace("Setting ipath " + this.ipath, 3);
                        this.sjr = new SearchJsonReceiver(this.ipath);
                        this.ms = new MetadataSearcher(this.mpath);
                    }
                    RequestHelperString i = new RequestHelperString(this.sjr, this.mi, this.ms);
                    Output.printTrace("Fetching result for query done" + ((String)object6).trim(), 3);
                    list2 = i.get_result(((String)object6).trim());
                    printWriter.println((String)((Object)list2));
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                stringArray = string8.split(":");
                if (stringArray.length > 0) {
                    object3 = stringArray[0].trim();
                }
                if (stringArray.length > 1) {
                    string5 = stringArray[1].trim();
                }
                if (stringArray.length > 2) {
                    object2 = stringArray[2];
                }
                if (stringArray.length > 3) {
                    int n = string8.indexOf(stringArray[1]);
                    object2 = string8.substring(n + stringArray[1].length() + 1);
                }
                Output.printTrace("Host: " + (String)object3 + " Name : " + string5 + " Args : ", 3);
                if (string5.equals("checkTFAMain")) {
                    printWriter.println("CheckOK");
                    bl = true;
                    break;
                }
                if (string5.equals("getTFARunMode")) {
                    printWriter.println("TFA_RUN_MODE:" + string);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string5.equals("Bye")) {
                    printWriter.println("Bye");
                    bl = true;
                    break;
                }
                if (Thread.interrupted()) {
                    printWriter.println("Closing due to Interruption");
                    printWriter.println("Bye");
                    Output.printTrace("Received Message to shutdown through Interrupt", 2);
                    break;
                }
                if (string5.equals("transferfile")) {
                    Output.printTrace("Inside transferfile " + (String)object2, 3);
                    Output.printTrace("Inside transferfile coming from " + (String)object3, 3);
                    String[] stringArray2 = ((String)object2).split(":");
                    object6 = stringArray2[0];
                    String i = stringArray2[1];
                    list2 = object3;
                    if (stringArray2.length > 2) {
                        list2 = stringArray2[2];
                    }
                    printWriter.println("READY_TO_RECIVE_FILE");
                    File file = new File((String)object6);
                    object4 = new Thread((Runnable)new TransferFile((String)object3, (String)object6, i, inputStream, (String)((Object)list2)), "TransferFileThread");
                    ((Thread)object4).start();
                    ((Thread)object4).join();
                    printWriter.println("SUCCESS");
                    bl = true;
                    continue;
                }
                if (string8.contains("addcollectornode")) {
                    TFAReceiverManager.addCollectorNode((String)object2);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string5.equals("processbug")) {
                    void var20_39;
                    System.out.println(" processbug in ReceiverMessageHandler");
                    String[] stringArray3 = ((String)object2).split("~");
                    object6 = new HashMap();
                    boolean i = true;
                    while (var20_39 < stringArray3.length) {
                        object6.put(stringArray3[var20_39].split("=")[0].trim(), stringArray3[var20_39].split("=")[1].trim());
                        ++var20_39;
                    }
                    String string10 = (String)object6.get("processbug");
                    list2 = (String)object6.get("nthreads");
                    int n = Integer.parseInt((String)((Object)list2));
                    object4 = new Bugfiles(string10, n);
                    ((Bugfiles)object4).sendToReceiver();
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string8.contains("getpollingthreadaction")) {
                    TFAReceiver tFAReceiver = TFAReceiver.getReceiverEntityByHost(((String)object3).trim());
                    object6 = tFAReceiver.getAttr("group");
                    String string11 = "tfar_" + ((String)object6).trim() + "_";
                    list2 = Action.getAction(string11 + "updatereceivers", "REQUESTED", false);
                    if (list2.size() == 0) {
                        list2 = Action.getAction(string11 + "stopproducer", "REQUESTED", false);
                    }
                    if (list2.size() == 0) {
                        list2 = Action.getAction(string11 + "startmonitor", "REQUESTED", false);
                    }
                    if (list2.size() == 0) {
                        list2 = Action.getAction(string11 + "removecollector", "REQUESTED", false);
                    }
                    if (list2.size() == 0) {
                        list2 = Action.getAction(string11 + "resetoosmonitor", "REQUESTED", false);
                    }
                    String string12 = this.updateActions(list2);
                    printWriter.println(string12);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string8.contains("sendsysinfo")) {
                    void var20_43;
                    String[] stringArray4 = ((String)object2).split("~");
                    object6 = new HashMap<String, String>();
                    boolean bl2 = true;
                    while (var20_43 < stringArray4.length) {
                        object6.put(stringArray4[var20_43].split("=")[0].trim(), stringArray4[var20_43].split("=")[1].trim());
                        ++var20_43;
                    }
                    String string13 = (String)object6.get("cores");
                    list2 = (String)object6.get("fm");
                    String string14 = (String)object6.get("mm");
                    object4 = (String)object6.get("node");
                    String string15 = (String)object6.get("cluster_name");
                    string15 = string15.trim();
                    String string16 = "Node:" + (String)object4 + " Cores:" + string13 + " Free Memory:" + list2 + " Maximum Memory:" + string14;
                    String string17 = (String)object4 + ".tfainfo";
                    Output.printTrace("sending " + string2 + " " + string17, 3);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string8.contains("getcollectornodes")) {
                    Set<String> set = RGlobal.collectorKeys.keySet();
                    for (String string18 : set) {
                        printWriter.println("Collector:" + string18.trim());
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string8.contains("syncreceivernodes")) {
                    String[] stringArray5 = ((String)object2).split(":");
                    object6 = stringArray5[0];
                    Output.printTrace("Syncing cluster nodes with source as " + (String)object6, 1);
                    TFAReceiverManager.syncRNodes((String)object6);
                    printWriter.println("SUCCESS");
                    bl = true;
                    continue;
                }
                if (string5.equals("printhosts")) {
                    Output.printTrace("Print Hosts Requested", 3);
                    TFAHost.printAll(printWriter);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string5.equals("printhostsandport")) {
                    Output.printTrace("Print Hosts Requested", 3);
                    int n = RGlobal.receiverPortForCollectors;
                    object6 = this.getAllReceiverPorts(n);
                    Set<Map.Entry<String, Integer>> set = ((HashMap)object6).entrySet();
                    for (Map.Entry entry : set) {
                        Output.printTrace("Host Name:" + (String)entry.getKey() + "," + entry.getValue(), 3);
                        printWriter.println("Host Name:" + (String)entry.getKey() + "," + entry.getValue());
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string5.equals("printreceivers")) {
                    Output.printTrace("Print Receivers Requested", 3);
                    TFAReceiver.printAll(printWriter, "collector", false);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string5.equals("updaternodes")) {
                    object6 = ((String)object2).split(":");
                    String[] stringArray2 = object6[0].split("~");
                    list2 = object6[1];
                    for (int i = 0; i < stringArray2.length; ++i) {
                        Output.printTrace("updaternodes:(SOURCE,action)=(" + stringArray2[i] + "," + list2 + ")", 3);
                        Output.printTrace("updaternodes: Calling TFAReceiverManager.updateRNodes()", 3);
                        String string15 = TFAReceiverManager.updateRNodes(stringArray2[i], (String)((Object)list2), true, -1, null, null);
                        if (!((String)((Object)list2)).equals("ph")) continue;
                        TFAReceiverManager.syncRNodes(string2);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string5.equals("removereceiver")) {
                    String string16 = ((String)object2).split(":")[0].trim();
                    object6 = TFAReceiverManager.removeGroup(string16, (String)object3);
                    Map<String, Integer> map = Global.getPortMapping();
                    map.remove(string16);
                    Output.printTrace("updating port mapping after removal of " + string16, 3);
                    Output.printTrace("port mapping after removal" + map, 3);
                    Global.setPortMapping(map);
                    Properties.getInstance();
                    Properties.writePortMappingToFile(map);
                    printWriter.println((String)object6);
                    bl = true;
                    continue;
                }
                if (string5.equals("transferdata")) {
                    try {
                        TransferData transferData = new TransferData(inputStream);
                        transferData.start();
                    }
                    catch (Exception exception) {
                        Output.printTrace("Can not transfer data", 1);
                    }
                    bl = true;
                    continue;
                }
                if (string5.equals("sendfiletor")) {
                    Object var18_32 = null;
                    Output.printTrace("actionArgs in sendfiletor: " + (String)object2, 3);
                    object6 = ((String)object2).split(":");
                    String string19 = object6[0].trim();
                    list2 = TopicManager.getTopic();
                    String string20 = (String)((Object)list2) + ":9092";
                    try {
                        Output.printTrace((String)((Object)list2) + "," + string20 + ":" + RGlobal.kvInt.get("k.producer.port") + ", " + string19, 3);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.out);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string5.equals("jsonsearch")) {
                    void var20_51;
                    String[] stringArray6 = ((String)object2).split("~");
                    object6 = new HashMap();
                    boolean bl3 = true;
                    while (var20_51 < stringArray6.length) {
                        object6.put(stringArray6[var20_51].split("=")[0].trim(), stringArray6[var20_51].split("=")[1].trim());
                        ++var20_51;
                    }
                    String string21 = (String)object6.get("query");
                    if (this.sjr == null) {
                        Output.printTrace("Setting ipath " + this.ipath, 3);
                        this.sjr = new SearchJsonReceiver(this.ipath);
                    }
                    list2 = new RequestHelperString(this.sjr, this.mi, this.ms);
                    Output.printTrace("Fetching result for query " + string21.trim(), 3);
                    String string22 = ((RequestHelperString)((Object)list2)).get_result(string21.trim());
                    printWriter.println(string22);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (bl) continue;
                printWriter.println("Unknown Action received");
                printWriter.println("FAIL");
            }
            Output.printTrace("ReceiverMessageHandler : Closing and Exiting", 3);
            printWriter.close();
            bufferedReader.close();
            this.socket.close();
        }
        catch (Exception exception) {
            Output.print("ReceiverMessageHandler : IOException in running ReceiverMessageHandler thread");
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Integer> getAllReceiverPorts(int n) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        String string = null;
        String string2 = null;
        String string3 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        String string4 = string3 + ":printreceiverport:" + string3;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            for (TFAHost tFAHost : entityCursor) {
                string2 = tFAHost.getHostname().trim();
                Output.printTrace("getAllReceiverPorts: NodeName=" + string2, 3);
                if (string2.equalsIgnoreCase(string3)) {
                    hashMap.put(string2, n);
                    continue;
                }
                Output.printTrace("getAllReceiverPorts: Make socket con to: " + string2, 3);
                Properties.getInstance();
                String string5 = Properties.trustStore;
                Properties.getInstance();
                String string6 = Properties.trustStorePassword;
                sSLSocket = SocketManager.getSecureSocketConnection(string2, Global.getSocketPort(), string5, string6);
                if (null == sSLSocket) {
                    Output.printTrace("getAllReceiverPorts: Make socket con toi failed: " + string2, 3);
                    continue;
                }
                printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter.println(string4);
                bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string = bufferedReader.readLine()) != null && !string.equals("DONE")) {
                    if (!string.contains("PORT")) continue;
                    String string7 = string.trim();
                    String[] stringArray = string7.split(":");
                    Output.printTrace("getAllReceiverPorts: NodeName=" + string7, 3);
                    hashMap.put(string2, Integer.parseInt(stringArray[1].trim()));
                }
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string2, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string2, 1);
            iOException.printStackTrace();
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    public String updateActions(List<Action> list) {
        String string = "NONE";
        if (list.size() > 0) {
            try {
                for (Action action : list) {
                    Output.printTrace("processing action:" + action.getActionName() + ":" + action.getActionStatus(), 3);
                    string = action.getActionRequestArgs();
                    action.setActionComplete();
                    action.store();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Output.printTrace("returning:" + string, 3);
        return string;
    }
}

