/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.security.KeyStore;
import java.util.HashSet;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.MessageHandler;
import oracle.rat.tfa.nls.Omsg;
import oracle.rat.tfa.nls.Oprint;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;

public class ReceiverConnectionAcceptorSSL
implements Runnable {
    @Override
    public void run() {
        SSLServerSocket sSLServerSocket = null;
        boolean bl = true;
        Properties properties = Properties.getInstance();
        String string = Properties.keyStore;
        char[] cArray = Properties.serverTrustStorePassword.toCharArray();
        char[] cArray2 = Properties.serverKeyStorePassword.toCharArray();
        System.setProperty("javax.net.ssl.trustStore", string);
        System.setProperty("javax.net.ssl.trustStorePassword", Properties.serverKeyStorePassword);
        System.setProperty("javax.net.ssl.keyStorePassword", Properties.serverKeyStorePassword);
        Output.printTrace("Connection Acceptor Thread started", 3);
        StringBuilder stringBuilder = new StringBuilder().append("Setting port in ReceiverConnectionAcceptorSSL ");
        Properties.getInstance();
        Output.printTrace(stringBuilder.append(Properties.getSocketPort()).toString(), 3);
        StringBuilder stringBuilder2 = new StringBuilder().append("Setting port in ReceiverConnectionAcceptorSSL ");
        Properties.getInstance();
        Output.printTrace(stringBuilder2.append(Properties.getSocketPort()).toString(), 1);
        int n = 8888;
        if (n == -1) {
            Output.print("Could not find a free port to run TFA");
            return;
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(string), cArray);
            String string2 = Properties.platform;
            Output.printTrace("OS Name : " + string2, 3);
            KeyManagerFactory keyManagerFactory = SocketManager.getSystemSpecificKeyManager();
            if (keyManagerFactory == null) {
                Output.print("Platform " + string2 + " is not supported.");
                return;
            }
            keyManagerFactory.init(keyStore, cArray2);
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
            SSLServerSocketFactory sSLServerSocketFactory = sSLContext.getServerSocketFactory();
            sSLServerSocket = (SSLServerSocket)sSLServerSocketFactory.createServerSocket(n);
            sSLServerSocket.setSoTimeout(5000);
            sSLServerSocket.setNeedClientAuth(false);
            String[] stringArray = sSLServerSocket.getEnabledProtocols();
            HashSet<String> hashSet = new HashSet<String>();
            for (String string3 : stringArray) {
                if (string3.equals("SSLv3") || string3.equals("SSLv2Hello")) continue;
                hashSet.add(string3);
            }
            Output.print("EnabledProtocol: " + hashSet);
            sSLServerSocket.setEnabledProtocols(hashSet.toArray(new String[0]));
            Output.printTrace("PublicConnAcceptor InetAddress: " + sSLServerSocket.getInetAddress(), 3);
            Output.printTrace("PublicConnAcceptor LocalPort: " + sSLServerSocket.getLocalPort(), 3);
            Output.printTrace("supported cipher suites :", 3);
            for (String string3 : sSLServerSocket.getSupportedCipherSuites()) {
                Output.printTrace(string3, 3);
            }
            Properties.getInstance();
            Properties.setKeystoresUpdated(true);
            String[] stringArray2 = new String[]{"SSL_RSA_WITH_3DES_EDE_CBC_SHA"};
            sSLServerSocket.setEnabledCipherSuites(stringArray2);
            Output.printTrace("enabled cipher suites :", 3);
            for (String string4 : sSLServerSocket.getEnabledCipherSuites()) {
                Output.printTrace(string4, 3);
            }
            while (bl) {
                try {
                    new Thread(new MessageHandler((SSLSocket)sSLServerSocket.accept())).start();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (!Thread.interrupted()) continue;
                    Output.printTrace("This Thread was Interrupted", 2);
                    bl = false;
                }
            }
            Output.printTrace("Received Message to shutdown through Interrupt", 2);
            if (!sSLServerSocket.isClosed()) {
                sSLServerSocket.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Output.printTrace("Could not listen on port: " + n, 1);
            System.exit(-1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private boolean isPortAvailable(int n) {
        Oprint oprint = new Oprint("en-US", "en", "UTF-8", "US");
        Omsg omsg = new Omsg("en-US", "en", "UTF-8", "US");
        Output.printTrace("Checking for port availability : " + n, 3);
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(n);
            serverSocket.close();
        }
        catch (IOException iOException) {
            System.out.println("Could not listen on port: " + n);
            return false;
        }
        return true;
    }

    private static void printServerSocketInfo(SSLServerSocket sSLServerSocket) {
        Output.printTrace("Server socket class: " + sSLServerSocket.getClass(), 4);
        Output.printTrace("   Socker address = " + sSLServerSocket.getInetAddress().toString(), 4);
        Output.printTrace("   Socker port = " + sSLServerSocket.getLocalPort(), 4);
        Output.printTrace("   Need client authentication = " + sSLServerSocket.getNeedClientAuth(), 4);
        Output.printTrace("   Want client authentication = " + sSLServerSocket.getWantClientAuth(), 4);
        Output.printTrace("   Use client mode = " + sSLServerSocket.getUseClientMode(), 4);
    }
}

