/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.util.Calendar;
import java.util.Date;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.DatabaseGeneralError;
import oracle.rat.tfa.entity.entitykey.ActionKey;
import oracle.rat.tfa.entity.entitykey.DatabaseGeneralErrorKey;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;

public class PurgeTFAMetadata
extends Thread {
    private Date lastRun = null;
    private long purgePeriod = 7L;

    public void setLastRun(Date date) {
        this.lastRun = date;
    }

    public Date getLastRun() {
        return this.lastRun;
    }

    public void setPurgePeriod(long l) {
        this.purgePeriod = l;
    }

    public long getPurgePeriod() {
        return this.purgePeriod;
    }

    public PurgeTFAMetadata() {
    }

    public PurgeTFAMetadata(long l) {
        this.purgePeriod = l;
    }

    @Override
    public void run() {
        long l;
        long l2;
        long l3;
        EntityCursor entityCursor;
        PrimaryIndex primaryIndex;
        CursorConfig cursorConfig;
        this.setName("PurgeTFAMetadata");
        Output.printTrace("Thread PurgeTFAMetadata Started...", 3);
        Transaction transaction = null;
        long l4 = 0L;
        long l5 = this.purgePeriod * 24L * 60L * 60L;
        this.lastRun = new Date();
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(DatabaseGeneralErrorKey.class, DatabaseGeneralError.class);
            entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (Object object : entityCursor) {
                    l3 = ((DatabaseGeneralError)object).getErrorTimeObj().getTime();
                    l2 = Calendar.getInstance().getTimeInMillis();
                    l = (l2 - l3) / 1000L;
                    if (l < l5) continue;
                    primaryIndex.delete((Object)((DatabaseGeneralError)object).getKey());
                    ++l4;
                }
                LogFile.writeLog("PurgeTFAMetadata: Total Events Purged : " + l4);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("PurgeTFAMetadata : Exception while purging TFA Metdata : " + exception.getMessage());
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("Exception while puging TFA Metdata : " + databaseException.getMessage());
        }
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(ActionKey.class, Action.class);
            entityCursor = primaryIndex.entities(transaction, cursorConfig);
            l4 = 0L;
            try {
                for (Object object : entityCursor) {
                    if (((Action)object).getActionCompleteTime() == null) continue;
                    l3 = ((Action)object).getActionCompleteTime().getTime();
                    l2 = Calendar.getInstance().getTimeInMillis();
                    l = (l2 - l3) / 1000L;
                    if (l5 <= 0L) {
                        l5 = 604800L;
                    }
                    if (l < l5) continue;
                    primaryIndex.delete((Object)((Action)object).getKey());
                    ++l4;
                }
                LogFile.writeLog("PurgeTFAMetadata: Total Actions Purged : " + l4);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Output.print("PurgeTFAMetadata : Exception while purging TFA Actions : " + exception.getMessage());
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("Exception while puging TFA Actions : " + databaseException.getMessage());
        }
    }
}

