/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import oracle.rat.tfa.RepositoryManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.util.FileHelper;
import oracle.rat.tfa.util.Output;
import org.apache.commons.io.FileSystemUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.comparator.SizeFileComparator;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;

public class PurgeTFACollections
extends Thread {
    private Date lastRun = null;
    private int oratopPurgePeriodDays = 15;

    public void setLastRun(Date date) {
        this.lastRun = date;
    }

    public Date getLastRun() {
        return this.lastRun;
    }

    public void setOratopPurgePeriodDays(int n) {
        this.oratopPurgePeriodDays = n;
    }

    public int getOratopPurgePeriodDays() {
        return this.oratopPurgePeriodDays;
    }

    @Override
    public void run() {
        this.setName("PurgeTFACollections");
        if (!Global.isAutoPurge()) {
            Output.printTrace("Unable to start PurgeTFACollections as AutoPurge flag is " + Global.isAutoPurge(), 3);
            return;
        }
        Output.printTrace("Thread PurgeTFACollections Started...", 3);
        this.lastRun = new Date();
        try {
            Object object;
            File file;
            String string = RepositoryManager.getInstance().getDirectory();
            try {
                file = new File(string + File.separator + "oratop");
                if (file.exists()) {
                    PrefixFileFilter prefixFileFilter = new PrefixFileFilter("oratop-", IOCase.SENSITIVE);
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(6, -this.oratopPurgePeriodDays);
                    object = calendar.getTime();
                    AgeFileFilter ageFileFilter = new AgeFileFilter((Date)object);
                    AndFileFilter andFileFilter = new AndFileFilter((IOFileFilter)prefixFileFilter, (IOFileFilter)ageFileFilter);
                    PrefixFileFilter prefixFileFilter2 = file.listFiles((FilenameFilter)andFileFilter);
                    if (((File[])prefixFileFilter2).length > 0) {
                        for (Comparable<File> comparable : prefixFileFilter2) {
                            if (comparable.delete()) {
                                Output.print("Purged Oratop Collection: " + comparable.getName());
                                continue;
                            }
                            Output.print("Unable to Purge Oratop Collection :" + comparable.getName());
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Output.printTrace("Exception while purging Oratop files in PurgeTFACollections", 2);
            }
            try {
                file = new File(string);
                if (file.exists()) {
                    long l = FileSystemUtils.freeSpaceKb((String)string) / 1024L;
                    Output.printTrace("Disk Space Available in  " + string + " : " + l + " MB", 3);
                    object = RepositoryManager.getInstance();
                    int n = Global.getMinPossibleSpaceForPurge();
                    if (((RepositoryManager)object).getMaxSizeMegabytes() < (long)n) {
                        n = (int)((RepositoryManager)object).getMaxSizeMegabytes();
                    }
                    Output.printTrace("Minimum Space Required for Purge : " + n + " MB", 3);
                    long l2 = ((RepositoryManager)object).getMaxSizeMegabytes() - ((RepositoryManager)object).getCurrentSizeMegabytes();
                    if (l2 < 0L) {
                        l2 = 0L;
                    }
                    Output.printTrace("Actual Free Space Available in Repostory : " + l2 + " MB", 3);
                    if (l <= (long)Global.getMinPossibleSpaceForPurge() || l2 <= 0L) {
                        Comparable<File> comparable;
                        PrefixFileFilter prefixFileFilter = new PrefixFileFilter(new String[]{"oratop-", "suptools"}, IOCase.SENSITIVE);
                        NotFileFilter notFileFilter = new NotFileFilter((IOFileFilter)prefixFileFilter);
                        Calendar calendar = Calendar.getInstance();
                        calendar.add(11, -Global.getMinFileAgeToPurge());
                        comparable = calendar.getTime();
                        AgeFileFilter ageFileFilter = new AgeFileFilter((Date)comparable);
                        AndFileFilter andFileFilter = new AndFileFilter((IOFileFilter)notFileFilter, (IOFileFilter)ageFileFilter);
                        File[] fileArray = file.listFiles((FilenameFilter)andFileFilter);
                        Output.printTrace("No of collections after applying filters : " + fileArray.length, 3);
                        if (fileArray.length > 0) {
                            Arrays.sort(fileArray, SizeFileComparator.SIZE_SUMDIR_REVERSE);
                            ArrayList<File> arrayList = new ArrayList<File>();
                            long l3 = l2;
                            long l4 = 0L;
                            for (int i = 0; i < fileArray.length; ++i) {
                                l4 = FileHelper.sizeOfDirectory(fileArray[i].getAbsolutePath()) / 0x100000L;
                                arrayList.add(fileArray[i]);
                                Output.printTrace("Collection Details : " + fileArray[i].getName() + " Size : " + l4 + " MB", 3);
                                if ((l3 += l4) > (long)n) break;
                            }
                            if (arrayList.size() > 0) {
                                for (File file2 : arrayList) {
                                    try {
                                        Output.print("Purging TFA Collection : " + file2.getAbsolutePath());
                                        Output.printTrace("Purging TFA Collection : " + file2.getAbsolutePath(), 3);
                                        FileUtils.deleteDirectory((File)file2);
                                    }
                                    catch (IOException iOException) {
                                        Output.printTrace("IOException in PurgeTFACollections while removing " + file2.getAbsolutePath(), 1);
                                    }
                                }
                            }
                            Output.printTrace("Purged " + (l3 - l2) + " MB", 3);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Output.printTrace("IOException while purging TFA collections in Thread PurgeTFACollections", 2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Output.printTrace("IOException in Thread PurgeTFACollections", 2);
        }
    }
}

