/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.ThreadInterruptedException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import oracle.rat.tfa.PrivateIPMessageHandler;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class PrivateConnAcceptor
implements Runnable {
    public static boolean listening = true;

    @Override
    public void run() {
        ServerSocket serverSocket = null;
        Properties properties = Properties.getInstance();
        int n = properties.getPrivatePort();
        if (n == -1) {
            Output.print("Could not find a free port to run privateConnectionAcceptor");
            return;
        }
        try {
            block19: {
                for (int i = 0; i < 12 && !new File(Properties.internalDir + File.separator + "dbs.txt").exists(); ++i) {
                    Thread.sleep(10000L);
                }
                try {
                    String[] stringArray;
                    InetAddress inetAddress = null;
                    NetworkInterface networkInterface = NetworkInterface.getByName("priv1");
                    if (networkInterface != null) {
                        stringArray = networkInterface.getInetAddresses();
                        inetAddress = Collections.list(stringArray).get(0);
                    }
                    if (inetAddress == null) {
                        for (String string : stringArray = new String[]{"192.168.16.24", "192.168.16.25"}) {
                            try {
                                inetAddress = InetAddress.getByName(string);
                                if (inetAddress == null || (serverSocket = new ServerSocket(n, 5, inetAddress)) == null) continue;
                                break block19;
                            }
                            catch (Exception exception) {
                                Output.print("Could not create socket with Private IP Address: " + string);
                            }
                        }
                        break block19;
                    }
                    serverSocket = new ServerSocket(n, 5, inetAddress);
                }
                catch (Exception exception) {
                    Output.print("Unable to determine Private IP Address");
                    return;
                }
            }
            if (serverSocket == null) {
                Output.print("Cound not create socket with private IP Address");
                return;
            }
            Output.print("PrivateConnectionAcceptor InetAddress " + serverSocket.getInetAddress());
            Output.print("PrivateConnectionAcceptor LocalPort " + serverSocket.getLocalPort());
            while (listening) {
                try {
                    new Thread(new PrivateIPMessageHandler(serverSocket.accept())).start();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    Output.print("PrivateConnAcceptor: SocketTimeoutException");
                    listening = false;
                }
                catch (ThreadInterruptedException threadInterruptedException) {
                    Output.print("PrivateConnAcceptor: This Thread was Interrupted");
                    listening = false;
                }
            }
            LogFile.writeLog("PrivateConnAcceptor: Received Message to shutdown through Interrupt");
            if (!serverSocket.isClosed()) {
                serverSocket.close();
            }
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
            Output.printTrace("Could not determine private IPAddress: ", 1);
            System.exit(-1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Output.printTrace("Could not listen on port: " + n, 1);
            System.exit(-1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }
}

