/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.util.Date;
import oracle.rat.tfa.RediscoveryThread;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.Utilities;

public class PeriodicChecker
extends Thread {
    private boolean stopThread = false;
    private boolean stopOldThread = true;
    private Date lastRediscoveryRun = null;

    @Override
    public void run() {
        Thread.currentThread().setName("PeriodicChecker");
        RediscoveryThread rediscoveryThread = null;
        long l = 60000L;
        int n = 1;
        LogFile.writeLog("PeriodicChecker : Sleeping for 5 minutes before starting first rediscovery");
        try {
            Thread.sleep(300000L);
            Output.printTrace("Starting first rediscovery..." + Properties.sslSwitch + Properties.userCert + Global.firstDiscovery, 3);
            if ((Properties.sslSwitch != 0 || Properties.userCert != 0) && Global.firstDiscovery == 0) {
                LogFile.writeLog("PeriodicChecker : Starting first rediscovery...");
                this.lastRediscoveryRun = new Date();
                rediscoveryThread = new RediscoveryThread("full");
                rediscoveryThread.start();
                this.stopOldThread = false;
                rediscoveryThread.join();
                try {
                    Utilities.writeToConfigPropertiesFile("firstDiscovery", "1");
                    Global.setFirstDiscovery(1);
                }
                catch (Exception exception) {
                    Output.print("Exception while updating config file " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Output.printTrace("Caught Interrupt Signal in PeriodicChecker", 3);
            this.stopThread = true;
            this.stopOldThread = true;
        }
        catch (Exception exception) {
            Output.print("Exception in PeriodicChecker" + exception.getMessage());
            exception.printStackTrace();
        }
        while (!this.stopThread) {
            try {
                Output.printTrace("periodicChecker sleep begin", 3);
                Thread.sleep(300000L);
                Output.printTrace("periodicChecker sleep end", 3);
                if (n == 72) {
                    n = 0;
                }
                int n2 = 1;
                while (!this.stopOldThread) {
                    Output.printTrace("Checking if rediscovery thread is alive : " + rediscoveryThread, 3);
                    if (rediscoveryThread != null) {
                        Output.printTrace("isAlive : " + rediscoveryThread.isAlive(), 3);
                    }
                    if (rediscoveryThread != null && rediscoveryThread.isAlive()) {
                        rediscoveryThread.join(l);
                        if (rediscoveryThread.isAlive()) {
                            Output.printTrace("Rediscovery thread is still alive. So sleeping for 4 more minutes for " + n2 + " times...", 3);
                            Thread.sleep(240000L);
                            ++n2;
                        }
                        if (n2 < 12) continue;
                        Output.printTrace("Limit reached : " + n2 + " times. So stopping Rediscovery thread", 3);
                        rediscoveryThread.stopRediscovery();
                        Output.printTrace("Last leg sleep of 4 more minutes waiting for rediscovery to stop", 3);
                        Thread.sleep(240000L);
                        this.stopOldThread = true;
                        continue;
                    }
                    this.stopOldThread = true;
                }
                if (n == 0) {
                    this.lastRediscoveryRun = new Date();
                    LogFile.writeLog("PeriodicChecker : New full rediscovery thread started");
                    rediscoveryThread = new RediscoveryThread("full");
                    rediscoveryThread.start();
                    this.stopOldThread = false;
                    ++n;
                    continue;
                }
                if (n % 12 == 0) {
                    LogFile.writeLog("PeriodicChecker : Lite rediscovery ran 12 times in last hour");
                }
                rediscoveryThread = new RediscoveryThread("lite");
                rediscoveryThread.start();
                this.stopOldThread = false;
                ++n;
            }
            catch (InterruptedException interruptedException) {
                Output.printTrace("Caught Interrupt Signal in PeriodicChecker", 3);
                this.stopThread = true;
                this.stopOldThread = true;
            }
            catch (Exception exception) {
                Output.print("Exception in PeriodicChecker : " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public void stopPeriodicChecker() {
        this.stopThread = true;
        this.stopOldThread = true;
    }

    public Date getLastRediscoveryRun() {
        return this.lastRediscoveryRun;
    }

    public static void main(String[] stringArray) {
        PeriodicChecker periodicChecker = new PeriodicChecker();
        periodicChecker.start();
    }
}

