/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import oracle.rat.tfa.ActionHandler;
import oracle.rat.tfa.CollectionManager;
import oracle.rat.tfa.ComponentEntityManager;
import oracle.rat.tfa.CreateFileEntitiesFromXml;
import oracle.rat.tfa.DiagCollectionTransfer;
import oracle.rat.tfa.RepositoryManager;
import oracle.rat.tfa.TFADirectoryManager;
import oracle.rat.tfa.TFAHostManager;
import oracle.rat.tfa.TFAInventoryManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DbPut;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.AlertClusterEviction;
import oracle.rat.tfa.entity.AlertClusterReconfiguration;
import oracle.rat.tfa.entity.DatabaseGeneralError;
import oracle.rat.tfa.entity.DatabaseParameter;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.Generic;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.InstanceShutdown;
import oracle.rat.tfa.entity.InstanceStartup;
import oracle.rat.tfa.entity.InventoryRun;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.singletons.DirectoryMappings;
import oracle.rat.tfa.type.DirectoryMappingType;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.xml.FileTypePatternXMLReader;
import oracle.rat.tfa.xml.SimileJSON;

public class OfflineMessageHandler {
    private static String offlineRun(String string) {
        int n;
        PrintWriter printWriter = new PrintWriter(System.out, true);
        Object object = "";
        boolean bl = false;
        Output.printTrace("Received: Message " + string + " at Server", 2);
        Output.print("Received: Message " + string + " at Server");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String[] stringArray = string.split(":");
        if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        if (stringArray.length > 1) {
            string3 = stringArray[1];
        }
        if (stringArray.length > 2) {
            string4 = stringArray[2];
        }
        if (stringArray.length > 3) {
            n = string.indexOf(stringArray[1]);
            string4 = string.substring(n + stringArray[1].length() + 1);
        }
        Output.printTrace("Host : " + string2 + " Name : " + string3 + " Args : " + string4, 2);
        if (string.contains("checkTFAMain")) {
            printWriter.println("CheckOK");
            object = "DONE";
            bl = true;
        } else if (string.contains("checkTFAStatus")) {
            String string5 = new Host().getHostname().trim();
            String string6 = Properties.getTFABuildID();
            printWriter.println("CheckOK!" + string5 + "!-!" + "OFFLINE" + "!" + Properties.tfaVersion + "!" + string6 + "!" + "COMPLETED");
            object = "DONE";
            bl = true;
        } else if (string.contains("Bye")) {
            object = "Bye";
            bl = true;
        } else if (string.contains("checkversion")) {
            printWriter.println("TFA Version: " + Properties.tfaVersion);
            object = "DONE";
            bl = true;
        } else if (string.contains("runinventory")) {
            Output.print("Storing: " + string3 + ":" + string2 + ":" + string4);
            Action action = new Action(string3, string2, "tfactl", string4);
            action.store();
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("recreatefileentitiesinbdb")) {
            Output.print("Inside recreatefileentitiesinbdb");
            CreateFileEntitiesFromXml createFileEntitiesFromXml = new CreateFileEntitiesFromXml(Properties.inventoryXMLFile);
            DbPut dbPut = DbManager.getInstance().getDbPut();
            for (FileEntity fileEntity : createFileEntitiesFromXml.getFileEntities()) {
                Output.print("Storing file entity : " + fileEntity.getFileName());
                fileEntity.printFileDetails();
                dbPut.storeFileEntity(fileEntity);
            }
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("printlocationofrepository")) {
            printWriter.println(RepositoryManager.getInstance().getDirectory());
            object = "DONE";
            bl = true;
        } else if (string.contains("runodscan")) {
            Action action = new Action(string3, string2, "tfactl", string4);
            action.store();
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("syncdb")) {
            Output.print("Syncing files to Oracle DB");
            FileEntity.dumpFilestoOracle();
            Output.print("Done syncing files to Oracle DB");
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("createSimileTimeline")) {
            SimileJSON simileJSON = new SimileJSON();
            printWriter.println("SUCCESS");
            bl = true;
        } else if (string.contains("checkdbexistance")) {
            n = OfflineMessageHandler.checkDbExistance(string4) ? 1 : 0;
            if (n != 0) {
                printWriter.println("DB EXISTS");
            } else {
                printWriter.println("DB DOES NOT EXIST");
            }
            printWriter.println("DONE");
        } else if (string.contains("startdiagcollection")) {
            Action action = new Action(string3, string2, "tfactl", string4);
            action.store();
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("addclouddirectory")) {
            string4 = string4.trim();
            Output.printTrace("ActionArgs for add directory: " + string4, 3);
            String[] stringArray2 = string4.split(":");
            String string7 = stringArray2[0].trim();
            String string8 = stringArray2[1].trim();
            String string9 = null;
            String string10 = "";
            String string11 = System.getenv("SRCHOME");
            boolean bl2 = Properties.isTFAOnADE();
            if (string11 == null || string11.length() == 0) {
                bl2 = false;
            }
            try {
                string11 = new File(string11).getCanonicalPath();
                Output.printTrace("srcHome : " + string11 + " , isADE : " + bl2, 3);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string7));
                int n2 = 0;
                while ((string9 = bufferedReader.readLine()) != null) {
                    if (bl2 && string9.trim().startsWith(string11)) {
                        String string12 = System.getenv("ORACLE_SID");
                        Output.printTrace("ORACLE_SID : " + string12, 3);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add("RDBMS");
                        string10 = TFADirectoryManager.addDirectory(string9.trim(), string12, string12, arrayList, null, "", null, false, string8, "exclusions", false);
                    } else {
                        string10 = TFADirectoryManager.addDirectory(string9.trim(), "", "", null, null, "", null, false, string8, "exclusions", false);
                    }
                    Output.printTrace("AddCloudDir : " + string9.trim() + " , Status : " + string10, 3);
                    printWriter.println("COUNT : " + ++n2);
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Output.printTrace("addclouddirectory: Dir file not found " + string7, 1);
            }
            catch (Exception exception) {
                Output.printTrace("addclouddirectory: Failed to add directory " + string9, 1);
                exception.printStackTrace();
            }
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("adddirectory")) {
            Object object2;
            string4 = string4.trim();
            Output.print("actionArgs for add directory: " + string4);
            String[] stringArray3 = string4.split(":");
            String string13 = stringArray3[0];
            String string14 = "";
            String string15 = "";
            String string16 = "";
            String string17 = "exclusions";
            boolean bl3 = false;
            for (int i = 1; i < stringArray3.length; ++i) {
                if (stringArray3[i].trim().startsWith("-i")) {
                    string15 = stringArray3[i].trim().replaceFirst("-i ", "").trim();
                    continue;
                }
                if (stringArray3[i].trim().startsWith("-d")) {
                    string14 = stringArray3[i].trim().replaceFirst("-d ", "").trim();
                    continue;
                }
                if (!stringArray3[i].trim().startsWith("-r")) continue;
                string16 = stringArray3[i].trim().replaceFirst("-r ", "").trim();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (!string16.equals("") && (object2 = string16.split(",")) != null && ((String[])object2).length > 0) {
                for (String string18 : object2) {
                    if (string18.equals("")) continue;
                    if (string18.contains("%")) {
                        arrayList2.add(string18);
                        String[] stringArray4 = string18.split("%");
                        if (stringArray4 == null || stringArray4.length <= 0) continue;
                        arrayList.add(stringArray4[0]);
                        continue;
                    }
                    arrayList.add(string18.trim());
                }
            }
            Output.print("In Message Handler : " + string14 + " " + string15 + " " + arrayList);
            try {
                object = object2 = TFADirectoryManager.addDirectory(string13, string14, string15, arrayList, arrayList2, "", null, false, "root", string17, bl3);
                bl = true;
            }
            catch (IOException iOException) {}
        } else if (string.contains("checkdirectory")) {
            TFADirectoryManager.checkDirectory(string2, string4);
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("donecheckingdirectory")) {
            TFADirectoryManager.doneChecking(string2, string4);
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("donebuildingremotezip")) {
            String[] stringArray5 = string.split(":");
            string4 = stringArray5[2] + ":" + stringArray5[3];
            Action action = new Action(string3, string2, "tfactl", string4);
            action.store();
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("completeddiagcollection")) {
            Output.print("Inside completeddiagcollection " + string4);
            Thread thread = new Thread((Runnable)new DiagCollectionTransfer(string2, string4), "DiagCollectionTransferThread");
            thread.start();
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("removedirectory")) {
            String string19 = TFADirectoryManager.removeDirectory(string4, null, false);
            object = string19;
            bl = true;
        } else if (string.contains("settracelevel")) {
            Global.setTraceLevel(Integer.parseInt(string4.trim()));
            Global.setTracingOn();
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("settracingon")) {
            Global.setTracingOn();
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("settracingoff")) {
            Global.setTracingOff();
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("changerepository")) {
            string4 = string4.trim();
            Output.print("actionArgs for change repository : " + string4);
            String[] stringArray6 = string4.split(":");
            String string20 = stringArray6[0].trim();
            long l = RepositoryManager.getInstance().getMaxSizeMegabytes();
            RepositoryManager.getInstance().changeRepository(string20, l);
            printWriter.println("SUCCESS");
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("printrepository")) {
            RepositoryManager.getInstance().printRepository(printWriter);
            object = "DONE";
            bl = true;
        } else if (string.contains("hostsync")) {
            TFAHostManager.addHostOnly(string4, "blah", "blah", "/blah");
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("ziptracesfordates")) {
            Output.print("We got into ziptracesfordates");
            Action action = new Action(string3, string2, "tfactl", string4);
            action.store();
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("addhost")) {
            String string21 = TFAHostManager.addHost(string4, "blah", "blah", "/blah");
            object = string21;
            bl = true;
        } else if (string.contains("addcluster")) {
            object = "SUCCESS";
            bl = true;
        } else if (string.contains("printactions")) {
            Action.printAll(printWriter, null);
            object = "DONE";
            bl = true;
        } else if (string.contains("printcollections")) {
            CollectionManager.printCollections(printWriter);
            object = "DONE";
            bl = true;
        } else if (string.contains("showactionmonitor")) {
            Action.printAll(printWriter, null);
            object = "DONE";
            bl = true;
        } else if (string.contains("printhosts")) {
            Output.print("Print Hosts Requested");
            String string22 = new Host().getHostname().trim();
            printWriter.println("Host Name : " + string22);
            object = "DONE";
            bl = true;
        } else if (string.contains("printstartups")) {
            Output.print("Print Startups Requested");
            InstanceStartup.printAll(printWriter);
            object = "DONE";
            bl = true;
        } else if (string.contains("printshutdowns")) {
            Output.print("Print Shutdowns Requested");
            InstanceShutdown.printAll(printWriter);
            object = "DONE";
            bl = true;
        } else if (string.contains("printparameters")) {
            Output.print("Print Parameters Requested");
            DatabaseParameter.printAll(printWriter);
            object = "DONE";
            bl = true;
        } else if (string.contains("checkrepositoryisopen")) {
            n = RepositoryManager.getInstance().isRepositoryOpen() ? 1 : 0;
            if (n != 0) {
                printWriter.println("Repository is open");
            } else {
                printWriter.println("Repository is full and closed");
            }
            object = "DONE";
            bl = true;
        } else if (string.contains("printerrors")) {
            Output.print("Print Errors Requested");
            DatabaseGeneralError.printAll(printWriter);
            object = "DONE";
            bl = true;
        } else if (string.contains("printclustereviction")) {
            Output.print("Print Cluster Evictions Requested");
            AlertClusterEviction.printAll(printWriter);
            printWriter.println("DONE");
            bl = true;
        } else if (string.contains("printclusterreconfig")) {
            Output.print("Print Cluster Reconfigurations Requested");
            AlertClusterReconfiguration.printAll(printWriter);
            printWriter.println("DONE");
            bl = true;
        } else if (string.contains("printgenericevent")) {
            Output.print("Print Generic Events Requested");
            Generic.printAll(printWriter);
            printWriter.println("DONE");
            bl = true;
        } else if (string.contains("printinventory")) {
            Output.print("Print Inventory Requested");
            TFAInventoryManager.printInventory(printWriter);
            object = "DONE";
            bl = true;
        } else if (string.contains("printinventorymerge")) {
            Output.print("Print Inventory For Merge Requested");
            TFAInventoryManager.printInvFilesForMerge(printWriter, string4);
            object = "DONE";
            bl = true;
        } else if (string.contains("printdirectories")) {
            try {
                TFADirectoryManager.dumpDirectoriesinOffline(printWriter);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object = "DONE";
            bl = true;
        } else if (string.contains("printinvrunstat")) {
            InventoryRun.print(printWriter);
            object = "DONE";
            bl = true;
        } else if (string.contains("validatefiletypepattern")) {
            String string23 = FileTypePatternXMLReader.testFileType();
            if (string23.equals("")) {
                printWriter.println("Valid FileTypePatternXML");
            } else {
                printWriter.println("Invalid FileTypePatternXML. Please check FileType : " + string23);
            }
            printWriter.println("DONE");
            bl = true;
        } else if (string.contains("getsubcompvalues")) {
            Output.print("getsubcompvalues: " + string4);
            String string24 = ComponentEntityManager.getSubCompValues(string4.trim());
            printWriter.print(string24);
            printWriter.println("DONE");
            bl = true;
        } else if (!string.contains("stop TFAMain") && !bl) {
            Output.print("Unknown Offline Action received");
            Output.print(string);
            object = "FAIL";
        }
        try {
            Thread thread = new Thread((Runnable)new ActionHandler(), "ActionHandlerThread");
            thread.start();
            thread.join();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Output.print("Closing and Exiting");
        return object;
    }

    private static boolean checkDbExistance(String string) {
        string = string.trim();
        Output.printTrace("Checking for existance of database : " + string, 3);
        boolean bl = false;
        Vector vector = DirectoryMappings.getInstance().getDirectories();
        HashSet<String> hashSet = new HashSet<String>();
        for (DirectoryMappingType directoryMappingType : vector) {
            hashSet.add(directoryMappingType.database);
        }
        if (hashSet.contains(string.toLowerCase()) || hashSet.contains(string.toUpperCase())) {
            bl = true;
        }
        Output.printTrace("Database exists : " + bl, 3);
        return bl;
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        String string3 = "";
        Thread.currentThread().setName("OfflineMessageHandler");
        if (stringArray.length == 0) {
            String[] stringArray2 = new String[3];
            stringArray = stringArray2;
            stringArray[0] = "mynode:runinventory:";
            stringArray[1] = "-tfaHome";
            stringArray[2] = "C:/tfa_home/";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].contains("-tfaHome")) {
                string3 = stringArray[i + 1];
                ++i;
                continue;
            }
            string2 = string2 + stringArray[i] + " ";
        }
        Global.offlineMode = true;
        Properties properties = Properties.getInstance(string3);
        Output.printTrace("Offline run input: " + string2, 3);
        Output.print(string2);
        string = OfflineMessageHandler.offlineRun(string2);
        System.out.println(string);
    }
}

