/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.persist.PrimaryIndex;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import oracle.rat.tfa.entity.Dom0PrivateNetwork;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;

public class ODAChecker
implements Runnable {
    public static boolean isDomIPUpdated = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            Object object;
            Object object2;
            if (isDomIPUpdated) {
                arrayList = new ArrayList();
                PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(Dom0PrivateNetwork.class);
                try (String string = primaryIndex.entities();){
                    object2 = string.iterator();
                    while (object2.hasNext()) {
                        object = (Dom0PrivateNetwork)object2.next();
                        arrayList.add(((Dom0PrivateNetwork)object).getPrivateIP());
                        Output.printTrace("BDB Dom0IP : " + ((Dom0PrivateNetwork)object).getPrivateIP(), 3);
                    }
                }
                if (arrayList.size() == 0) {
                    arrayList.add("192.168.16.24");
                    arrayList.add("192.168.16.25");
                    object2 = new Dom0PrivateNetwork("192.168.16.24");
                    ((Dom0PrivateNetwork)object2).store();
                    object = new Dom0PrivateNetwork("192.168.16.25");
                    ((Dom0PrivateNetwork)object).store();
                }
                isDomIPUpdated = false;
            }
            for (String string : arrayList) {
                object2 = null;
                object = null;
                object2 = SocketManager.getPrivatePort(string);
                Output.printTrace("Private port to connect " + (String)object2, 3);
                String string2 = new Host().getHostname().trim();
                if (object2 == null) continue;
                PrintWriter printWriter = null;
                boolean bl = false;
                try {
                    String string3;
                    object = SocketManager.getSocketConnectionWithIP(string, new Integer((String)object2));
                    if (object != null) {
                        LogFile.writeLog("Sending certificates to " + string);
                        bl = this.sendCertificates((Socket)object);
                    }
                    if (object != null && !((Socket)object).isClosed()) {
                        ((Socket)object).close();
                    }
                    if (!bl) continue;
                    object = null;
                    int n = 1;
                    Thread.sleep(60000L);
                    while (object == null) {
                        Thread.sleep(30000L);
                        try {
                            object = SocketManager.getSocketConnectionWithIP(string, new Integer((String)object2));
                            if (object == null && n % 10 == 0) {
                                LogFile.writeLog("Not able to connect to dom0 for " + n * 30 + "s");
                            }
                            ++n;
                        }
                        catch (Exception exception) {}
                    }
                    LogFile.writeLog("Registering dom0: " + string);
                    printWriter = new PrintWriter(((Socket)object).getOutputStream(), true);
                    StringBuilder stringBuilder = new StringBuilder().append(string2).append(":addhost:").append(string2).append(":");
                    Properties.getInstance();
                    String string4 = stringBuilder.append(Properties.getTFACookie()).toString();
                    Output.printTrace(string4, 3);
                    printWriter.println(string4);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Socket)object).getInputStream()));
                    while ((string3 = bufferedReader.readLine()) != null) {
                        if (!string3.equals("SUCCESS")) continue;
                        LogFile.writeLog(string + " is successfully added");
                        break;
                    }
                    bufferedReader.close();
                    if (((Socket)object).isClosed()) continue;
                    ((Socket)object).close();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                catch (Exception exception) {
                    Output.printTrace("Caught Exception in ODAChecker thread", 1);
                    exception.printStackTrace();
                }
            }
            try {
                Output.printTrace("ODAChecker thread sleep begin", 3);
                Thread.sleep(300000L);
                Output.printTrace("ODAChecker thread sleep end", 3);
                continue;
            }
            catch (InterruptedException interruptedException) {
                Output.printTrace("Caught interrupt signal in ODAChecker thread...", 1);
                continue;
            }
            break;
        }
    }

    private boolean sendCertificates(Socket socket) {
        boolean bl = true;
        try {
            PrintWriter printWriter = null;
            Properties.getInstance();
            String string = Properties.tfaHome;
            String string2 = string + File.separator + "server.jks";
            String string3 = string + File.separator + "client.jks";
            String string4 = string + File.separator + "internal" + File.separator + "ssl.properties";
            File file = new File(string2);
            File file2 = new File(string3);
            File file3 = new File(string4);
            if (!file3.exists()) {
                return false;
            }
            String string5 = file3.length() + "!" + file.length() + "!" + file2.length();
            String string6 = new Host().getHostname().trim();
            try {
                String string7;
                String string8 = string6 + ":recieveFile:" + string5;
                Output.printTrace("remoterequest : " + string8, 3);
                printWriter = new PrintWriter(socket.getOutputStream(), true);
                printWriter.println(string8);
                boolean bl2 = false;
                InputStream inputStream = socket.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((string7 = bufferedReader.readLine()) != null) {
                    if (string7.equals("EXIST")) {
                        bl2 = true;
                        break;
                    }
                    if (!string7.equals("NOTEXIST")) continue;
                }
                if (bl2) {
                    LogFile.writeLog("Certificates exist on dom0");
                    return false;
                }
                File[] fileArray = new File[]{file3, file, file2};
                for (File file4 : fileArray) {
                    this.copyFile(socket, file4);
                }
            }
            catch (UnknownHostException unknownHostException) {
                Output.printTrace("Failed to transfer certificates to dom0 :  " + unknownHostException.getMessage(), 1);
                unknownHostException.printStackTrace();
                bl = false;
            }
            catch (IOException iOException) {
                Output.printTrace("Failed to transfer certificates to dom0 :  " + iOException.getMessage(), 1);
                iOException.printStackTrace();
                bl = false;
            }
            catch (Exception exception) {
                Output.printTrace("Failed to transfer certificates to dom0 :  " + exception.getMessage(), 1);
                exception.printStackTrace();
                bl = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    private void copyFile(Socket socket, File file) {
        try {
            String string;
            int n;
            LogFile.writeLog("Started copying file " + file.getName());
            byte[] byArray = new byte[8192];
            FileInputStream fileInputStream = new FileInputStream(file);
            int n2 = 0;
            OutputStream outputStream = socket.getOutputStream();
            while ((n = fileInputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
                outputStream.flush();
                n2 += n;
            }
            fileInputStream.close();
            Output.printTrace("Total Written to Socket " + n2, 3);
            Output.printTrace("Done transferring " + file.getName(), 3);
            InputStream inputStream = socket.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                Output.printTrace("fromServer " + string, 3);
                if (!string.equals("DONE")) continue;
            }
            LogFile.writeLog("Transfer complete " + file.getName());
        }
        catch (Exception exception) {
            Output.printTrace("Exception in transfer file : " + file.getName() + " to ODADom0", 1);
            exception.printStackTrace();
        }
    }
}

