/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.BroadcastMessage;
import oracle.rat.tfa.CollectionManager;
import oracle.rat.tfa.ComponentEntityManager;
import oracle.rat.tfa.CreateFileEntitiesFromXml;
import oracle.rat.tfa.ExaDom0RegistryManager;
import oracle.rat.tfa.RepositoryManager;
import oracle.rat.tfa.TFAAccessManager;
import oracle.rat.tfa.TFADirectoryManager;
import oracle.rat.tfa.TFAInventoryManager;
import oracle.rat.tfa.TFAIpsManager;
import oracle.rat.tfa.TFAReceiverManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.AdrIncident;
import oracle.rat.tfa.entity.AlertClusterEviction;
import oracle.rat.tfa.entity.AlertClusterReconfiguration;
import oracle.rat.tfa.entity.DatabaseGeneralError;
import oracle.rat.tfa.entity.DatabaseParameter;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.Generic;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.InstanceShutdown;
import oracle.rat.tfa.entity.InstanceStartup;
import oracle.rat.tfa.entity.InventoryRun;
import oracle.rat.tfa.entity.TFAHost;
import oracle.rat.tfa.entity.TFAIps;
import oracle.rat.tfa.entity.TFAMetaData;
import oracle.rat.tfa.entity.TFAReceiver;
import oracle.rat.tfa.entity.ZipEntity;
import oracle.rat.tfa.receiver.RGlobal;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.singletons.DirectoryMappings;
import oracle.rat.tfa.ssh.UserAuthPubKey;
import oracle.rat.tfa.tfar15.FileMonitor15;
import oracle.rat.tfa.type.DirectoryMappingType;
import oracle.rat.tfa.util.ConfigManager;
import oracle.rat.tfa.util.EncryptionUtil;
import oracle.rat.tfa.util.FileHelper;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Notification;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.RandomString;
import oracle.rat.tfa.util.SocketManager;
import oracle.rat.tfa.util.StringUtil;
import oracle.rat.tfa.xml.GPNPProfileXMLReader;
import oracle.rat.tfa.xml.SimileJSON;
import org.apache.commons.io.FileUtils;

public class NonRootMessageHandler
implements Runnable {
    private Socket socket = null;
    private String TFAARGSEP = ":(?!\\\\)";
    private String reqUser = "";

    public NonRootMessageHandler(Socket socket) {
        this.socket = socket;
    }

    @Override
    public void run() {
        Thread.currentThread().setName("NonRootMessageHandler");
        PrintWriter printWriter = null;
        boolean bl = false;
        String string = "COLLECTOR";
        string = Properties.TFARunMode.toUpperCase();
        String string2 = new Host().getHostname().trim();
        List<String> list = TFAHost.getHostsInTFA();
        Object var10_6 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = "";
        long l = Thread.currentThread().getId();
        String string4 = l + "_" + System.currentTimeMillis() + ".pub";
        String string5 = Properties.tfaHome + File.separator + "internal" + File.separator + ".root" + File.separator + string4;
        String string6 = Properties.tfaHome + File.separator + "internal" + File.separator + ".root" + File.separator + "mykey.rsa";
        File file = new File(string5);
        String string7 = null;
        File file2 = null;
        try {
            Object object;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            InputStream inputStream = this.socket.getInputStream();
            printWriter = new PrintWriter(this.socket.getOutputStream(), true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string8 = bufferedReader.readLine();
            if (string8 != null) {
                if (string8.contains("~~~~~~reqUser=")) {
                    object = string8.split("=")[1].split("~");
                    this.reqUser = object[0].trim();
                    if (!TFAAccessManager.checkUserAccess(this.reqUser)) {
                        try {
                            file.delete();
                        }
                        catch (Exception exception) {
                            Output.printTrace("Could not delete keyFile" + string5, 1);
                        }
                        Output.printTrace("Access Denied. User " + this.reqUser + " does not have permission to run TFA.", 1);
                        printWriter.println("LOGINFAILED");
                        printWriter.close();
                        bufferedReader.close();
                        this.socket.close();
                        return;
                    }
                } else {
                    try {
                        file.delete();
                    }
                    catch (Exception exception) {
                        Output.printTrace("Could not delete keyFile" + string5, 1);
                    }
                    Output.printTrace("Access Denied. Invalid request.", 1);
                    printWriter.println("LOGINFAILED");
                    printWriter.close();
                    bufferedReader.close();
                    this.socket.close();
                    return;
                }
            }
            object = Properties.getEscapedUserName(this.reqUser);
            File file3 = new File(Properties.tfaHome + File.separator + "." + (String)object);
            if (!file3.exists()) {
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    Output.printTrace("Could not delete keyFile" + string5, 1);
                }
                Output.printTrace("Access Denied. User " + this.reqUser + " does not have permission to run TFA.", 1);
                printWriter.println("LOGINFAILED");
                printWriter.close();
                bufferedReader.close();
                this.socket.close();
                return;
            }
            long l2 = System.currentTimeMillis();
            string7 = Properties.tfaHome + File.separator + "." + (String)object + File.separator + l2 + "_session.lk";
            file2 = new File(string7);
            FileUtils.touch((File)file2);
            Runtime.getRuntime().exec("chown " + this.reqUser + " " + string7);
            FileHelper.changePermission("700", string7);
            printWriter.println("sessionid=" + l2);
            while ((string8 = bufferedReader.readLine()) != null) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                String[] stringArray;
                Object object6;
                Object object7;
                Object object8;
                int n;
                String string9;
                Object object9;
                this.checkAndRemoveFile(file2);
                if (!bl2) {
                    if (string8.contains("------finished_keyfile------")) {
                        bl2 = true;
                        bufferedWriter.close();
                        object9 = new UserAuthPubKey();
                        string9 = string6 + ".pub";
                        bl3 = TFAAccessManager.checkUserAccess(this.reqUser) ? UserAuthPubKey.sameKeyPairPub(string9, string5) : false;
                        try {
                            file.delete();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (bl3) continue;
                        Output.printTrace("Access Denied. User " + this.reqUser + " does not have permission to run TFA.", 1);
                        printWriter.println("LOGINFAILED");
                        printWriter.close();
                        bufferedReader.close();
                        this.socket.close();
                        return;
                    }
                    if (string8.contains("~~~~~~reqUser=")) {
                        object9 = string8.split("=")[1].split("~");
                        this.reqUser = object9[0].trim();
                        continue;
                    }
                    object = Properties.getEscapedUserName(this.reqUser);
                    string6 = Properties.tfaHome + File.separator + "internal" + File.separator + ".root" + File.separator + (String)object + "_mykey.rsa";
                    try {
                        string8 = EncryptionUtil.decrypt(string8, string6);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    bufferedWriter.write(string8);
                    if (Properties.isWindows()) {
                        bufferedWriter.write("\n");
                    } else {
                        bufferedWriter.newLine();
                    }
                    if (string8.contains(" root@")) {
                        this.reqUser = "root";
                        object9 = string8.split("@");
                        string3 = object9[((String[])object9).length - 1].trim();
                        if (!string3.equals(string2)) continue;
                    }
                    if (!string8.contains("rsa")) continue;
                    object9 = string8.trim().split(" ");
                    this.reqUser = object9[((String[])object9).length - 1].trim();
                    string3 = string2;
                    object = Properties.getEscapedUserName(this.reqUser);
                    string6 = Properties.tfaHome + File.separator + "internal" + File.separator + ".root" + File.separator + (String)object + "_mykey.rsa";
                    continue;
                }
                Output.printTrace("Non Root userName " + this.reqUser, 3);
                object9 = null;
                string9 = null;
                String string10 = null;
                String[] stringArray2 = string8.split(":");
                if (stringArray2.length > 0) {
                    object9 = stringArray2[0];
                }
                if (stringArray2.length > 1) {
                    string9 = stringArray2[1].trim();
                }
                if (stringArray2.length > 2) {
                    string10 = stringArray2[2];
                }
                if (stringArray2.length > 3) {
                    n = string8.indexOf(stringArray2[1]);
                    string10 = string8.substring(n + stringArray2[1].length() + 1);
                }
                Output.printTrace("Host: " + (String)object9 + " Name : " + string9 + " Args : ", 3);
                if (string10 != null) {
                    n = 1;
                    if (string10.contains("-u ") || string10.contains("-user ")) {
                        printWriter.println("Invalid User argument passed");
                        LogFile.writeLog("[ERROR] [User flag cannot be passed to TFA CommandLine] " + string8);
                        n = 0;
                    }
                    if (string10.contains(";") || string10.contains("<") || string10.contains(">") || string10.contains("&") || string10.contains(">>") || string10.contains("|") || string10.contains("`") || string10.contains("$")) {
                        printWriter.println("Invalid characters found in argument passed");
                        LogFile.writeLog("[ERROR] [Invalid characters found in TFA CommandLine] " + string8);
                        n = 0;
                    }
                    if (n == 0) {
                        printWriter.println("FAIL");
                        bl = true;
                        break;
                    }
                }
                if (string9.equals("checkTFAMain")) {
                    printWriter.println("CheckOK");
                    bl = true;
                    break;
                }
                if (string9.equals("getTFARunMode")) {
                    printWriter.println("TFA_RUN_MODE:" + string);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("checkTFAStatus")) {
                    String string11 = this.getPidOfTFAMain();
                    String string12 = new Host().getHostname().trim();
                    String string13 = Integer.toString(Global.getPortMapping().get(string12));
                    String string14 = Properties.getTFABuildID();
                    if (string10 != null && string10.trim().contains("noinv")) {
                        printWriter.println("CheckOK!" + string12 + "!" + string11 + "!" + string13 + "!" + Properties.tfaVersion + "!" + string14);
                    } else {
                        String string15 = this.getInventoryRunStatus();
                        printWriter.println("CheckOK!" + string12 + "!" + string11 + "!" + string13 + "!" + Properties.tfaVersion + "!" + string14 + "!" + string15);
                    }
                    if (((String)object9).equals(string12)) {
                        this.checkTFAMainInAllNodes(printWriter);
                    }
                    bl = true;
                    break;
                }
                if (string9.equals("Bye")) {
                    printWriter.println("Bye");
                    bl = true;
                    break;
                }
                if (Thread.interrupted()) {
                    printWriter.println("Closing due to Interruption");
                    printWriter.println("Bye");
                    Output.printTrace("Received Message to shutdown through Interrupt", 2);
                    break;
                }
                if (string9.equals("checkversion")) {
                    printWriter.println("TFA Version : " + Properties.tfaVersion);
                    printWriter.println("DONE");
                    bl = true;
                    break;
                }
                if (string9.equals("runinventory")) {
                    Output.printTrace("Inside runinventory in NonRootMessageHandler : " + string10, 3);
                    Action action = new Action(string9, (String)object9, "tfactl", string10);
                    action.store();
                    printWriter.println("SUCCESS");
                    bl = true;
                    continue;
                }
                if (string9.equals("runodscan")) {
                    if (!Global.isOdScanOn()) {
                        printWriter.println("On Demand Scan is disabled");
                        printWriter.println("FAILED");
                    } else if (Global.isRtScanRunning().booleanValue()) {
                        printWriter.println("Real Time scan is running");
                        printWriter.println("FAILED");
                    } else {
                        Action action = new Action(string9, (String)object9, "tfactl", string10);
                        action.store();
                        printWriter.println("SUCCESS");
                    }
                    bl = true;
                    continue;
                }
                if (string9.equals("copytagfile")) {
                    String[] stringArray3 = string10.split(this.TFAARGSEP);
                    String string16 = stringArray3[0].trim();
                    String string17 = stringArray3[1].trim();
                    Output.printTrace("Action copytagfile tag: " + string16 + " remoteHost: " + string17, 3);
                    if (!list.contains(string17)) {
                        printWriter.println("Remote Host '" + string17 + "' is not part of TFA Node List.");
                        printWriter.println("FAILED");
                        break;
                    }
                    String string18 = this.getCommandFromTag(string16);
                    Output.printTrace("ActionName copytagfile command after get: " + string18, 3);
                    if (string18 != null) {
                        Output.printTrace("ActionName copytagfile tag is >>" + string16 + "<<", 3);
                        String string19 = "-USER-" + this.reqUser + "-TAG-";
                        if (string16.startsWith("srdcfile-")) {
                            Output.printTrace("ActionName copytagfile Replacing -TAG- with -USER-" + this.reqUser + "-TAG-", 3);
                            string16 = string16.replace("-TAG-", string19);
                            Output.printTrace("ActionName copytagfile new tag is >>" + string16 + "<<", 3);
                        }
                        this.initiateZipTransferUsingTag(string17, string16, printWriter);
                    } else {
                        printWriter.println("ERROR: Invalid Copy Tag : " + string16);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("executecommandprint")) {
                    String string20;
                    String[] stringArray4 = string10.split(":");
                    String string21 = stringArray4[0].trim();
                    String string22 = stringArray4[1].trim();
                    String string23 = "";
                    if (!list.contains(string21)) {
                        printWriter.println("Remote Host '" + string21 + "' is not part of TFA Node List.");
                        printWriter.println("FAILED");
                        break;
                    }
                    if (!(string22.equals("tfactloratop") || string22.equals("tfactlruntool") || string22.equals("tfactlips"))) {
                        Output.printTrace("Arguments are not valid for executecommandprint : " + string10, 1);
                        printWriter.print("Arguments are not valid for executecommandprint : " + string10);
                        printWriter.println("DONE");
                        break;
                    }
                    if (stringArray4.length > 2) {
                        string23 = stringArray4[2].trim().split(";")[0];
                    }
                    if ((string20 = this.getCommandFromTag(string21, string22)) != null) {
                        this.sendCommandToRemoteHostPrint(string21, string22, printWriter, string23, this.reqUser);
                    } else {
                        printWriter.println("ERROR: Invalid Tag : " + string22);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("parseevents")) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Properties.getInstance();
                    String string24 = stringBuilder.append(Properties.tfaHome).append(File.separator).append("bin").append(File.separator).append("tfactl").toString();
                    String string25 = string24 + " parseevents ";
                    Output.printTrace("Trying to execute command : " + string25, 3);
                    try {
                        String string26;
                        Process process = Runtime.getRuntime().exec(string25);
                        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        while ((string26 = bufferedReader2.readLine()) != null) {
                            Output.printTrace("Parser Output : " + string26, 3);
                        }
                        Output.printTrace("Successfully updated events in TFA ", 3);
                    }
                    catch (Exception exception) {
                        Output.print("NonRootMessageHandler : Exception in parseevents");
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("searchusingtnt")) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Properties.getInstance();
                    String string27 = stringBuilder.append(Properties.tfaHome).append(File.separator).append("bin").append(File.separator).append("tfactl").toString();
                    Boolean bl4 = true;
                    File file4 = new File(Properties.inventoryXMLFile);
                    if (!file4.exists()) {
                        printWriter.println("ERROR: Can not run analyze command now as first inventory is not yet finished.");
                        printWriter.println("Check status of inventory using tfactl print status command.");
                    } else {
                        Object object10;
                        Object object11;
                        Long l3 = new Long(file4.lastModified());
                        Output.printTrace("Checking if we need to create conf file, last mod " + l3, 3);
                        String string28 = Properties.tfaHome + File.separator + "ext" + File.separator + "tnt" + File.separator + "conf" + File.separator + "propfilets.bin";
                        object8 = new File(string28);
                        if (((File)object8).exists()) {
                            object11 = new FileInputStream(string28);
                            object7 = new BufferedReader(new InputStreamReader((InputStream)object11));
                            object6 = ((BufferedReader)object7).readLine();
                            ((FileInputStream)object11).close();
                            ((BufferedReader)object7).close();
                            object10 = new Long(Long.parseLong((String)object6));
                            Output.printTrace("last run time " + object10, 3);
                            if (l3.equals(object10)) {
                                bl4 = false;
                            }
                        }
                        if (bl4.booleanValue()) {
                            object11 = new BufferedWriter(new FileWriter(string28));
                            ((Writer)object11).write(l3 + "");
                            ((BufferedWriter)object11).close();
                            object7 = string27 + " createtntprop " + Properties.inventoryXMLFile + " \"" + Properties.timezone + "\"";
                            Output.printTrace("Trying to execute command : " + (String)object7, 3);
                            try {
                                String string29;
                                object6 = Runtime.getRuntime().exec((String)object7);
                                object10 = new BufferedReader(new InputStreamReader(((Process)object6).getInputStream()));
                                while ((string29 = ((BufferedReader)object10).readLine()) != null) {
                                    Output.printTrace("TNT Configuration" + string29, 3);
                                }
                                Output.printTrace("Successfully updated TNT Configuration in TFA ", 3);
                            }
                            catch (Exception exception) {
                                Output.print("NonRootMessageHandler : Exception in searchusingtnt");
                            }
                        }
                        object11 = Properties.tfaHome + File.separator + "ext" + File.separator + "tnt" + File.separator + "bin" + File.separator + "tnt";
                        object7 = string10.split("~", -1);
                        object6 = new ArrayList<Object>();
                        ((ArrayList)object6).add("perl");
                        ((ArrayList)object6).add(object11);
                        object10 = object7[7].trim();
                        if (object7[6].trim().equals("1")) {
                            ((ArrayList)object6).add("-e");
                        }
                        if (!object7[0].trim().equals("")) {
                            ((ArrayList)object6).add("-p");
                            ((ArrayList)object6).add(object7[0].trim());
                        }
                        if (!object7[3].trim().equals("")) {
                            ((ArrayList)object6).add("-t");
                            ((ArrayList)object6).add(object7[3].trim());
                        }
                        boolean bl5 = false;
                        if (!object7[4].trim().equals("")) {
                            bl5 = true;
                            if (!object7[5].trim().equals("")) {
                                ((ArrayList)object6).add("-s");
                                ((ArrayList)object6).add(object7[4].trim());
                                ((ArrayList)object6).add("-l");
                                ((ArrayList)object6).add(object7[5].trim());
                            } else {
                                ((ArrayList)object6).add("-d");
                                ((ArrayList)object6).add(object7[4].trim());
                            }
                        }
                        ((ArrayList)object6).add(object7[2].trim());
                        if (!bl5) {
                            ((ArrayList)object6).add(object7[1].trim());
                        }
                        stringArray = new Host().getHostname().trim();
                        if (((String)object10).equals("") || ((String)object10).indexOf((String)stringArray) >= 0) {
                            object5 = ((ArrayList)object6).toArray(new String[((ArrayList)object6).size()]);
                            try {
                                Process process = Runtime.getRuntime().exec((String[])object5);
                                object4 = new BufferedReader(new InputStreamReader(process.getInputStream()));
                                while ((object3 = ((BufferedReader)object4).readLine()) != null) {
                                    printWriter.println((String)object3);
                                }
                                ((BufferedReader)object4).close();
                            }
                            catch (Exception exception) {
                                Output.print("NonRootMessageHandler : Exception in searchusingtnt");
                            }
                        }
                        if (((String)object9).equals(stringArray)) {
                            this.doSearchInAllNodes(printWriter, string10);
                        }
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("startdiagcollection")) {
                    n = 0;
                    String string30 = null;
                    String string31 = null;
                    String string32 = null;
                    if (string10 == null) {
                        Output.printTrace("No Arguments passed for diagcollection ", 1);
                        printWriter.println("No Arguments passed for diagcollection");
                        printWriter.println("FAILED");
                        n = 1;
                        break;
                    }
                    if (!string10.contains(" -logid ")) {
                        Output.printTrace("logid was not passed for diagcollection ", 1);
                        printWriter.println("logid was not passed for diagcollection");
                        printWriter.println("FAILED");
                        n = 1;
                        break;
                    }
                    String string33 = string10.substring(string10.lastIndexOf(":") + 1).trim();
                    if (string33 == null) {
                        Output.printTrace("Attempt to pass null CollectionID to diagcollect", 1);
                        printWriter.println("Illegal parameter passed to diagcollection : collectionID");
                        printWriter.println("FAILED");
                        n = 1;
                        break;
                    }
                    if (!Pattern.matches("^[A-Za-z0-9\\-]+$", string33)) {
                        Output.printTrace("Attempt to pass invalid CollectionID to diagcollect as : " + string33, 1);
                        printWriter.println("Illegal parameter passed to diagcollection : collectionID");
                        printWriter.println("FAILED");
                        break;
                    }
                    object8 = string10.substring(0, string10.lastIndexOf(":")).split("-");
                    for (int i = 0; i < ((String[])object8).length; ++i) {
                        Output.printTrace("Argument_" + i + " " + object8[i], 3);
                        if (n == 0 && object8[i].startsWith("user ")) {
                            string31 = ((String)object8[i]).replaceFirst("user ", "").trim();
                            Output.printTrace("Attempt to pass -user to diagcollect as : " + string31, 1);
                            printWriter.println("Illegal parameter passed to diagcollection -user");
                            printWriter.println("FAILED");
                            n = 1;
                        }
                        if (n == 0 && object8[i].startsWith("tag ") && !Pattern.matches("^[A-Za-z0-9_\\-]+$", string32 = ((String)object8[i]).replaceFirst("tag ", "").trim())) {
                            Output.printTrace("Attempt to pass invalid -tag to diagcollect as : " + string32, 1);
                            printWriter.println("Illegal parameter passed to diagcollection -tag");
                            printWriter.println("FAILED");
                            n = 1;
                        }
                        if (n == 0 && object8[i].startsWith("logid ")) {
                            string32 = ((String)object8[i]).replaceFirst("logid ", "").trim();
                            if (!Pattern.matches("^[0-9]+$", string32)) {
                                Output.printTrace("Attempt to pass invalid -logid to diagcollect as : " + string32, 1);
                                printWriter.println("Illegal parameter passed to diagcollection -logid");
                                printWriter.println("FAILED");
                                n = 1;
                            }
                            if (n == 0) {
                                object7 = new Host().getHostname().trim();
                                if (!(string32 = string32 + (String)object7).equals(string33)) {
                                    Output.printTrace("Attempt to pass invalid CollectionID to diagcollect as : " + string33, 1);
                                    printWriter.println("Illegal parameter passed to diagcollection :CollectionID");
                                    printWriter.println("FAILED");
                                    n = 1;
                                }
                            }
                        }
                        if (n != 0 || !((String)object8[i]).startsWith("z ") || Pattern.matches("^[A-Za-z0-9_\\.\\-+]+$", string32 = ((String)object8[i]).replaceFirst("z ", "").trim())) continue;
                        Output.printTrace("Attempt to pass invalid -z to diagcollect as : " + string32, 1);
                        printWriter.println("Illegal parameter passed to diagcollection -z");
                        printWriter.println("FAILED");
                        n = 1;
                    }
                    if (n == 0) {
                        String string34 = string10.substring(string10.lastIndexOf("-logid"));
                        object7 = string10.substring(1, string10.lastIndexOf("-logid") - 1);
                        string10 = (String)object7 + " -user " + this.reqUser + " " + string34;
                        Output.printTrace("Adding : -user " + this.reqUser + " to actionArgs in diagcollect", 3);
                        Output.printTrace("New actionArgs in diagcollect:" + string10, 3);
                    }
                    if (n == 0 && !string10.contains("-uid") && (string30 = RepositoryManager.checkRepositoryIsOpenInNodes(string10)) != null) {
                        Output.print("Repository is full and closed. So cannot execute action.");
                        printWriter.println("Repository is full and closed in node!" + string30);
                        printWriter.println("FAILED");
                    }
                    if (n == 0 && string30 == null) {
                        Action action = new Action(string9, (String)object9, "tfactl", string10);
                        object7 = new ArrayList();
                        object6 = new HashMap<String, String>();
                        object6.put("collectionType", "manual");
                        object7.add(object6);
                        action.setMetadata((List)object7);
                        action.store();
                        printWriter.println("SUCCESS");
                    }
                    bl = true;
                    continue;
                }
                if (string9.equals("createSimileTimeline")) {
                    SimileJSON simileJSON = new SimileJSON();
                    printWriter.println("SUCCESS");
                    bl = true;
                    continue;
                }
                if (string9.equals("modifydirectorypermission")) {
                    string10 = string10.trim();
                    String[] stringArray5 = string10.split(this.TFAARGSEP);
                    String string35 = stringArray5[0].trim();
                    String string36 = stringArray5[1].trim();
                    String string37 = null;
                    boolean bl6 = false;
                    object8 = "";
                    String string38 = "";
                    if (stringArray5.length > 2 && (string37 = stringArray5[2].trim()).equals("")) {
                        string37 = null;
                    }
                    if (stringArray5.length > 3 && stringArray5[3].trim().equals("1")) {
                        bl6 = true;
                    }
                    if (stringArray5.length > 4) {
                        object8 = stringArray5[4].trim();
                    }
                    string35 = new File(string35).getCanonicalPath();
                    object7 = FileHelper.getFileOwner(string35);
                    Output.printTrace("Modify Directory User : " + this.reqUser, 3);
                    Output.printTrace("Directory Owner : " + (String)object7, 3);
                    if (object7 != null && !((String)object7).equals(this.reqUser)) {
                        printWriter.print("User " + this.reqUser + " does not have permission to modify the directory " + string35);
                        printWriter.println("FAILED");
                        bl = true;
                        return;
                    }
                    Output.printTrace("Inside NonRootMessageHandler :" + string35 + " " + string36 + " " + string37 + " " + bl6 + "nodelist: " + (String)object8, 3);
                    if ("".equals(object8) || "local".equals(object8) || "all".equals(object8) || ((String)object8).contains(string2)) {
                        string38 = TFADirectoryManager.modifyDirectoryPermission(string35, string36, string37, bl6);
                    }
                    if (((String)object9).equals(string2) && !"".equals(object8)) {
                        this.modifyDirectoryInNodes(string10, printWriter, (String)object8);
                    }
                    printWriter.println(string38);
                    bl = true;
                    continue;
                }
                if (string9.equals("adddirectory")) {
                    string10 = string10.trim();
                    Output.printTrace("actionArgs for add directory : " + string10, 3);
                    String[] stringArray6 = string10.split(this.TFAARGSEP);
                    String string39 = stringArray6[0];
                    File file5 = new File(string39);
                    if (!file5.exists() || !file5.isDirectory()) {
                        printWriter.println("FAILED. Directory " + string39 + " does not exist.");
                        bl = true;
                        return;
                    }
                    String string40 = string39;
                    string39 = file5.getCanonicalPath();
                    String string41 = FileHelper.getFileOwner(string39);
                    Output.printTrace("Add Directory User : " + this.reqUser, 3);
                    Output.printTrace("Directory Owner : " + string41, 3);
                    if (string41 != null && !string41.equals(this.reqUser)) {
                        printWriter.print("User " + this.reqUser + " does not have permission to add the directory " + string39);
                        printWriter.println("FAILED");
                        bl = true;
                        return;
                    }
                    if (string39.equals(File.separator) || string39.startsWith(File.separator + "usr") || string39.startsWith(File.separator + "bin") || string39.startsWith(File.separator + "boot") || string39.startsWith(File.separator + "var") && !string39.startsWith(File.separator + "var" + File.separator + "log") && !string39.startsWith(File.separator + "var" + File.separator + "opt") && !string39.startsWith(File.separator + "var" + File.separator + "adm") && !string39.startsWith(File.separator + "var" + File.separator + "opt" + File.separator + "oracle") || string39.startsWith(File.separator + "etc") && !string39.startsWith(File.separator + "etc" + File.separator + "oracle") || string39.equals(File.separator + "opt") || string39.startsWith(File.separator + "dev") || string39.startsWith(File.separator + "lib") || string39.startsWith(File.separator + "lib64") || string39.startsWith(File.separator + "media") || string39.startsWith(File.separator + "misc") || string39.startsWith(File.separator + "root") || string39.startsWith(File.separator + "proc") || string39.startsWith(File.separator + "sbin") || string39.startsWith(File.separator + "selinux") || string39.startsWith(File.separator + "srv") || string39.startsWith(File.separator + "tmp")) {
                        printWriter.println("No directories were added to TFA");
                        bl = true;
                        return;
                    }
                    if (Pattern.matches("^[/|\\\\]net[/|\\\\]*$", string39) || Pattern.matches("^[/|\\\\]net[/|\\\\]([^//\\\\]+)[/|\\\\]*$", string39)) {
                        printWriter.println("No directories were added to TFA");
                        Output.printTrace("Can not process dir " + string40, 1);
                        bl = true;
                        return;
                    }
                    string39 = string40;
                    object8 = "";
                    String string42 = "";
                    object7 = "";
                    object6 = this.reqUser;
                    boolean bl7 = true;
                    String string43 = "exclusions";
                    boolean bl8 = false;
                    object5 = "";
                    object3 = "";
                    for (int i = 1; i < stringArray6.length; ++i) {
                        if (stringArray6[i].trim().equals("-private")) {
                            bl7 = true;
                            continue;
                        }
                        if (stringArray6[i].trim().equals("-noexclusions")) {
                            string43 = "noexclusions";
                            continue;
                        }
                        if (stringArray6[i].trim().equals("-collectall")) {
                            bl8 = true;
                            string43 = "collectall";
                            continue;
                        }
                        if (stringArray6[i].trim().startsWith("-node")) {
                            object5 = stringArray6[i].trim().split(" ")[1];
                            Output.printTrace("nodelist: " + (String)object5, 3);
                            continue;
                        }
                        if (stringArray6[i].trim().startsWith("-i")) {
                            string42 = stringArray6[i].trim().replaceFirst("-i ", "").trim();
                            continue;
                        }
                        if (stringArray6[i].trim().startsWith("-d")) {
                            object8 = stringArray6[i].trim().replaceFirst("-d ", "").trim();
                            continue;
                        }
                        if (!stringArray6[i].trim().startsWith("-r")) continue;
                        object7 = stringArray6[i].trim().replaceFirst("-r ", "").trim();
                        Output.printTrace("component:" + (String)object7, 3);
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    object4 = new ArrayList();
                    if (!((String)object7).equals("") && (object2 = ((String)object7).split(",")) != null && ((String[])object2).length > 0) {
                        for (String string44 : object2) {
                            if (string44.equals("")) continue;
                            if (string44.contains("%")) {
                                Output.printTrace("contains % " + string44, 1);
                                object4.add(string44);
                                String[] stringArray7 = string44.split("%");
                                if (stringArray7 == null || stringArray7.length <= 0) continue;
                                arrayList.add(stringArray7[0]);
                                continue;
                            }
                            arrayList.add(string44.trim());
                        }
                    }
                    if ("".equals(object5) || "local".equals(object5) || "all".equals(object5) || ((String)object5).contains(string2)) {
                        Output.printTrace("In NonRootMessageHandler : isPrivate:" + bl7 + " owner:" + (String)object6 + " collectionPolicy:" + string43 + " collectAll: " + bl8, 3);
                        Output.printTrace("In NonRootMessageHandler : components:" + arrayList + " subcomps:" + object4 + " database:" + (String)object8 + " instance:" + string42, 3);
                        object3 = TFADirectoryManager.addDirectory(string39, (String)object8, string42, arrayList, (List<String>)object4, "", printWriter, bl7, (String)object6, string43, bl8);
                    }
                    if (((String)object9).equals(string2) && !"".equals(object5)) {
                        this.addDirectoryInNodes(string10, printWriter, (String)object5);
                    }
                    printWriter.println((String)object3);
                    bl = true;
                    continue;
                }
                if (string9.equals("checkdbexistence")) {
                    Output.printTrace("ActionArgs in checkdbexistence: " + string10, 3);
                    n = this.checkDbExistence(string10, (String)object9) ? 1 : 0;
                    if (n != 0) {
                        printWriter.println("DB EXISTS");
                    } else {
                        printWriter.println("DB DOES NOT EXIST");
                    }
                    printWriter.println("DONE");
                    continue;
                }
                if (string9.equals("checkrepositoryisopen")) {
                    n = RepositoryManager.getInstance().isRepositoryOpen() ? 1 : 0;
                    if (n != 0) {
                        printWriter.println("Repository is open");
                    } else {
                        printWriter.println("Repository is full and closed");
                    }
                    printWriter.println("DONE");
                    continue;
                }
                if (string9.equals("checktagexists")) {
                    String string45 = string10.split(":")[0];
                    if (string2.equals(object9)) {
                        String string46 = string10.split(":")[1];
                        if (string46 != null) {
                            this.checkTagExistsInNodes(printWriter, string46, string45);
                        }
                    } else if (new File(RepositoryManager.getInstance().getDirectory() + File.separator + string45).exists()) {
                        Output.printTrace("Tag " + string45 + " already exists in host " + string2, 3);
                        printWriter.println("Tag already exists in host " + string2);
                    }
                    printWriter.println("DONE");
                    continue;
                }
                if (string9.equals("checkdirectory")) {
                    TFADirectoryManager.checkDirectory((String)object9, string10);
                    printWriter.println("SUCCESS");
                    bl = true;
                    continue;
                }
                if (string9.equals("donecheckingdirectory")) {
                    TFADirectoryManager.doneChecking((String)object9, string10);
                    printWriter.println("SUCCESS");
                    bl = true;
                    continue;
                }
                if (string9.equals("removedirectory")) {
                    string10 = string10.trim();
                    String string47 = "";
                    Output.printTrace("In remove directory: " + string10, 3);
                    String[] stringArray8 = string10.split(this.TFAARGSEP);
                    String string48 = stringArray8[0];
                    Output.printTrace("In remove directory dirPath: " + string48, 3);
                    String string49 = "";
                    if (stringArray8.length > 1) {
                        string49 = stringArray8[1];
                    }
                    string48 = new File(string48).getCanonicalPath();
                    String string50 = FileHelper.getFileOwner(string48);
                    Output.printTrace("Remove Directory User : " + this.reqUser, 3);
                    Output.printTrace("Directory Owner : " + string50, 3);
                    if (string50 != null && !string50.equals(this.reqUser)) {
                        printWriter.print("User " + this.reqUser + " does not have permission to remove the directory " + string48);
                        printWriter.println("FAILED");
                        bl = true;
                        return;
                    }
                    Output.printTrace("In remove directory nodelist: " + string49, 3);
                    if ("".equals(string49) || "local".equals(string49)) {
                        string47 = TFADirectoryManager.removeDirectory(string48, printWriter, false);
                    } else if (((String)object9).equals(string2)) {
                        string47 = this.removeDirectoryInNodes(printWriter, string48, string49);
                    }
                    printWriter.println(string47);
                    bl = true;
                    continue;
                }
                if (string9.equals("removesubdirectories")) {
                    string10 = string10.trim();
                    String string51 = "";
                    Output.printTrace("In remove subdirectory: " + string10, 3);
                    String[] stringArray9 = string10.split(this.TFAARGSEP);
                    String string52 = stringArray9[0];
                    Output.printTrace("In remove subdirectory dirPath: " + string52, 3);
                    String string53 = "";
                    if (stringArray9.length > 1) {
                        string53 = stringArray9[1];
                    }
                    string52 = new File(string52).getCanonicalPath();
                    String string54 = FileHelper.getFileOwner(string52);
                    Output.printTrace("Remove Directory User : " + this.reqUser, 3);
                    Output.printTrace("Directory Owner : " + string54, 3);
                    if (string54 != null && !string54.equals(this.reqUser)) {
                        printWriter.print("User " + this.reqUser + " does not have permission to remove the directory " + string52);
                        printWriter.println("FAILED");
                        bl = true;
                        return;
                    }
                    Output.printTrace("In remove subdirectory nodelist: " + string53, 3);
                    if ("".equals(string53) || "local".equals(string53)) {
                        string51 = TFADirectoryManager.removeSubDirectories(string52, printWriter);
                    } else if (((String)object9).equals(string2)) {
                        string51 = this.removeSubDirectoryInNodes(printWriter, string52, string53);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printbuildversion")) {
                    printWriter.println(Properties.getTFABuildID());
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("manageips")) {
                    String string55;
                    Date date;
                    String[] stringArray10 = string10.split(" ");
                    String string56 = stringArray10[0];
                    if (TFAIpsManager.addTFAIps(string56, date = Calendar.getInstance().getTime(), string55 = string10.replace(string56 + " ", ""))) {
                        printWriter.println("SUCCESS");
                    } else {
                        printWriter.println("FAILED");
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("removeips")) {
                    if (TFAIpsManager.removeTFAIps(string10)) {
                        printWriter.println("SUCCESS");
                    } else {
                        printWriter.println("FAILED");
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("resumeips")) {
                    String string57 = TFAIpsManager.resumeTFAIps(string10);
                    if (string57 != null) {
                        printWriter.println(string57);
                        printWriter.println("SUCCESS");
                    } else {
                        printWriter.println("FAILED");
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("getsuspendedips")) {
                    List<TFAIps> list2 = TFAIpsManager.getAllTFAIps();
                    for (TFAIps tFAIps : list2) {
                        printWriter.println(tFAIps.getCollectionId() + " " + tFAIps.getTimestamp() + " " + tFAIps.getCmdArgs());
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("testmail")) {
                    Notification notification = new Notification();
                    String[] stringArray11 = string10.split(":");
                    notification.setTo(stringArray11[0].trim());
                    notification.setFrom("tfa@localhost.com");
                    notification.setSubject("Test Mail From TFA");
                    notification.setMessage("This is test Message from TFA");
                    notification.sendMail();
                    printWriter.println("Successfully sent mail to " + stringArray11[0].trim());
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("checktfaaccess")) {
                    String[] stringArray12 = string10.split(":");
                    String string58 = stringArray12[0].trim();
                    boolean bl9 = TFAAccessManager.checkUserAccess(string58);
                    if (bl9) {
                        printWriter.println("SUCCESS");
                    } else {
                        printWriter.println("FAILED");
                    }
                    bl = true;
                    continue;
                }
                if (string9.equals("checkaccessonremote")) {
                    String string59;
                    String[] stringArray13 = string10.split(":");
                    String string60 = stringArray13[0].trim();
                    boolean bl10 = TFAAccessManager.checkUserAccessOnRemote(string60, string59 = stringArray13[1].trim(), printWriter);
                    if (bl10) {
                        printWriter.println("SUCCESS");
                    } else {
                        printWriter.println("FAILED");
                    }
                    bl = true;
                    continue;
                }
                if (string9.equals("checkuseraccess")) {
                    String[] stringArray14 = string10.split(":");
                    String string61 = stringArray14[0].trim();
                    boolean bl11 = TFAAccessManager.checkUserAccess(string61);
                    if (bl11) {
                        printWriter.println("ACCESS GRANTED");
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("listtfausers")) {
                    TFAAccessManager.listTFAUsers(printWriter);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printExaDom0")) {
                    Output.printTrace("Inside printExaDom0 for : " + string10, 3);
                    String string62 = ExaDom0RegistryManager.getRegisteredExaDom0Host();
                    if (string62 == null) {
                        printWriter.println("NULL");
                    } else {
                        printWriter.println(string62);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("gethashkey")) {
                    String string63 = GPNPProfileXMLReader.getInstance().getHashKey();
                    printWriter.println(string63);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("showactionmonitor")) {
                    Action.printAll(printWriter, null);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("getLogDirectory")) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Properties.getInstance();
                    printWriter.println(stringBuilder.append(Properties.logDir.trim()).append("!").toString());
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("getInventoryLocation")) {
                    String string64 = string10.trim();
                    if (string2.equals(string64)) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Properties.getInstance();
                        printWriter.println(stringBuilder.append(Properties.inventoryDir.trim()).append("!").toString());
                    } else {
                        this.dumpRemoteInventoryLocation(printWriter, string64);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printrepository")) {
                    String string65 = "";
                    if (string10 == null) {
                        RepositoryManager.getInstance().printRepository(printWriter);
                    } else {
                        string65 = string10.trim();
                    }
                    String string66 = new Host().getHostname().trim();
                    if (((String)object9).equals(string66)) {
                        this.dumpRepositoryInAllNodes(printWriter, string65);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printlocationofrepository")) {
                    String string67 = RepositoryManager.getInstance().getDirectory();
                    Output.printTrace("printlocationofrepository" + string67, 1);
                    printWriter.println(string67);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("getRepositoryLocation")) {
                    String string68 = string10.trim();
                    if (string2.equals(string68)) {
                        printWriter.println(RepositoryManager.getInstance().getDirectory() + "!");
                    } else {
                        this.dumpRemoteRepositoryLocation(printWriter, string68);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("getReplacedHostName")) {
                    String string69 = string10.trim();
                    String string70 = StringUtil.getReplacementFor(string69);
                    printWriter.println(string70 + "!");
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printmaxsizeofrepository")) {
                    printWriter.println(RepositoryManager.getInstance().getMaxSizeMegabytes());
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printactions")) {
                    Action.printAll(printWriter, string10);
                    String string71 = new Host().getHostname().trim();
                    if (((String)object9).equals(string71)) {
                        this.dumpActionsInAllNodes(printWriter, string10);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printOngoingCollections")) {
                    Action.getOngoingCollections(printWriter);
                    String string72 = new Host().getHostname().trim();
                    if (((String)object9).equals(string72)) {
                        this.dumpOngoingCollectionsInAllNodes(printWriter);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printtfahome")) {
                    String string73 = Properties.tfaHome;
                    Output.printTrace("Inside print printtfahome " + string73, 3);
                    if (string73 != null) {
                        printWriter.println(string73);
                    } else {
                        printWriter.println("");
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printreceivers")) {
                    Output.printTrace("Print Receivers Requested", 3);
                    TFAReceiver.printAll(printWriter, "collector", false);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printcollectors")) {
                    Output.printTrace("Print Collectors Requested", 3);
                    String string74 = string10;
                    if (string.equalsIgnoreCase("receiver")) {
                        if (string74.equals("false")) {
                            TFAReceiver.printAll(printWriter, "receiver", false);
                        } else {
                            TFAReceiver.printAll(printWriter, "receiver", true);
                        }
                    } else {
                        printWriter.println("No collectors found as you can't register collectors in collectors cluster");
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printcollections")) {
                    String string75 = null;
                    long l4 = 0L;
                    if (string10 != null && !string10.equals("")) {
                        Output.printTrace("printcollections args: " + string10, 3);
                        string75 = string10.trim();
                        String string76 = null;
                        if (string75.endsWith("h")) {
                            string76 = string75.substring(0, string75.indexOf("h"));
                            if (string76 != null) {
                                int n2 = new Integer(string76);
                                l4 = n2 * 60 * 60;
                                Output.printTrace("timeInHours " + n2 + " diffInSecs " + l4, 3);
                            }
                        } else if (string75.endsWith("d") && (string76 = string75.substring(0, string75.indexOf("d"))) != null) {
                            int n3 = new Integer(string76);
                            l4 = n3 * 24 * 60 * 60;
                            Output.printTrace("timeInDays " + n3 + " diffInSecs " + l4, 3);
                        }
                    }
                    String string77 = CollectionManager.printCollections(printWriter, l4, this.reqUser);
                    printWriter.println(string77);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("stopcollection")) {
                    String string78 = string10.trim();
                    boolean bl12 = false;
                    if (((String)object9).equals(string2)) {
                        bl12 = true;
                    }
                    String string79 = CollectionManager.stopCollection(string78, printWriter, bl12);
                    printWriter.println(string79);
                    bl = true;
                    continue;
                }
                if (string9.equals("printhosts")) {
                    Output.printTrace("Print Hosts Requested", 3);
                    TFAHost.printAll(printWriter);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printrobjects")) {
                    String string80 = string10;
                    Output.printTrace("Print R Objects Requested and type is " + string80, 3);
                    if (string80.equals("show") || string80.equals("showtype")) {
                        TFAReceiver.printRObjects(printWriter, "All", string80);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("getsubcompvalues")) {
                    Output.printTrace("getsubcompvalues: " + string10, 1);
                    String string81 = ComponentEntityManager.getSubCompValues(string10.trim());
                    printWriter.print(string81);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printevents")) {
                    String string82 = null;
                    long l5 = 86400L;
                    String[] stringArray15 = string10.trim().split(" ");
                    object8 = new ArrayList();
                    for (int i = 0; i < stringArray15.length; ++i) {
                        String string83 = stringArray15[i].trim();
                        if (string83.equalsIgnoreCase("-since")) {
                            string82 = stringArray15[i + 1];
                            object7 = null;
                            if (string82.endsWith("h")) {
                                object7 = string82.substring(0, string82.indexOf("h"));
                                if (object7 != null) {
                                    int n4 = new Integer((String)object7);
                                    l5 = n4 * 60 * 60;
                                    Output.printTrace("timeInHours " + n4 + " diffInSecs " + l5, 3);
                                }
                            } else if (string82.endsWith("d") && (object7 = string82.substring(0, string82.indexOf("d"))) != null) {
                                int n5 = new Integer((String)object7);
                                l5 = n5 * 24 * 60 * 60;
                                Output.printTrace("timeInDays " + n5 + " diffInSecs " + l5, 3);
                            }
                        }
                        if (!string83.equalsIgnoreCase("-cell")) continue;
                        if (stringArray15[i + 1].equalsIgnoreCase("all")) {
                            String string84 = Properties.tfaHome + File.separator + "internal" + File.separator + "cellnames.txt";
                            if (!new File(string84).exists()) continue;
                            try {
                                String string85;
                                object7 = new BufferedReader(new FileReader(string84));
                                while ((string85 = ((BufferedReader)object7).readLine()) != null) {
                                    object8.add(string85.trim());
                                }
                                ((BufferedReader)object7).close();
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                Output.print("NonRootMessageHandler : FileNotFoundException encountered in printevents");
                            }
                            catch (IOException iOException) {
                                Output.print("NonRootMessageHandler : IOException encountered in printevents");
                            }
                            continue;
                        }
                        for (String string86 : stringArray15[i + 1].split(",")) {
                            object8.add(string86.trim());
                        }
                    }
                    InstanceStartup.printEvents(printWriter, l5);
                    InstanceShutdown.printEvents(printWriter, l5);
                    DatabaseParameter.printEvents(printWriter);
                    DatabaseGeneralError.printEvents(printWriter, l5);
                    AlertClusterEviction.printEvents(printWriter, l5);
                    AlertClusterReconfiguration.printEvents(printWriter, l5);
                    Generic.printEvents(printWriter, l5);
                    AdrIncident.printEvents(printWriter, l5);
                    if (object8.size() > 0) {
                        InstanceStartup.printXMLEvents(printWriter, l5, (List<String>)object8);
                        InstanceShutdown.printXMLEvents(printWriter, l5, (List<String>)object8);
                        DatabaseParameter.printXMLEvents(printWriter, (List<String>)object8);
                        DatabaseGeneralError.printXMLEvents(printWriter, l5, (List<String>)object8);
                        AlertClusterEviction.printXMLEvents(printWriter, l5, (List<String>)object8);
                        AlertClusterReconfiguration.printXMLEvents(printWriter, l5, (List<String>)object8);
                        Generic.printXMLEvents(printWriter, l5, (List<String>)object8);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printstartups")) {
                    Output.printTrace("Print Startups Requested", 3);
                    InstanceStartup.printAll(printWriter);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printshutdowns")) {
                    Output.printTrace("Print Shutdowns Requested", 3);
                    InstanceShutdown.printAll(printWriter);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printparameters")) {
                    Output.printTrace("Print Parameters Requested", 3);
                    DatabaseParameter.printAll(printWriter);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printerrors")) {
                    Output.printTrace("Print Errors Requested", 3);
                    DatabaseGeneralError.printAll(printWriter);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printclustereviction")) {
                    Output.printTrace("Print Cluster Evictions Requested", 3);
                    AlertClusterEviction.printAll(printWriter);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printclusterreconfig")) {
                    Output.printTrace("Print Cluster Reconfigurations Requested", 3);
                    AlertClusterReconfiguration.printAll(printWriter);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printgenericevent")) {
                    Output.printTrace("Print Generic Events Requested", 3);
                    Generic.printAll(printWriter);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printadrincidents")) {
                    Output.printTrace("Print ADR Incidents Requested", 3);
                    AdrIncident.printAll(printWriter);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printinventory")) {
                    Output.printTrace("Print Inventory Requested " + string10, 3);
                    if (string10 == null || string10.trim().equals("") || string10.trim().equals("local")) {
                        TFAInventoryManager.printInventory(printWriter);
                    } else {
                        this.dumpInventoryInNodes(printWriter, string10.trim());
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printinventorymerge")) {
                    Output.printTrace("Print Inventory For Merge Requested", 3);
                    TFAInventoryManager.printInvFilesForMerge(printWriter, string10);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printdirectories")) {
                    Output.printTrace("Inside printdirectories " + string10, 3);
                    String string87 = null;
                    String string88 = "";
                    String string89 = "";
                    String string90 = "";
                    if (string10 != null && !string10.trim().equals("")) {
                        try {
                            String[] stringArray16 = string10.split(":");
                            if (stringArray16 != null) {
                                string88 = stringArray16[0];
                                string89 = stringArray16[1];
                                string90 = stringArray16[2];
                                string87 = stringArray16[3];
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Output.printTrace("Inside printdirectories comp: " + string88 + " policy: " + string89 + " permission: " + string90 + " nodes: " + string87, 3);
                    if (string87 == null || string87.equals("") || string87.equals("local")) {
                        TFADirectoryManager.dumpDirectories(printWriter, string88, string89, string90);
                    } else {
                        this.dumpDirectoriesInNodes(printWriter, string87, string88, string89, string90);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printinvrunstat")) {
                    InventoryRun.print(printWriter);
                    String string91 = new Host().getHostname().trim();
                    if (((String)object9).equals(string91)) {
                        this.dumpInventoryRunStatsInAllNodes(printWriter);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("lastrediscoveryrun")) {
                    Date date;
                    if (Global.getPeriodicCheckerThread() != null && (date = Global.getPeriodicCheckerThread().getLastRediscoveryRun()) != null) {
                        printWriter.println(date);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printconfig")) {
                    Output.printTrace("Print Config Requested " + string10, 3);
                    String[] stringArray17 = string10.split("~");
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (int i = 0; i < stringArray17.length; ++i) {
                        hashMap.put(stringArray17[i].split("=")[0].trim(), stringArray17[i].split("=")[1].trim());
                    }
                    if (((String)hashMap.get("node")).equalsIgnoreCase("local")) {
                        ConfigManager.printConfig(printWriter, (String)hashMap.get("name"));
                    } else {
                        this.dumpConfigInNodes(printWriter, (String)hashMap.get("node"), (String)hashMap.get("name"));
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printinternalconfig")) {
                    Output.printTrace("Print Internal Config Requested " + string10, 3);
                    printWriter.println("Number of Threads to inventory files in parallel : " + Global.getThreadPoolSizeForInventory() + "\n");
                    printWriter.println("File Count to switch inventory to parallel file processing : " + Global.getFileCountInventorySwitch() + "\n");
                    if (Global.isInternalSearchString().booleanValue()) {
                        printWriter.println("Search String based script execution : ON\n");
                    } else {
                        printWriter.println("Search String based script execution : OFF\n");
                    }
                    if (Global.isCollectAllDirsByFile()) {
                        printWriter.println("Collect All Directories by XML file : ON\n");
                    } else {
                        printWriter.println("Collect All Directories by XML file : OFF\n");
                    }
                    String string92 = ExaDom0RegistryManager.getRegisteredExaDom0Host();
                    if (string92 != null) {
                        printWriter.println("Registered ExaDom0 Host: " + string92 + "\n");
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("printlog")) {
                    String string93 = new Host().getHostname().trim();
                    printWriter.println("Node: " + string93);
                    LogFile.printLog(printWriter);
                    if (((String)object9).equals(string93)) {
                        this.printLogInAllNodes(printWriter);
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string8.contains("getcollectornodes")) {
                    Set<String> set = RGlobal.collectorKeys.keySet();
                    Output.printTrace("In getcollectornodes set size " + set.size(), 3);
                    for (String string94 : set) {
                        Output.printTrace("Got key " + string94, 3);
                        printWriter.println("Collector:" + string94.trim());
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string8.contains("removecollector")) {
                    if (Properties.TFARunMode.equalsIgnoreCase("collector")) {
                        this.stopProducer(printWriter);
                        ConfigManager.set("r.send.data.realtime", "false", "BOOLEAN");
                        FileMonitor15.keeprunning = false;
                    }
                    String string95 = string10.split(this.TFAARGSEP)[0].trim();
                    String string96 = TFAReceiverManager.removeGroup_collector(string95, (String)object9);
                    Map<String, Integer> map = Global.getPortMapping();
                    map.remove(string95);
                    Output.printTrace("updating port mapping after removal of " + string95, 3);
                    Output.printTrace("port mapping after removal" + map, 3);
                    Global.setPortMapping(map);
                    Properties.getInstance();
                    Properties.writePortMappingToFile(map);
                    printWriter.println(string96);
                    String string97 = Properties.tfaHome;
                    String string98 = string97 + File.separator + "." + this.reqUser.trim() + File.separator + "collectorkey.store";
                    this.sendCollectorFile(printWriter, string98);
                    bl = true;
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string9.equals("updatetfametadata")) {
                    String string99 = string10.trim();
                    String[] stringArray18 = string99.split(":");
                    RGlobal.topic = stringArray18[0];
                    RGlobal.tfaHome = Properties.tfaHome;
                    int n6 = Integer.parseInt(stringArray18[1]);
                    String string100 = stringArray18[2];
                    TFAMetaData tFAMetaData = new TFAMetaData(string100, RGlobal.topic, n6);
                    DbManager.getInstance().getDbPut().storeTFAMetaDataEntity(tFAMetaData);
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (string8.contains("addcollector")) {
                    int n7;
                    String[] stringArray19 = string10.split("~");
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (int i = 1; i < stringArray19.length; ++i) {
                        hashMap.put(stringArray19[i].split("=")[0].trim(), stringArray19[i].split("=")[1].trim());
                    }
                    String string101 = (String)hashMap.get("collector");
                    String string102 = Properties.tfaHome;
                    String string103 = string102 + File.separator + "." + this.reqUser.trim() + File.separator + "collectorkey.store";
                    object8 = null;
                    String string104 = (String)hashMap.get("roption");
                    object7 = (String)hashMap.get("koption");
                    object6 = (String)hashMap.get("ctype");
                    int n8 = 0;
                    String string105 = "";
                    stringArray = string104.trim().split("\\.");
                    if (stringArray[1].equals("auto")) {
                        string105 = string102 + File.separator + "." + this.reqUser + File.separator + stringArray[2] + ".opts";
                        Output.printTrace("Opts file " + string105, 3);
                    }
                    if (string104.startsWith("y")) {
                        try {
                            object8 = EncryptionUtil.encrypt(this.getKey(string101, string103));
                        }
                        catch (Exception exception) {}
                    } else {
                        try {
                            object8 = EncryptionUtil.encrypt(RGlobal.collectorKeys.get(string101.trim()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    object7 = TFAMetaData.getTFAMetaData();
                    Output.printTrace("got kopt:" + (String)object7, 1);
                    if (((String)object7).equals("NONE")) {
                        n8 = RGlobal.receiverPortForCollectors;
                        RGlobal.topic = string2.trim();
                        RGlobal.tfaHome = Properties.tfaHome;
                        object5 = string2.trim() + ":" + Integer.toString(n8);
                        Output.printTrace("updating rinfo in tfa nodes:" + (String)object5, 1);
                        object7 = object5;
                        object3 = new RandomString(9);
                        String string106 = ((RandomString)object3).nextString();
                        object4 = new TFAMetaData(string106, RGlobal.topic, n8);
                        DbManager.getInstance().getDbPut().storeTFAMetaDataEntity((TFAMetaData)object4);
                        object5 = ((String)object5).trim() + ":" + string106;
                        object2 = string2 + ":updatetfametadata:" + (String)object5;
                        new BroadcastMessage((String)object2).broadcast();
                    }
                    if (RGlobal.collectorKeys.containsKey(string101)) {
                        Output.printTrace("Collector node " + string101 + " was already added to the Receiver " + string2, 3);
                    } else {
                        Output.printTrace("Adding Collector node " + string101 + " to the Receiver " + string2, 3);
                        object5 = new TFAReceiver(string101.trim(), "blah", "blah", "/bah");
                        ((TFAReceiver)object5).setAttr("hostkey", (String)object8);
                        ((TFAReceiver)object5).setAttr("type", (String)object6);
                        DbManager.getInstance().getDbPut().storeTFAReceiverEntity((TFAReceiver)object5);
                        RGlobal.collectorKeys.put(string101, (String)object8);
                        Output.printTrace("Collector node " + string101 + " added to the Receiver " + string2, 3);
                    }
                    printWriter.println("PORT:" + (String)object7);
                    object5 = "";
                    object3 = TFAHost.getHostsInTFA();
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        object4 = (String)iterator.next();
                        if (((String)object5).equals("")) {
                            object5 = (String)object4 + ":" + n8;
                            continue;
                        }
                        object5 = (String)object5 + "," + (String)object4 + ":" + n8;
                    }
                    object5 = object7;
                    printWriter.println("RHOSTS=" + (String)object5);
                    if (!string105.equals("") && (n7 = this.createWrapFile(string105, (String)object5, this.reqUser)) == 1) {
                        printWriter.println("FAILED : Error while creating wrap file. Wrap file may not be proper xml file. Check TFA logs for details.");
                    }
                    if (((String)object9).equals(string2)) {
                        this.sendCollectorFile(printWriter, string103);
                        String string107 = "cnode=" + string101.trim() + "~cpassword=" + ((String)object8).trim() + "~ctype=" + ((String)object6).trim();
                        object4 = string2 + ":syncclientobject:" + string2 + "~" + string107;
                        new BroadcastMessage((String)object4).broadcast();
                    }
                    printWriter.println("DONE");
                    bl = true;
                    continue;
                }
                if (bl) continue;
                printWriter.println("Unknown or Invalid Action received for user : " + this.reqUser);
                printWriter.println("FAIL");
            }
            this.checkAndRemoveFile(file2);
            Output.printTrace("NonRootMessageHandler : Closing and Exiting", 3);
            printWriter.close();
            bufferedReader.close();
            this.socket.close();
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            this.checkAndRemoveFile(file2);
            Output.print("NonRootMessageHandler : SSLHandshakeException in running NonRootMessageHandler Thread" + sSLHandshakeException.getMessage());
            sSLHandshakeException.printStackTrace();
        }
        catch (IOException iOException) {
            this.checkAndRemoveFile(file2);
            Output.print("NonRootMessageHandler : IOException in running NonRootMessageHandler thread");
            iOException.printStackTrace();
        }
    }

    private void checkAndRemoveFile(File file) {
        if (file != null && file.exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTFAMainInAllNodes(PrintWriter printWriter) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string = null;
        String string2 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string3 = Properties.trustStore;
        Properties.getInstance();
        String string4 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            String string5 = string2 + ":checkTFAStatus:";
            for (TFAHost tFAHost : entityCursor) {
                String string6;
                string = tFAHost.getHostname();
                if (string.equalsIgnoreCase(string2)) continue;
                Output.printTrace("Making Socket connection to :" + string, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string3, string4);
                if (sSLSocket == null) {
                    printWriter.println("CheckFAIL!" + string + "!" + "-");
                    continue;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string5);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string6 = bufferedReader.readLine()) != null) {
                    printWriter.println(string6);
                }
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string, 1);
            Output.print("NonRootMessageHandler : IOException in checkTFAMainInAllNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    private String getPidOfTFAMain() {
        String string = null;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(Properties.internalDir + File.separator + ".pidfile"));
            while ((string2 = bufferedReader.readLine()) != null) {
                Output.printTrace("Inside getPidOfTFAMain: " + string2, 3);
                string = string2;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpDirectoriesInNodes(PrintWriter printWriter, String string, String string2, String string3, String string4) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string5 = null;
        String string6 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string7 = Properties.trustStore;
        Properties.getInstance();
        String string8 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (!string.equals("") && !string.equals("local")) {
                if (string.equals("all")) {
                    PrimaryIndex object = DbManager.getInstance().getAllEntities(TFAHost.class);
                    entityCursor = object.entities(null, cursorConfig);
                    for (TFAHost tFAHost : entityCursor) {
                        string5 = tFAHost.getHostname().trim();
                        arrayList.add(string5);
                    }
                } else {
                    for (String string9 : string.split(",")) {
                        arrayList.add(string9.trim());
                    }
                }
            }
            String exception = string6 + ":printdirectories:" + string2 + ":" + string3 + ":" + string4;
            for (String string10 : arrayList) {
                string5 = string10;
                if (!string5.equalsIgnoreCase(string6)) {
                    String string11;
                    Output.printTrace("Making Socket connection to :" + string5, 3);
                    sSLSocket = SocketManager.getSecureSocketConnection(string5.trim(), Global.getSocketPort(), string7, string8);
                    if (sSLSocket == null) {
                        printWriter.println("Connection refused!" + string5);
                        continue;
                    }
                    printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                    printWriter2.println(exception);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                    while ((string11 = bufferedReader.readLine()) != null && !string11.equals("DONE")) {
                        printWriter.println(string11);
                    }
                    bufferedReader.close();
                    if (sSLSocket.isClosed()) continue;
                    sSLSocket.close();
                    continue;
                }
                TFADirectoryManager.dumpDirectories(printWriter, string2, string3, string4);
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string5, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string5, 1);
            Output.print("NonRootMessageHandler : IOException in dumpDirectoriesInNodes");
        }
        finally {
            try {
                if (entityCursor != null) {
                    entityCursor.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpConfigInNodes(PrintWriter printWriter, String string, String string2) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string3 = null;
        String string4 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string5 = Properties.trustStore;
        Properties.getInstance();
        String string6 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String[] stringArray;
            if (!string.equals("") && !string.equalsIgnoreCase("local")) {
                if (string.equalsIgnoreCase("all")) {
                    stringArray = DbManager.getInstance().getAllEntities(TFAHost.class);
                    entityCursor = stringArray.entities(null, cursorConfig);
                    for (TFAHost tFAHost : entityCursor) {
                        string3 = tFAHost.getHostname().trim();
                        arrayList.add(string3);
                    }
                } else {
                    for (String string7 : string.split(",")) {
                        arrayList.add(string7.trim());
                    }
                }
            }
            stringArray = string4 + ":printconfig:node=local~name=" + string2;
            for (String string8 : arrayList) {
                string3 = string8;
                if (!string3.equalsIgnoreCase(string4)) {
                    String string9;
                    Output.printTrace("Making Socket connection to :" + string3, 3);
                    sSLSocket = SocketManager.getSecureSocketConnection(string3.trim(), Global.getSocketPort(), string5, string6);
                    if (sSLSocket == null) {
                        printWriter.println("Connection refused!" + string3);
                        continue;
                    }
                    printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                    printWriter2.println((String)stringArray);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                    while ((string9 = bufferedReader.readLine()) != null && !string9.equals("DONE")) {
                        printWriter.println(string9);
                    }
                    bufferedReader.close();
                    if (sSLSocket.isClosed()) continue;
                    sSLSocket.close();
                    continue;
                }
                ConfigManager.printConfig(printWriter, string2);
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string3, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string3, 1);
            Output.print("NonRootMessageHandler : IOException in dumpDirectoriesInNodes");
        }
        finally {
            try {
                if (entityCursor != null) {
                    entityCursor.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInventoryInNodes(PrintWriter printWriter, String string) {
        Object object;
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string2 = null;
        String string3 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string4 = Properties.trustStore;
        Properties.getInstance();
        String string5 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (!string.equals("") && !string.equals("local")) {
                if (string.equals("all")) {
                    object = DbManager.getInstance().getAllEntities(TFAHost.class);
                    entityCursor = object.entities(null, cursorConfig);
                    for (TFAHost tFAHost : entityCursor) {
                        string2 = tFAHost.getHostname().trim();
                        arrayList.add(string2);
                    }
                } else {
                    for (String string6 : string.split(",")) {
                        arrayList.add(string6.trim());
                    }
                }
            }
            object = string3 + ":printinventory";
            for (String string7 : arrayList) {
                string2 = string7;
                if (!string2.equalsIgnoreCase(string3)) {
                    String string8;
                    Output.printTrace("Making Socket connection to :" + string2, 3);
                    sSLSocket = SocketManager.getSecureSocketConnection(string2.trim(), Global.getSocketPort(), string4, string5);
                    if (sSLSocket == null) {
                        printWriter.println("Connection refused!" + string2);
                        continue;
                    }
                    printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                    printWriter2.println((String)object);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                    while ((string8 = bufferedReader.readLine()) != null && !string8.equals("DONE")) {
                        printWriter.println(string8);
                    }
                    bufferedReader.close();
                    if (sSLSocket.isClosed()) continue;
                    sSLSocket.close();
                    continue;
                }
                TFAInventoryManager.printInventory(printWriter);
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string2, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string2, 1);
            Output.print("NonRootMessageHandler : IOException in dumpDirectoriesInAllNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
        if (string.equals("all")) {
            ArrayList arrayList2 = new ArrayList();
            String string9 = Properties.internalDir + File.separator + "cellnames.txt";
            if (new File(string9).exists()) {
                try {
                    String string6;
                    object = new BufferedReader(new FileReader(string9));
                    while ((string6 = ((BufferedReader)object).readLine()) != null) {
                        arrayList2.add(string6.trim());
                    }
                    ((BufferedReader)object).close();
                    if (arrayList2.size() > 0) {
                        Output.printTrace("No of cells : " + arrayList2.size(), 3);
                        Iterator iterator = arrayList2.iterator();
                        while (iterator.hasNext()) {
                            String string10 = (String)iterator.next();
                            String string11 = Properties.inventoryDir + File.separator + "inventory_" + string10 + ".xml";
                            if (!new File(string11).exists()) continue;
                            Output.printTrace("Inventory File exists : " + string11, 3);
                            CreateFileEntitiesFromXml createFileEntitiesFromXml = new CreateFileEntitiesFromXml(string11);
                            for (FileEntity fileEntity : createFileEntitiesFromXml.getFileEntities()) {
                                fileEntity.printFileDetails(printWriter, string10);
                            }
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Output.print("NonRootMessageHandler : FileNotFoundException encountered in printinventory");
                }
                catch (IOException iOException) {
                    Output.print("NonRootMessageHandler : IOException encountered in printinventory");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpOngoingCollectionsInAllNodes(PrintWriter printWriter) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string = null;
        String string2 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string3 = Properties.trustStore;
        Properties.getInstance();
        String string4 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            String string5 = string2 + ":printOngoingCollections";
            for (TFAHost tFAHost : entityCursor) {
                String string6;
                string = tFAHost.getHostname();
                if (string.equalsIgnoreCase(string2)) continue;
                Output.printTrace("Making Socket connection to :" + string, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string3, string4);
                if (sSLSocket == null) {
                    printWriter.println("Connection refused!" + string);
                    continue;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string5);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string6 = bufferedReader.readLine()) != null && !string6.equals("DONE")) {
                    printWriter.println(string6);
                }
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string, 1);
            Output.print("NonRootMessageHandler : IOException in dumpOngoingCollectionsInAllNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpActionsInAllNodes(PrintWriter printWriter, String string) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string2 = null;
        String string3 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string4 = Properties.trustStore;
        Properties.getInstance();
        String string5 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            String string6 = string3 + ":printactions:" + string;
            if (string == null) {
                string6 = string3 + ":printactions";
            }
            for (TFAHost tFAHost : entityCursor) {
                String string7;
                string2 = tFAHost.getHostname();
                if (string2.equalsIgnoreCase(string3)) continue;
                Output.printTrace("Making Socket connection to :" + string2, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string2.trim(), Global.getSocketPort(), string4, string5);
                if (sSLSocket == null) {
                    printWriter.println("Connection refused!" + string2);
                    continue;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string6);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string7 = bufferedReader.readLine()) != null && !string7.equals("DONE")) {
                    printWriter.println(string7);
                }
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string2, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string2, 1);
            Output.print("NonRootMessageHandler : IOException in dumpActionsInAllNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpRepositoryInAllNodes(PrintWriter printWriter, String string) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string2 = null;
        String string3 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string4 = Properties.trustStore;
        Properties.getInstance();
        String string5 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            String string6 = string3 + ":printrepository";
            for (TFAHost tFAHost : entityCursor) {
                string2 = tFAHost.getHostname();
                if (!string2.equalsIgnoreCase(string3)) {
                    String string7;
                    if (!string.equals("")) {
                        string2 = string;
                    }
                    Output.printTrace("Making Socket connection to :" + string2, 3);
                    sSLSocket = SocketManager.getSecureSocketConnection(string2.trim(), Global.getSocketPort(), string4, string5);
                    if (sSLSocket == null) {
                        printWriter.println("Connection refused!" + string2);
                        continue;
                    }
                    printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                    printWriter2.println(string6);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                    while ((string7 = bufferedReader.readLine()) != null && !string7.equals("DONE")) {
                        printWriter.println(string7);
                    }
                    bufferedReader.close();
                    if (!sSLSocket.isClosed()) {
                        sSLSocket.close();
                    }
                }
                if (string.equals("")) continue;
                break;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string2, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string2, 1);
            Output.print("NonRootMessageHandler : IOException in dumpRepositoryInAllNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    private void dumpRemoteInventoryLocation(PrintWriter printWriter, String string) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string2 = new Host().getHostname().trim();
        Properties.getInstance();
        String string3 = Properties.trustStore;
        Properties.getInstance();
        String string4 = Properties.trustStorePassword;
        try {
            String string5 = string2 + ":getInventoryLocation:" + string;
            if (!string.equals(string2)) {
                String string6;
                Output.printTrace("Making Socket connection to :" + string, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string3, string4);
                if (sSLSocket == null) {
                    printWriter.println("Connection refused!" + string);
                    return;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string5);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string6 = bufferedReader.readLine()) != null && !string6.equals("DONE")) {
                    printWriter.println(string6);
                }
                bufferedReader.close();
                if (!sSLSocket.isClosed()) {
                    sSLSocket.close();
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string, 1);
            Output.print("NonRootMessageHandler : IOException in dumpRemoteInventoryLocation");
        }
    }

    private void dumpRemoteRepositoryLocation(PrintWriter printWriter, String string) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string2 = new Host().getHostname().trim();
        Properties.getInstance();
        String string3 = Properties.trustStore;
        Properties.getInstance();
        String string4 = Properties.trustStorePassword;
        try {
            String string5 = string2 + ":getRepositoryLocation:" + string;
            if (!string.equals(string2)) {
                String string6;
                Output.printTrace("Making Socket connection to :" + string, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string3, string4);
                if (sSLSocket == null) {
                    printWriter.println("Connection refused!" + string);
                    return;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string5);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string6 = bufferedReader.readLine()) != null && !string6.equals("DONE")) {
                    printWriter.println(string6);
                }
                bufferedReader.close();
                if (!sSLSocket.isClosed()) {
                    sSLSocket.close();
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string, 1);
            Output.print("NonRootMessageHandler : IOException in dumpRemoteRepositoryLocation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInventoryRunStatsInAllNodes(PrintWriter printWriter) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string = null;
        String string2 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string3 = Properties.trustStore;
        Properties.getInstance();
        String string4 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            String string5 = string2 + ":printinvrunstat";
            for (TFAHost tFAHost : entityCursor) {
                String string6;
                string = tFAHost.getHostname();
                if (string.equalsIgnoreCase(string2)) continue;
                Output.printTrace("Making Socket connection to :" + string, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string3, string4);
                if (sSLSocket == null) {
                    printWriter.println("Connection refused!" + string);
                    continue;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string5);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string6 = bufferedReader.readLine()) != null && !string6.equals("DONE")) {
                    printWriter.println(string6);
                }
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string, 1);
            Output.print("NonRootMessageHandler : IOException in dumpInventoryRunStatsInAllNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printLogInAllNodes(PrintWriter printWriter) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string = null;
        String string2 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string3 = Properties.trustStore;
        Properties.getInstance();
        String string4 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            String string5 = string2 + ":printlog";
            for (TFAHost tFAHost : entityCursor) {
                String string6;
                string = tFAHost.getHostname();
                if (string.equalsIgnoreCase(string2)) continue;
                Output.printTrace("Making Socket connection to :" + string, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string3, string4);
                if (sSLSocket == null) {
                    printWriter.println("Connection refused!" + string);
                    continue;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string5);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string6 = bufferedReader.readLine()) != null && !string6.equals("DONE")) {
                    printWriter.println(string6);
                }
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string, 1);
            Output.print("NonRootMessageHandler : IOException in printLogInAllNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSearchInAllNodes(PrintWriter printWriter, String string) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string2 = null;
        String string3 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string4 = Properties.trustStore;
        Properties.getInstance();
        String string5 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            String string6 = string3 + ":searchusingtnt:" + string;
            if (string == null) {
                string6 = string3 + ":searchusingtnt";
            }
            String[] stringArray = string.split("~", -1);
            String string7 = stringArray[7].trim();
            for (TFAHost tFAHost : entityCursor) {
                String string8;
                string2 = tFAHost.getHostname();
                boolean bl = false;
                if (string7.equals("") || string7.indexOf(string2) >= 0) {
                    bl = true;
                }
                if (string2.equalsIgnoreCase(string3) || !bl) continue;
                Output.printTrace("Making Socket connection to :" + string2, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string2.trim(), Global.getSocketPort(), string4, string5);
                if (sSLSocket == null) {
                    printWriter.println("\n\nERROR : Skipping analysis on the host " + string2 + " as TFA is down !\n\n");
                    continue;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string6);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string8 = bufferedReader.readLine()) != null && !string8.equals("DONE")) {
                    printWriter.println(string8);
                }
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string2, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string2, 1);
            Output.print("NonRootMessageHandler : IOException in doSearchInAllNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    private String getBuildVersion() {
        Output.printTrace("Reading build version file....", 3);
        String string = "";
        if (!new File(Properties.buildVersionFile).exists()) {
            return string;
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(Properties.buildVersionFile));
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string2.trim();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Output.print("NonRootMessageHandler : IOException while reading build file");
        }
        return string;
    }

    private void updateConfigPropertiesFile(String string, String string2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(Properties.configPropertiesFile);
            java.util.Properties properties = new java.util.Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            properties.setProperty(string, string2);
            FileOutputStream fileOutputStream = new FileOutputStream(Properties.configPropertiesFile);
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Output.print("NonRootMessageHandler : IOException while updating config file: " + iOException.getMessage());
        }
        catch (Exception exception) {
            Output.print("NonRootMessageHandler : Exception while updating config file " + exception.getMessage());
        }
    }

    private boolean checkForValidity(String string) {
        Object object;
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(ZipEntity.class);
        EntityCursor entityCursor = primaryIndex.entities();
        for (ZipEntity zipEntity : entityCursor) {
            String string2 = zipEntity.getFileNameFull();
            if (!string2.contains(File.separator)) continue;
            int n = string2.lastIndexOf(File.separator);
            String string3 = string2.substring(0, n);
            n = string2.lastIndexOf(File.separator);
            string3 = string3.substring(0, n);
            hashSet.add(string3);
        }
        entityCursor.close();
        Properties.getInstance();
        if (Properties.getInstallType().equals("GI")) {
            if (Properties.getOracleBase() != null) {
                hashSet.add(Properties.getOracleBase() + File.separator + "tfa" + File.separator + "repository");
            } else {
                object = Properties.tfaHome;
                hashSet.add(((String)object).substring(0, ((String)object).substring(0, ((String)object).lastIndexOf(File.separator)).lastIndexOf(File.separator)) + File.separator + "repository");
            }
        } else if (Properties.getInstance().getNodeType().equals("ODA") || Properties.getInstance().getNodeType().equals("ODADom0") || Properties.getInstance().getNodeType().equals("ODAVMGuest")) {
            hashSet.add(Properties.tfaHome + File.separator + "repository");
        } else if (Properties.tfaHome.contains(new Host().getHostname().trim())) {
            object = Properties.tfaHome;
            hashSet.add(((String)object).substring(0, ((String)object).substring(0, ((String)object).lastIndexOf(File.separator)).lastIndexOf(File.separator)) + File.separator + "repository");
        } else {
            hashSet.add(Properties.tfaHome + File.separator + "repository");
        }
        Output.printTrace("Valid directories for repository : " + hashSet, 3);
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        if (hashSet.contains(string)) {
            bl = true;
        }
        Output.printTrace("Output of validity : " + bl, 3);
        return bl;
    }

    private boolean isDirectoryEmpty(String string) {
        boolean bl = false;
        File file = new File(string);
        if (file.isDirectory() && file.list().length == 0) {
            bl = true;
        }
        return bl;
    }

    public String getTFAHome(String string) {
        String string2 = "";
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        Properties.getInstance();
        String string3 = Properties.trustStore;
        Properties.getInstance();
        String string4 = Properties.trustStorePassword;
        String string5 = new Host().getHostname().trim();
        String string6 = string5 + ":printtfahome";
        try {
            if (!string.equalsIgnoreCase(string5)) {
                String string7;
                Output.printTrace("Making Socket connection to :" + string, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string3, string4);
                if (sSLSocket == null) {
                    Output.print("Connection refused by " + string);
                    return "CONNECTION REFUSED";
                }
                printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter.println(string6);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string7 = bufferedReader.readLine()) != null && !string7.equals("DONE") && !string7.equals("FAIL")) {
                    string2 = string2 + string7;
                }
                bufferedReader.close();
                if (!sSLSocket.isClosed()) {
                    sSLSocket.close();
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.print("Unknown host: " + string);
        }
        catch (IOException iOException) {
            Output.print("NonRootMessageHandler : IOException while getTFAHome");
        }
        Output.printTrace("tfahome: " + string2, 3);
        return string2;
    }

    private void initiateZipTransferUsingTag(String string, String string2, PrintWriter printWriter) {
        PrintWriter printWriter2 = null;
        String string3 = new Host().getHostname().trim();
        String string4 = this.getCommandFromTag(string2);
        if (string4 == null) {
            return;
        }
        long l = new File(string4).length();
        String string5 = string3 + ":zipreadyfortransferusingtag:" + string2 + ":" + l;
        Properties.getInstance();
        String string6 = Properties.trustStore;
        Properties.getInstance();
        String string7 = Properties.trustStorePassword;
        SSLSocket sSLSocket = null;
        try {
            Output.printTrace("Making secure socket connection to " + string, 3);
            Output.printTrace("Sending message that file is ready for transfer " + string2, 3);
            sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string6, string7);
            if (sSLSocket == null) {
                printWriter.println("Connection refused!" + string);
                return;
            }
            printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
            printWriter2.println(string5);
        }
        catch (Exception exception) {
            Output.print("NonRootMessageHandler : Exception in sending message that file is ready for transfer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDbExistence(String string, String string2) {
        boolean bl;
        block20: {
            String string3;
            DirectoryMappingType directoryMappingType2;
            String string4;
            String string5;
            block21: {
                string = string.trim();
                String[] stringArray = string.split(":");
                string5 = stringArray[0];
                String[] stringArray2 = null;
                string4 = new Host().getHostname().trim();
                if (stringArray.length > 1 && stringArray[1] != null && !stringArray[1].equals("")) {
                    for (String object2 : stringArray2 = stringArray[1].split(",")) {
                        Output.printTrace("checkDbExistence : " + object2, 3);
                    }
                }
                Output.printTrace("Checking for existence of database : " + string5 + " in nodes : " + stringArray2, 3);
                bl = false;
                List<String> list = null;
                if (stringArray2 != null && stringArray2.length > 0) {
                    list = Arrays.asList(stringArray2);
                }
                if (stringArray2 == null || list != null && (list.contains("local") || list.contains(string4))) {
                    Vector vector = DirectoryMappings.getInstance().getDirectories();
                    HashSet<String> hashSet = new HashSet<String>();
                    for (DirectoryMappingType directoryMappingType2 : vector) {
                        hashSet.add(directoryMappingType2.database);
                    }
                    if (hashSet.contains(string5.toLowerCase()) || hashSet.contains(string5.toUpperCase())) {
                        bl = true;
                    }
                }
                Output.printTrace("Database exists : " + bl, 3);
                if (bl) {
                    return bl;
                }
                string3 = "";
                if (stringArray2 == null) break block21;
                for (String string6 : stringArray2) {
                    if (string6.equals("local")) continue;
                    string3 = this.performActionsInNode(string5, null, "checkdbexistence", "DB EXISTS", "DB DOES NOT EXIST", false, string6);
                    Output.printTrace("Database exists STATUS: " + string3, 3);
                    if (!string3.equals("DB EXISTS")) continue;
                    bl = true;
                    break block20;
                }
                break block20;
            }
            if (!string2.equalsIgnoreCase(string4)) break block20;
            Object var10_18 = null;
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            directoryMappingType2 = null;
            try {
                PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(String.class, TFAHost.class);
                directoryMappingType2 = primaryIndex.entities(null, cursorConfig);
                Iterator iterator = directoryMappingType2.iterator();
                while (iterator.hasNext()) {
                    TFAHost tFAHost = (TFAHost)iterator.next();
                    String string7 = tFAHost.getHostname();
                    string3 = this.performActionsInNode(string5, null, "checkdbexistence", "DB EXISTS", "DB DOES NOT EXIST", false, string7);
                    Output.printTrace("Database exists STATUS: " + string3, 3);
                    if (!string3.equals("DB EXISTS")) continue;
                    bl = true;
                }
            }
            catch (Exception exception) {
                Output.printTrace("MessageHandler : Exception in checkDbExistence", 1);
            }
            finally {
                try {
                    directoryMappingType2.close();
                }
                catch (Exception exception) {
                    Output.print("MessageHandler : Exception while closing the cursor in checkDbExistence");
                }
            }
        }
        return bl;
    }

    private void sendCommandToRemoteHostPrint(String string, String string2, PrintWriter printWriter, String string3, String string4) {
        Output.printTrace("Sending command " + string2 + " to remote host : " + string, 3);
        PrintWriter printWriter2 = null;
        String string5 = new Host().getHostname().trim();
        String string6 = string5 + ":runcommandinhost:su " + string4 + " -c " + string2 + ":" + string3;
        Properties.getInstance();
        String string7 = Properties.trustStore;
        Properties.getInstance();
        String string8 = Properties.trustStorePassword;
        SSLSocket sSLSocket = null;
        try {
            String string9;
            Output.printTrace("Making secure socket connection to " + string, 3);
            Output.printTrace("Sending message to execute command : " + string2, 3);
            sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string7, string8);
            if (sSLSocket == null) {
                printWriter.println("Connection refused!" + string);
                return;
            }
            printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
            printWriter2.println(string6);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
            while ((string9 = bufferedReader.readLine()) != null && !string9.equals("DONE")) {
                printWriter.println(string9);
            }
            bufferedReader.close();
            if (!sSLSocket.isClosed()) {
                sSLSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendCommandToRemoteHost(String string, String string2, PrintWriter printWriter) {
        Output.printTrace("Sending command " + string2 + " to remote host : " + string, 3);
        PrintWriter printWriter2 = null;
        String string3 = new Host().getHostname().trim();
        String string4 = string3 + ":runcommandinhost:" + string2;
        Properties.getInstance();
        String string5 = Properties.trustStore;
        Properties.getInstance();
        String string6 = Properties.trustStorePassword;
        SSLSocket sSLSocket = null;
        try {
            Output.printTrace("Making secure socket connection to " + string, 3);
            Output.printTrace("Sending message to execute command : " + string2, 3);
            sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string5, string6);
            if (sSLSocket == null) {
                printWriter.println("Connection refused!" + string);
                return;
            }
            printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
            printWriter2.println(string4);
            if (!sSLSocket.isClosed()) {
                sSLSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAutoPatchingInAllNodes(PrintWriter printWriter) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string = null;
        String string2 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string3 = Properties.trustStore;
        Properties.getInstance();
        String string4 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            String string5 = string2 + ":checkautopatchingenabled:";
            for (TFAHost tFAHost : entityCursor) {
                String string6;
                string = tFAHost.getHostname().trim();
                if (string.equalsIgnoreCase(string2)) continue;
                Output.printTrace("Making Socket connection to :" + string, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string3, string4);
                if (sSLSocket == null) {
                    printWriter.println("Connection Refused by " + string);
                    continue;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string5);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string6 = bufferedReader.readLine()) != null) {
                    printWriter.println(string6);
                }
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string, 1);
            Output.print("NonRootMessageHandler : IOException in checkAutoPatchingInAllNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkKeyStoresUpdatedInAllNodes(PrintWriter printWriter) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string = null;
        String string2 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string3 = Properties.trustStore;
        Properties.getInstance();
        String string4 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            String string5 = string2 + ":checkkeystoresupdated:";
            for (TFAHost tFAHost : entityCursor) {
                String string6;
                string = tFAHost.getHostname();
                if (string.equalsIgnoreCase(string2)) continue;
                Output.printTrace("Making Socket connection to :" + string, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string3, string4);
                if (sSLSocket == null) {
                    printWriter.println("Connection Refused by " + string);
                    continue;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string5);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string6 = bufferedReader.readLine()) != null) {
                    printWriter.println(string6);
                }
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string, 1);
            Output.print("NonRootMessageHandler : IOException in checkKeyStoresUpdatedInAllNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    private void checkTagExistsInNodes(PrintWriter printWriter, String string, String string2) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string3 = null;
        String string4 = new Host().getHostname().trim();
        Properties.getInstance();
        String string5 = Properties.trustStore;
        Properties.getInstance();
        String string6 = Properties.trustStorePassword;
        boolean bl = false;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            String[] stringArray = string.split(" ");
            String string7 = string4 + ":checktagexists:" + string2;
            for (String string8 : stringArray) {
                String string9;
                string3 = string8;
                if (string3.equalsIgnoreCase(string4)) continue;
                Output.printTrace("Making Socket connection to :" + string3, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string3.trim(), Global.getSocketPort(), string5, string6);
                if (sSLSocket == null) continue;
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string7);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string9 = bufferedReader.readLine()) != null) {
                    if (string9.contains("Tag already exists")) {
                        bl = true;
                    }
                    printWriter.println(string9);
                }
                if (!bl) {
                    bufferedReader.close();
                    if (sSLSocket.isClosed()) continue;
                    sSLSocket.close();
                    continue;
                }
                break;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.print("Unknown host: " + string3);
        }
        catch (IOException iOException) {
            Output.print("NonRootMessageHandler : IOException in checkTagExistsInNodes");
        }
    }

    private String getInventoryRunStatus() {
        String string = InventoryRun.getInventoryStatus();
        Output.printTrace("status of Inventory Run : " + string, 3);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDirectoryInNodes(String string, PrintWriter printWriter, String string2) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string3 = null;
        String string4 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string5 = Properties.trustStore;
        Properties.getInstance();
        String string6 = Properties.trustStorePassword;
        boolean bl = false;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (string2.equals("all")) {
                PrimaryIndex object = DbManager.getInstance().getAllEntities(TFAHost.class);
                entityCursor = object.entities(null, cursorConfig);
                for (TFAHost tFAHost : entityCursor) {
                    string3 = tFAHost.getHostname().trim();
                    arrayList.add(string3);
                }
            } else {
                for (String string7 : string2.split(",")) {
                    arrayList.add(string7.trim());
                }
                if (!string2.contains(string4)) {
                    bl = true;
                }
            }
            String exception = string4 + ":adddirectory:" + string;
            for (String string8 : arrayList) {
                String string9;
                string3 = string8;
                if (string3.equalsIgnoreCase(string4)) continue;
                Output.printTrace("Making Socket connection to :" + string3, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string3.trim(), Global.getSocketPort(), string5, string6);
                if (sSLSocket == null) {
                    if (!bl) continue;
                    printWriter.println("Connection refused!" + string3);
                    continue;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(exception);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string9 = bufferedReader.readLine()) != null) {
                    if (string9.equals("DONE") || string9.startsWith("SUCCESS") || string9.startsWith("FAILED")) {
                        Output.printTrace("fromServer : " + string9, 3);
                        if (!bl) break;
                        printWriter.println(string9);
                        break;
                    }
                    if (!bl) continue;
                    printWriter.println(string9);
                }
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string3, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string3, 1);
            Output.print("NonRootMessageHandler : IOException in addDirectoryInNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyDirectoryInNodes(String string, PrintWriter printWriter, String string2) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string3 = null;
        String string4 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string5 = Properties.trustStore;
        Properties.getInstance();
        String string6 = Properties.trustStorePassword;
        boolean bl = false;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (string2.equals("all")) {
                PrimaryIndex object = DbManager.getInstance().getAllEntities(TFAHost.class);
                entityCursor = object.entities(null, cursorConfig);
                for (TFAHost tFAHost : entityCursor) {
                    string3 = tFAHost.getHostname().trim();
                    arrayList.add(string3);
                }
            } else {
                for (String string7 : string2.split(",")) {
                    arrayList.add(string7.trim());
                }
                if (!string2.contains(string4)) {
                    bl = true;
                }
            }
            String exception = string4 + ":modifydirectorypermission:" + string;
            for (String string8 : arrayList) {
                String string9;
                string3 = string8;
                if (string3.equalsIgnoreCase(string4)) continue;
                Output.printTrace("Making Socket connection to :" + string3, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string3.trim(), Global.getSocketPort(), string5, string6);
                if (sSLSocket == null) {
                    if (!bl) continue;
                    printWriter.println("Connection refused!" + string3);
                    continue;
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(exception);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string9 = bufferedReader.readLine()) != null) {
                    if (string9.equals("DONE") || string9.startsWith("SUCCESS") || string9.startsWith("FAILED")) {
                        Output.printTrace("fromServer : " + string9, 3);
                        if (!bl) break;
                        printWriter.println(string9);
                        break;
                    }
                    if (!bl) continue;
                    printWriter.println(string9);
                }
                bufferedReader.close();
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string3, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string3, 1);
            Output.print("NonRootMessageHandler : IOException in modifyDirectoryInNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String removeDirectoryInNodes(PrintWriter printWriter, String string, String string2) {
        String string3 = "DONE";
        Output.printTrace("removeDirectoryInNodes :" + string2, 3);
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string4 = null;
        String string5 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string6 = Properties.trustStore;
        Properties.getInstance();
        String string7 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (string2.equals("all")) {
                PrimaryIndex object = DbManager.getInstance().getAllEntities(TFAHost.class);
                entityCursor = object.entities(null, cursorConfig);
                for (TFAHost tFAHost : entityCursor) {
                    string4 = tFAHost.getHostname().trim();
                    arrayList.add(string4);
                }
            } else {
                for (String string8 : string2.split(",")) {
                    arrayList.add(string8.trim());
                }
            }
            String exception = string5 + ":removedirectory:" + string;
            for (String string9 : arrayList) {
                string4 = string9;
                if (!string4.equalsIgnoreCase(string5)) {
                    String string10;
                    Output.printTrace("Making Socket connection to :" + string4, 3);
                    sSLSocket = SocketManager.getSecureSocketConnection(string4.trim(), Global.getSocketPort(), string6, string7);
                    if (sSLSocket == null) continue;
                    printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                    printWriter2.println(exception);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                    while (!((string10 = bufferedReader.readLine()) == null || string10.equals("DONE") || string10.startsWith("SUCCESS") || string10.startsWith("FAILED"))) {
                    }
                    bufferedReader.close();
                    if (sSLSocket.isClosed()) continue;
                    sSLSocket.close();
                    continue;
                }
                string3 = TFADirectoryManager.removeDirectory(string, printWriter, false);
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string4, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string4, 1);
            Output.print("NonRootMessageHandler : IOException in dumpDirectoriesInNodes");
        }
        finally {
            try {
                if (entityCursor != null) {
                    entityCursor.close();
                }
            }
            catch (Exception exception) {}
        }
        return string3;
    }

    private String getRemoteTFAHome(String string) {
        String string2 = new Host().getHostname().trim() + File.separator + "tfa_home";
        String string3 = string + File.separator + "tfa_home";
        Properties.getInstance();
        String string4 = Properties.tfaHome.trim().replaceAll(string2, string3);
        return string4;
    }

    private String getCommandFromTag(String string) {
        String string2 = null;
        Properties.getInstance();
        String string3 = Properties.tfaHome.trim();
        String string4 = string3 + File.separator + "bin" + File.separator + "tfactl";
        if (string.startsWith(string4)) {
            string2 = string.split(";")[0];
        } else if (string.equals("removewallet")) {
            string2 = "rm -rf " + Properties.internalDir + File.separator + "tfawallet";
        } else if (string.equals("removecellnames")) {
            string2 = "rm -f " + Properties.internalDir + File.separator + "cellnames.txt";
        } else if (string.equals("removecellips")) {
            string2 = "rm -f " + Properties.internalDir + File.separator + "cellips.txt";
        } else if (string.startsWith("cellinv-")) {
            String string5 = string.split("-")[1];
            if (string5 != null) {
                string2 = Properties.internalDir + File.separator + "." + string5 + ".inv";
            }
        } else if (string.startsWith("cellinvxml-")) {
            String string6 = string.split("-")[1];
            if (string6 != null) {
                string2 = Properties.inventoryDir + File.separator + "inventory_" + string6 + ".xml";
            }
        } else if (string.startsWith("rmcellinv-")) {
            String string7 = string.split("-")[1];
            if (string7 != null) {
                string2 = "rm -f " + Properties.internalDir + File.separator + "." + string7 + ".inv";
            }
        } else if (string.equals("maketfawallet")) {
            string2 = "mkdir -p " + Properties.internalDir + File.separator + "tfawallet";
        } else if (string.equals("cellnames")) {
            string2 = Properties.internalDir + File.separator + "cellnames.txt";
        } else if (string.equals("cellips")) {
            string2 = Properties.internalDir + File.separator + "cellips.txt";
        } else if (string.startsWith("walletfile-")) {
            String string8 = string.split("-")[1];
            if (string8 != null && !string8.contains("..")) {
                try {
                    string2 = new File(Properties.internalDir).getCanonicalPath() + File.separator + "tfawallet" + File.separator + string8;
                    if (this.isSymbolicLink(new File(string2))) {
                        string2 = null;
                    }
                }
                catch (IOException iOException) {
                    string2 = null;
                }
            }
        } else if (string.startsWith("repofile-")) {
            String string9 = string.split("-TAG-")[1];
            if ((string9 = string9.replace("-FILE-", File.separator)) != null && !string9.contains("..")) {
                try {
                    string2 = new File(RepositoryManager.getInstance().getDirectory()).getCanonicalPath() + File.separator + string9;
                    if (this.isSymbolicLink(new File(string2))) {
                        string2 = null;
                    }
                }
                catch (IOException iOException) {
                    string2 = null;
                }
            }
        } else if (string.startsWith("ipsfile-")) {
            String string10 = string.split("-USER-")[1];
            if ((string10 = string10.replace("-FILE-", File.separator)) != null && !string10.contains("..")) {
                try {
                    string2 = new File(RepositoryManager.getInstance().getDirectory()).getCanonicalPath() + File.separator + "suptools" + File.separator + "ips" + File.separator + string10;
                    if (this.isSymbolicLink(new File(string2))) {
                        string2 = null;
                    }
                }
                catch (IOException iOException) {
                    string2 = null;
                }
            }
        } else if (string.startsWith("srdcfile-")) {
            String string11 = string.split("-TAG-")[1];
            Output.printTrace("getCommandFromTag srdc tag: " + string11, 1);
            if (string11 != null && !string11.contains("..")) {
                try {
                    string11 = "tfa_" + string11 + ".xml";
                    string2 = new File(RepositoryManager.getInstance().getDirectory()).getCanonicalPath() + File.separator + "suptools" + File.separator + "srdc" + File.separator + "user_" + this.reqUser + File.separator + string11;
                    Output.printTrace("getCommandFromTag srdc command: " + string2, 1);
                    if (this.isSymbolicLink(new File(string2))) {
                        string2 = null;
                    }
                }
                catch (IOException iOException) {
                    string2 = null;
                }
            }
        } else if (string.equals("tfactloratop")) {
            string2 = string4 + " analyze -comp oratop ";
        } else if (string.equals("tfactlruntool")) {
            string2 = string4 + " run ";
        } else if (string.equals("tfactlips")) {
            string2 = string4 + " local ips ";
        }
        Output.print("Command in getCommandFromTag :" + string2);
        Output.printTrace("Command in getCommandFromTag :" + string2, 3);
        return string2;
    }

    private String getCommandFromTag(String string, String string2) {
        String string3 = null;
        if (string2 == null) {
            return string3;
        }
        String string4 = this.getRemoteTFAHome(string);
        String string5 = string4 + File.separator + "bin" + File.separator + "tfactl";
        if (string2.startsWith(string5)) {
            string3 = string2.split(";")[0];
        } else if (string2.equals("removewallet")) {
            string3 = "rm -rf " + string4 + File.separator + "internal" + File.separator + "tfawallet";
        } else if (string2.equals("removecellnames")) {
            string3 = "rm -f " + string4 + File.separator + "internal" + File.separator + "cellnames.txt";
        } else if (string2.equals("removecellips")) {
            string3 = "rm -f " + string4 + File.separator + "internal" + File.separator + "cellips.txt";
        } else if (string2.startsWith("rmcellinv-")) {
            String string6 = string2.split("-")[1];
            if (string6 != null) {
                string3 = "rm -f " + string4 + File.separator + "internal" + File.separator + "." + string6 + ".inv";
            }
        } else if (string2.equals("maketfawallet")) {
            string3 = "mkdir -p " + string4 + File.separator + "internal" + File.separator + "tfawallet";
        } else if (string2.equals("tfactloratop")) {
            string3 = string5 + " analyze -comp oratop ";
        } else if (string2.equals("tfactlruntool")) {
            string3 = string5 + " run ";
        } else if (string2.equals("tfactlips")) {
            string3 = string5 + " local ips ";
        }
        Output.printTrace("Command in getCommandFromTag :" + string3, 3);
        return string3;
    }

    private String performActionsInNode(String string, PrintWriter printWriter, String string2, String string3, String string4, boolean bl, String string5) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string6 = null;
        String string7 = new Host().getHostname().trim();
        String string8 = Properties.trustStore;
        String string9 = Properties.trustStorePassword;
        String string10 = "";
        String string11 = "SUCCESS";
        try {
            String string12 = "";
            string12 = string != null ? string7 + ":" + string2.trim() + ":" + string : string7 + ":" + string2.trim();
            string6 = string5;
            if (!string6.equalsIgnoreCase(string7)) {
                Output.printTrace("Making Socket connection to :" + string6, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string6.trim(), Global.getSocketPort(), string8, string9);
                if (sSLSocket == null) {
                    if (printWriter != null) {
                        printWriter.println("MessageHandler : Connection refused! " + string6);
                    }
                    return "Failed Socket Connection";
                }
                printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter2.println(string12);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string10 = bufferedReader.readLine()) != null) {
                    if (string10.equals("DONE") || string10.startsWith(string3.trim()) || string10.startsWith(string4.trim())) {
                        Output.printTrace("MessageHandler: Status from " + string6 + " : " + string10, 3);
                        string11 = string10;
                        break;
                    }
                    if (!bl) continue;
                    printWriter.println(string10);
                }
                bufferedReader.close();
                if (!sSLSocket.isClosed()) {
                    sSLSocket.close();
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("MessageHandler : Don't know about host: " + string6, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("MessageHandler : Couldn't get I/O for the connection to Host : " + string6, 1);
        }
        return string11;
    }

    public boolean isNodePartOfTFA(String string) {
        return TFAHost.getHostsInTFA().contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String removeSubDirectoryInNodes(PrintWriter printWriter, String string, String string2) {
        String string3 = "DONE";
        Output.printTrace("removeSubDirectoryInNodes :" + string2, 3);
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string4 = null;
        String string5 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        Properties.getInstance();
        String string6 = Properties.trustStore;
        Properties.getInstance();
        String string7 = Properties.trustStorePassword;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (string2.equals("all")) {
                PrimaryIndex object = DbManager.getInstance().getAllEntities(TFAHost.class);
                entityCursor = object.entities(null, cursorConfig);
                for (TFAHost tFAHost : entityCursor) {
                    string4 = tFAHost.getHostname().trim();
                    arrayList.add(string4);
                }
            } else {
                for (String string8 : string2.split(",")) {
                    arrayList.add(string8.trim());
                }
            }
            String exception = string5 + ":removesubdirectories:" + string;
            for (String string9 : arrayList) {
                string4 = string9;
                if (!string4.equalsIgnoreCase(string5)) {
                    String string10;
                    Output.printTrace("Making Socket connection to :" + string4, 3);
                    sSLSocket = SocketManager.getSecureSocketConnection(string4.trim(), Global.getSocketPort(), string6, string7);
                    if (sSLSocket == null) {
                        printWriter.println("Connection refused!" + string4);
                        continue;
                    }
                    printWriter2 = new PrintWriter(sSLSocket.getOutputStream(), true);
                    printWriter2.println(exception);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                    while (!((string10 = bufferedReader.readLine()) == null || string10.equals("DONE") || string10.startsWith("SUCCESS") || string10.startsWith("FAILED"))) {
                    }
                    bufferedReader.close();
                    if (sSLSocket.isClosed()) continue;
                    sSLSocket.close();
                    continue;
                }
                string3 = TFADirectoryManager.removeSubDirectories(string, printWriter);
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string4, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string4, 1);
            Output.print("NonRootMessageHandler : IOException in dumpDirectoriesInNodes");
        }
        finally {
            try {
                if (entityCursor != null) {
                    entityCursor.close();
                }
            }
            catch (Exception exception) {}
        }
        return string3;
    }

    private int createWrapFile(String string, String string2, String string3) {
        String string4 = "";
        String string5 = "";
        int n = 0;
        string4 = new File(Properties.perlexe).exists() ? Properties.perlexe : File.separator + "usr" + File.separator + "bin" + File.separator + "perl";
        try {
            String string6 = string4 + " " + Properties.tfaHome + File.separator + "bin" + File.separator + "tfaosutils.pl export2wrapfile " + string + " " + string2 + " " + string3;
            Output.printTrace("NonRootMessageHandler : Command : " + string6, 3);
            Process process = Runtime.getRuntime().exec(string6);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string5 = bufferedReader.readLine()) != null) {
                if (n == 1) {
                    Output.printTrace(string5, 1);
                } else {
                    Output.printTrace("NonRootMessageHandler : LINE : " + string5, 3);
                }
                if (!string5.contains("ERROR")) continue;
                Output.printTrace("NonRootMessageHandler : " + string5, 1);
                n = 1;
            }
        }
        catch (Exception exception) {
            Output.printTrace("NonRootMessageHandler : Exception in createWrapFile " + exception.getMessage(), 1);
        }
        return n;
    }

    private String getKey(String string, String string2) {
        BufferedReader bufferedReader = null;
        String string3 = null;
        String string4 = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string2));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string3.startsWith(string)) continue;
                String[] stringArray = string3.split("=");
                string4 = stringArray[1];
                break;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Output.printTrace("NonRootMessageHandler : File " + string2 + " not found", 3);
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            Output.printTrace("NonRootMessageHandler : IOException in getKey call", 3);
            iOException.printStackTrace();
        }
        return string4;
    }

    private boolean isSymbolicLink(File file) {
        boolean bl = false;
        try {
            bl = !file.getAbsoluteFile().equals(file.getCanonicalFile());
        }
        catch (Exception exception) {
            Output.printTrace("Exception in isSymbolicLink() : " + exception.getMessage(), 1);
            bl = true;
        }
        return bl;
    }

    private void stopProducer(PrintWriter printWriter) {
        try {
            int n = RGlobal.activeThreads.size();
            Output.printTrace("No of activeThreads befroe stop=" + n, 1);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendCollectorFile(PrintWriter printWriter, String string) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter2 = null;
        String string2 = null;
        String string3 = new Host().getHostname().trim();
        EntityCursor entityCursor = null;
        String string4 = Properties.trustStore;
        String string5 = Properties.trustStorePassword;
        String string6 = "";
        String string7 = "SUCCESS";
        OutputStream outputStream = null;
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadUncommitted(true);
        try {
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(String.class, TFAHost.class);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            for (TFAHost tFAHost : entityCursor) {
                int n;
                string2 = tFAHost.getHostname();
                if (string2.equalsIgnoreCase(string3)) continue;
                Output.printTrace("Making Socket connection to :" + string2, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string2.trim(), Global.getSocketPort(), string4, string5);
                if (sSLSocket == null) {
                    printWriter.println("MessageHandler : Connection refused! " + string2);
                    continue;
                }
                outputStream = sSLSocket.getOutputStream();
                printWriter2 = new PrintWriter(outputStream, true);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                String string8 = string;
                File file = new File(string8);
                String string9 = string3;
                string9 = "TFAR_" + this.reqUser.trim();
                String string10 = string3 + ":transferfile:" + string8 + ":" + file.length() + ":" + string9;
                Output.printTrace("Request to R:" + string10, 3);
                printWriter2.println(string10);
                outputStream.flush();
                while ((string6 = bufferedReader.readLine()) != null && !string6.equals("READY_TO_RECIVE_FILE")) {
                }
                File file2 = new File(string8);
                byte[] byArray = new byte[8192];
                FileInputStream fileInputStream = new FileInputStream(file2);
                int n2 = 0;
                while ((n = fileInputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                    outputStream.flush();
                    n2 += n;
                }
                fileInputStream.close();
                Output.printTrace("Total Written to Socket : " + n2, 3);
                while ((string6 = bufferedReader.readLine()) != null) {
                    Output.printTrace("Msg from R is " + string6, 3);
                    if (string6.equals("SUCCESS")) break;
                    Output.printTrace("Msg from R is " + string6, 3);
                }
                if (sSLSocket.isClosed()) continue;
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("NonRootMessageHandler : Don't know about host: " + string2, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("NonRootMessageHandler : Couldn't get I/O for the connection to Host : " + string2, 1);
            Output.print("NonRootMessageHandler : IOException in performActionsInRemoteNodes");
        }
        finally {
            try {
                entityCursor.close();
            }
            catch (Exception exception) {
                Output.print("NonRootMessageHandler : Exception while closing the cursor in performActionsInRemoteNodes");
            }
        }
        return string7;
    }
}

