/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import com.sleepycat.je.ThreadInterruptedException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import oracle.rat.tfa.NonRootMessageHandler;
import oracle.rat.tfa.nls.Omsg;
import oracle.rat.tfa.nls.Oprint;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class NonRootConnectionAcceptor
implements Runnable {
    public static boolean listening = true;

    @Override
    public void run() {
        ServerSocket serverSocket = null;
        try {
            InetAddress inetAddress = InetAddress.getByName("127.0.0.1");
            if (inetAddress == null) {
                Output.print("Unable to determine Loopback Address");
                return;
            }
            serverSocket = new ServerSocket(0, 5, inetAddress);
            serverSocket.setSoTimeout(5000);
            Output.print("InetAddress " + serverSocket.getInetAddress());
            Output.print("LocalPort " + serverSocket.getLocalPort());
            Properties.getInstance().writeNonRootPortToFile(serverSocket.getLocalPort());
            while (listening) {
                try {
                    new Thread(new NonRootMessageHandler(serverSocket.accept())).start();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    Output.printTrace("SocketTimeoutException while listening", 2);
                }
                catch (ThreadInterruptedException threadInterruptedException) {
                    Output.print("ThreadInterruptedException while listening");
                    listening = false;
                }
                catch (Exception exception) {
                    Output.print("Exception while listening");
                    exception.printStackTrace();
                }
                if (!Thread.interrupted()) continue;
                Output.printTrace("NonRootConnectionAcceptor is Interrupted", 2);
                listening = false;
            }
            Output.print("Received Message to shutdown through Interrupt");
            if (!serverSocket.isClosed()) {
                serverSocket.close();
            }
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean isKeySetup() {
        String string = Properties.getUserName();
        if (!string.equals("root")) {
            System.out.println("User '" + string + "' do not have permissions to run on remote node.");
            System.out.println("DONE");
            System.exit(0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        String string2 = stringBuilder.append(Properties.tfaHome).append(File.separator).append("internal").append(File.separator).append(".root").append(File.separator).append("mykey.rsa").toString();
        File file = new File(string2);
        if (!file.exists()) {
            System.out.println("Keyfile '" + string2 + "' does not exists.");
            return false;
        }
        return true;
    }

    private boolean isPortAvailable(int n) {
        Oprint oprint = new Oprint("en-US", "en", "UTF-8", "US");
        Omsg omsg = new Omsg("en-US", "en", "UTF-8", "US");
        Output.printTrace("Checking for port availability : " + n, 3);
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(n);
            serverSocket.close();
        }
        catch (IOException iOException) {
            System.out.println("NonRoot Could not listen on port: " + n);
            return false;
        }
        return true;
    }
}

