/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.rat.tfa.TFAMergeFiles;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Utilities;

public class MergeDemo
extends JPanel
implements TreeSelectionListener {
    private JEditorPane htmlPane;
    private JPanel fileInfoPane;
    private JTree tree;
    private DefaultListModel listModel;
    private JList list;
    private static final String selectString = "Select File";
    private static final String removeString = "Remove File";
    private static final String mergeString = "Merge Files";
    private JTextArea fileInfoField;
    private JButton selectButton;
    private JButton removeButton;
    private JButton mergeButton;
    private URL helpURL;
    private static boolean DEBUG = false;
    private static boolean playWithLineStyle = false;
    private static String lineStyle = "Horizontal";
    private static final String newline = "\n";
    private Output op = new Output();
    private static boolean useSystemLookAndFeel = false;

    public MergeDemo(FileEntity[] fileEntityArray) {
        super(new GridLayout(1, 0));
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.createNodes(defaultMutableTreeNode, fileEntityArray);
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        if (playWithLineStyle) {
            System.out.println("line style = " + lineStyle);
            this.tree.putClientProperty("JTree.lineStyle", lineStyle);
        }
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(1);
        this.list.setSelectedIndex(0);
        this.list.addListSelectionListener(new list1Listener());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.selectButton = new JButton(selectString);
        this.selectButton.setActionCommand("select");
        this.selectButton.setToolTipText("Click this button to Select a file from the Tree to add to the Merge List");
        this.selectButton.addActionListener(new AddButtonListener());
        this.removeButton = new JButton(removeString);
        this.removeButton.setActionCommand("remove");
        this.removeButton.setToolTipText("Click this button to remove a file from the files to merge List");
        this.removeButton.addActionListener(new RemoveButtonListener());
        this.mergeButton = new JButton(mergeString);
        this.mergeButton.setActionCommand("merge");
        this.mergeButton.setToolTipText("Click this button to run the merge and display the results");
        this.mergeButton.addActionListener(new MergeButtonListener());
        JScrollPane jScrollPane2 = new JScrollPane(this.tree);
        this.fileInfoPane = new JPanel();
        this.fileInfoPane.setBackground(Color.WHITE);
        this.fileInfoField = new JTextArea(10, 50);
        this.fileInfoPane.add(this.fileInfoField);
        this.htmlPane = new JEditorPane();
        this.htmlPane.setEditable(false);
        JPanel jPanel = new JPanel();
        jPanel.add(this.selectButton);
        jPanel.add(this.removeButton);
        jPanel.add(this.mergeButton);
        JScrollPane jScrollPane3 = new JScrollPane(this.htmlPane);
        jScrollPane3.setPreferredSize(new Dimension(600, 300));
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(jScrollPane2);
        jSplitPane.setRightComponent(jScrollPane);
        jSplitPane.setDividerLocation(300);
        JSplitPane jSplitPane2 = new JSplitPane(0);
        jSplitPane2.setTopComponent(jPanel);
        jSplitPane2.setBottomComponent(jSplitPane);
        JSplitPane jSplitPane3 = new JSplitPane(0);
        jSplitPane3.setTopComponent(jSplitPane2);
        jSplitPane3.setBottomComponent(this.fileInfoPane);
        JSplitPane jSplitPane4 = new JSplitPane(1);
        jSplitPane4.setLeftComponent(jSplitPane3);
        jSplitPane4.setRightComponent(jScrollPane3);
        this.add(jSplitPane4);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isLeaf()) {
            this.setFileInfo(object);
        } else {
            this.displayURL(this.helpURL);
        }
        if (DEBUG) {
            System.out.println(object.toString());
        }
    }

    private void setFileInfo(Object object) {
        this.fileInfoField.setText("File Name  :" + ((FileEntity)object).getFileName() + newline + "File Type  :" + ((FileEntity)object).getType() + newline + "First Date :" + ((FileEntity)object).getFirstTime().toString() + newline + "Last Date  :" + ((FileEntity)object).getLastTime().toString());
    }

    private void initHelp() {
        String string = "TreeDemoHelp.html";
        this.helpURL = this.getClass().getResource(string);
        if (this.helpURL == null) {
            System.err.println("Couldn't open help file: " + string);
        } else if (DEBUG) {
            System.out.println("Help URL is " + this.helpURL);
        }
        this.displayURL(this.helpURL);
    }

    private void displayURL(URL uRL) {
        try {
            if (uRL != null) {
                this.htmlPane.setPage(uRL);
            } else {
                this.htmlPane.setText("File Not Found");
                if (DEBUG) {
                    System.out.println("Attempted to display a null URL.");
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Attempted to read a bad URL: " + uRL);
        }
    }

    private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode, FileEntity[] fileEntityArray) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        DefaultMutableTreeNode defaultMutableTreeNode4 = null;
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode();
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode();
        TreeNode treeNode = null;
        boolean bl = false;
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("Host X");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        for (int i = 0; i < fileEntityArray.length; ++i) {
            bl = false;
            if (defaultMutableTreeNode2.getChildCount() > 0) {
                treeNode = defaultMutableTreeNode2.getFirstChild();
            }
            for (int j = 0; j < defaultMutableTreeNode2.getChildCount(); ++j) {
                treeNode = defaultMutableTreeNode2.getChildAt(j);
                if (!treeNode.toString().contentEquals(fileEntityArray[i].getBaseDirectory())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                defaultMutableTreeNode3 = new DefaultMutableTreeNode(fileEntityArray[i].getBaseDirectory());
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                defaultMutableTreeNode6 = defaultMutableTreeNode3;
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(fileEntityArray[i]);
                defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                continue;
            }
            defaultMutableTreeNode4 = new DefaultMutableTreeNode(fileEntityArray[i]);
            defaultMutableTreeNode6 = (DefaultMutableTreeNode)DefaultMutableTreeNode.class.cast(treeNode);
            defaultMutableTreeNode6.add(defaultMutableTreeNode4);
        }
    }

    private static void createAndShowGUI() {
        if (useSystemLookAndFeel) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                System.err.println("Couldn't use system look and feel.");
            }
        }
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (Exception exception) {
            System.err.println("Couldn't use Oracle Look and Feel.");
        }
        Utilities utilities = new Utilities();
        Output output = new Output();
        Output.print("MergeDemo: Starting : " + utilities.getDateTime());
        Socket socket = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        String string = new Host().getHostname();
        String string2 = null;
        ArrayList arrayList = null;
        FileEntity[] fileEntityArray = null;
        try {
            Output.print("Making Socket connection to Local TFAMain");
            socket = new Socket(string.trim(), 4444);
            printWriter = new PrintWriter(socket.getOutputStream(), true);
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            Output.print("Sending request for mergable files  : ");
            printWriter.println(string + ":printinventorymerge:");
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.contentEquals("DONE")) {
                    Output.print("Received Done for printinventorymerge request");
                    break;
                }
                Output.print("Eligible File: " + string2);
                arrayList.add(string2);
            }
            if (!socket.isClosed()) {
                socket.close();
            }
            fileEntityArray = new FileEntity[arrayList.toArray().length];
            for (int i = 0; i < fileEntityArray.length; ++i) {
                fileEntityArray[i] = new FileEntity(new File(arrayList.get(i).toString()));
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.print("Don't know about host: " + string);
        }
        catch (IOException iOException) {
            Output.print("Couldn't get I/O for the connection to Host : " + string);
            iOException.printStackTrace();
        }
        JFrame jFrame = new JFrame("TreeDemo");
        jFrame.setDefaultCloseOperation(3);
        jFrame.add(new MergeDemo(fileEntityArray));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MergeDemo.createAndShowGUI();
            }
        });
    }

    class MergeButtonListener
    implements ActionListener {
        MergeButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            ListSelectionModel listSelectionModel = MergeDemo.this.list.getSelectionModel();
            String[] stringArray = new String[MergeDemo.this.listModel.getSize()];
            FileEntity[] fileEntityArray = new FileEntity[MergeDemo.this.listModel.getSize()];
            for (int i = 0; i < MergeDemo.this.listModel.getSize(); ++i) {
                MergeDemo.this.op;
                Output.print("Merge file :: " + MergeDemo.this.listModel.getElementAt(i));
                string = MergeDemo.this.listModel.getElementAt(i);
                FileEntity fileEntity = (FileEntity)((Object)string);
                MergeDemo.this.op;
                Output.print("From FE : " + fileEntity.getFileName());
                stringArray[i] = fileEntity.getFileName();
                fileEntityArray[i] = (FileEntity)MergeDemo.this.listModel.getElementAt(i);
            }
            String[] stringArray2 = new String[]{};
            TFAMergeFiles.run(stringArray2, fileEntityArray);
            string = "file:///C:/tfa_home/mergefiles/outfile.html";
            try {
                if (string != null) {
                    MergeDemo.this.htmlPane.setPage(string);
                } else {
                    MergeDemo.this.htmlPane.setText("File Not Found");
                    if (DEBUG) {
                        System.out.println("Attempted to display a null URL.");
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("Attempted to read a bad URL: " + string);
            }
        }
    }

    class RemoveButtonListener
    implements ActionListener {
        RemoveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ListSelectionModel listSelectionModel = MergeDemo.this.list.getSelectionModel();
            int n = listSelectionModel.getMinSelectionIndex();
            int n2 = listSelectionModel.getMaxSelectionIndex();
            MergeDemo.this.listModel.removeRange(n, n2);
            int n3 = MergeDemo.this.listModel.size();
            if (n3 == 0) {
                MergeDemo.this.removeButton.setEnabled(false);
            } else {
                if (n == MergeDemo.this.listModel.getSize()) {
                    --n;
                }
                MergeDemo.this.list.setSelectedIndex(n);
            }
        }
    }

    class AddButtonListener
    implements ActionListener {
        AddButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = MergeDemo.this.list.getSelectedIndex();
            int n2 = MergeDemo.this.listModel.getSize();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)MergeDemo.this.tree.getLastSelectedPathComponent();
            if (!MergeDemo.this.listModel.contains(defaultMutableTreeNode.getUserObject())) {
                MergeDemo.this.listModel.addElement(defaultMutableTreeNode.getUserObject());
                MergeDemo.this.list.setSelectedIndex(n2);
                MergeDemo.this.removeButton.setEnabled(true);
            }
        }
    }

    class list1Listener
    implements ListSelectionListener {
        list1Listener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            Object e = jList.getSelectedValue();
            if (!jList.isSelectionEmpty()) {
                MergeDemo.this.setFileInfo(e);
            } else {
                System.out.println("Nothing is selected.");
            }
        }
    }
}

