/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Utilities;

public class ManageLogsAutoPurge
extends Thread {
    private boolean stopThread = false;
    private boolean interruptForIntervalUpdate = false;

    @Override
    public void run() {
        while (!this.stopThread) {
            try {
                Utilities.triggerAutoPurge(Global.getManageLogsAutoPurgePolicyAge());
                Output.printTrace("ManageLogsAutoPurge sleep begin", 3);
                Thread.sleep(Global.getManageLogsAutoPurgeInterval() * 60 * 1000);
                Output.printTrace("ManageLogsAutoPurge sleep end", 3);
            }
            catch (InterruptedException interruptedException) {
                if (this.getInterruptForIntervalUpdate()) {
                    this.setInterruptForIntervalUpdate(false);
                    continue;
                }
                this.stopThread = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void stopManageLogsAutoPurge() {
        this.stopThread = true;
        this.setInterruptForIntervalUpdate(false);
        Output.printTrace("ManageLogsAutoPurge set to true", 3);
    }

    public void setInterruptForIntervalUpdate(boolean bl) {
        this.interruptForIntervalUpdate = bl;
        Output.printTrace("Setting ManageLogsAutoPurge interruptForIntervalUpdate set to " + bl, 3);
    }

    public boolean getInterruptForIntervalUpdate() {
        return this.interruptForIntervalUpdate;
    }
}

