/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.Utilities;

public class InstanceMonitor
extends Thread {
    private boolean stopThread = false;
    public static List<String> instances = new ArrayList<String>();

    @Override
    public void run() {
        while (!this.stopThread) {
            try {
                Properties.getInstance();
                List<String> list = Utilities.getOracleInstanceList(Properties.isWindows());
                if (list.size() != 0) {
                    Collections.sort(list);
                }
                if (instances.size() != 0) {
                    Collections.sort(instances);
                    if (!instances.equals(list)) {
                        if (list.size() <= instances.size()) {
                            Thread.sleep(600000L);
                        }
                        String string = new Host().getHostname().trim();
                        LogFile.writeLog("InstanceMonitor restarting scanner: ");
                        Action action = new Action("startrtscan", string, "InstanceMonitor", "");
                        action.store();
                    }
                }
                instances = list;
                Output.printTrace("InstanceMonitor sleep begin", 3);
                Thread.sleep(30000L);
                Output.printTrace("InstanceMonitor sleep end", 3);
            }
            catch (InterruptedException interruptedException) {
                this.stopThread = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void stopInstanceMonitor() {
        this.stopThread = true;
    }
}

