/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.RepositoryManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;

public class DiagCollectionTransfer
implements Runnable {
    private String hostname;
    private String actionArgs;

    public DiagCollectionTransfer() {
    }

    public DiagCollectionTransfer(String string, String string2) {
        this.hostname = string;
        this.actionArgs = string2;
    }

    @Override
    public void run() {
        String string = new Host().getHostname();
        Output.printTrace("Args in DiagCollectionTransfer: " + this.actionArgs, 3);
        Properties.getInstance();
        String[] stringArray = this.actionArgs.split(Properties.TFAARGSEP);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Output.printTrace("Remote host : " + this.hostname, 3);
        this.doTransfer(this.hostname, string2, string3);
    }

    private void doTransfer(String string, String string2, String string3) {
        String string4 = new Host().getHostname();
        String string5 = string4 + ":dodiagcollectiontransfer:" + string2;
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        try {
            Object object;
            if (Properties.TFARunMode.equalsIgnoreCase("RECEIVER")) {
                object = string2.split("/");
                string2 = RepositoryManager.getInstance().getDirectory() + File.separator + object[((String[])object).length - 1];
                string5 = string5 + ":delete";
            }
            Properties.getInstance();
            object = Properties.trustStore;
            Properties.getInstance();
            String string6 = Properties.trustStorePassword;
            sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), (String)object, string6);
            if (sSLSocket == null) {
                Output.printTrace("Unable to connect to " + string, 3);
            } else {
                int n;
                InputStream inputStream = sSLSocket.getInputStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter.println(string5);
                byte[] byArray = new byte[8192];
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                int n2 = 0;
                Output.printTrace("Reading from socket input stream of " + string + " to " + string2, 3);
                Output.printTrace("Transferring file of size : " + Long.valueOf(string3), 3);
                while ((n = inputStream.read(byArray)) != -1 && Long.valueOf(string3) > (long)n2) {
                    bufferedOutputStream.write(byArray, 0, n);
                    bufferedOutputStream.flush();
                    if ((long)(n2 += n) != Long.valueOf(string3)) continue;
                }
                Output.printTrace("Total number of bytes written : " + n2, 3);
                bufferedOutputStream.close();
                if (!sSLSocket.isClosed()) {
                    sSLSocket.close();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

